/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.randomforest;

import com.actelion.research.calc.regression.ParameterRegressionMethod;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

public class ParameterRandomForest
extends ParameterRegressionMethod {
    public static final int NUM_TREES = 100;
    public static final double MTRY = 0.333;
    public static final int NODE_SIZE = 5;
    public static final int MAX_NODES = 50;
    public static final String TAG_TREES = "NumTrees";
    public static final String TAG_MTRY = "MTry";
    public static final String TAG_NODE_SIZE = "NodeSize";
    public static final String TAG_MAX_NODES = "MaxNodes";
    private int nTrees;
    private double fractionMTry;
    private int nodeSize;
    private int maxNodes;

    public ParameterRandomForest() {
        super("Random Forest regression");
        this.initialize();
    }

    private void initialize() {
        this.setFractionMTry(0.333);
        this.setMaxNodes(50);
        this.setNodeSize(5);
        this.setNumTrees(100);
    }

    public int getNumberOfTrees() {
        return this.nTrees;
    }

    public double getFractionMTry() {
        return this.fractionMTry;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setFractionMTry(double d) {
        this.fractionMTry = d;
        this.properties.put(TAG_MTRY, Double.toString(d));
    }

    public void setNumTrees(int n) {
        this.nTrees = n;
        this.properties.put(TAG_TREES, Integer.toString(n));
    }

    public void setNodeSize(int n) {
        this.nodeSize = n;
        this.properties.put(TAG_NODE_SIZE, Integer.toString(n));
    }

    public void setMaxNodes(int n) {
        this.maxNodes = n;
        this.properties.put(TAG_MAX_NODES, Integer.toString(n));
    }

    @Override
    protected void decodeProperties2Parameter() {
        this.nTrees = Integer.parseInt(this.properties.getProperty(TAG_TREES));
        this.fractionMTry = Double.parseDouble(this.properties.getProperty(TAG_MTRY));
        this.nodeSize = Integer.parseInt(this.properties.getProperty(TAG_NODE_SIZE));
        this.maxNodes = Integer.parseInt(this.properties.getProperty(TAG_MAX_NODES));
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterRandomForest parameterRandomForest = (ParameterRandomForest)parameterRegressionMethod;
        if (this.nTrees > parameterRandomForest.nTrees) {
            n = 1;
        } else if (this.nTrees < parameterRandomForest.nTrees) {
            n = -1;
        }
        if (n == 0) {
            if (this.fractionMTry > parameterRandomForest.fractionMTry) {
                n = 1;
            } else if (this.fractionMTry < parameterRandomForest.fractionMTry) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.nodeSize > parameterRandomForest.nodeSize) {
                n = 1;
            } else if (this.nodeSize < parameterRandomForest.nodeSize) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.maxNodes > parameterRandomForest.maxNodes) {
                n = 1;
            } else if (this.maxNodes < parameterRandomForest.maxNodes) {
                n = -1;
            }
        }
        return n;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        StringBuilder stringBuilder = new StringBuilder("ParameterRNDForest{");
        stringBuilder.append("name=").append(this.getName());
        stringBuilder.append(" trees=").append(this.nTrees);
        stringBuilder.append(" frac variables=").append(this.fractionMTry);
        stringBuilder.append(" nodeSize=").append(this.nodeSize);
        stringBuilder.append(" maxNodes=").append(this.maxNodes);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add(TAG_TREES);
        list.add(TAG_MTRY);
        list.add(TAG_NODE_SIZE);
        list.add(TAG_MAX_NODES);
        return list;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File("/home/korffmo1/tmp/tmp00");
        File file2 = new File(file, "randomForest.properties");
        ParameterRandomForest parameterRandomForest = new ParameterRandomForest();
        parameterRandomForest.nTrees = 1000;
        parameterRandomForest.fractionMTry = 0.321;
        parameterRandomForest.nodeSize = 7;
        parameterRandomForest.maxNodes = 42;
        parameterRandomForest.write(file2);
        ParameterRandomForest parameterRandomForest2 = new ParameterRandomForest();
        parameterRandomForest2.read(file2);
        System.out.println(parameterRandomForest2.toString());
    }
}

