/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.simple;

import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.PointDouble;
import java.awt.Point;
import java.util.List;
import java.util.Vector;

public class LinearRegression {
    private double intercept;
    private double slope;
    private Vector<PointDouble> v = new Vector();
    private Vector<PointDouble> residuals = new Vector();
    private double xMean = 0.0;
    private double yMean = 0.0;

    public void addPoint(Point point) {
        this.v.addElement(new PointDouble(point));
    }

    public void addPoint(PointDouble pointDouble) {
        this.v.addElement(pointDouble);
    }

    public void addPoint(double d, double d2) {
        this.v.addElement(new PointDouble(d, d2));
    }

    public void clear() {
        this.v = new Vector();
    }

    public List<PointDouble> getValues() {
        return this.v;
    }

    public double[][] getValuesAsArray() {
        double[][] dArray = new double[2][this.v.size()];
        for (int i = 0; i < this.v.size(); ++i) {
            dArray[0][i] = this.v.get((int)i).x;
            dArray[1][i] = this.v.get((int)i).y;
        }
        return dArray;
    }

    public DoubleArray getValuesAsArrayX() {
        DoubleArray doubleArray = new DoubleArray(this.v.size());
        for (int i = 0; i < this.v.size(); ++i) {
            doubleArray.add(this.v.get((int)i).x);
        }
        return doubleArray;
    }

    public DoubleArray getValuesAsArrayY() {
        DoubleArray doubleArray = new DoubleArray(this.v.size());
        for (int i = 0; i < this.v.size(); ++i) {
            doubleArray.add(this.v.get((int)i).y);
        }
        return doubleArray;
    }

    public Vector<PointDouble> regress() {
        this.xMean = 0.0;
        this.yMean = 0.0;
        for (PointDouble pointDouble : this.v) {
            this.xMean += pointDouble.x;
            this.yMean += pointDouble.y;
        }
        this.xMean /= (double)this.v.size();
        this.yMean /= (double)this.v.size();
        double d = 0.0;
        double d2 = 0.0;
        for (PointDouble pointDouble2 : this.v) {
            d += (pointDouble2.x - this.xMean) * (pointDouble2.y - this.yMean);
            d2 += (pointDouble2.x - this.xMean) * (pointDouble2.x - this.xMean);
        }
        this.slope = d / d2;
        this.intercept = this.yMean - this.slope * this.xMean;
        Vector vector = new Vector();
        for (PointDouble pointDouble : this.v) {
            PointDouble pointDouble2;
            double d3 = pointDouble.y - (this.intercept + this.slope * pointDouble.x);
            pointDouble2 = new PointDouble(pointDouble.x, (int)d3);
            vector.addElement(pointDouble2);
        }
        return vector;
    }

    public void calculate() {
        if (this.v.size() > 1) {
            this.residuals = this.regress();
        }
    }

    public Vector<PointDouble> getResiduals() {
        return this.residuals;
    }

    public PointDouble getMean() {
        return new PointDouble(this.xMean + 0.5, this.yMean + 0.5);
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getXMean() {
        return this.xMean;
    }

    public double getYMean() {
        return this.yMean;
    }

    public double getY(double d) {
        return this.intercept + this.slope * d;
    }

    public void setSlope(double d) {
        this.slope = d;
    }
}

