/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.classification;

import com.actelion.research.util.Formatter;
import java.io.Serializable;
import java.util.List;

public class PrecisionAndRecall
implements Serializable {
    public static final String ATTR_TP = "TP";
    public static final String ATTR_TN = "TN";
    public static final String ATTR_FP = "FP";
    public static final String ATTR_FN = "FN";
    public int truePositive = 0;
    public int trueNegative = 0;
    public int falsePositive = 0;
    public int falseNegative = 0;

    public PrecisionAndRecall(int n, int n2, int n3, int n4) {
        this.truePositive = n;
        this.trueNegative = n2;
        this.falsePositive = n3;
        this.falseNegative = n4;
    }

    public PrecisionAndRecall() {
    }

    public void add(PrecisionAndRecall precisionAndRecall) {
        this.truePositive += precisionAndRecall.truePositive;
        this.trueNegative += precisionAndRecall.trueNegative;
        this.falsePositive += precisionAndRecall.falsePositive;
        this.falseNegative += precisionAndRecall.falseNegative;
    }

    public void parse2PrecisionAndRecall(String string) {
        if (ATTR_TP.equals(string)) {
            ++this.truePositive;
        } else if (ATTR_TN.equals(string)) {
            ++this.trueNegative;
        } else if (ATTR_FP.equals(string)) {
            ++this.falsePositive;
        } else if (ATTR_FN.equals(string)) {
            ++this.falseNegative;
        } else {
            throw new RuntimeException("Parsing error for '" + string + "'.");
        }
    }

    public int getTruePositive() {
        return this.truePositive;
    }

    public void setTruePositive(int n) {
        this.truePositive = n;
    }

    public int getTrueNegative() {
        return this.trueNegative;
    }

    public void setTrueNegative(int n) {
        this.trueNegative = n;
    }

    public int getFalsePositive() {
        return this.falsePositive;
    }

    public void setFalsePositive(int n) {
        this.falsePositive = n;
    }

    public int getFalseNegative() {
        return this.falseNegative;
    }

    public void setFalseNegative(int n) {
        this.falseNegative = n;
    }

    public int getSum() {
        return this.trueNegative + this.truePositive + this.falsePositive + this.falseNegative;
    }

    public double calculatePrecision() {
        int n = this.truePositive + this.falsePositive;
        if (n == 0) {
            return 0.0;
        }
        return (double)this.truePositive / (double)(this.truePositive + this.falsePositive);
    }

    public double calculateRecall() {
        int n = this.truePositive + this.falseNegative;
        if (n == 0) {
            return 0.0;
        }
        return (double)this.truePositive / (double)(this.truePositive + this.falseNegative);
    }

    public double calculateAccuracy() {
        double d = (double)(this.truePositive + this.trueNegative) / (double)this.getSum();
        return d;
    }

    public double calculateHarmonicMean() {
        double d;
        double d2 = this.calculatePrecision();
        if (d2 + (d = this.calculateRecall()) == 0.0) {
            return 0.0;
        }
        double d3 = 2.0 * (d2 * d / (d2 + d));
        return d3;
    }

    public double calculateCohensKappa() {
        double d = this.getSum();
        double d2 = (double)(this.truePositive + this.falseNegative) / d * ((double)(this.truePositive + this.falsePositive) / d);
        double d3 = (double)(this.falsePositive + this.trueNegative) / d * ((double)(this.falseNegative + this.trueNegative) / d);
        double d4 = d2 + d3;
        double d5 = this.calculateAccuracy();
        double d6 = (d5 - d4) / (1.0 - d4);
        return d6;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Accuracy " + Formatter.format3(this.calculateAccuracy()));
        stringBuilder.append(", precision " + Formatter.format3(this.calculatePrecision()));
        stringBuilder.append(", recall " + Formatter.format3(this.calculateRecall()));
        stringBuilder.append(", F1 " + Formatter.format3(this.calculateHarmonicMean()));
        stringBuilder.append(", Cohens' kappa " + Formatter.format3(this.calculateCohensKappa()));
        stringBuilder.append("\n");
        stringBuilder.append("True positive " + this.truePositive);
        stringBuilder.append("\n");
        stringBuilder.append("True negative " + this.trueNegative);
        stringBuilder.append("\n");
        stringBuilder.append("False positive " + this.falsePositive);
        stringBuilder.append("\n");
        stringBuilder.append("False negative " + this.falseNegative);
        return stringBuilder.toString();
    }

    public static double getHarmonicMean(List<PrecisionAndRecall> list) {
        double d = 0.0;
        for (PrecisionAndRecall precisionAndRecall : list) {
            d += precisionAndRecall.calculateHarmonicMean();
        }
        return d / (double)list.size();
    }

    public static void main(String[] stringArray) {
        PrecisionAndRecall precisionAndRecall = new PrecisionAndRecall();
        precisionAndRecall.truePositive = 20;
        precisionAndRecall.trueNegative = 15;
        precisionAndRecall.falseNegative = 5;
        precisionAndRecall.falsePositive = 10;
        System.out.println("Cohen's kappa: " + precisionAndRecall.calculateCohensKappa());
    }
}

