/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.SelfOrganizedMap;
import com.actelion.research.calc.VectorSOM;
import com.actelion.research.chem.SSSearcherWithIndex;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class BinarySOM
extends SelfOrganizedMap {
    private static final int KEY_COUNT = SSSearcherWithIndex.getNoOfKeys();
    private static final int MASK_COUNT = (SSSearcherWithIndex.getNoOfKeys() + 31) / 32;
    private double[] mKeyFrequency;
    private int mMaxKeyCount;
    private int[] mMask;
    private int[][] mKeyMaskMap;
    private ArrayList mRandomizedKeyIndexList;
    private byte[] mBitCount;
    private Random mRandom;

    public BinarySOM() {
        this.init();
    }

    public BinarySOM(int n, int n2, int n3) {
        super(n, n2, n3);
        this.init();
    }

    private void init() {
        int n;
        this.mRandom = new Random();
        this.mMask = new int[32];
        this.mMask[0] = Integer.MIN_VALUE;
        for (n = 0; n < 31; ++n) {
            this.mMask[n + 1] = this.mMask[n] >>> 1;
        }
        this.mRandomizedKeyIndexList = new ArrayList();
        for (n = 0; n < KEY_COUNT; ++n) {
            this.mRandomizedKeyIndexList.add(new Integer(n));
        }
        this.mBitCount = new byte[65536];
        for (n = 0; n < 65536; ++n) {
            this.mBitCount[n] = (byte)Integer.bitCount(n);
        }
    }

    @Override
    protected void initializeNormalization() {
        int n;
        this.startProgress("Calculating key frequencies...", 0, this.mController.getInputVectorCount());
        this.mKeyFrequency = new double[KEY_COUNT];
        for (n = 0; n < this.mController.getInputVectorCount() && !this.threadMustDie(); ++n) {
            this.updateProgress(n);
            int[] nArray = (int[])this.mController.getInputVector(n);
            for (int i = 0; i < MASK_COUNT; ++i) {
                for (int j = 0; j < 32; ++j) {
                    if ((nArray[i] & this.mMask[j]) == 0) continue;
                    int n2 = i * 32 + j;
                    this.mKeyFrequency[n2] = this.mKeyFrequency[n2] + 1.0;
                }
            }
        }
        if (!this.threadMustDie()) {
            n = 0;
            while (n < KEY_COUNT) {
                int n3 = n++;
                this.mKeyFrequency[n3] = this.mKeyFrequency[n3] / (double)this.mController.getInputVectorCount();
            }
        }
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        super.write(bufferedWriter);
        bufferedWriter.write("<keyFrequency=\"" + VectorSOM.doubleArrayToString(this.mKeyFrequency) + "\">");
        bufferedWriter.newLine();
    }

    @Override
    public void read(BufferedReader bufferedReader) throws Exception {
        boolean bl;
        super.read(bufferedReader);
        String string = bufferedReader.readLine();
        boolean bl2 = bl = !string.startsWith("<keyFrequency=");
        if (!bl) {
            this.mKeyFrequency = VectorSOM.stringToDoubleArray(BinarySOM.extractValue(string));
        }
        if (bl) {
            throw new IOException("Invalid SOM file format");
        }
    }

    @Override
    protected String referenceVectorToString(int n, int n2) {
        return SSSearcherWithIndex.getHexStringFromIndex((int[])this.mReferenceVector[n][n2]);
    }

    @Override
    protected void setReferenceVector(int n, int n2, String string) throws Exception {
        this.mReferenceVector[n][n2] = SSSearcherWithIndex.getIndexFromHexString(string);
    }

    @Override
    public double getDissimilarity(Object object, Object object2) {
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < MASK_COUNT; ++i) {
            int n3 = nArray[i] & nArray2[i];
            int n4 = nArray[i] | nArray2[i];
            n += this.mBitCount[0xFFFF & n3] + this.mBitCount[n3 >>> 16];
            n2 += this.mBitCount[0xFFFF & n4] + this.mBitCount[n4 >>> 16];
        }
        return 1.0 - (double)n / (double)n2;
    }

    @Override
    protected void updateReference(Object object, Object object2, double d) {
        int[] nArray = this.mKeyMaskMap[(int)d];
        int[] nArray2 = (int[])object;
        int[] nArray3 = (int[])object2;
        for (int i = 0; i < MASK_COUNT; ++i) {
            int n = i;
            nArray3[n] = nArray3[n] ^ nArray[i] & (nArray2[i] ^ nArray3[i]);
        }
    }

    @Override
    protected Object getRandomVector() {
        int[] nArray = new int[MASK_COUNT];
        for (int i = 0; i < MASK_COUNT; ++i) {
            for (int j = 0; j < 32; ++j) {
                if (!(this.mRandom.nextDouble() < this.mKeyFrequency[32 * i + j])) continue;
                int n = i;
                nArray[n] = nArray[n] | this.mMask[j];
            }
        }
        return nArray;
    }

    @Override
    protected Object getMeanVector(Object object, Object object2) {
        int[] nArray = (int[])object;
        int[] nArray2 = (int[])object2;
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < MASK_COUNT; ++i) {
            nArray3[i] = nArray[i];
            for (int j = 0; j < 32; ++j) {
                if ((nArray[i] & this.mMask[j]) == (nArray2[i] & this.mMask[j]) || !(Math.random() < 0.5)) continue;
                int n = i;
                nArray3[n] = nArray3[n] & ~this.mMask[j];
                int n2 = i;
                nArray3[n2] = nArray3[n2] | nArray2[i] & this.mMask[j];
            }
        }
        return nArray3;
    }

    @Override
    public Object normalizeVector(Object object) {
        return object;
    }

    @Override
    protected void calculateInfluences(double d) {
        super.calculateInfluences(d);
        this.mMaxKeyCount = 0;
        this.mKeyMaskMap = new int[KEY_COUNT][];
        for (int i = 0; i < this.mInfluence.length; ++i) {
            for (int j = 0; j < this.mInfluence[i].length; ++j) {
                if (this.mInfluence[i][j] == 0.0) continue;
                int n = (int)((double)KEY_COUNT * this.mInfluence[i][j] + 0.5);
                if (this.mMaxKeyCount < n) {
                    this.mMaxKeyCount = n;
                }
                this.mInfluence[i][j] = n;
                if (this.mKeyMaskMap[n] != null) continue;
                this.mKeyMaskMap[n] = new int[MASK_COUNT];
            }
        }
    }

    @Override
    protected void applyInfluences(Object object, Point point) {
        this.randomizeKeyMasks();
        super.applyInfluences(object, point);
    }

    private void randomizeKeyMasks() {
        int[] nArray = new int[MASK_COUNT];
        Collections.shuffle(this.mRandomizedKeyIndexList);
        for (int i = 1; i <= this.mMaxKeyCount; ++i) {
            int n = (Integer)this.mRandomizedKeyIndexList.get(i - 1);
            int n2 = n >> 5;
            nArray[n2] = nArray[n2] | this.mMask[n & 0x1F];
            if (this.mKeyMaskMap[i] == null) continue;
            for (int j = 0; j < MASK_COUNT; ++j) {
                this.mKeyMaskMap[i][j] = nArray[j];
            }
        }
    }
}

