/*
 * Decompiled with CFR 0.152.
 */
package swingjs.jzlib;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import swingjs.jzlib.Inflater;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inflater;
    protected byte[] buf;
    protected int len;
    protected boolean closed = false;
    protected boolean eof = false;
    private boolean close_in = false;
    protected static final int DEFAULT_BUFSIZE = 512;
    protected boolean myinflater = false;
    private byte[] byte1 = new byte[1];
    private byte[] b = new byte[512];

    public InflaterInputStream(InputStream in, Inflater inflater, int size, boolean close_in) {
        super(in);
        this.inflater = inflater;
        this.buf = new byte[size];
        this.close_in = close_in;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.read(this.byte1, 0, 1) == -1 ? -1 : this.byte1[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readInf(b, off, len);
    }

    protected int readInf(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        int n = 0;
        this.inflater.setOutput(b, off, len);
        while (!this.eof) {
            if (this.inflater.avail_in == 0) {
                this.fill();
            }
            int err = this.inflater.inflate(0);
            n += this.inflater.next_out_index - off;
            off = this.inflater.next_out_index;
            switch (err) {
                case -3: {
                    throw new IOException(this.inflater.msg);
                }
                case 1: 
                case 2: {
                    this.eof = true;
                    if (err != 2) break;
                    return -1;
                }
            }
            if (this.inflater.avail_out != 0) continue;
            break;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.eof ? 0 : 1;
    }

    @Override
    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > this.b.length) {
                len = this.b.length;
            }
            if ((len = this.read(this.b, 0, len)) != -1) continue;
            this.eof = true;
            break;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.myinflater) {
                this.inflater.end();
            }
            if (this.close_in) {
                this.in.close();
            }
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            if (this.inflater.istate.wrap == 0 && !this.inflater.finished()) {
                this.buf[0] = 0;
                this.len = 1;
            } else {
                if (this.inflater.istate.was != -1L) {
                    throw new IOException("footer is not found");
                }
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
        }
        this.inflater.setInput(this.buf, 0, this.len, true);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long getTotalIn() {
        return this.inflater.getTotalInL();
    }

    public long getTotalOut() {
        return this.inflater.getTotalOutL();
    }

    public byte[] getAvailIn() {
        if (this.inflater.avail_in <= 0) {
            return null;
        }
        byte[] tmp = new byte[this.inflater.avail_in];
        System.arraycopy(this.inflater.in, this.inflater.in_index, tmp, 0, this.inflater.avail_in);
        return tmp;
    }

    public void readHeader() throws IOException {
        byte[] empty = "".getBytes();
        this.inflater.setInput(empty, 0, 0, false);
        this.inflater.setOutput(empty, 0, 0);
        int err = this.inflater.inflate(0);
        if (!this.inflater.istate.inParsingHeader()) {
            return;
        }
        byte[] b1 = new byte[1];
        do {
            int i;
            if ((i = this.in.read(b1, 0, 1)) <= 0) {
                throw new IOException("no input");
            }
            this.inflater.setInput(b1, 0, b1.length, false);
            err = this.inflater.inflate(0);
            if (err == 0) continue;
            throw new IOException(this.inflater.msg);
        } while (this.inflater.istate.inParsingHeader());
    }

    public Inflater getInflater() {
        return this.inflater;
    }
}

