/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Math;
import smile.validation.RegressionMeasure;

public class RMSE
implements RegressionMeasure {
    @Override
    public double measure(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", dArray.length, dArray2.length));
        }
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.sqr(dArray[i] - dArray2[i]);
        }
        return Math.sqrt(d / (double)n);
    }

    public String toString() {
        return "RMSE";
    }
}

