/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.math.kernel.MercerKernel;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class GaussianProcessRegression<T>
implements Regression<T> {
    private static final long serialVersionUID = 1L;
    private T[] knots;
    private double[] w;
    private MercerKernel<T> kernel;
    private double lambda;

    public GaussianProcessRegression(T[] TArray, double[] dArray, MercerKernel<T> mercerKernel, double d) {
        if (TArray.length != dArray.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", TArray.length, dArray.length));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + d);
        }
        this.kernel = mercerKernel;
        this.lambda = d;
        this.knots = TArray;
        int n = TArray.length;
        DenseMatrix denseMatrix = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double d2 = mercerKernel.k(TArray[i], TArray[j]);
                denseMatrix.set(i, j, d2);
                denseMatrix.set(j, i, d2);
            }
            denseMatrix.add(i, i, d);
        }
        Cholesky cholesky = denseMatrix.cholesky();
        this.w = (double[])dArray.clone();
        cholesky.solve(this.w);
    }

    public GaussianProcessRegression(T[] TArray, double[] dArray, T[] TArray2, MercerKernel<T> mercerKernel, double d) {
        int n;
        if (TArray.length != dArray.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", TArray.length, dArray.length));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + d);
        }
        this.kernel = mercerKernel;
        this.lambda = d;
        this.knots = TArray2;
        int n2 = TArray.length;
        int n3 = TArray2.length;
        DenseMatrix denseMatrix = Matrix.zeros(n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                denseMatrix.set(i, n, mercerKernel.k(TArray[i], TArray2[n]));
            }
        }
        DenseMatrix denseMatrix2 = denseMatrix.ata();
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i <= n; ++i) {
                denseMatrix2.add(n, i, d * mercerKernel.k(TArray2[n], TArray2[i]));
                denseMatrix2.set(i, n, denseMatrix2.get(n, i));
            }
        }
        this.w = new double[n3];
        denseMatrix.atx(dArray, this.w);
        LU lU = denseMatrix2.lu(true);
        lU.solve(this.w);
    }

    GaussianProcessRegression(T[] TArray, double[] dArray, T[] TArray2, MercerKernel<T> mercerKernel, double d, boolean bl) {
        int n;
        if (TArray.length != dArray.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", TArray.length, dArray.length));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + d);
        }
        this.kernel = mercerKernel;
        this.lambda = d;
        this.knots = TArray;
        int n2 = TArray.length;
        int n3 = TArray2.length;
        DenseMatrix denseMatrix = Matrix.zeros(n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                denseMatrix.set(i, n, mercerKernel.k(TArray[i], TArray2[n]));
            }
        }
        DenseMatrix denseMatrix2 = Matrix.zeros(n3, n3);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i <= n; ++i) {
                double d2 = mercerKernel.k(TArray2[n], TArray2[i]);
                denseMatrix2.set(n, i, d2);
                denseMatrix2.set(i, n, d2);
            }
        }
        denseMatrix2.setSymmetric(true);
        EVD eVD = denseMatrix2.eigen();
        DenseMatrix denseMatrix3 = eVD.getEigenVectors();
        DenseMatrix denseMatrix4 = eVD.getD();
        for (int i = 0; i < n3; ++i) {
            denseMatrix4.set(i, i, 1.0 / Math.sqrt(denseMatrix4.get(i, i)));
        }
        DenseMatrix denseMatrix5 = (DenseMatrix)denseMatrix3.abmm(denseMatrix4);
        DenseMatrix denseMatrix6 = (DenseMatrix)denseMatrix5.abtmm(denseMatrix3);
        DenseMatrix denseMatrix7 = (DenseMatrix)denseMatrix.abmm(denseMatrix6);
        DenseMatrix denseMatrix8 = denseMatrix7.ata();
        for (int i = 0; i < n3; ++i) {
            denseMatrix8.add(i, i, d);
        }
        Cholesky cholesky = denseMatrix8.cholesky();
        DenseMatrix denseMatrix9 = cholesky.inverse();
        DenseMatrix denseMatrix10 = (DenseMatrix)((DenseMatrix)denseMatrix7.abmm(denseMatrix9)).abtmm(denseMatrix7);
        this.w = new double[n2];
        denseMatrix10.atx(dArray, this.w);
        for (int i = 0; i < n2; ++i) {
            this.w[i] = (dArray[i] - this.w[i]) / d;
        }
    }

    public double[] coefficients() {
        return this.w;
    }

    public double shrinkage() {
        return this.lambda;
    }

    @Override
    public double predict(T t) {
        double d = 0.0;
        for (int i = 0; i < this.knots.length; ++i) {
            d += this.w[i] * this.kernel.k(t, this.knots[i]);
        }
        return d;
    }

    public static class Trainer<T>
    extends RegressionTrainer<T> {
        private MercerKernel<T> kernel;
        private double lambda;

        public Trainer(MercerKernel<T> mercerKernel, double d) {
            this.kernel = mercerKernel;
            this.lambda = d;
        }

        @Override
        public GaussianProcessRegression<T> train(T[] TArray, double[] dArray) {
            return new GaussianProcessRegression<T>(TArray, dArray, this.kernel, this.lambda);
        }

        public GaussianProcessRegression<T> train(T[] TArray, double[] dArray, T[] TArray2) {
            return new GaussianProcessRegression<T>(TArray, dArray, TArray2, this.kernel, this.lambda);
        }
    }
}

