/*
 * Decompiled with CFR 0.152.
 */
package smile.math.random;

import smile.math.random.RandomNumberGenerator;

public class UniversalGenerator
implements RandomNumberGenerator {
    private static final int DEFAULT_RANDOM_SEED = 54217137;
    static final int BIG_PRIME = 899999963;
    private double c;
    private double cd;
    private double cm;
    private double[] u;
    private int i97;
    private int j97;

    public UniversalGenerator() {
        this.setSeed(54217137L);
    }

    public UniversalGenerator(int n) {
        this.setSeed(n);
    }

    public UniversalGenerator(long l) {
        this.setSeed(l);
    }

    @Override
    public void setSeed(long l) {
        this.u = new double[97];
        int n = Math.abs((int)(l % 899999963L));
        int n2 = n / 30082;
        int n3 = n % 30082;
        if (n2 < 0 || n2 > 31328 || n3 < 0 || n3 > 30081) {
            n2 %= 31329;
            n3 %= 30082;
        }
        int n4 = n2 / 177 % 177 + 2;
        int n5 = n2 % 177 + 2;
        int n6 = n3 / 169 % 178 + 1;
        int n7 = n3 % 169;
        for (int i = 0; i < 97; ++i) {
            double d = 0.0;
            double d2 = 0.5;
            for (int j = 0; j < 24; ++j) {
                int n8 = n4 * n5 % 179 * n6 % 179;
                n4 = n5;
                n5 = n6;
                n6 = n8;
                if ((n7 = (53 * n7 + 1) % 169) * n8 % 64 >= 32) {
                    d += d2;
                }
                d2 *= 0.5;
            }
            this.u[i] = d;
        }
        this.c = 0.021602869033813477;
        this.cd = 0.45623308420181274;
        this.cm = 0.9999998211860657;
        this.i97 = 96;
        this.j97 = 32;
    }

    @Override
    public double nextDouble() {
        double d = this.u[this.i97] - this.u[this.j97];
        if (d < 0.0) {
            d += 1.0;
        }
        this.u[this.i97] = d;
        if (--this.i97 < 0) {
            this.i97 = 96;
        }
        if (--this.j97 < 0) {
            this.j97 = 96;
        }
        this.c -= this.cd;
        if (this.c < 0.0) {
            this.c += this.cm;
        }
        if ((d -= this.c) < 0.0) {
            d += 1.0;
        }
        return d;
    }

    @Override
    public void nextDoubles(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = this.u[this.i97] - this.u[this.j97];
            if (d < 0.0) {
                d += 1.0;
            }
            this.u[this.i97] = d;
            if (--this.i97 < 0) {
                this.i97 = 96;
            }
            if (--this.j97 < 0) {
                this.j97 = 96;
            }
            this.c -= this.cd;
            if (this.c < 0.0) {
                this.c += this.cm;
            }
            if ((d -= this.c) < 0.0) {
                d += 1.0;
            }
            dArray[i] = d;
        }
    }

    @Override
    public int next(int n) {
        return this.nextInt() >>> 32 - n;
    }

    @Override
    public int nextInt() {
        return (int)Math.floor(2.147483647E9 * (2.0 * this.nextDouble() - 1.0));
    }

    @Override
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        return (int)(this.nextDouble() * (double)n);
    }

    @Override
    public long nextLong() {
        return (long)Math.floor(9.223372036854776E18 * (2.0 * this.nextDouble() - 1.0));
    }
}

