/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class QR {
    protected DenseMatrix qr;
    protected double[] tau;
    protected boolean singular;

    public QR(DenseMatrix denseMatrix, double[] dArray, boolean bl) {
        this.qr = denseMatrix;
        this.tau = dArray;
        this.singular = bl;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public Cholesky CholeskyOfAtA() {
        int n = this.qr.ncols();
        DenseMatrix denseMatrix = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, i, this.tau[i]);
            for (int j = 0; j < i; ++j) {
                denseMatrix.set(i, j, this.qr.get(j, i));
            }
        }
        return new Cholesky(denseMatrix);
    }

    public DenseMatrix getR() {
        int n = this.qr.ncols();
        DenseMatrix denseMatrix = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, i, this.tau[i]);
            for (int j = i + 1; j < n; ++j) {
                denseMatrix.set(i, j, this.qr.get(i, j));
            }
        }
        return denseMatrix;
    }

    public DenseMatrix getQ() {
        int n = this.qr.nrows();
        int n2 = this.qr.ncols();
        DenseMatrix denseMatrix = Matrix.zeros(n, n2);
        for (int i = n2 - 1; i >= 0; --i) {
            denseMatrix.set(i, i, 1.0);
            for (int j = i; j < n2; ++j) {
                int n3;
                if (this.qr.get(i, i) == 0.0) continue;
                double d = 0.0;
                for (n3 = i; n3 < n; ++n3) {
                    d += this.qr.get(n3, i) * denseMatrix.get(n3, j);
                }
                d = -d / this.qr.get(i, i);
                for (n3 = i; n3 < n; ++n3) {
                    denseMatrix.add(n3, j, d * this.qr.get(n3, i));
                }
            }
        }
        return denseMatrix;
    }

    public void solve(double[] dArray, double[] dArray2) {
        if (dArray.length != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x 1", this.qr.nrows(), this.qr.nrows(), dArray.length));
        }
        if (dArray2.length != this.qr.ncols()) {
            throw new IllegalArgumentException("A and x dimensions don't match.");
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        double[] dArray3 = (double[])dArray.clone();
        this.solve(Matrix.newInstance(dArray3));
        System.arraycopy(dArray3, 0, dArray2, 0, dArray2.length);
    }

    public void solve(DenseMatrix denseMatrix) {
        int n;
        int n2;
        if (denseMatrix.nrows() != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.qr.nrows(), this.qr.nrows(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n3 = this.qr.nrows();
        int n4 = this.qr.ncols();
        int n5 = denseMatrix.ncols();
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                int n6;
                double d = 0.0;
                for (n6 = n2; n6 < n3; ++n6) {
                    d += this.qr.get(n6, n2) * denseMatrix.get(n6, n);
                }
                d = -d / this.qr.get(n2, n2);
                for (n6 = n2; n6 < n3; ++n6) {
                    denseMatrix.add(n6, n, d * this.qr.get(n6, n2));
                }
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            for (n = 0; n < n5; ++n) {
                denseMatrix.set(n2, n, denseMatrix.get(n2, n) / this.tau[n2]);
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n5; ++i) {
                    denseMatrix.sub(n, i, denseMatrix.get(n2, i) * this.qr.get(n, n2));
                }
            }
        }
    }
}

