/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.LinkedList;
import smile.clustering.FastPair;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.sort.IntHeapSelect;

public class HierarchicalClustering {
    private static final long serialVersionUID = 1L;
    private int[][] merge;
    private double[] height;

    public HierarchicalClustering(Linkage linkage) {
        int n;
        int n2 = linkage.size();
        this.merge = new int[n2 - 1][2];
        int[] nArray = new int[n2];
        this.height = new double[n2 - 1];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = i;
            nArray[i] = i;
        }
        FastPair fastPair = new FastPair(nArray2, linkage);
        for (n = 0; n < n2 - 1; ++n) {
            this.height[n] = fastPair.getNearestPair(this.merge[n]);
            linkage.merge(this.merge[n][0], this.merge[n][1]);
            fastPair.remove(this.merge[n][1]);
            fastPair.updatePoint(this.merge[n][0]);
            int n3 = this.merge[n][0];
            int n4 = this.merge[n][1];
            this.merge[n][0] = Math.min(nArray[n3], nArray[n4]);
            this.merge[n][1] = Math.max(nArray[n3], nArray[n4]);
            nArray[n3] = n2 + n;
        }
        if (linkage instanceof UPGMCLinkage || linkage instanceof WPGMCLinkage || linkage instanceof WardLinkage) {
            for (n = 0; n < this.height.length; ++n) {
                this.height[n] = Math.sqrt(this.height[n]);
            }
        }
    }

    public int[][] getTree() {
        return this.merge;
    }

    public double[] getHeight() {
        return this.height;
    }

    public int[] partition(int n) {
        int n2;
        int n3 = this.merge.length + 1;
        int[] nArray = new int[n3];
        IntHeapSelect intHeapSelect = new IntHeapSelect(n);
        for (n2 = 2; n2 <= n; ++n2) {
            intHeapSelect.add(this.merge[n3 - n2][0]);
            intHeapSelect.add(this.merge[n3 - n2][1]);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.bfs(nArray, intHeapSelect.get(n2), n2);
        }
        return nArray;
    }

    public int[] partition(double d) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.height.length - 1; ++n2) {
            if (!(this.height[n2] > this.height[n2 + 1])) continue;
            throw new IllegalStateException("Non-monotonic cluster tree -- the linkage is probably not appropriate!");
        }
        n2 = this.merge.length + 1;
        for (n = 2; n <= n2 && !(this.height[n2 - n] < d); ++n) {
        }
        if (n <= 2) {
            throw new IllegalArgumentException("The parameter h is too large.");
        }
        return this.partition(n - 1);
    }

    private void bfs(int[] nArray, int n, int n2) {
        int n3 = this.merge.length + 1;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.offer(n);
        Integer n4 = (Integer)linkedList.poll();
        while (n4 != null) {
            if (n4 < n3) {
                nArray[n4.intValue()] = n2;
            } else {
                int n5 = this.merge[n4 = Integer.valueOf(n4 - n3)][0];
                if (n5 >= n3) {
                    linkedList.offer(n5);
                } else {
                    nArray[n5] = n2;
                }
                int n6 = this.merge[n4][1];
                if (n6 >= n3) {
                    linkedList.offer(n6);
                } else {
                    nArray[n6] = n2;
                }
            }
            n4 = (Integer)linkedList.poll();
        }
    }
}

