/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;

public class RigidFragment {
    int mCoreAtomCount;
    int[] mCoreToFragmentAtom;
    int[] mFragmentToOriginalAtom;
    int[] mExtendedToFragmentAtom;
    int[] mOriginalToExtendedAtom;
    Conformer[] mConformerList;
    double[] mConformerLikelihood;

    public RigidFragment(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, Conformer[] conformerArray, double[] dArray) {
        this.mCoreAtomCount = n;
        this.mCoreToFragmentAtom = nArray;
        this.mFragmentToOriginalAtom = nArray2;
        this.mExtendedToFragmentAtom = nArray3;
        this.mOriginalToExtendedAtom = nArray4;
        this.mConformerList = conformerArray;
        this.mConformerLikelihood = dArray;
    }

    public Coordinates getCoreCoordinates(int n, int n2) {
        return this.mConformerList[n].getCoordinates(this.mCoreToFragmentAtom[n2]);
    }

    public Coordinates getExtendedCoordinates(int n, int n2) {
        return this.mConformerList[n].getCoordinates(this.mExtendedToFragmentAtom[n2]);
    }

    public int getConformerCount() {
        return this.mConformerList.length;
    }

    public double getConformerLikelihood(int n) {
        return this.mConformerLikelihood[n];
    }

    public int getLikelyRandomConformerIndex(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.mConformerLikelihood.length; ++i) {
            double d4 = (1.0 - d2) * this.mConformerLikelihood[i] + d2 / (double)this.mConformerLikelihood.length;
            if (!(d <= (d3 += d4))) continue;
            return i;
        }
        return this.mConformerLikelihood.length - 1;
    }

    public int originalToExtendedAtom(int n) {
        return this.mOriginalToExtendedAtom[n];
    }

    public int coreToOriginalAtom(int n) {
        return this.mFragmentToOriginalAtom[this.mCoreToFragmentAtom[n]];
    }

    public int extendedToOriginalAtom(int n) {
        return this.mFragmentToOriginalAtom[this.mExtendedToFragmentAtom[n]];
    }

    public int getConnectionPointCount() {
        return this.mExtendedToFragmentAtom.length - this.mCoreToFragmentAtom.length;
    }

    public int getCoreSize() {
        return this.mCoreToFragmentAtom.length;
    }

    public int getExtendedSize() {
        return this.mExtendedToFragmentAtom.length;
    }
}

