/*
 * Decompiled with CFR 0.152.
 */
package org.machinelearning.svm.libsvm;

import org.machinelearning.svm.libsvm.QMatrix;
import org.machinelearning.svm.libsvm.svm;

class Solver {
    int active_size;
    byte[] y;
    double[] G;
    static final byte LOWER_BOUND = 0;
    static final byte UPPER_BOUND = 1;
    static final byte FREE = 2;
    byte[] alpha_status;
    double[] alpha;
    QMatrix Q;
    double[] QD;
    double eps;
    double Cp;
    double Cn;
    double[] p;
    int[] active_set;
    double[] G_bar;
    int l;
    boolean unshrink;
    static final double INF = Double.POSITIVE_INFINITY;

    Solver() {
    }

    double get_C(int n) {
        return this.y[n] > 0 ? this.Cp : this.Cn;
    }

    void update_alpha_status(int n) {
        this.alpha_status[n] = this.alpha[n] >= this.get_C(n) ? 1 : (this.alpha[n] <= 0.0 ? 0 : 2);
    }

    boolean is_upper_bound(int n) {
        return this.alpha_status[n] == 1;
    }

    boolean is_lower_bound(int n) {
        return this.alpha_status[n] == 0;
    }

    boolean is_free(int n) {
        return this.alpha_status[n] == 2;
    }

    void swap_index(int n, int n2) {
        this.Q.swap_index(n, n2);
        byte by = this.y[n];
        this.y[n] = this.y[n2];
        this.y[n2] = by;
        double d = this.G[n];
        this.G[n] = this.G[n2];
        this.G[n2] = d;
        byte by2 = this.alpha_status[n];
        this.alpha_status[n] = this.alpha_status[n2];
        this.alpha_status[n2] = by2;
        double d2 = this.alpha[n];
        this.alpha[n] = this.alpha[n2];
        this.alpha[n2] = d2;
        d2 = this.p[n];
        this.p[n] = this.p[n2];
        this.p[n2] = d2;
        int n3 = this.active_set[n];
        this.active_set[n] = this.active_set[n2];
        this.active_set[n2] = n3;
        double d3 = this.G_bar[n];
        this.G_bar[n] = this.G_bar[n2];
        this.G_bar[n2] = d3;
    }

    void reconstruct_gradient() {
        int n;
        if (this.active_size == this.l) {
            return;
        }
        int n2 = 0;
        for (n = this.active_size; n < this.l; ++n) {
            this.G[n] = this.G_bar[n] + this.p[n];
        }
        for (n = 0; n < this.active_size; ++n) {
            if (!this.is_free(n)) continue;
            ++n2;
        }
        if (2 * n2 < this.active_size) {
            svm.info("\nWARNING: using -h 0 may be faster\n");
        }
        if (n2 * this.l > 2 * this.active_size * (this.l - this.active_size)) {
            for (int i = this.active_size; i < this.l; ++i) {
                float[] fArray = this.Q.get_Q(i, this.active_size);
                for (n = 0; n < this.active_size; ++n) {
                    if (!this.is_free(n)) continue;
                    int n3 = i;
                    this.G[n3] = this.G[n3] + this.alpha[n] * (double)fArray[n];
                }
            }
        } else {
            for (int i = 0; i < this.active_size; ++i) {
                if (!this.is_free(i)) continue;
                float[] fArray = this.Q.get_Q(i, this.l);
                double d = this.alpha[i];
                for (n = this.active_size; n < this.l; ++n) {
                    int n4 = n;
                    this.G[n4] = this.G[n4] + d * (double)fArray[n];
                }
            }
        }
    }

    void Solve(int n, QMatrix qMatrix, double[] dArray, byte[] byArray, double[] dArray2, double d, double d2, double d3, SolutionInfo solutionInfo, int n2) {
        int n3;
        int n4;
        this.l = n;
        this.Q = qMatrix;
        this.QD = qMatrix.get_QD();
        this.p = (double[])dArray.clone();
        this.y = (byte[])byArray.clone();
        this.alpha = (double[])dArray2.clone();
        this.Cp = d;
        this.Cn = d2;
        this.eps = d3;
        this.unshrink = false;
        this.alpha_status = new byte[n];
        for (n4 = 0; n4 < n; ++n4) {
            this.update_alpha_status(n4);
        }
        this.active_set = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            this.active_set[n4] = n4;
        }
        this.active_size = n;
        this.G = new double[n];
        this.G_bar = new double[n];
        for (n4 = 0; n4 < n; ++n4) {
            this.G[n4] = this.p[n4];
            this.G_bar[n4] = 0.0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            if (this.is_lower_bound(n4)) continue;
            float[] fArray = qMatrix.get_Q(n4, n);
            double d4 = this.alpha[n4];
            for (n3 = 0; n3 < n; ++n3) {
                int n5 = n3;
                this.G[n5] = this.G[n5] + d4 * (double)fArray[n3];
            }
            if (!this.is_upper_bound(n4)) continue;
            for (n3 = 0; n3 < n; ++n3) {
                int n6 = n3;
                this.G_bar[n6] = this.G_bar[n6] + this.get_C(n4) * (double)fArray[n3];
            }
        }
        n4 = 0;
        int n7 = Math.max(10000000, n > 21474836 ? Integer.MAX_VALUE : 100 * n);
        int n8 = Math.min(n, 1000) + 1;
        int[] nArray = new int[2];
        while (n4 < n7) {
            int n9;
            int n10;
            double d5;
            double d6;
            double d7;
            if (--n8 == 0) {
                n8 = Math.min(n, 1000);
                if (n2 != 0) {
                    this.do_shrinking();
                }
                svm.info(".");
            }
            if (this.select_working_set(nArray) != 0) {
                this.reconstruct_gradient();
                this.active_size = n;
                svm.info("*");
                if (this.select_working_set(nArray) != 0) break;
                n8 = 1;
            }
            n3 = nArray[0];
            int n11 = nArray[1];
            ++n4;
            float[] fArray = qMatrix.get_Q(n3, this.active_size);
            float[] fArray2 = qMatrix.get_Q(n11, this.active_size);
            double d8 = this.get_C(n3);
            double d9 = this.get_C(n11);
            double d10 = this.alpha[n3];
            double d11 = this.alpha[n11];
            if (this.y[n3] != this.y[n11]) {
                d7 = this.QD[n3] + this.QD[n11] + (double)(2.0f * fArray[n11]);
                if (d7 <= 0.0) {
                    d7 = 1.0E-12;
                }
                d6 = (-this.G[n3] - this.G[n11]) / d7;
                d5 = this.alpha[n3] - this.alpha[n11];
                int n12 = n3;
                this.alpha[n12] = this.alpha[n12] + d6;
                int n13 = n11;
                this.alpha[n13] = this.alpha[n13] + d6;
                if (d5 > 0.0) {
                    if (this.alpha[n11] < 0.0) {
                        this.alpha[n11] = 0.0;
                        this.alpha[n3] = d5;
                    }
                } else if (this.alpha[n3] < 0.0) {
                    this.alpha[n3] = 0.0;
                    this.alpha[n11] = -d5;
                }
                if (d5 > d8 - d9) {
                    if (this.alpha[n3] > d8) {
                        this.alpha[n3] = d8;
                        this.alpha[n11] = d8 - d5;
                    }
                } else if (this.alpha[n11] > d9) {
                    this.alpha[n11] = d9;
                    this.alpha[n3] = d9 + d5;
                }
            } else {
                d7 = this.QD[n3] + this.QD[n11] - (double)(2.0f * fArray[n11]);
                if (d7 <= 0.0) {
                    d7 = 1.0E-12;
                }
                d6 = (this.G[n3] - this.G[n11]) / d7;
                d5 = this.alpha[n3] + this.alpha[n11];
                int n14 = n3;
                this.alpha[n14] = this.alpha[n14] - d6;
                int n15 = n11;
                this.alpha[n15] = this.alpha[n15] + d6;
                if (d5 > d8) {
                    if (this.alpha[n3] > d8) {
                        this.alpha[n3] = d8;
                        this.alpha[n11] = d5 - d8;
                    }
                } else if (this.alpha[n11] < 0.0) {
                    this.alpha[n11] = 0.0;
                    this.alpha[n3] = d5;
                }
                if (d5 > d9) {
                    if (this.alpha[n11] > d9) {
                        this.alpha[n11] = d9;
                        this.alpha[n3] = d5 - d9;
                    }
                } else if (this.alpha[n3] < 0.0) {
                    this.alpha[n3] = 0.0;
                    this.alpha[n11] = d5;
                }
            }
            d7 = this.alpha[n3] - d10;
            d6 = this.alpha[n11] - d11;
            for (n10 = 0; n10 < this.active_size; ++n10) {
                int n16 = n10;
                this.G[n16] = this.G[n16] + ((double)fArray[n10] * d7 + (double)fArray2[n10] * d6);
            }
            n10 = this.is_upper_bound(n3) ? 1 : 0;
            boolean bl = this.is_upper_bound(n11);
            this.update_alpha_status(n3);
            this.update_alpha_status(n11);
            if (n10 != this.is_upper_bound(n3)) {
                fArray = qMatrix.get_Q(n3, n);
                if (n10 != 0) {
                    for (n9 = 0; n9 < n; ++n9) {
                        int n17 = n9;
                        this.G_bar[n17] = this.G_bar[n17] - d8 * (double)fArray[n9];
                    }
                } else {
                    for (n9 = 0; n9 < n; ++n9) {
                        int n18 = n9;
                        this.G_bar[n18] = this.G_bar[n18] + d8 * (double)fArray[n9];
                    }
                }
            }
            if (bl == this.is_upper_bound(n11)) continue;
            fArray2 = qMatrix.get_Q(n11, n);
            if (bl) {
                for (n9 = 0; n9 < n; ++n9) {
                    int n19 = n9;
                    this.G_bar[n19] = this.G_bar[n19] - d9 * (double)fArray2[n9];
                }
                continue;
            }
            for (n9 = 0; n9 < n; ++n9) {
                int n20 = n9;
                this.G_bar[n20] = this.G_bar[n20] + d9 * (double)fArray2[n9];
            }
        }
        if (n4 >= n7) {
            if (this.active_size < n) {
                this.reconstruct_gradient();
                this.active_size = n;
                svm.info("*");
            }
            System.err.print("\nWARNING: reaching max number of iterations\n");
            throw new RuntimeException("WARNING: reaching max number of iterations");
        }
        solutionInfo.rho = this.calculate_rho();
        double d12 = 0.0;
        for (int i = 0; i < n; ++i) {
            d12 += this.alpha[i] * (this.G[i] + this.p[i]);
        }
        solutionInfo.obj = d12 / 2.0;
        for (int i = 0; i < n; ++i) {
            dArray2[this.active_set[i]] = this.alpha[i];
        }
        solutionInfo.upper_bound_p = d;
        solutionInfo.upper_bound_n = d2;
        svm.info("\noptimization finished, #iter = " + n4 + "\n");
    }

    int select_working_set(int[] nArray) {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        int n3 = -1;
        double d3 = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (this.y[n] == 1) {
                if (this.is_upper_bound(n) || !(-this.G[n] >= d)) continue;
                d = -this.G[n];
                n2 = n;
                continue;
            }
            if (this.is_lower_bound(n) || !(this.G[n] >= d)) continue;
            d = this.G[n];
            n2 = n;
        }
        n = n2;
        float[] fArray = null;
        if (n != -1) {
            fArray = this.Q.get_Q(n, this.active_size);
        }
        for (int i = 0; i < this.active_size; ++i) {
            double d4;
            double d5;
            double d6;
            if (this.y[i] == 1) {
                if (this.is_lower_bound(i)) continue;
                d6 = d + this.G[i];
                if (this.G[i] >= d2) {
                    d2 = this.G[i];
                }
                if (!(d6 > 0.0) || !((d5 = (d4 = this.QD[n] + this.QD[i] - 2.0 * (double)this.y[n] * (double)fArray[i]) > 0.0 ? -(d6 * d6) / d4 : -(d6 * d6) / 1.0E-12) <= d3)) continue;
                n3 = i;
                d3 = d5;
                continue;
            }
            if (this.is_upper_bound(i)) continue;
            d6 = d - this.G[i];
            if (-this.G[i] >= d2) {
                d2 = -this.G[i];
            }
            if (!(d6 > 0.0) || !((d5 = (d4 = this.QD[n] + this.QD[i] + 2.0 * (double)this.y[n] * (double)fArray[i]) > 0.0 ? -(d6 * d6) / d4 : -(d6 * d6) / 1.0E-12) <= d3)) continue;
            n3 = i;
            d3 = d5;
        }
        if (d + d2 < this.eps || n3 == -1) {
            return 1;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return 0;
    }

    private boolean be_shrunk(int n, double d, double d2) {
        if (this.is_upper_bound(n)) {
            if (this.y[n] == 1) {
                return -this.G[n] > d;
            }
            return -this.G[n] > d2;
        }
        if (this.is_lower_bound(n)) {
            if (this.y[n] == 1) {
                return this.G[n] > d2;
            }
            return this.G[n] > d;
        }
        return false;
    }

    void do_shrinking() {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (this.y[n] == 1) {
                if (!this.is_upper_bound(n) && -this.G[n] >= d) {
                    d = -this.G[n];
                }
                if (this.is_lower_bound(n) || !(this.G[n] >= d2)) continue;
                d2 = this.G[n];
                continue;
            }
            if (!this.is_upper_bound(n) && -this.G[n] >= d2) {
                d2 = -this.G[n];
            }
            if (this.is_lower_bound(n) || !(this.G[n] >= d)) continue;
            d = this.G[n];
        }
        if (!this.unshrink && d + d2 <= this.eps * 10.0) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.active_size = this.l;
        }
        block1: for (n = 0; n < this.active_size; ++n) {
            if (!this.be_shrunk(n, d, d2)) continue;
            --this.active_size;
            while (this.active_size > n) {
                if (!this.be_shrunk(this.active_size, d, d2)) {
                    this.swap_index(n, this.active_size);
                    continue block1;
                }
                --this.active_size;
            }
        }
    }

    double calculate_rho() {
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        for (int i = 0; i < this.active_size; ++i) {
            double d4 = (double)this.y[i] * this.G[i];
            if (this.is_lower_bound(i)) {
                if (this.y[i] > 0) {
                    d = Math.min(d, d4);
                    continue;
                }
                d2 = Math.max(d2, d4);
                continue;
            }
            if (this.is_upper_bound(i)) {
                if (this.y[i] < 0) {
                    d = Math.min(d, d4);
                    continue;
                }
                d2 = Math.max(d2, d4);
                continue;
            }
            ++n;
            d3 += d4;
        }
        double d5 = n > 0 ? d3 / (double)n : (d + d2) / 2.0;
        return d5;
    }

    static class SolutionInfo {
        double obj;
        double rho;
        double upper_bound_p;
        double upper_bound_n;
        double r;

        SolutionInfo() {
        }
    }
}

