/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.PT;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.ModulationSet;

public class Modulation {
    private static final double TWOPI = Math.PI * 2;
    private double[] qCoefs;
    private double a1;
    private double a2;
    private double center;
    private double left;
    private double right;
    private int order;
    private char axis;
    private final char type;
    private double[] params;
    private String utens;
    private double delta2;
    public static final char TYPE_DISP_FOURIER = 'f';
    public static final char TYPE_SPIN_FOURIER = 'm';
    public static final char TYPE_SPIN_SAWTOOTH = 't';
    public static final char TYPE_DISP_SAWTOOTH = 's';
    public static final char TYPE_OCC_FOURIER = 'o';
    public static final char TYPE_OCC_CRENEL = 'c';
    public static final char TYPE_U_FOURIER = 'u';
    public static final char TYPE_DISP_LEGENDRE = 'l';
    public static final char TYPE_U_LEGENDRE = 'L';
    static double[][] legendre = new double[][]{{1.0}, {0.0, 1.0}};

    public Modulation(char axis2, char type, double[] params, String utens, double[] qCoefs) {
        Logger.info("MOD create " + Escape.e(qCoefs) + " axis=" + axis2 + " type=" + type + " params=" + Escape.e(params) + " utens=" + utens);
        this.axis = axis2;
        this.type = type;
        this.utens = utens;
        this.params = params;
        this.qCoefs = qCoefs;
        switch (type) {
            case 'f': 
            case 'm': 
            case 'o': 
            case 'u': {
                this.a1 = params[0];
                this.a2 = params[1];
                break;
            }
            case 'L': 
            case 'l': {
                this.a1 = params[2];
                this.order = (int)params[3];
                this.calcLegendre(this.order);
            }
            case 'c': 
            case 's': 
            case 't': {
                this.center = params[0];
                this.delta2 = params[1] / 2.0;
                if (this.delta2 > 0.5) {
                    this.delta2 = 0.5;
                }
                this.left = this.center - this.delta2;
                this.right = this.center + this.delta2;
                if (this.left < 0.0) {
                    this.left += 1.0;
                }
                if (this.right > 1.0) {
                    this.right -= 1.0;
                }
                if (this.left >= this.right && this.left - this.right < (double)0.01f) {
                    this.left = this.right + (double)0.01f;
                }
                if (this.a1 != 0.0) break;
                this.a1 = params[2] / this.delta2;
            }
        }
    }

    void apply(ModulationSet ms, double[][] t) {
        double v = 0.0;
        double nt = 0.0;
        boolean isSpin = false;
        int i = this.qCoefs.length;
        while (--i >= 0) {
            nt += this.qCoefs[i] * t[i][0];
        }
        switch (this.type) {
            case 'm': {
                isSpin = true;
            }
            case 'f': 
            case 'o': 
            case 'u': {
                double theta = Math.PI * 2 * nt;
                if (this.a1 != 0.0) {
                    v += this.a1 * Math.sin(theta);
                }
                if (this.a2 != 0.0) {
                    v += this.a2 * Math.cos(theta);
                }
                if (!Logger.debuggingHigh) break;
                Logger.info("MOD " + ms.id + " " + t[0][0] + " " + Escape.e(this.qCoefs) + " axis=" + this.axis + " v=" + v + " csin,ccos=" + this.a1 + "," + this.a2 + " / theta=" + theta);
                break;
            }
            case 'L': 
            case 'l': {
                double x;
                ms.occAbsolute = true;
                nt -= Math.floor(nt);
                if (!this.range(nt)) {
                    ms.vOcc = 0.0;
                    return;
                }
                ms.vOcc = 1.0;
                x = (x + 1.0) % 2.0 + (double)((x = (nt - this.center) / this.delta2) < -1.0 ? 1 : -1);
                double xp = 1.0;
                double[] p = legendre[this.order];
                int i2 = 0;
                int n = p.length;
                while (true) {
                    v += p[i2] * xp;
                    if (++i2 == n) break;
                    xp *= x;
                }
                v *= this.a1;
                break;
            }
            case 'c': {
                ms.occAbsolute = true;
                ms.vOcc = this.range(nt - Math.floor(nt)) ? 1 : 0;
                return;
            }
            case 't': {
                isSpin = true;
            }
            case 's': {
                ms.occAbsolute = true;
                nt -= Math.floor(nt);
                if (!this.range(nt)) {
                    ms.vOcc = 0.0;
                    return;
                }
                ms.vOcc = 1.0;
                if (this.left > this.right) {
                    if (nt < this.left && this.left < this.center) {
                        nt += 1.0;
                    } else if (nt > this.right && this.right > this.center) {
                        nt -= 1.0;
                    }
                }
                v = this.a1 * (nt - this.center);
            }
        }
        if (isSpin) {
            double[] f = ms.axesLengths;
            if (f == null) {
                System.out.println("Modulation.java axis error");
            }
            switch (this.axis) {
                case 'x': {
                    ms.mxyz.x += v / f[0];
                    break;
                }
                case 'y': {
                    ms.mxyz.y += v / f[1];
                    break;
                }
                case 'z': {
                    ms.mxyz.z += v / f[2];
                }
            }
        } else {
            switch (this.axis) {
                case 'x': {
                    ms.x += v;
                    break;
                }
                case 'y': {
                    ms.y += v;
                    break;
                }
                case 'z': {
                    ms.z += v;
                    break;
                }
                case 'U': {
                    ms.addUTens(this.utens, v);
                    break;
                }
                default: {
                    if (Double.isNaN(ms.vOcc)) {
                        ms.vOcc = 0.0;
                    }
                    ms.vOcc += v;
                }
            }
        }
    }

    private boolean range(double x4) {
        return this.left < this.right ? this.left <= x4 && x4 <= this.right : this.left <= x4 || x4 <= this.right;
    }

    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("type", "" + this.type + this.axis);
        info.put("params", this.params);
        info.put("qCoefs", this.qCoefs);
        if (this.utens != null) {
            info.put("Utens", this.utens);
        }
        return info;
    }

    synchronized void calcLegendre(int m) {
        int n = legendre.length;
        if (n > m) {
            return;
        }
        double[][] l = AU.newDouble2((m += 3) + 1);
        for (int i = 0; i < n; ++i) {
            l[i] = legendre[i];
        }
        while (n <= m) {
            l[n] = new double[n + 1];
            double[] p = l[n];
            for (int i = 0; i < n; ++i) {
                p[i + 1] = (double)(2 * n - 1) * l[n - 1][i] / (double)n;
                if (i >= n - 1) continue;
                int n2 = i;
                p[n2] = p[n2] + (double)(1 - n) * l[n - 2][i] / (double)n;
            }
            ++n;
        }
        legendre = l;
    }

    public String toString() {
        return "[Modulation " + this.type + " " + PT.toJSON(null, this.params) + "]";
    }
}

