/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import org.jmol.api.Interface;
import org.jmol.c.STR;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.NucleicRenderer;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.shapebio.BioShape;

public class CartoonRenderer
extends RocketsRenderer {
    private NucleicRenderer nucleicRenderer;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        if (!this.setupRR(bioShape, false)) {
            return;
        }
        if (this.isNucleic || this.isPhosphorusOnly) {
            if (this.nucleicRenderer == null) {
                this.nucleicRenderer = (NucleicRenderer)Interface.getInterface("org.jmol.renderbio.NucleicRenderer", this.vwr, "render");
            }
            this.calcScreenControlPoints();
            this.nucleicRenderer.renderNucleic(this);
            return;
        }
        boolean val = this.vwr.getBoolean(603979819);
        if (this.helixRockets != val) {
            bioShape.falsifyMesh();
            this.helixRockets = val;
        }
        this.ribbonTopScreens = this.calcScreens(0.5, this.mads);
        this.ribbonBottomScreens = this.calcScreens(-0.5, this.mads);
        this.calcRopeMidPoints();
        this.renderProtein();
        this.vwr.freeTempPoints(this.cordMidPoints);
        this.vwr.freeTempPoints(this.ribbonTopScreens);
        this.vwr.freeTempPoints(this.ribbonBottomScreens);
    }

    private void renderProtein() {
        boolean lastWasSheet = false;
        boolean lastWasHelix = false;
        ProteinStructure previousStructure = null;
        boolean needRockets = this.helixRockets || !this.renderArrowHeads;
        boolean doRockets = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            boolean isSheet;
            ProteinStructure thisStructure = (ProteinStructure)this.monomers[i].getStructure();
            if (thisStructure != previousStructure) {
                lastWasSheet = false;
            }
            previousStructure = thisStructure;
            boolean isHelix = this.structureTypes[i] == STR.HELIX;
            boolean bl = isSheet = this.structureTypes[i] == STR.SHEET;
            if (this.bsVisible.get(i)) {
                if (isHelix && needRockets) {
                    doRockets = true;
                } else if (isSheet || isHelix) {
                    if (lastWasSheet && isSheet || lastWasHelix && isHelix) {
                        this.renderHermiteRibbon(true, i, true);
                    } else {
                        this.renderHermiteArrowHead(i);
                    }
                } else {
                    this.renderHermiteConic(i, true, 7);
                }
            }
            lastWasSheet = isSheet;
            lastWasHelix = isHelix && !this.helixRockets;
        }
        if (doRockets) {
            this.renderRockets();
        }
    }
}

