/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3d;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;
import org.jmol.viewer.JC;

public class AxesRenderer
extends CageRenderer {
    private final P3d originScreen = new P3d();
    private short[] colixes = new short[3];
    private P3d pt000;
    private final P3d ptTemp = new P3d();

    @Override
    protected void initRenderer() {
        this.endcap = (byte)2;
        this.draw000 = false;
    }

    @Override
    protected boolean render() {
        SymmetryInterface unitcell;
        boolean isXY;
        Axes axes = (Axes)this.shape;
        int mad10 = this.vwr.getObjectMad10(1);
        boolean bl = isXY = axes.axisXY.z != 0.0;
        if (mad10 == 0 || !this.g3d.checkTranslucent(false)) {
            return false;
        }
        if (isXY ? this.exportType == 1 : this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        int modelIndex = this.vwr.am.cmi;
        if (this.ms.isJmolDataFrameForModel(modelIndex) && !this.ms.getJmolFrameType(modelIndex).equals("plot data")) {
            return false;
        }
        boolean isUnitCell = this.vwr.g.axesMode == 0x24000020;
        SymmetryInterface symmetryInterface = unitcell = isUnitCell ? this.vwr.getCurrentUnitCell() : null;
        if (isUnitCell && (unitcell == null || modelIndex < 0)) {
            return false;
        }
        this.imageFontScaling = this.vwr.imageFontScaling;
        if (this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        this.font3d = this.vwr.gdata.getFont3DScaled(axes.font3d, this.imageFontScaling);
        isUnitCell = isUnitCell && unitcell != null && this.ms.unitCells != null;
        String axisType = isUnitCell ? axes.axisType : null;
        boolean isabcxyz = isXY && isUnitCell && axes.axes2 != null;
        this.isPolymer = isUnitCell && unitcell.isPolymer();
        this.isSlab = isUnitCell && unitcell.isSlab();
        this.nDims = isUnitCell ? unitcell.getDimensionality() : 3;
        this.periodicity = isUnitCell ? unitcell.getPeriodicity() : 7;
        this.setShifts();
        double scale = axes.scale;
        if (isabcxyz) {
            if ("xyzabc".equals(axes.axes2)) {
                this.render1(axes, mad10, false, axisType, isUnitCell, 2.0, null);
            }
            if (!"abc".equals(axes.axes2)) {
                this.vwr.setBooleanProperty("axesmolecular", true);
            }
            axes.reinitShape();
            this.render1(axes, mad10, true, null, false, scale, axes.axes2);
            this.vwr.setBooleanProperty("axesunitcell", true);
        } else {
            this.render1(axes, mad10, isXY, axisType, isUnitCell, scale, null);
        }
        return true;
    }

    private void render1(Axes axes, int mad10, boolean isXY, String axisType, boolean isUnitCell, double scale, String labels2) {
        boolean showOrigin;
        boolean checkAxisType;
        boolean isDataFrame = this.vwr.isJmolDataFrame();
        this.pt000 = isDataFrame ? this.pt0 : axes.originPoint;
        int nPoints = 6;
        int labelPtr = 0;
        if (isUnitCell) {
            nPoints = 3;
            labelPtr = 6;
        } else if (isXY) {
            nPoints = 3;
            labelPtr = 9;
        } else if (this.vwr.g.axesMode == 603979809) {
            nPoints = 6;
            int n = labelPtr = this.vwr.getBoolean(603979806) ? 15 : 9;
        }
        if (axes.labels != null) {
            if (nPoints != 3) {
                nPoints = axes.labels.length < 6 ? 3 : 6;
            }
            labelPtr = -1;
        }
        int slab = this.vwr.gdata.slab;
        int diameter = mad10;
        boolean drawTicks = false;
        this.ptTemp.setT(this.originScreen);
        boolean bl = checkAxisType = labels2 == null && axisType != null && (isXY || this.vwr.getDouble(0x22000001) != 0.0 || axes.fixedOrigin != null);
        if (isXY) {
            if (mad10 >= 20) {
                int n = diameter = mad10 > 500 ? 3 : mad10 / 200;
                if (diameter == 0) {
                    diameter = 2;
                }
            }
            if (this.g3d.isAntialiased()) {
                diameter += diameter;
            }
            this.g3d.setSlab(0);
            this.ptTemp.setT(axes.axisXY);
            this.pt0i.setT(this.tm.transformPt2D(this.ptTemp));
            if (this.ptTemp.x < 0.0) {
                int offx = (int)this.ptTemp.x;
                int offy = (int)this.ptTemp.x;
                this.pointT.setT(this.pt000);
                for (int i = 0; i < 3; ++i) {
                    this.pointT.add(axes.getAxisPoint(i, false, this.ptTemp));
                }
                this.pt0i.setT(this.tm.transformPt(this.pt000));
                this.pt2i.scaleAdd(-1, this.pt0i, this.tm.transformPt(this.pointT));
                if (this.pt2i.x < 0) {
                    offx = -offx;
                }
                if (this.pt2i.y < 0) {
                    offy = -offy;
                }
                this.pt0i.x += offx;
                this.pt0i.y += offy;
            }
            this.ptTemp.set(this.pt0i.x, this.pt0i.y, this.pt0i.z);
            double zoomDimension = this.vwr.getScreenDim();
            double scaleFactor = zoomDimension / 10.0 * scale;
            if (this.g3d.isAntialiased()) {
                scaleFactor *= 2.0;
            }
            if ((isUnitCell || "abc".equals(axes.axes2)) && isXY) {
                scaleFactor /= 2.0;
            }
            for (int i = 0; i < 3; ++i) {
                P3d pt = this.p3Screens[i];
                this.tm.rotatePoint(axes.getAxisPoint(i, false, this.pointT), pt);
                pt.z *= -1.0;
                pt.scaleAdd2(scaleFactor, pt, this.ptTemp);
            }
        } else {
            boolean bl2 = drawTicks = axes.tickInfos != null;
            if (drawTicks) {
                this.checkTickTemps();
                this.tickA.setT(this.pt000);
            }
            this.tm.transformPtNoClip(this.pt000, this.ptTemp);
            diameter = this.getDiameter((int)this.ptTemp.z, mad10);
            int i = nPoints;
            while (--i >= 0) {
                P3d p = axes.getAxisPoint(i, !isDataFrame, this.pointT);
                this.tm.transformPtNoClip(p, this.p3Screens[i]);
            }
            if (this.shifting) {
                if (this.vvert == null) {
                    this.vvert = new P3d[]{new P3d(), new P3d(), new P3d(), new P3d(), new P3d(), new P3d()};
                }
                if (this.shiftA) {
                    this.setVVert(axes, 0);
                }
                if (this.shiftB) {
                    this.setVVert(axes, 1);
                }
                if (this.shiftC) {
                    this.setVVert(axes, 2);
                }
            }
        }
        double xCenter = this.ptTemp.x;
        double yCenter = this.ptTemp.y;
        this.colixes[0] = this.vwr.getObjectColix(1);
        this.colixes[1] = this.vwr.getObjectColix(2);
        this.colixes[2] = this.vwr.getObjectColix(3);
        boolean bl3 = showOrigin = this.nDims == 3 && !isXY && nPoints == 3 && (scale == 2.0 || isUnitCell);
        if (this.nDims == 2) {
            nPoints = 2;
        }
        int i = nPoints;
        while (--i >= 0) {
            String label;
            if (labels2 != null && i >= labels2.length() || checkAxisType && !axisType.contains(JC.axesTypes[i])) continue;
            if (this.exportType != 1 && Math.abs(xCenter - this.p3Screens[i].x) + Math.abs(yCenter - this.p3Screens[i].y) <= 2.0) {
                showOrigin = false;
                if (!false) continue;
            }
            this.colix = this.colixes[i % 3];
            this.g3d.setC(this.colix);
            String string = labels2 != null ? labels2.substring(i, i + 1) : (axes.labels == null ? JC.axisLabels[i + labelPtr] : (label = i < axes.labels.length ? axes.labels[i] : null));
            if (label != null && label.length() > 0) {
                P3d p = i == 0 && this.shiftA ? this.vvert[1] : (i == 1 && this.shiftB ? this.vvert[3] : (i == 2 && this.shiftC ? this.vvert[5] : this.p3Screens[i]));
                this.renderLabel(label, p.x, p.y, p.z, xCenter, yCenter);
            }
            if (drawTicks) {
                this.tickInfo = axes.tickInfos[i % 3 + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = axes.tickInfos[0];
                }
                if (this.tickInfo != null) {
                    this.tickB.setT(axes.getAxisPoint(i, isDataFrame || isUnitCell, this.pointT));
                    this.tickInfo.first = 0.0;
                    this.tickInfo.signFactor = i % 6 >= 3 ? -1 : 1;
                }
            }
            int d = this.isSlab && i == 2 || this.isPolymer && i > 0 ? -4 : diameter;
            P3d p1 = this.ptTemp;
            P3d p2 = this.p3Screens[i];
            if (i == 2 && this.shiftC) {
                p1 = this.vvert[4];
                p2 = this.vvert[5];
            } else if (i == 1 && this.shiftB) {
                p1 = this.vvert[2];
                p2 = this.vvert[3];
            } else if (i == 0 && this.shiftA) {
                p1 = this.vvert[0];
                p2 = this.vvert[1];
            }
            this.renderLine(p1, p2, d, drawTicks && this.tickInfo != null);
        }
        if (showOrigin) {
            String label0;
            String string = label0 = axes.labels == null || axes.labels.length == 3 || axes.labels[3] == null ? "0" : axes.labels[3];
            if (label0 != null && label0.length() != 0) {
                this.colix = this.vwr.cm.colixBackgroundContrast;
                this.g3d.setC(this.colix);
                this.renderLabel(label0, xCenter, yCenter, this.ptTemp.z, xCenter, yCenter);
            }
        }
        if (isXY) {
            this.g3d.setSlab(slab);
        }
    }

    private void setVVert(Axes axes, int i) {
        int vpt = i * 2;
        this.vvert[vpt].setT(axes.originPoint);
        axes.getAxisPoint(i, false, this.pt);
        this.vvert[vpt].sub(this.pt);
        this.pt.add(axes.originPoint);
        this.tm.transformPtNoClip(this.vvert[vpt], this.vvert[vpt]);
        this.tm.transformPtNoClip(this.pt, this.vvert[vpt + 1]);
    }

    private void renderLabel(String str, double x, double y, double z, double xCenter, double yCenter) {
        int strAscent = this.font3d.getAscent();
        int strWidth = this.font3d.stringWidth(str);
        double dx = x - xCenter;
        double dy = y - yCenter;
        if (dx != 0.0 || dy != 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx = (double)strWidth * 0.75 * dx / dist;
            dy = (double)strAscent * 0.75 * dy / dist;
            x += dx;
            y += dy;
        }
        double xStrBaseline = Math.floor(x - (double)strWidth / 2.0);
        double yStrBaseline = Math.floor(y + (double)strAscent / 2.0);
        this.g3d.drawString(str, this.font3d, (int)xStrBaseline, (int)yStrBaseline, (int)z, (int)z, (short)0);
    }
}

