/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.PT;
import javajs.util.SB;

public class QS {
    public static final int S = 0;
    public static final int P = 1;
    public static final int SP = 2;
    public static final int DS = 3;
    public static final int DC = 4;
    public static final int FS = 5;
    public static final int FC = 6;
    public static final int GS = 7;
    public static final int GC = 8;
    public static final int HS = 9;
    public static final int HC = 10;
    public static final int IS = 11;
    public static final int IC = 12;
    public static int MAX_TYPE_SUPPORTED = 6;
    private static final int MAXID = 13;
    public static final int[] idSpherical = new int[]{0, 1, 2, 3, 3, 5, 5, 7, 7, 9, 9, 11, 11};
    public static final String[] tags = new String[]{"S", "P", "SP", "5D", "D", "7F", "F", "9G", "G", "11H", "H", "13I", "I"};
    public static final String[] tags2 = new String[]{"S", "X", "SP", "5D", "XX", "7F", "XXX", "9G", "XXXX", "11H", "XXXXX", "13I", "XXXXXX"};
    public static final String CANONICAL_DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    public static final String CANONICAL_DS_LIST = "d0    d1+   d1-   d2+   d2-";
    public static final String CANONICAL_FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    public static final String CANONICAL_FS_LIST = "f0    f1+   f1-   f2+   f2-   f3+   f3-";

    public static boolean isQuantumBasisSupported(char ch) {
        return "SPLDF".indexOf(Character.toUpperCase(ch)) >= 0;
    }

    public static int[][] getNewDfCoefMap() {
        return new int[][]{new int[1], new int[3], new int[4], new int[5], new int[6], new int[7], new int[10], new int[9], new int[15], new int[11], new int[21], new int[13], new int[28]};
    }

    public static int getItem(int i) {
        return i >= 0 && i < 13 ? i : -1;
    }

    public static int getQuantumShellTagID(String tag) {
        return tag.equals("L") ? 2 : QS.getQuantumShell(tag);
    }

    private static int getQuantumShell(String tag) {
        for (int i = 0; i < 13; ++i) {
            if (!tags[i].equals(tag) && !tags2[i].equals(tag)) continue;
            return i;
        }
        return -1;
    }

    public static final int getQuantumShellTagIDSpherical(String tag) {
        if (tag.equals("L")) {
            return 2;
        }
        int id = QS.getQuantumShell(tag);
        return id < 0 ? id : idSpherical[id];
    }

    public static final String getQuantumShellTag(int id) {
        return id >= 0 && id < 13 ? tags[id] : "" + id;
    }

    public static final String getMOString(double[] lc) {
        SB sb = new SB();
        if (lc.length == 2) {
            return "" + (int)(lc[0] < 0.0 ? -lc[1] : lc[1]);
        }
        sb.appendC('[');
        for (int i = 0; i < lc.length; i += 2) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.appendD(lc[i]).append(" ").appendI((int)lc[i + 1]);
        }
        sb.appendC(']');
        return sb.toString();
    }

    public static boolean createDFMap(int[] map, String fileList, String jmolList, int minLength) {
        String[] tokens = PT.getTokens(fileList);
        boolean isOK = true;
        for (int i = 0; i < map.length; ++i) {
            int pt;
            String key = tokens[i];
            if (key.length() < minLength || (pt = jmolList.indexOf(key)) < 0) {
                isOK = false;
                break;
            }
            map[pt /= 6] = i - pt;
        }
        if (!isOK) {
            map[0] = Integer.MIN_VALUE;
        }
        return isOK;
    }
}

