/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public abstract class BioPolymer
implements Structure {
    public Model model;
    public Monomer[] monomers;
    protected boolean hasStructure;
    protected P3d[] leadMidpoints;
    protected P3d[] leadPoints;
    protected P3d[] controlPoints;
    protected V3d[] wingVectors;
    protected int[] leadAtomIndices;
    protected int type = 0;
    public int bioPolymerIndexInModel;
    public int monomerCount;
    protected static final int TYPE_NOBONDING = 0;
    protected static final int TYPE_AMINO = 1;
    protected static final int TYPE_NUCLEIC = 2;
    protected static final int TYPE_CARBOHYDRATE = 3;
    public int cyclicFlag;
    private boolean invalidLead;
    protected boolean invalidControl = false;
    protected double sheetSmoothing;
    protected boolean hasWingPoints;
    public BS reversed;
    public boolean twistedSheets;
    private final V3d unitVectorX = V3d.new3(1.0, 0.0, 0.0);
    private int selectedMonomerCount;
    BS bsSelectedMonomers;
    public boolean haveParameters;

    protected BioPolymer(Monomer[] monomers, boolean hasStructure) {
        this.monomers = monomers;
        this.hasStructure = hasStructure;
        int i = this.monomerCount = monomers.length;
        while (--i >= 0) {
            monomers[i].setBioPolymer(this, i);
        }
        this.model = monomers[0].getModel();
    }

    @Override
    public void setAtomBits(BS bs) {
        this.getRange(bs, true);
    }

    @Override
    public void setAtomBitsAndClear(BS bs, BS bsOut) {
        int i = this.monomerCount;
        while (--i >= 0) {
            this.monomers[i].setAtomBitsAndClear(bs, bsOut);
        }
    }

    public void getRange(BS bs, boolean isMutated) {
        if (this.monomerCount == 0) {
            return;
        }
        if (isMutated) {
            int i = this.monomerCount;
            while (--i >= 0) {
                this.monomers[i].setAtomBits(bs);
            }
        } else {
            bs.setBits(this.monomers[0].firstAtomIndex, this.monomers[this.monomerCount - 1].lastAtomIndex + 1);
        }
    }

    public void clearStructures() {
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            this.invalidLead = true;
        }
        if (this.invalidLead) {
            int i = this.monomerCount;
            while (--i >= 0) {
                this.leadAtomIndices[i] = this.monomers[i].leadAtomIndex;
            }
            this.invalidLead = false;
        }
        return this.leadAtomIndices;
    }

    protected int getIndex(int chainID, int seqcode, int istart, int iend) {
        int i = this.monomerCount;
        while (--i >= 0) {
            Monomer m = this.monomers[i];
            if (m.chain.chainID != chainID || m.seqcode != seqcode || istart >= 0 && istart != m.firstAtomIndex && iend != m.lastAtomIndex) continue;
            break;
        }
        return i;
    }

    final P3d getLeadPoint(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    private final P3d getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    private final P3d getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int i, P3d midPoint) {
        if (i == this.monomerCount) {
            --i;
        } else if (i > 0) {
            midPoint.ave(this.getLeadPoint(i), this.getLeadPoint(i - 1));
            return;
        }
        midPoint.setT(this.getLeadPoint(i));
    }

    final P3d getWingPoint(int polymerIndex) {
        return this.monomers[polymerIndex].getWingAtom();
    }

    public void setConformation(BS bsSelected) {
        Atom[] atoms = this.model.ms.at;
        boolean updated = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.monomers[i].updateOffsetsForAlternativeLocations(atoms, bsSelected)) continue;
            updated = true;
        }
        if (updated) {
            this.recalculateLeadMidpointsAndWingVectors();
            for (i = 9; i < 16; ++i) {
                BioShapeCollection s = (BioShapeCollection)this.model.ms.vwr.shm.shapes[i];
                if (s == null) continue;
                int b = s.bioShapes.length;
                while (--b >= 0) {
                    BioShape bi = s.bioShapes[b];
                    if (bi.bioPolymer != this) continue;
                    bi.falsifyMesh();
                }
            }
        }
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.invalidControl = true;
        this.invalidLead = true;
        this.getLeadAtomIndices();
        this.resetHydrogenPoints();
        this.calcLeadMidpointsAndWingVectors();
    }

    protected void resetHydrogenPoints() {
    }

    public P3d[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadMidpoints;
    }

    P3d[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadPoints;
    }

    public P3d[] getControlPoints(boolean isTraceAlpha, double sheetSmoothing, boolean invalidate) {
        if (invalidate) {
            this.invalidControl = true;
        }
        return !isTraceAlpha ? this.leadMidpoints : (sheetSmoothing == 0.0 ? this.leadPoints : this.getControlPoints2(sheetSmoothing));
    }

    private P3d[] getControlPoints2(double sheetSmoothing) {
        if (!this.invalidControl && sheetSmoothing == this.sheetSmoothing) {
            return this.controlPoints;
        }
        this.getLeadPoints();
        V3d v = new V3d();
        if (this.controlPoints == null) {
            this.controlPoints = new P3d[this.monomerCount + 1];
        }
        if (!Double.isNaN(sheetSmoothing)) {
            this.sheetSmoothing = sheetSmoothing;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.controlPoints[i] = this.getControlPoint(i, v);
        }
        this.controlPoints[this.monomerCount] = this.getTerminatorPoint();
        this.invalidControl = false;
        return this.controlPoints;
    }

    protected P3d getControlPoint(int i, V3d v) {
        return this.leadPoints[i];
    }

    public final V3d[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors() {
        P3d leadPoint;
        if (this.leadMidpoints == null) {
            this.leadMidpoints = new P3d[this.monomerCount + 1];
            this.leadPoints = new P3d[this.monomerCount + 1];
            this.wingVectors = new V3d[this.monomerCount + 1];
            this.sheetSmoothing = Double.MIN_VALUE;
        }
        if (this.reversed == null) {
            this.reversed = BS.newN(this.monomerCount);
        } else {
            this.reversed.clearAll();
        }
        this.twistedSheets = this.model.ms.vwr.getBoolean(603979968);
        V3d vectorA = new V3d();
        V3d vectorB = new V3d();
        V3d vectorC = new V3d();
        V3d vectorD = new V3d();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = leadPoint = this.getLeadPoint(0);
        V3d previousVectorD = null;
        for (int i = 1; i < this.monomerCount; ++i) {
            P3d leadPointPrev = leadPoint;
            leadPoint = this.getLeadPoint(i);
            if (leadPoint == null) {
                return;
            }
            this.leadPoints[i] = leadPoint;
            P3d midpoint = new P3d();
            midpoint.ave(leadPoint, leadPointPrev);
            this.leadMidpoints[i] = midpoint;
            if (!this.hasWingPoints) continue;
            vectorA.sub2(leadPoint, leadPointPrev);
            vectorB.sub2(leadPointPrev, this.getWingPoint(i - 1));
            vectorC.cross(vectorA, vectorB);
            vectorD.cross(vectorA, vectorC);
            vectorD.normalize();
            if (!this.twistedSheets && previousVectorD != null && previousVectorD.angle(vectorD) > 1.5707963267948966) {
                this.reversed.set(i);
                vectorD.scale(-1.0);
            }
            previousVectorD = this.wingVectors[i] = V3d.newV(vectorD);
        }
        this.leadPoints[this.monomerCount] = this.leadMidpoints[this.monomerCount] = this.getTerminatorPoint();
        if (!this.hasWingPoints) {
            if (this.monomerCount < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                V3d previousVectorC = null;
                for (int i = 1; i < this.monomerCount; ++i) {
                    vectorA.sub2(this.leadMidpoints[i], this.leadPoints[i]);
                    vectorB.sub2(this.leadPoints[i], this.leadMidpoints[i + 1]);
                    if (vectorB.length() == 0.0) {
                        vectorC = previousVectorC;
                    } else {
                        vectorC.cross(vectorA, vectorB);
                        vectorC.normalize();
                        if (previousVectorC != null && previousVectorC.angle(vectorC) > 1.5707963267948966) {
                            vectorC.scale(-1.0);
                        }
                    }
                    previousVectorC = this.wingVectors[i] = V3d.newV(vectorC);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[this.monomerCount] = this.wingVectors[this.monomerCount - 1];
    }

    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest, short[] mads, int myVisibilityFlag, BS bsNot) {
        int i = this.monomerCount;
        while (--i >= 0) {
            Atom a;
            if ((this.monomers[i].shapeVisibilityFlags & myVisibilityFlag) == 0 || !(a = this.monomers[i].getLeadAtom()).checkVisible() || bsNot != null && bsNot.get(a.i) || mads[i] <= 0 && mads[i + 1] <= 0) continue;
            this.monomers[i].findNearestAtomIndex(xMouse, yMouse, closest, mads[i], mads[i + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BS bsSelected) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BS();
        }
        this.bsSelectedMonomers.clearAll();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bsSelected)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int i) {
        return i >= 0 && this.bsSelectedMonomers.get(i);
    }

    public int getPolymerPointsAndVectors(int last, BS bs, Lst<P3d[]> vList, boolean isTraceAlpha, double sheetSmoothing) {
        P3d[] points = this.getControlPoints(isTraceAlpha, sheetSmoothing, false);
        V3d[] vectors = this.getWingVectors();
        int count = this.monomerCount;
        for (int j = 0; j < count; ++j) {
            if (bs.get(this.monomers[j].leadAtomIndex)) {
                vList.addLast(new P3d[]{points[j], P3d.newP(vectors[j])});
                last = j;
                continue;
            }
            if (last == 0x7FFFFFFE) continue;
            vList.addLast(new P3d[]{points[j], P3d.newP(vectors[j])});
            last = 0x7FFFFFFE;
        }
        if (last + 1 < count) {
            vList.addLast(new P3d[]{points[last + 1], P3d.newP(vectors[last + 1])});
        }
        return last;
    }

    public String getSequence() {
        char[] buf = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            buf[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(buf);
    }

    public void getPolymerSequenceAtoms(int group1, int nGroups, BS bsInclude, BS bsResult) {
        int i = Math.min(this.monomerCount, group1 + nGroups);
        while (--i >= group1) {
            this.monomers[i].getMonomerSequenceAtoms(bsInclude, bsResult);
        }
    }

    public ProteinStructure getProteinStructure(int monomerIndex) {
        return null;
    }

    public boolean calcParameters() {
        this.haveParameters = true;
        return this.calcEtaThetaAngles() || this.calcPhiPsiAngles();
    }

    protected boolean calcEtaThetaAngles() {
        return false;
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    protected double calculateRamachandranHelixAngle(int m, char qtype) {
        return Double.NaN;
    }

    public boolean isNucleic() {
        return this.monomerCount > 0 && this instanceof NucleicPolymer;
    }

    public void getRangeGroups(int nResidues, BS bsAtoms, BS bsResult) {
        int i;
        BS bsTemp = new BS();
        for (i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bsAtoms)) continue;
            bsTemp.setBits(Math.max(0, i - nResidues), i + nResidues + 1);
            i += nResidues - 1;
        }
        i = bsTemp.nextSetBit(0);
        while (i >= 0 && i < this.monomerCount) {
            this.monomers[i].setAtomBits(bsResult);
            i = bsTemp.nextSetBit(i + 1);
        }
    }

    public void calcRasmolHydrogenBonds(BioPolymer polymer, BS bsA, BS bsB, Lst<Bond> vHBonds, int nMaxPerResidue, int[][][] min, boolean checkDistances, boolean dsspIgnoreHydrogens) {
    }

    public int getType() {
        return this.type;
    }

    public boolean isCyclic() {
        return (this.cyclicFlag == 0 ? (this.cyclicFlag = this.monomerCount >= 4 && this.monomers[0].isConnectedAfter(this.monomers[this.monomerCount - 1]) ? 1 : -1) : this.cyclicFlag) == 1;
    }

    public String toString() {
        return "[Polymer type " + this.type + " n=" + this.monomerCount + " " + (this.monomerCount > 0 ? this.monomers[0] + " " + this.monomers[this.monomerCount - 1] : "") + "]";
    }
}

