/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.PT;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class Orientation {
    public String saveName;
    private M3d rotationMatrix = new M3d();
    private double xTrans;
    private double yTrans;
    private double zoom;
    private double rotationRadius;
    private P3d center = new P3d();
    private P3d navCenter = new P3d();
    private double xNav = Double.NaN;
    private double yNav = Double.NaN;
    private double navDepth = Double.NaN;
    private double cameraDepth = Double.NaN;
    private double cameraX = Double.NaN;
    private double cameraY = Double.NaN;
    private boolean windowCenteredFlag;
    private boolean navigationMode;
    private String moveToText;
    private double[] pymolView;
    private Viewer vwr;

    public Orientation(Viewer vwr, boolean asDefault, double[] pymolView) {
        this.vwr = vwr;
        if (pymolView != null) {
            this.pymolView = pymolView;
            this.moveToText = "moveTo -1.0 PyMOL " + Escape.eAD(pymolView);
            return;
        }
        vwr.finalizeTransformParameters();
        if (asDefault) {
            M3d rot = (M3d)vwr.ms.getInfoM("defaultOrientationMatrix");
            if (rot == null) {
                this.rotationMatrix.setScale(1.0);
            } else {
                this.rotationMatrix.setM3(rot);
            }
        } else {
            vwr.tm.getRotation(this.rotationMatrix);
        }
        this.xTrans = vwr.tm.getTranslationXPercent();
        this.yTrans = vwr.tm.getTranslationYPercent();
        this.zoom = vwr.tm.getZoomSetting();
        this.center.setT(vwr.tm.fixedRotationCenter);
        this.windowCenteredFlag = vwr.tm.isWindowCentered();
        this.rotationRadius = vwr.getDouble(0x2200002C);
        this.navigationMode = vwr.getBoolean(603979889);
        this.moveToText = vwr.tm.getMoveToText(-1.0, false);
        if (this.navigationMode) {
            this.xNav = vwr.tm.getNavigationOffsetPercent('X');
            this.yNav = vwr.tm.getNavigationOffsetPercent('Y');
            this.navDepth = vwr.tm.navigationDepthPercent;
            this.navCenter = P3d.newP(vwr.tm.navigationCenter);
        }
        if (vwr.tm.camera.z != 0.0) {
            this.cameraDepth = vwr.tm.getCameraDepth();
            this.cameraX = vwr.tm.camera.x;
            this.cameraY = vwr.tm.camera.y;
        }
    }

    public String getMoveToText(boolean asCommand) {
        return asCommand ? "   " + this.moveToText + "\n  save orientation " + PT.esc(this.saveName.substring(12)) + ";\n" : this.moveToText;
    }

    public boolean restore(double timeSeconds, boolean isAll) {
        if (isAll) {
            this.vwr.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            this.vwr.setBooleanProperty("navigationMode", this.navigationMode);
            if (this.pymolView == null) {
                this.vwr.moveTo(this.vwr.eval, timeSeconds, this.center, null, Double.NaN, this.rotationMatrix, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth, this.cameraDepth, this.cameraX, this.cameraY);
            } else {
                this.vwr.tm.moveToPyMOL(this.vwr.eval, timeSeconds, this.pymolView);
            }
        } else {
            this.vwr.tm.setRotation(this.rotationMatrix);
        }
        return true;
    }
}

