/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.AtomIndexIterator;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

class IsoSolventReader
extends AtomDataReader {
    private double cavityRadius;
    private double envelopeRadius;
    private P3d[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private AtomIndexIterator iter;
    private BS bsSurfacePoints;
    private BS bsSurfaceDone;
    private BS[] bsLocale;
    private Map<String, Edge> htEdges;
    protected Lst<Edge> vEdges;
    private Lst<Face> vFaces;
    private final P3d ptS1 = new P3d();
    private final P3d ptS2 = new P3d();
    protected final V3d vTemp = new V3d();
    protected final P4d plane = new P4d();
    protected final P3d ptTemp2 = new P3d();
    protected final V3d vTemp2 = new V3d();
    protected final P3d p = new P3d();
    private static boolean testLinear = false;
    private BS[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    int nTest = 0;
    private double rAS;
    private double rBS;
    private double rAS2;
    private double rBS2;
    private double dAB;
    private double dAB2;
    private double ecosASB2;

    IsoSolventReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        if (this.isProgressive) {
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BS[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    @Override
    protected void setup(boolean isMapData) {
        this.setup2();
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.sr = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !isMapData && this.sg.atomDataServer != null && !this.isCavity && this.sr > 0.0 && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Double.NaN, null);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !isMapData) {
                double minPtsPerAng;
                double r = Math.max(1.0, Math.max(this.params.solventExtendedAtomRadius, this.params.solventRadius));
                double d = minPtsPerAng = r >= 1.0 ? 1.5 / r : 0.0;
                if (minPtsPerAng > 0.0) {
                    System.out.println("IsoSolventReader.minPtsPerAng=" + minPtsPerAng);
                }
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, minPtsPerAng);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!isMapData) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (isMapData) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BSUtil.setAll(this.myAtomCount);
        }
    }

    @Override
    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        if (this.isCavity && this.dataType != 1207 && this.dataType != 1208) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Double.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Double.MAX_VALUE);
            this.markSphereVoxels(0.0, Double.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        Lst<Object[]> info = this.params.slabInfo;
        if (info != null) {
            for (int i = 0; i < info.size(); ++i) {
                if (!((Boolean)((Object[])info.get(i))[2]).booleanValue() || !(((Object[])info.get(i))[0] instanceof P4d)) continue;
                this.volumeData.capData((P4d)((Object[])info.get(i))[0], this.params.cutoff);
                info.removeItemAt(i--);
            }
        }
    }

    @Override
    protected double getSurfacePointAndFraction(double cutoff, boolean isCutoffAbsolute, double valueA, double valueB, T3d pointA, V3d edgeVector, int x, int y, int z, int vA0, int vB0, double[] fReturn, T3d ptReturn) {
        int vs;
        int vA = this.marchingCubes.getLinearOffset(x, y, z, vA0);
        int vB = this.marchingCubes.getLinearOffset(x, y, z, vB0);
        boolean bl = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(vA) || this.bsSurfaceVoxels.get(vB));
        if (this.voxelSource != null && (vs = Math.abs(Double.isNaN(valueB) || valueA < valueB ? this.voxelSource[vA] : this.voxelSource[vB])) > 0) {
            this.iAtomSurface = this.atomIndex[vs - 1];
        }
        if (testLinear || this.voxelSource == null || this.voxelSource[vA] == 0 || this.voxelSource[vA] != this.voxelSource[vB]) {
            return this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        }
        double fraction = fReturn[0] = MeshSurface.getSphericalInterpolationFraction(this.voxelSource[vA] < 0 ? this.sr : this.atomRadius[this.voxelSource[vA] - 1], valueA, valueB, edgeVector.length());
        ptReturn.scaleAdd2(fraction, edgeVector, pointA);
        double diff = valueB - valueA;
        return valueA + fraction * diff;
    }

    @Override
    public int addVertexCopy(T3d vertexXYZ, double value, int assocVertex, boolean asCopy) {
        int i = this.addVC(vertexXYZ, value, assocVertex, asCopy);
        if (i < 0) {
            return i;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(i);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[i] = this.iAtomSurface;
        }
        return i;
    }

    @Override
    public void selectPocket(boolean doExclude) {
        int i;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        T3d[] v = this.meshData.vs;
        int nVertices = this.meshData.vc;
        double[] vv = this.meshData.vvs;
        int nDots = this.dots.length;
        for (int i2 = 0; i2 < nVertices; ++i2) {
            for (int j = 0; j < nDots; ++j) {
                if (!(this.dots[j].distance(v[i2]) < this.envelopeRadius)) continue;
                vv[i2] = Double.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        int nSets = this.meshData.nSets;
        BS pocketSet = BS.newN(nSets);
        block2: for (i = 0; i < nSets; ++i) {
            BS ss = this.meshData.surfaceSet[i];
            if (ss == null) continue;
            int j = ss.nextSetBit(0);
            while (j >= 0) {
                if (Double.isNaN(this.meshData.vvs[j])) {
                    pocketSet.set(i);
                    continue block2;
                }
                j = ss.nextSetBit(j + 1);
            }
        }
        for (i = 0; i < nSets; ++i) {
            if (this.meshData.surfaceSet[i] == null || pocketSet.get(i) != doExclude) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (!doExclude) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    @Override
    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BS bsAll = new BS();
            BS[] bsSurfaces = this.meshData.getSurfaceSet();
            BS[] bsSources = null;
            double[] volumes = (double[])(this.isPocket ? null : MeshData.calculateVolumeOrArea(this.meshData, null, false, false));
            double minVolume = this.isCavity ? 4.71238898038469 * Math.pow(this.sr, 3.0) : 0.0;
            double maxVolume = 0.0;
            boolean maxIsNegative = false;
            if (volumes != null && !this.isCavity) {
                for (int i = 0; i < this.meshData.nSets; ++i) {
                    double v = volumes[i];
                    if (!(Math.abs(v) > maxVolume)) continue;
                    maxVolume = Math.abs(v);
                    maxIsNegative = v < 0.0;
                }
            }
            double factor = maxIsNegative ? -1 : 1;
            for (int i = 0; i < this.meshData.nSets; ++i) {
                BS bss = bsSurfaces[i];
                if (bss.intersects(this.bsSurfacePoints) && (volumes == null || volumes[i] * factor > minVolume) && this.params.vertexSource != null) {
                    BS bs = new BS();
                    if (bsSources == null) {
                        bsSources = new BS[bsSurfaces.length];
                    }
                    int j = bss.nextSetBit(0);
                    while (j >= 0) {
                        int iatom = this.params.vertexSource[j];
                        if (iatom >= 0) {
                            if (bsAll.get(iatom)) {
                                this.meshData.invalidateSurfaceSet(i);
                                break;
                            }
                            bs.set(iatom);
                        }
                        j = bss.nextSetBit(j + 1);
                    }
                    bsAll.or(bs);
                    continue;
                }
                this.meshData.invalidateSurfaceSet(i);
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(MeshSurface.getSlabWithinRange(-100.0, 0.0));
        }
    }

    private void generateSolventCavity() {
        int x;
        BS bs = BS.newN(this.nPointsX * this.nPointsY * this.nPointsZ);
        int i = 0;
        int nDots = this.dots.length;
        int n = 0;
        double r2 = this.envelopeRadius;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                int z = 0;
                while (z < this.nPointsZ) {
                    block9: {
                        double d;
                        double d2 = this.voxelData[x][y][z];
                        if (d < Double.MAX_VALUE && d2 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(x, y, z, this.ptV);
                            for (int j = 0; j < nDots; ++j) {
                                if (!(this.dots[j].distance(this.ptV) < r2)) {
                                    continue;
                                }
                                break block9;
                            }
                            bs.set(i);
                            ++n;
                        }
                    }
                    ++z;
                    ++i;
                }
            }
        }
        Logger.info("cavities include " + n + " voxel points");
        this.atomRadius = new double[n];
        this.atomXyzTruncated = new P3d[n];
        int ipt = 0;
        int apt = 0;
        for (x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    if (!bs.get(ipt++)) continue;
                    this.atomXyzTruncated[apt] = new P3d();
                    this.volumeData.voxelPtToXYZ(x, y, z, this.atomXyzTruncated[apt]);
                    this.atomRadius[apt++] = this.voxelData[x][y][z];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n;
        this.thisAtomSet = BSUtil.setAll(this.myAtomCount);
        this.rs = null;
        this.setRadii();
    }

    private void generateSolventCube() {
        if (this.dataType == 1207) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BS();
        this.bsSurfaceVoxels = new BS();
        this.bsSurfacePoints = new BS();
        if (this.doCalculateTroughs) {
            this.iter = this.sg.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new Lst();
            this.bsLocale = new BS[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info(this.vEdges.size() + " edges");
            this.vFaces = new Lst();
            this.getFaces();
            Logger.info(this.vFaces.size() + " faces");
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Double.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.validSpheres.or(this.noFaceSpheres);
            this.vEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Double.MAX_VALUE);
        }
        this.markSphereVoxels(0.0, this.doCalculateTroughs ? Double.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        int iatomA;
        for (iatomA = 0; iatomA < this.myAtomCount; ++iatomA) {
            this.bsLocale[iatomA] = new BS();
        }
        for (iatomA = 0; iatomA < this.myAtomCount; ++iatomA) {
            P3d ptA = this.atomXyzTruncated[iatomA];
            double rA = this.rs[iatomA];
            this.sg.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[iatomA], rA + this.maxRS);
            while (this.iter.hasNext()) {
                int iB = this.iter.next();
                int iatomB = this.myIndex[iB];
                if (iatomA >= this.firstNearbyAtom && iatomB >= this.firstNearbyAtom) continue;
                P3d ptB = this.atomXyzTruncated[iatomB];
                double rB = this.rs[iatomB];
                double dAB = ptA.distance(ptB);
                if (dAB >= rA + rB) continue;
                Edge edge = new Edge(this, iatomA, iatomB, dAB);
                this.vEdges.addLast(edge);
                this.bsLocale[iatomA].set(iatomB);
                this.bsLocale[iatomB].set(iatomA);
                this.htEdges.put(edge.toString(), edge);
            }
        }
    }

    protected Edge findEdge(int i, int j) {
        return this.htEdges.get(i < j ? i + "_" + j : j + "_" + i);
    }

    private void getFaces() {
        BS bs = new BS();
        this.params.surfaceAtoms = this.validSpheres = new BS();
        this.noFaceSpheres = BSUtil.setAll(this.myAtomCount);
        int i = this.vEdges.size();
        while (--i >= 0) {
            Edge edge = (Edge)this.vEdges.get(i);
            int ia = edge.ia;
            int ib = edge.ib;
            bs.clearAll();
            bs.or(this.bsLocale[ia]);
            bs.and(this.bsLocale[ib]);
            int ic = bs.nextSetBit(ib + 1);
            while (ic >= 0) {
                if (this.getSolventPoints(edge, ia, ib, ic)) {
                    boolean isOK = false;
                    Face f = this.validateFace(ia, ib, ic, edge, this.ptS1);
                    if (f != null) {
                        this.vFaces.addLast(f);
                        isOK = true;
                    }
                    if ((f = this.validateFace(ia, ib, ic, edge, this.ptS2)) != null) {
                        this.vFaces.addLast(f);
                        isOK = true;
                    }
                    if (isOK) {
                        this.noFaceSpheres.clear(ia);
                        this.noFaceSpheres.clear(ib);
                        this.noFaceSpheres.clear(ic);
                    }
                }
                ic = bs.nextSetBit(ic + 1);
            }
        }
    }

    private Face validateFace(int ia, int ib, int ic, Edge edge, P3d ptS) {
        this.sg.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, ptS, this.maxRS);
        boolean isValid = true;
        while (this.iter.hasNext()) {
            double d;
            int iia = this.iter.next();
            int iatom = this.myIndex[iia];
            if (iatom == ia || iatom == ib || iatom == ic || !((d = this.atomData.atoms[iia].distance(ptS)) < this.atomData.atomRadius[iia] + this.sr)) continue;
            isValid = false;
            break;
        }
        Edge bc = this.findEdge(ib, ic);
        Edge ca = this.findEdge(ia, ic);
        Face f = isValid ? new Face(ia, ib, ic, ptS) : null;
        edge.addFace(f);
        bc.addFace(f);
        ca.addFace(f);
        if (!isValid) {
            return null;
        }
        this.validSpheres.set(ia);
        this.validSpheres.set(ib);
        this.validSpheres.set(ic);
        return f;
    }

    private void markFaceVoxels(boolean firstPass) {
        BS bsThisPass = new BS();
        V3d v0 = this.volumetricVectors[0];
        V3d v1 = this.volumetricVectors[1];
        V3d v2 = this.volumetricVectors[2];
        int fi = this.vFaces.size();
        while (--fi >= 0) {
            Face f = (Face)this.vFaces.get(fi);
            P3d ptA = this.atomXyzTruncated[f.ia];
            P3d ptB = this.atomXyzTruncated[f.ib];
            P3d ptC = this.atomXyzTruncated[f.ic];
            P3d ptS = f.pS;
            this.setGridLimitsForAtom(ptS, this.sr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT(this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT(this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        double value = this.sr - this.ptV.distance(ptS);
                        double v = this.voxelData[i][j][k];
                        int ipt = this.volumeData.getPointIndex(i, j, k);
                        if (firstPass && value > 0.0) {
                            this.bsSurfaceDone.set(ipt);
                        }
                        if (MeasureD.isInTetrahedron(this.ptV, ptA, ptB, ptC, ptS, this.plane, this.vTemp, this.vTemp2, false) && (!firstPass ? !this.bsSurfaceDone.get(ipt) && value < 0.0 && value > -this.volumeData.maxGrid * 1.8 && value > v == bsThisPass.get(ipt) : value > 0.0 && (v < 0.0 || v == Double.MAX_VALUE || value > v == bsThisPass.get(ipt)))) {
                            bsThisPass.set(ipt);
                            this.setVoxel(i, j, k, ipt, value);
                            if (this.voxelSource != null) {
                                this.voxelSource[ipt] = -1 - f.ia;
                            }
                            if (value > 0.0) {
                                this.bsSurfaceVoxels.set(ipt);
                            }
                        }
                        this.ptV.add(v2);
                    }
                    this.ptV.add2(v1, this.ptZ0);
                }
                this.ptV.add2(v0, this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        V3d v0 = this.volumetricVectors[0];
        V3d v1 = this.volumetricVectors[1];
        V3d v2 = this.volumetricVectors[2];
        int ei = this.vEdges.size();
        while (--ei >= 0) {
            Edge edge = (Edge)this.vEdges.get(ei);
            if (!edge.isValid()) continue;
            int ia = edge.ia;
            int ib = edge.ib;
            P3d ptA = this.atomXyzTruncated[ia];
            P3d ptB = this.atomXyzTruncated[ib];
            this.rAS = this.rs[ia];
            this.rBS = this.rs[ib];
            this.rAS2 = this.rs2[ia];
            this.rBS2 = this.rs2[ib];
            this.dAB = edge.d;
            this.dAB2 = edge.d2;
            this.ecosASB2 = edge.cosASB2;
            this.setGridLimitsForAtom(edge, edge.maxr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT(this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT(this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        double value;
                        double dVS = this.checkSpecialVoxel(ptA, ptB, this.ptV);
                        if (!Double.isNaN(dVS) && (value = this.sr - dVS) < this.voxelData[i][j][k]) {
                            int ipt = this.volumeData.getPointIndex(i, j, k);
                            this.setVoxel(i, j, k, ipt, value);
                            if (this.voxelSource != null) {
                                this.voxelSource[ipt] = -1 - ia;
                            }
                        }
                        this.ptV.add(v2);
                    }
                    this.ptV.add2(v1, this.ptZ0);
                }
                this.ptV.add2(v0, this.ptY0);
            }
        }
    }

    @Override
    protected void unsetVoxelData() {
        if (!this.havePlane) {
            this.unsetVoxelData2();
            return;
        }
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] < (double)0.001f) continue;
                this.thisPlane[i] = 0.001f;
            }
        } else {
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] < (double)0.001f) continue;
                        this.voxelData[x][y][z] = 0.001f;
                    }
                }
            }
        }
    }

    private boolean getSolventPoints(Edge edge, int ia, int ib, int ic) {
        double rAS = this.rs[ia];
        V3d v = edge.v;
        double cosAngleBAS = (edge.d2 + this.rs2[ia] - this.rs2[ib]) / (2.0 * edge.d * rAS);
        double angleBAS = Math.acos(cosAngleBAS);
        this.p.scaleAdd2(cosAngleBAS * rAS, v, this.atomXyzTruncated[ia]);
        MeasureD.getPlaneThroughPoint(this.p, v, this.plane);
        double dPS = Math.sin(angleBAS) * rAS;
        P3d ptC = this.atomXyzTruncated[ic];
        double rCS = this.rs[ic];
        double dCT = MeasureD.distanceToPlane(this.plane, ptC);
        if (Math.abs(dCT) >= rCS * 0.9) {
            return false;
        }
        this.ptTemp.scaleAdd2(-dCT, v, ptC);
        double dpT = this.p.distance(this.ptTemp);
        double dsp2 = dPS * dPS;
        double dST2 = this.rs2[ic] - dCT * dCT;
        double cosTheta = (dsp2 + dpT * dpT - dST2) / (2.0 * dPS * dpT);
        if (Math.abs(cosTheta) >= 0.99) {
            return false;
        }
        V3d vXS = this.vTemp2;
        vXS.sub2(this.ptTemp, this.p);
        vXS.normalize();
        this.ptTemp.scaleAdd2(dPS * cosTheta, vXS, this.p);
        vXS.cross(v, vXS);
        vXS.normalize();
        vXS.scale(Math.sqrt(1.0 - cosTheta * cosTheta) * dPS);
        this.ptS1.add2(this.ptTemp, vXS);
        this.ptS2.sub2(this.ptTemp, vXS);
        return true;
    }

    private double checkSpecialVoxel(P3d ptA, P3d ptB, P3d ptV) {
        double d;
        double dAV = ptA.distance(ptV);
        double dAV2 = ptA.distanceSquared(ptV);
        double f = this.rAS / dAV;
        if (f > 1.0) {
            this.p.set(ptA.x + (ptV.x - ptA.x) * f, ptA.y + (ptV.y - ptA.y) * f, ptA.z + (ptV.z - ptA.z) * f);
            return ptB.distanceSquared(this.p) >= this.rBS2 ? Double.NaN : this.solventDistance(this.rAS, this.rAS2, this.rBS2, dAV, dAV2, ptB.distanceSquared(ptV));
        }
        double dBV = ptB.distance(ptV);
        f = this.rBS / dBV;
        if (d > 1.0) {
            this.p.set(ptB.x + (ptV.x - ptB.x) * f, ptB.y + (ptV.y - ptB.y) * f, ptB.z + (ptV.z - ptB.z) * f);
            return ptA.distanceSquared(this.p) >= this.rAS2 ? Double.NaN : this.solventDistance(this.rBS, this.rBS2, this.rAS2, dBV, dBV * dBV, dAV2);
        }
        return Double.NaN;
    }

    private double solventDistance(double rAS, double rAS2, double rBS2, double dAV, double dAV2, double dBV2) {
        double dVS;
        double angleVAB = Math.acos((dAV2 + this.dAB2 - dBV2) / (2.0 * dAV * this.dAB));
        double angleSAB = Math.acos((rAS2 + this.dAB2 - rBS2) / (2.0 * rAS * this.dAB));
        double dVS2 = rAS2 + dAV2 - 2.0 * rAS * dAV * Math.cos(angleSAB - angleVAB);
        return this.ecosASB2 < (rAS2 + dVS2 - dAV * dAV) / ((dVS = Math.sqrt(dVS2)) * rAS) ? dVS : Double.NaN;
    }

    void dumpLine(P3d pt1, T3d pt2, String label, String color) {
        this.sg.log("draw ID \"x" + label + this.nTest++ + "\" " + P3d.newP(pt1) + " " + P3d.newP(pt2) + " color " + color);
    }

    void dumpLine2(P3d pt1, P3d pt2, String label, double d, String color1, String color2) {
        V3d pt = new V3d();
        pt.setT(pt2);
        pt.sub(pt1);
        pt.normalize();
        pt.scale(d);
        pt.add(pt1);
        this.sg.log("draw ID \"" + label + this.nTest++ + "\" " + P3d.newP(pt1) + " " + P3d.newP(pt) + " color " + color1);
        this.sg.log("draw ID \"" + label + this.nTest++ + "\"" + P3d.newP(pt) + " " + P3d.newP(pt2) + " color " + color2 + "\"" + label + "\"");
    }

    void dumpPoint(P3d pt, String label, String color) {
        this.sg.log("draw ID \"" + label + this.nTest++ + "\"" + P3d.newP(pt) + " color " + color);
    }

    @Override
    public double getValueAtPoint(T3d pt, boolean getSource) {
        if (this.contactPair != null) {
            return pt.distance(this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        double value = Double.MAX_VALUE;
        for (int iAtom = 0; iAtom < this.firstNearbyAtom; ++iAtom) {
            double r = pt.distance(this.atomXyzTruncated[iAtom]) - this.rs[iAtom];
            if (!(r < value)) continue;
            value = r;
        }
        return value == Double.MAX_VALUE ? Double.NaN : value;
    }

    @Override
    void discardTempData(boolean discardAll) {
        this.rs = null;
        this.rs2 = null;
        this.discardTempDataSR(discardAll);
    }

    @Override
    public double[] getPlane(int x) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = x;
        this.thisPlane = this.yzPlanes[x % 2];
        if (this.contactPair == null) {
            this.resetPlane(Double.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[x];
            this.markSphereVoxels(0.0, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels(this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        P3d pS;

        Face(int ia, int ib, int ic, P3d pS) {
            this.ia = ia;
            this.ib = ib;
            this.ic = ic;
            this.pS = P3d.newP(pS);
        }

        public String toString() {
            return this.ia + "_" + this.ib + "_" + this.ic + "_" + this.pS;
        }
    }

    private class Edge
    extends P3d {
        int ia;
        int ib;
        int nFaces;
        int nInvalid;
        double d;
        double d2;
        double maxr;
        double cosASB2;
        V3d v;

        Edge(IsoSolventReader r, int ia, int ib, double d) {
            this.ia = Math.min(ia, ib);
            this.ib = Math.max(ia, ib);
            this.d = d;
            this.d2 = d * d;
            this.maxr = Math.sqrt(this.d2 / 4.0 + Math.max(r.rs2[ia], r.rs2[ib]));
            this.ave(r.atomXyzTruncated[ia], r.atomXyzTruncated[ib]);
            this.cosASB2 = (r.rs2[ia] + r.rs2[ib] - this.d2) / (r.rs[ib] * r.rs[ia]);
            this.v = V3d.newVsub(r.atomXyzTruncated[ib], r.atomXyzTruncated[ia]);
            this.v.normalize();
        }

        void addFace(Face f) {
            ++this.nFaces;
            if (f == null) {
                ++this.nInvalid;
                return;
            }
        }

        boolean isValid() {
            return this.nFaces == 0 || this.nInvalid != this.nFaces;
        }

        @Override
        public String toString() {
            return this.ia + "_" + this.ib;
        }
    }
}

