/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class AtomPropertyMapper
extends AtomDataReader {
    private MepCalculation mepCalc;
    private String mepType;
    private int calcType = 0;
    private boolean doSmoothProperty;
    private AtomIndexIterator iter;
    private double smoothingPower;
    private int iAtomSurface;

    AtomPropertyMapper() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
        this.mepType = (String)sg.getReaderData();
    }

    @Override
    protected void setup(boolean isMapData) {
        this.setup2();
        this.haveSurfaceAtoms = true;
        this.volumeData.sr = this;
        this.volumeData.doIterate = false;
        this.point = this.params.point;
        this.doSmoothProperty = this.params.propertySmoothing;
        this.doUseIterator = true;
        if (this.doSmoothProperty) {
            this.smoothingPower = this.params.propertySmoothingPower;
            if (this.smoothingPower < 0.0) {
                this.smoothingPower = 0.0;
            } else if (this.smoothingPower > 10.0) {
                this.smoothingPower = 10.0;
            }
            if (this.smoothingPower == 0.0) {
                this.doSmoothProperty = false;
            }
            this.smoothingPower = (this.smoothingPower - 11.0) / 2.0;
        }
        this.maxDistance = this.params.propertyDistanceMax;
        if (this.mepType != null) {
            this.doSmoothProperty = true;
            if (this.params.mep_calcType >= 0) {
                this.calcType = this.params.mep_calcType;
            }
            this.mepCalc = (MepCalculation)Interface.getOption("quantum." + this.mepType + "Calculation", (Viewer)this.sg.atomDataServer, "file");
        }
        if (!this.doSmoothProperty && this.maxDistance == 2.147483647E9) {
            this.maxDistance = 5.0;
        }
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Double.NaN, null);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        if (!this.doSmoothProperty && this.meshData.vertexSource != null) {
            this.hasColorData = true;
            int i = this.meshData.vc;
            while (--i >= 0) {
                int iAtom = this.meshData.vertexSource[i];
                if (iAtom >= 0) {
                    this.meshData.vvs[i] = this.params.theProperty[iAtom];
                    continue;
                }
                this.hasColorData = false;
                break;
            }
        }
        this.setHeader("property", this.params.calculationType);
        this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, 0.0);
        this.params.cutoff = 0.0;
    }

    @Override
    protected void setVolumeData() {
        if (this.params.thePlane != null) {
            this.setVolumeDataADR();
        }
    }

    @Override
    protected void initializeMapping() {
        if (this.params.showTiming) {
            Logger.startTimer("property mapping");
        }
        if (this.bsNearby != null) {
            this.bsMySelected.or(this.bsNearby);
        }
        this.iter = this.sg.atomDataServer.getSelectedAtomIterator(this.bsMySelected, false, false, false);
    }

    @Override
    protected void finalizeMapping() {
        this.iter.release();
        this.iter = null;
        if (this.params.showTiming) {
            Logger.checkTimer("property mapping", false);
        }
    }

    @Override
    protected void generateCube() {
    }

    @Override
    public int getSurfaceAtomIndex() {
        return this.iAtomSurface;
    }

    @Override
    public double getValueAtPoint(T3d pt, boolean getSource) {
        if (this.haveOneProperty && !getSource) {
            return this.theProperty;
        }
        double dmin = Double.MAX_VALUE;
        double dminNearby = Double.MAX_VALUE;
        double value = this.doSmoothProperty ? 0.0 : Double.NaN;
        double vdiv = 0.0;
        this.sg.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, pt, this.maxDistance);
        this.iAtomSurface = -1;
        while (this.iter.hasNext()) {
            int ia = this.iter.next();
            int myAtom = this.myIndex[ia];
            boolean isNearby = myAtom >= this.firstNearbyAtom;
            P3d ptA = this.atomXyzTruncated[myAtom];
            double p = this.atomProp[myAtom];
            if (Double.isNaN(p)) continue;
            double d2 = pt.distanceSquared(ptA);
            if (isNearby) {
                if (d2 < dminNearby) {
                    dminNearby = d2;
                    if (!this.doSmoothProperty && dminNearby < dmin) {
                        dmin = d2;
                        value = Double.NaN;
                    }
                }
            } else if (d2 < dmin) {
                dmin = d2;
                this.iAtomSurface = ia;
                if (!this.doSmoothProperty) {
                    value = p;
                }
            }
            if (this.mepCalc != null) {
                value += this.mepCalc.valueFor(p, d2, this.calcType);
                continue;
            }
            if (!this.doSmoothProperty) continue;
            d2 = Math.pow(d2, this.smoothingPower);
            vdiv += d2;
            value += d2 * p;
        }
        return this.mepCalc != null ? value : (this.doSmoothProperty ? (vdiv == 0.0 || dminNearby < dmin ? Double.NaN : value / vdiv) : value);
    }
}

