/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;

class PixelatorShaded
extends Pixelator {
    private int[] bgRGB;
    private int[] tmp = new int[3];
    private int zSlab;
    private int zDepth;
    int zShadePower;

    PixelatorShaded(Graphics3D g) {
        super(g);
    }

    Pixelator set(int zSlab, int zDepth, int zShadePower) {
        this.bgcolor = this.g.bgcolor;
        this.bgRGB = new int[]{this.bgcolor & 0xFF, this.bgcolor >> 8 & 0xFF, this.g.bgcolor >> 16 & 0xFF};
        this.zSlab = zSlab < 0 ? 0 : zSlab;
        this.zDepth = zDepth < 0 ? 0 : zDepth;
        this.zShadePower = zShadePower;
        this.p0 = this.g.pixel0;
        return this;
    }

    @Override
    void addPixel(int offset, int z, int p) {
        if (z > this.zDepth) {
            return;
        }
        if (z >= this.zSlab && this.zShadePower > 0) {
            int i;
            int[] t = this.tmp;
            int[] zs = this.bgRGB;
            t[0] = p;
            t[1] = p >> 8;
            t[2] = p >> 16;
            double f = (double)(this.zDepth - z) / (double)(this.zDepth - this.zSlab);
            if (this.zShadePower > 1) {
                for (i = 0; i < this.zShadePower; ++i) {
                    f *= f;
                }
            }
            for (i = 0; i < 3; ++i) {
                t[i] = zs[i] + (int)(f * (double)((t[i] & 0xFF) - zs[i]));
            }
            p = t[2] << 16 | t[1] << 8 | t[0] | p & 0xFF000000;
        }
        this.p0.addPixel(offset, z, p);
    }

    void showZBuffer() {
        int i = this.p0.zb.length;
        while (--i >= 0) {
            if (this.p0.pb[i] == 0) continue;
            int z = (int)Math.min(255.0f, Math.max(0.0f, 255.0f * (float)(this.zDepth - this.p0.zb[i]) / (float)(this.zDepth - this.zSlab)));
            this.p0.pb[i] = 0xFF000000 | z | z << 8 | z << 16;
        }
    }
}

