/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.V3d;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.util.GData;

public class HermiteRenderer
implements G3DRenderer {
    private static V3d vAB = new V3d();
    private static V3d vAC = new V3d();
    private JmolRendererInterface g3d;
    private GData gdata;
    private final P3i[] pLeft = new P3i[16];
    private final P3i[] pRight = new P3i[16];
    private final double[] sLeft = new double[16];
    private final double[] sRight = new double[16];
    private final P3d[] pTopLeft = new P3d[16];
    private final P3d[] pTopRight = new P3d[16];
    private final P3d[] pBotLeft = new P3d[16];
    private final P3d[] pBotRight = new P3d[16];
    private final P3d a1;
    private final P3d a2;
    private final P3d b1;
    private final P3d b2;
    private final P3d c1;
    private final P3d c2;
    private final P3d d1;
    private final P3d d2;
    private final V3d T1;
    private final V3d T2;
    private final V3d depth1;
    private final boolean[] needToFill;

    public HermiteRenderer() {
        int i = 16;
        while (--i >= 0) {
            this.pLeft[i] = new P3i();
            this.pRight[i] = new P3i();
            this.pTopLeft[i] = new P3d();
            this.pTopRight[i] = new P3d();
            this.pBotLeft[i] = new P3d();
            this.pBotRight[i] = new P3d();
        }
        this.a1 = new P3d();
        this.a2 = new P3d();
        this.b1 = new P3d();
        this.b2 = new P3d();
        this.c1 = new P3d();
        this.c2 = new P3d();
        this.d1 = new P3d();
        this.d2 = new P3d();
        this.T1 = new V3d();
        this.T2 = new V3d();
        this.depth1 = new V3d();
        this.needToFill = new boolean[16];
    }

    @Override
    public G3DRenderer set(JmolRendererInterface g3d, GData gdata) {
        this.g3d = g3d;
        this.gdata = gdata;
        return this;
    }

    public void renderHermiteRope(boolean fill, int tension, int diameterBeg, int diameterMid, int diameterEnd, P3d p0, P3d p1, P3d p2, P3d p3) {
        int z1 = (int)p1.z;
        int z2 = (int)p2.z;
        if (p0.z == 1.0 || z1 == 1 || z2 == 1 || p3.z == 1.0) {
            return;
        }
        if (this.gdata.isClippedZ(z1) || this.gdata.isClippedZ(z2)) {
            return;
        }
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int xT1 = (x2 - (int)p0.x) * tension / 8;
        int yT1 = (y2 - (int)p0.y) * tension / 8;
        int zT1 = (z2 - (int)p0.z) * tension / 8;
        int xT2 = ((int)p3.x - x1) * tension / 8;
        int yT2 = ((int)p3.y - y1) * tension / 8;
        int zT2 = ((int)p3.z - z1) * tension / 8;
        this.sLeft[0] = 0.0;
        this.pLeft[0].set(x1, y1, z1);
        this.sRight[0] = 1.0;
        this.pRight[0].set(x2, y2, z2);
        int sp = 0;
        int dDiameterFirstHalf = 0;
        int dDiameterSecondHalf = 0;
        if (fill) {
            dDiameterFirstHalf = 2 * (diameterMid - diameterBeg);
            dDiameterSecondHalf = 2 * (diameterEnd - diameterMid);
        }
        do {
            int dy;
            P3i a = this.pLeft[sp];
            P3i b = this.pRight[sp];
            int dx = b.x - a.x;
            if (dx >= -1 && dx <= 1 && (dy = b.y - a.y) >= -1 && dy <= 1) {
                double s = this.sLeft[sp];
                if (fill) {
                    int d = s < 0.5 ? diameterBeg + (int)((double)dDiameterFirstHalf * s) : diameterMid + (int)((double)dDiameterSecondHalf * (s - 0.5));
                    this.g3d.fillSphereI(d, a);
                } else {
                    this.g3d.plotPixelClippedP3i(a);
                }
                --sp;
                continue;
            }
            double s = (this.sLeft[sp] + this.sRight[sp]) / 2.0;
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            if (sp >= 15) break;
            P3i pMid = this.pRight[sp + 1];
            pMid.x = (int)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
            pMid.y = (int)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
            pMid.z = (int)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
            this.pRight[sp + 1] = this.pRight[sp];
            this.sRight[sp + 1] = this.sRight[sp];
            this.pRight[sp] = pMid;
            this.sRight[sp] = s;
            this.pLeft[++sp].setT(pMid);
            this.sLeft[sp] = s;
        } while (sp >= 0);
    }

    public void renderHermiteRibbon(boolean fill, boolean border, int tension, P3d p0, P3d p1, P3d p2, P3d p3, P3d p4, P3d p5, P3d p6, P3d p7, int aspectRatio, int fillType) {
        boolean isRev;
        if (p0.z == 1.0 || p1.z == 1.0 || p2.z == 1.0 || p3.z == 1.0 || p4.z == 1.0 || p5.z == 1.0 || p6.z == 1.0 || p7.z == 1.0) {
            return;
        }
        if (!fill) {
            tension = Math.abs(tension);
            this.renderParallelPair(fill, tension, p0, p1, p2, p3, p4, p5, p6, p7);
            return;
        }
        boolean bl = isRev = tension < 0;
        if (isRev) {
            tension = -tension;
        }
        double ratio = 1.0 / (double)aspectRatio;
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int z1 = (int)p1.z;
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int z2 = (int)p2.z;
        int xT1 = (x2 - (int)p0.x) * tension / 8;
        int yT1 = (y2 - (int)p0.y) * tension / 8;
        int zT1 = (z2 - (int)p0.z) * tension / 8;
        int xT2 = ((int)p3.x - x1) * tension / 8;
        int yT2 = ((int)p3.y - y1) * tension / 8;
        int zT2 = ((int)p3.z - z1) * tension / 8;
        this.pTopLeft[0].set(x1, y1, z1);
        this.pTopRight[0].set(x2, y2, z2);
        int x5 = (int)p5.x;
        int y5 = (int)p5.y;
        int z5 = (int)p5.z;
        int x6 = (int)p6.x;
        int y6 = (int)p6.y;
        int z6 = (int)p6.z;
        int xT5 = (x6 - (int)p4.x) * tension / 8;
        int yT5 = (y6 - (int)p4.y) * tension / 8;
        int zT5 = (z6 - (int)p4.z) * tension / 8;
        int xT6 = ((int)p7.x - x5) * tension / 8;
        int yT6 = ((int)p7.y - y5) * tension / 8;
        int zT6 = ((int)p7.z - z5) * tension / 8;
        this.pBotLeft[0].set(x5, y5, z5);
        this.pBotRight[0].set(x6, y6, z6);
        this.sLeft[0] = 0.0;
        this.sRight[0] = 1.0;
        this.needToFill[0] = true;
        int sp = 0;
        boolean closeEnd = false;
        do {
            double dyTop;
            double dyTop2;
            P3d a = this.pTopLeft[sp];
            P3d b = this.pTopRight[sp];
            double dxTop = b.x - a.x;
            double dxTop2 = dxTop * dxTop;
            if (dxTop2 < 10.0 && (dyTop2 = (dyTop = b.y - a.y) * dyTop) < 10.0) {
                double dyBot;
                double dyBot2;
                P3d c = this.pBotLeft[sp];
                P3d d = this.pBotRight[sp];
                double dxBot = d.x - c.x;
                double dxBot2 = dxBot * dxBot;
                if (dxBot2 < 8.0 && (dyBot2 = (dyBot = d.y - c.y) * dyBot) < 8.0) {
                    if (border) {
                        this.g3d.fillSphereBits(3, a);
                        this.g3d.fillSphereBits(3, c);
                    }
                    if (this.needToFill[sp]) {
                        if (aspectRatio > 0) {
                            this.T1.sub2(a, c);
                            this.T1.scale(ratio);
                            this.T2.sub2(a, b);
                            this.depth1.cross(this.T1, this.T2);
                            this.depth1.scale(this.T1.length() / this.depth1.length());
                            this.a1.add2(a, this.depth1);
                            this.a2.sub2(a, this.depth1);
                            this.b1.add2(b, this.depth1);
                            this.b2.sub2(b, this.depth1);
                            this.c1.add2(c, this.depth1);
                            this.c2.sub2(c, this.depth1);
                            this.d1.add2(d, this.depth1);
                            this.d2.sub2(d, this.depth1);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.d1, this.c1, false);
                            this.g3d.fillQuadrilateral(this.a2, this.b2, this.d2, this.c2, false);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.b2, this.a2, false);
                            this.g3d.fillQuadrilateral(this.c1, this.d1, this.d2, this.c2, false);
                            closeEnd = true;
                        } else if (fillType == 0) {
                            if (isRev) {
                                this.g3d.fillQuadrilateral(c, d, b, a, false);
                            } else {
                                this.g3d.fillQuadrilateral(a, b, d, c, false);
                            }
                        } else if (isRev) {
                            if (fillType != HermiteRenderer.isFront(a, b, d)) {
                                this.g3d.fillTriangle3f(a, b, d, false);
                            }
                            if (fillType != HermiteRenderer.isFront(a, d, c)) {
                                this.g3d.fillTriangle3f(a, d, c, false);
                            }
                        } else {
                            if (fillType == HermiteRenderer.isFront(a, b, d)) {
                                this.g3d.fillTriangle3f(a, b, d, false);
                            }
                            if (fillType == HermiteRenderer.isFront(a, d, c)) {
                                this.g3d.fillTriangle3f(a, d, c, false);
                            }
                        }
                        this.needToFill[sp] = false;
                    }
                    if (dxTop2 + dyTop2 < 2.0 && dxBot2 + dyBot2 < 2.0) {
                        --sp;
                        continue;
                    }
                }
            }
            double s = (this.sLeft[sp] + this.sRight[sp]) / 2.0;
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            if (sp >= 15) break;
            int spNext = sp + 1;
            P3d pMidTop = this.pTopRight[spNext];
            pMidTop.x = h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2;
            pMidTop.y = h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2;
            pMidTop.z = h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2;
            P3d pMidBot = this.pBotRight[spNext];
            pMidBot.x = h1 * (double)x5 + h2 * (double)x6 + h3 * (double)xT5 + h4 * (double)xT6;
            pMidBot.y = h1 * (double)y5 + h2 * (double)y6 + h3 * (double)yT5 + h4 * (double)yT6;
            pMidBot.z = h1 * (double)z5 + h2 * (double)z6 + h3 * (double)zT5 + h4 * (double)zT6;
            this.pTopRight[spNext] = this.pTopRight[sp];
            this.pTopRight[sp] = pMidTop;
            this.pBotRight[spNext] = this.pBotRight[sp];
            this.pBotRight[sp] = pMidBot;
            this.sRight[spNext] = this.sRight[sp];
            this.sRight[sp] = s;
            this.needToFill[spNext] = this.needToFill[sp];
            this.pTopLeft[spNext].setT(pMidTop);
            this.pBotLeft[spNext].setT(pMidBot);
            this.sLeft[spNext] = s;
            ++sp;
        } while (sp >= 0);
        if (closeEnd) {
            this.a1.z += 1.0;
            this.c1.z += 1.0;
            this.c2.z += 1.0;
            this.a2.z += 1.0;
            this.g3d.fillQuadrilateral(this.a1, this.c1, this.c2, this.a2, false);
        }
    }

    private static int isFront(P3d a, P3d b, P3d c) {
        vAB.sub2(b, a);
        vAC.sub2(c, a);
        vAB.cross(vAB, vAC);
        return HermiteRenderer.vAB.z < 0.0 ? -1 : 1;
    }

    private void renderParallelPair(boolean fill, int tension, P3d p0, P3d p1, P3d p2, P3d p3, P3d p4, P3d p5, P3d p6, P3d p7) {
        P3d[] endPoints = new P3d[]{p2, p1, p6, p5};
        Lst<P3d> points = new Lst<P3d>();
        int whichPoint = 0;
        int numTopStrandPoints = 2;
        double numPointsPerSegment = 5.0;
        double interval = 1.0 / numPointsPerSegment;
        double currentInt = 0.0;
        int x1 = (int)p1.x;
        int y1 = (int)p1.y;
        int z1 = (int)p1.z;
        int x2 = (int)p2.x;
        int y2 = (int)p2.y;
        int z2 = (int)p2.z;
        int xT1 = (x2 - (int)p0.x) * tension / 8;
        int yT1 = (y2 - (int)p0.y) * tension / 8;
        int zT1 = (z2 - (int)p0.z) * tension / 8;
        int xT2 = ((int)p3.x - x1) * tension / 8;
        int yT2 = ((int)p3.y - y1) * tension / 8;
        int zT2 = ((int)p3.z - z1) * tension / 8;
        this.sLeft[0] = 0.0;
        this.pLeft[0].set(x1, y1, z1);
        this.sRight[0] = 1.0;
        this.pRight[0].set(x2, y2, z2);
        int sp = 0;
        for (int strands = 2; strands > 0; --strands) {
            if (strands == 1) {
                x1 = (int)p5.x;
                y1 = (int)p5.y;
                z1 = (int)p5.z;
                x2 = (int)p6.x;
                y2 = (int)p6.y;
                z2 = (int)p6.z;
                xT1 = (x2 - (int)p4.x) * tension / 8;
                yT1 = (y2 - (int)p4.y) * tension / 8;
                zT1 = (z2 - (int)p4.z) * tension / 8;
                xT2 = ((int)p7.x - x1) * tension / 8;
                yT2 = ((int)p7.y - y1) * tension / 8;
                zT2 = ((int)p7.z - z1) * tension / 8;
                this.sLeft[0] = 0.0;
                this.pLeft[0].set(x1, y1, z1);
                this.sRight[0] = 1.0;
                this.pRight[0].set(x2, y2, z2);
                sp = 0;
            }
            points.addLast(endPoints[whichPoint++]);
            currentInt = interval;
            do {
                double s;
                P3i a = this.pLeft[sp];
                P3i b = this.pRight[sp];
                int dx = b.x - a.x;
                int dy = b.y - a.y;
                int dist2 = dx * dx + dy * dy;
                if (dist2 <= 2) {
                    s = this.sLeft[sp];
                    this.g3d.fillSphereI(3, a);
                    if (s < 1.0 - currentInt) {
                        P3d temp = new P3d();
                        temp.set(a.x, a.y, a.z);
                        points.addLast(temp);
                        currentInt += interval;
                        if (strands == 2) {
                            ++numTopStrandPoints;
                        }
                    }
                    --sp;
                    continue;
                }
                s = (this.sLeft[sp] + this.sRight[sp]) / 2.0;
                double s2 = s * s;
                double s3 = s2 * s;
                double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
                double h2 = -2.0 * s3 + 3.0 * s2;
                double h3 = s3 - 2.0 * s2 + s;
                double h4 = s3 - s2;
                if (sp >= 15) break;
                P3i pMid = this.pRight[sp + 1];
                pMid.x = (int)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
                pMid.y = (int)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
                pMid.z = (int)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
                this.pRight[sp + 1] = this.pRight[sp];
                this.sRight[sp + 1] = this.sRight[sp];
                this.pRight[sp] = pMid;
                this.sRight[sp] = s;
                this.pLeft[++sp].setT(pMid);
                this.sLeft[sp] = s;
            } while (sp >= 0);
            points.addLast(endPoints[whichPoint++]);
        }
        int size = points.size();
        for (int top = 0; top < numTopStrandPoints && top + numTopStrandPoints < size; ++top) {
            this.g3d.drawLineAB((P3d)points.get(top), (P3d)points.get(top + numTopStrandPoints));
        }
    }
}

