/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.PT;

public class XtlWriter {
    protected boolean haveUnitCell = true;
    protected boolean isHighPrecision = true;
    protected double slop;
    protected int precision;
    private static double SLOPD = 1.0E-11;
    private static float SLOPF = 1.0E-6f;
    private static final String[] twelfths = new String[]{"0.000000000000", "0.083333333333", "0.166666666667", "0.250000000000", "0.333333333333", "0.416666666667", "0.500000000000", "0.583333333333", "0.666666666667", "0.750000000000", "0.833333333333", "0.916666666667", "1.000000000000"};
    private static final String[] twelfthsF = new String[]{"0.0000000", "0.0833333", "0.1666667", "0.2500000", "0.3333333", "0.4166667", "0.5000000", "0.5833333", "0.6666667", "0.7500000", "0.8333333", "0.9166667", "1.0000000"};

    protected String clean(double d) {
        int t;
        if (!this.isHighPrecision) {
            return this.cleanF((float)d);
        }
        return !this.haveUnitCell || (t = XtlWriter.twelfthsOf(d)) < 0 ? PT.formatD(d, 18, 12, false, false) : (d < 0.0 ? "   -" : "    ") + twelfths[t];
    }

    private static int twelfthsOf(double f) {
        if (f == 0.0) {
            return 0;
        }
        int i = (int)Math.round(f = Math.abs(f * 12.0));
        return i <= 12 && Math.abs(f - (double)i) < SLOPD * 12.0 ? i : -1;
    }

    private String cleanF(float f) {
        int t;
        if (this.slop != 0.0) {
            return this.cleanSlop(f);
        }
        return !this.haveUnitCell || (t = XtlWriter.twelfthsOfF(f)) < 0 ? PT.formatD(f, 12, 7, false, false) : (f < 0.0f ? "   -" : "    ") + twelfthsF[t];
    }

    private String cleanSlop(double f) {
        return PT.formatD(f, this.precision + 6, this.precision, false, false);
    }

    private static int twelfthsOfF(float f) {
        if (f == 0.0f) {
            return 0;
        }
        int i = Math.round(f = Math.abs(f * 12.0f));
        return i <= 12 && Math.abs(f - (float)i) < SLOPF * 12.0f ? i : -1;
    }

    protected String cleanT(double d) {
        String s = this.clean(d);
        if (this.isHighPrecision) {
            return s;
        }
        int i = s.length();
        while (--i >= 2 && s.charAt(i) == '0' && s.charAt(i - 1) != '.') {
        }
        return s.substring(0, i + 1);
    }
}

