/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean haveCharges;
    private boolean inputOnly;
    private boolean isLongMode;
    private boolean getLastConventional;
    private boolean havePrimitiveMapping;
    private boolean isProperties;
    private static final int STATE_NONE = 0;
    private static final int STATE_INPUT = 1;
    private static final int STATE_INPUT_FROM = 2;
    private static final int STATE_WAVEFUNCTION = 3;
    private static final int STATE_OPT_POINT = 4;
    private static final int STATE_OPT_FINAL = 5;
    private static final int STATE_FREQ = 6;
    private int state = 0;
    private int ac;
    private int atomIndexLast;
    private int[] atomFrag;
    private int[] primitiveToIndex;
    private double[] nuclearCharges;
    private Lst<String> lstCoords;
    private Double energy;
    private P3d ptOriginShift = new P3d();
    private V3d[] directLatticeVectors;
    private String spaceGroupName;
    private boolean checkModelTrigger;
    private boolean fullSymmetry;
    private Map<String, Lst<Object>> htCriticalPoints;
    private boolean directLatticeVectorsFirst;
    private int cpno = -1;
    private static final String[] crtypes = new String[]{"??", "nuclei", "bonds", "rings", "cages"};
    private Lst<String> symops = new Lst();
    private final double[] f14 = new double[14];
    private final double[] f16 = new double[16];
    private static final int[] smap = new int[]{2, 3, 4, 11, 5, 6, 7, 12, 8, 9, 10, 13};
    private double primitiveVolume;
    private double primitiveDensity;
    private String firstLine;
    private String type;

    @Override
    public String rd() throws Exception {
        while (super.rd() != null && (this.line.startsWith(" PROCESS") || this.line.startsWith(" INFORMATION") || this.line.startsWith(" WARNING"))) {
        }
        return this.line;
    }

    @Override
    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.isPrimitive = !this.inputOnly && !this.checkFilterKey("CONV");
        this.addVibrations &= !this.inputOnly && this.desiredModelNumber < 0;
        this.getLastConventional = !this.isPrimitive && this.desiredModelNumber == 0;
        this.fullSymmetry = this.checkFilterKey("FULLSYM");
        this.setFractionalCoordinates(this.readHeader());
        this.asc.crystalReaderLatticeOpsOnly = !this.inputOnly;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.firstLine != null) {
            this.line = this.firstLine;
            this.firstLine = null;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.indexOf("DIMENSIONALITY OF THE SYSTEM") >= 0) {
            this.isPolymer = false;
            this.isSlab = false;
            this.isMolecular = false;
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            } else if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            } else if (this.line.indexOf("0") >= 0) {
                this.isMolecular = true;
            }
            return true;
        }
        if (!this.isPolymer && this.line.indexOf("CONSTRUCTION OF A NANOTUBE FROM A SLAB") >= 0) {
            this.isPolymer = true;
            this.isSlab = false;
            return true;
        }
        if (!this.isMolecular && this.line.indexOf("* CLUSTER CALCULATION") >= 0) {
            this.isMolecular = true;
            this.isSlab = false;
            this.isPolymer = false;
            return true;
        }
        if (this.line.startsWith(" INPUT COORDINATES")) {
            this.state = 1;
            if (this.inputOnly) {
                this.newAtomSet();
                this.readCoordLines();
                this.continuing = false;
            }
            return true;
        }
        if (this.line.startsWith(" GEOMETRY INPUT FROM EXTERNAL")) {
            this.state = 2;
            if (this.inputOnly) {
                this.continuing = false;
            }
            return true;
        }
        if (this.line.startsWith(" GEOMETRY FOR WAVE FUNCTION")) {
            this.state = 3;
            return true;
        }
        if (this.line.startsWith(" COORDINATE OPTIMIZATION - POINT")) {
            this.state = 4;
            return true;
        }
        if (this.line.startsWith(" FINAL OPTIMIZED GEOMETRY")) {
            this.getLastConventional = false;
            this.state = 5;
            return true;
        }
        if (this.addVibrations && this.line.contains(this.isVersion3 ? "EIGENVALUES (EV) OF THE MASS" : "EIGENVALUES (EIGV) OF THE MASS") || this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0) {
            this.state = 6;
            this.isLongMode = this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0;
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" TRANSFORMATION MATRIX")) {
            this.readPrimitiveLatticeVectors();
            return true;
        }
        if (this.line.startsWith(" COORDINATES OF THE EQUIVALENT ATOMS") || this.line.startsWith(" INPUT LIST - ATOM N.")) {
            return true;
        }
        if (this.line.indexOf("SYMMOPS - ") >= 0) {
            this.readSymmetryOperators();
            return true;
        }
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            this.newLattice(this.line.indexOf("- CONVENTIONAL") >= 0);
            return true;
        }
        if (this.line.startsWith(" CRYSTALLOGRAPHIC CELL")) {
            if (!this.isPrimitive) {
                this.newLattice(true);
            }
            return true;
        }
        if (this.line.startsWith(" DIRECT LATTICE VECTOR")) {
            this.getDirect();
            return true;
        }
        if (this.line.startsWith(" COORDINATES IN THE CRYSTALLOGRAPHIC CELL")) {
            boolean bl = this.checkModelTrigger = !this.isPrimitive;
            if (this.checkModelTrigger) {
                this.readCoordLines();
            }
            return true;
        }
        if (this.addVibrations && this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            this.readFreqFragments();
            return true;
        }
        if (this.checkModelTrigger && (this.line.indexOf("CARTESIAN COORDINATES") >= 0 || this.line.indexOf("TOTAL ENERGY") >= 0 || this.line.indexOf("REFERENCE GEOMETRY DEFINED") >= 0 || this.line.indexOf("FUNCTIONS") >= 0)) {
            this.checkModelTrigger = false;
            if (!this.addModel()) {
                return true;
            }
        }
        if (this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT")) {
            if (this.isMolecular) {
                return this.doGetModel(++this.modelNumber, null) ? this.readAtoms() : this.checkLastModel();
            }
            this.readCoordLines();
            this.checkModelTrigger = true;
        }
        if (this.isProperties && this.line.startsWith("   ATOM N.AT.")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtoms();
            } else {
                this.checkLastModel();
            }
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY(")) {
            this.line = PT.rep(this.line, "( ", "(");
            String[] tokens = this.getTokens();
            this.energy = Double.parseDouble(tokens[2]);
            this.setEnergy();
            this.rd();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            } else if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains(" *******");
            }
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            return this.readPartialCharges();
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            return this.readTotalAtomicCharges();
        }
        if (this.line.startsWith(" MAX GRADIENT")) {
            return this.readGradient();
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            return this.readData("spin", 3);
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            return this.readData("magneticMoment", 1);
        }
        if (this.line.startsWith(" BORN CHARGE TENSOR.")) {
            return this.readBornChargeTensors();
        }
        if (!this.isProperties) {
            return true;
        }
        if (this.line.startsWith(" DEFINITION OF TRACELESS")) {
            return this.getQuadrupoleTensors();
        }
        if (this.line.startsWith(" MULTIPOLE ANALYSIS BY ATOMS")) {
            this.appendLoadNote("Multipole Analysis");
            return true;
        }
        if (this.line.startsWith(" CP N. ")) {
            this.cpno = this.parseIntAt(this.line, 6);
            return true;
        }
        if (this.line.startsWith(" CP TYPE ")) {
            this.processNextCriticalPoint();
            return true;
        }
        return true;
    }

    private void processNextCriticalPoint() throws Exception {
        if (this.htCriticalPoints == null) {
            this.htCriticalPoints = new Hashtable<String, Lst<Object>>();
            this.asc.setModelInfoForSet("criticalPoints", this.htCriticalPoints, 0);
        }
        int nblank = 0;
        String id = null;
        Lst<Object> entry = null;
        double f = 0.5291772;
        Hashtable<String, Double> m = null;
        double v = Double.NaN;
        double g = Double.NaN;
        double rho = Double.NaN;
        double[] evalues = null;
        String type = null;
        while ((this.line != null || this.rd().length() > 0 || ++nblank < 2) && this.line.indexOf("CLUSTER") < 0) {
            int pt;
            if (this.line.length() > 0) {
                nblank = 0;
            }
            if ((pt = this.line.indexOf(":")) > 0) {
                String key = this.line.substring(0, pt).trim();
                String value = this.line.substring(pt + 1);
                if (key.equals("CP TYPE")) {
                    type = crtypes["??,-3,-1,+1,+3".indexOf(value.substring(5, 7)) / 3];
                    entry = this.htCriticalPoints.get(type);
                    if (entry == null) {
                        entry = new Lst();
                        this.htCriticalPoints.put(type, entry);
                    }
                    m = new Hashtable<String, Double>();
                    entry.addLast(m);
                    int i = entry.size();
                    id = "cp_" + i;
                    m.put("cpno", (Double)this.cpno);
                    m.put("id", (Double)((Object)id));
                    m.put("type", (Double)((Object)type));
                    m.put("index", (Double)i);
                } else if (key.equals("COORD(AU)  (X  Y  Z)")) {
                    P3d xyz = P3d.new3(f * this.parseDoubleStr(value.substring(0, 12)), f * this.parseDoubleStr(value.substring(12, 24)), f * this.parseDoubleStr(value.substring(24, 36)));
                    m.put("point", (Double)((Object)xyz));
                    Logger.info("CRYSTAL TOPOND critical point " + type + " " + xyz);
                } else if (key.equals("PROPERTIES (RHO,GRHO,LAP)")) {
                    rho = this.parseDoubleStr(value.substring(0, 12));
                    m.put("rho", rho);
                    m.put("lap", this.parseDoubleStr(value.substring(24, 36)));
                } else if (key.equals("PROPERTIES (-LAP,GLAP,RHO)")) {
                    m.put("lap", -this.parseDoubleStr(value.substring(0, 12)));
                    rho = this.parseDoubleStr(value.substring(24, 36));
                    m.put("rho", rho);
                } else if (key.equals("KINETIC ENERGY DENSITIES (G,K)")) {
                    g = this.parseDoubleStr(value.substring(0, 12));
                    m.put("kineticEnergyG", g);
                } else if (key.equals("VIRIAL DENSITY")) {
                    v = this.parseDoubleStr(value.substring(0, 12));
                    m.put("virialDensityV", v);
                    m.put("ratioVG", Math.abs(v) / g);
                    m.put("energyDensityH", g + v);
                    m.put("ratioHRho", (g + v) / rho);
                } else if (key.equals("EIGENVALUES (L1 L2 L3)")) {
                    double e1 = this.parseDoubleStr(value.substring(0, 12));
                    double e2 = this.parseDoubleStr(value.substring(12, 24));
                    double e3 = this.parseDoubleStr(value.substring(24, 36));
                    evalues = new double[]{e1, e2, e3};
                    m.put("eigenvalues", (Double)evalues);
                    m.put("ellipticity", e1 / e2 - 1.0);
                    m.put("anisotropy", e3 - Math.abs(e1 + e2) / 2.0);
                } else if (key.equals("EIGENVECTORS")) {
                    value = value + this.rd().substring(33) + this.rd().substring(33);
                    double[][] ev = new double[3][3];
                    int p = 0;
                    for (int ei = 0; ei < 3; ++ei) {
                        int ej = 0;
                        while (ej < 3) {
                            ev[ej][ei] = this.parseDoubleStr(value.substring(p, p + 12));
                            ++ej;
                            p += 12;
                        }
                    }
                    T3d[] evectors = new P3d[]{P3d.new3(ev[0][0], ev[0][1], ev[0][2]), P3d.new3(ev[1][0], ev[1][1], ev[1][2]), P3d.new3(ev[2][0], ev[2][1], ev[2][2])};
                    System.out.println("evpts " + evectors[0] + " " + evectors[1] + " " + evectors[2]);
                    m.put("eigenvectors", (Double)evectors);
                    Tensor t = new Tensor().setFromEigenVectors(evectors, evalues, "cp", id, null);
                    m.put("tensor", (Double)((Object)t));
                }
            }
            this.line = null;
        }
    }

    private void newLattice(boolean isConv) throws Exception {
        this.lstCoords = null;
        this.readLatticeParams(!isConv);
        this.symops.clear();
        if (!isConv) {
            this.primitiveToCrystal = null;
        }
        if (!this.directLatticeVectorsFirst) {
            this.directLatticeVectors = null;
        }
    }

    private boolean addModel() throws Exception {
        if (this.getLastConventional) {
            return true;
        }
        if (!this.doGetModel(++this.modelNumber, null)) {
            this.lstCoords = null;
            this.checkLastModel();
            if (this.asc.iSet >= 0) {
                this.asc.removeAtomSet(this.asc.iSet);
            }
            return false;
        }
        this.processCoordLines();
        return true;
    }

    private void readSymmetryOperators() throws Exception {
        this.symops.clear();
        this.rd();
        this.f16[15] = 1.0;
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf("END") < 0) {
            if (this.line.indexOf("V INV") >= 0) continue;
            this.fillDoubleArray(this.line, 0, this.f14);
            if (Double.isNaN(this.f14[0])) break;
            for (int i = 0; i < 12; ++i) {
                this.f16[i] = this.f14[smap[i]];
            }
            Logger.info("CrystalReader: " + this.line);
            if (this.isSlab || this.isPolymer) continue;
            M4d m4 = M4d.newA16(this.f16);
            String xyz = SymmetryOperation.getXYZFromMatrix(m4, false, false, false);
            if (xyz.indexOf("0y") >= 0 || xyz.indexOf("0z") >= 0) {
                Logger.error("CrystalReader: Symmetry operator could not be created for " + xyz);
                continue;
            }
            this.symops.addLast(xyz);
            Logger.info("CrystalReader: state=" + this.state + " Symmop " + this.symops.size() + ": " + xyz);
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setInfo("symmetryType", this.isSlab ? "2D - SLAB" : (this.isPolymer ? "1D - POLYMER" : this.type));
        this.processCoordLines();
        if (this.energy != null) {
            this.setEnergy();
        }
        this.finalizeReaderASCR();
        this.asc.checkNoEmptyModel();
        if (this.htCriticalPoints != null) {
            String note = "";
            Lst<Object> list = this.htCriticalPoints.get("nuclei");
            if (list != null) {
                note = note + "\n _M.criticalPoints.nuclei.length = " + list.size();
            }
            if ((list = this.htCriticalPoints.get("bonds")) != null) {
                note = note + "\n _M.criticalPoints.bonds.length = " + list.size();
            }
            if ((list = this.htCriticalPoints.get("rings")) != null) {
                note = note + "\n _M.criticalPoints.rings.length = " + list.size();
            }
            if ((list = this.htCriticalPoints.get("cages")) != null) {
                note = note + "\n _M.criticalPoints.cages.length = " + list.size();
            }
            note = note + "\n Use MACRO TOPOND for TOPOND functions.";
            this.addJmolScript("set drawHover");
            this.appendLoadNote(note);
            this.setLoadNote();
        }
    }

    private void getDirect() throws Exception {
        this.directLatticeVectors = this.read3Vectors(this.line.indexOf("(BOHR") >= 0);
        if (!this.iHaveUnitCell) {
            this.directLatticeVectorsFirst = true;
        }
    }

    private void setUnitCellOrientation() {
        if (this.directLatticeVectors == null) {
            return;
        }
        V3d a = new V3d();
        V3d b = new V3d();
        if (this.isPrimitive) {
            a = this.directLatticeVectors[0];
            b = this.directLatticeVectors[1];
        } else {
            if (this.primitiveToCrystal == null) {
                return;
            }
            M3d mp = new M3d();
            mp.setColumnV(0, this.directLatticeVectors[0]);
            mp.setColumnV(1, this.directLatticeVectors[1]);
            mp.setColumnV(2, this.directLatticeVectors[2]);
            mp.mul(this.primitiveToCrystal);
            a = new V3d();
            b = new V3d();
            mp.getColumnV(0, a);
            mp.getColumnV(1, b);
        }
        this.matUnitCellOrientation = Qd.getQuaternionFrame(new P3d(), a, b).getMatrix();
        Logger.info("oriented unit cell is in model " + this.asc.atomSetCount);
    }

    private void readPrimitiveLatticeVectors() throws Exception {
        this.primitiveToCrystal = M3d.newA9(this.fillDoubleArray(null, 0, new double[9]));
    }

    private boolean readHeader() throws Exception {
        String name;
        this.havePrimitiveMapping = true;
        this.discardLinesUntilContains("*******************************************************************************");
        this.readLines(2);
        this.isVersion3 = this.line.indexOf("CRYSTAL03") >= 0;
        this.discardLinesUntilContains("EEEEEEEEEE");
        this.rd();
        if (this.line.length() == 0) {
            this.discardLinesUntilContains("*********");
            name = this.rd().trim();
        } else {
            name = this.line.trim();
            this.rd();
        }
        this.type = this.rd().trim();
        int pt = this.type.indexOf("- PROPERTIES");
        if (pt >= 0) {
            this.isProperties = true;
            this.type = this.type.substring(0, pt).trim();
        }
        this.asc.setCollectionName(name + (!this.isProperties && this.desiredModelNumber == 0 ? " (optimized)" : ""));
        if (this.type.indexOf("GEOMETRY INPUT FROM EXTERNAL FILE") >= 0) {
            this.firstLine = this.line;
            this.type = this.rd().trim();
        }
        this.isPolymer = this.type.equals("1D - POLYMER") || this.type.equals("POLYMER CALCULATION");
        boolean bl = this.isSlab = this.type.equals("2D - SLAB") || this.type.equals("SLAB CALCULATION");
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error("Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.asc.setInfo("unitCellType", this.isPrimitive ? "primitive" : "conventional");
        if (this.type.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.rd();
            this.asc.setInfo("molecularCalculationPointGroup", this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        this.discardLinesUntilContains2("SPACE GROUP", "****");
        pt = this.line.indexOf(":");
        if (pt >= 0 && !this.isPrimitive) {
            this.spaceGroupName = this.line.substring(pt + 1).trim();
        }
        this.doApplySymmetry = this.isProperties;
        return !this.isProperties;
    }

    private void readLatticeParams(boolean isPrimitive) throws Exception {
        double f;
        double d = f = this.line.indexOf("(BOHR") >= 0 ? 0.5291772 : 1.0;
        if (isPrimitive) {
            this.newAtomSet();
        }
        this.primitiveVolume = 0.0;
        this.primitiveDensity = 0.0;
        if (this.isPolymer && !isPrimitive && this.line.indexOf("BOHR =") < 0) {
            this.setUnitCell(this.parseDoubleStr(this.line.substring(this.line.indexOf("CELL") + 4)) * f, -1.0, -1.0, 90.0, 90.0, 90.0);
        } else {
            while (this.rd().indexOf("GAMMA") < 0) {
                if (this.line.indexOf("VOLUME=") < 0) continue;
                this.primitiveVolume = this.parseDoubleStr(this.line.substring(43));
                this.primitiveDensity = this.parseDoubleStr(this.line.substring(66));
            }
            String[] tokens = PT.getTokens(this.rd());
            double a = this.parseDoubleStr(tokens[0]);
            double b = this.parseDoubleStr(tokens[1]);
            if (!this.isSlab && !this.isPolymer && tokens.length == 7) {
                this.primitiveVolume = this.parseDoubleStr(tokens[6]);
                if (Math.abs(this.primitiveVolume - a * b) < 0.1) {
                    this.isSlab = true;
                }
            }
            if (this.isSlab) {
                if (isPrimitive) {
                    this.setUnitCell(a * f, b * f, -1.0, this.parseDoubleStr(tokens[3]), this.parseDoubleStr(tokens[4]), this.parseDoubleStr(tokens[5]));
                } else {
                    this.setUnitCell(a * f, b * f, -1.0, 90.0, 90.0, this.parseDoubleStr(tokens[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(a, -1.0, -1.0, this.parseDoubleStr(tokens[3]), this.parseDoubleStr(tokens[4]), this.parseDoubleStr(tokens[5]));
            } else {
                this.setUnitCell(a * f, b * f, this.parseDoubleStr(tokens[2]) * f, this.parseDoubleStr(tokens[3]), this.parseDoubleStr(tokens[4]), this.parseDoubleStr(tokens[5]));
            }
        }
    }

    private int getAtomIndexFromPrimitiveIndex(int iPrim) {
        return this.primitiveToIndex == null ? iPrim : this.primitiveToIndex[iPrim];
    }

    private boolean readAtoms() throws Exception {
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.lstCoords = null;
        while (this.rd() != null && this.line.indexOf("*") < 0) {
            if (this.line.indexOf("X(ANGSTROM") < 0) continue;
            this.setFractionalCoordinates(false);
            this.isMolecular = true;
        }
        int i = this.atomIndexLast;
        boolean doNormalizePrimitive = false;
        this.atomIndexLast = this.asc.ac;
        boolean isFractional = this.iHaveFractionalCoordinates;
        if (!isFractional) {
            this.setUnitCellOrientation();
            if (this.matUnitCellOrientation != null) {
                this.getSymmetry().initializeOrientation(this.matUnitCellOrientation);
            }
        }
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf(this.isPrimitive ? "*" : "=") < 0) {
            Atom atom = this.asc.addNewAtom();
            String[] tokens = this.getTokens();
            int pt = this.isProperties ? 1 : 2;
            atom.elementSymbol = CrystalReader.getElementSymbol(this.getAtomicNumber(tokens[pt++]));
            atom.atomName = CrystalReader.fixAtomName(tokens[pt++]);
            if (this.isProperties) {
                // empty if block
            }
            int n = ++pt;
            double x = this.parseDoubleStr(tokens[n]);
            int n2 = ++pt;
            double y = this.parseDoubleStr(tokens[n2]);
            double z = this.parseDoubleStr(tokens[++pt]);
            if (this.haveCharges) {
                atom.partialCharge = this.asc.atoms[i++].partialCharge;
            }
            if (isFractional && !this.isProperties) {
                if (x < 0.0 && (this.isPolymer || this.isSlab || doNormalizePrimitive)) {
                    x += 1.0;
                }
                if (y < 0.0 && (this.isSlab || doNormalizePrimitive)) {
                    y += 1.0;
                }
                if (z < 0.0 && doNormalizePrimitive) {
                    z += 1.0;
                }
            }
            this.setAtomCoordXYZ(atom, x, y, z);
        }
        this.ac = this.asc.ac - this.atomIndexLast;
        return true;
    }

    private static String fixAtomName(String s) {
        return s.length() > 1 && PT.isLetter(s.charAt(1)) ? s.substring(0, 1) + Character.toLowerCase(s.charAt(1)) + s.substring(2) : s;
    }

    private int getAtomicNumber(String token) {
        return this.parseIntStr(token) % 100;
    }

    private void readCoordLines() throws Exception {
        String atom;
        String string = atom = this.inputOnly ? " ATOM" : "  ATOM";
        if (this.line.indexOf(atom) < 0) {
            this.discardLinesUntilContains(atom);
        }
        this.lstCoords = new Lst();
        while (this.rd() != null && this.line.length() > 0) {
            if (this.line.indexOf("****") >= 0) continue;
            this.lstCoords.addLast(this.line);
        }
    }

    private void processCoordLines() throws Exception {
        if (this.lstCoords == null) {
            return;
        }
        this.ac = this.lstCoords.size();
        double[] irreducible = null;
        for (int i = 0; i < this.ac; ++i) {
            int offset;
            int atomicNumber;
            Atom atom = this.asc.addNewAtom();
            String[] tokens = PT.getTokens((String)this.lstCoords.get(i));
            atom.atomSerial = this.parseIntStr(tokens[0]);
            switch (tokens.length) {
                case 7: 
                case 8: {
                    atomicNumber = this.getAtomicNumber(tokens[2]);
                    offset = 4;
                    if (i == 0) {
                        irreducible = new double[this.ac];
                    }
                    if (!tokens[1].equals("T")) break;
                    irreducible[i] = 1.0;
                    break;
                }
                default: {
                    atomicNumber = this.getAtomicNumber(tokens[1]);
                    offset = 2;
                }
            }
            double x = this.parseDoubleStr(tokens[offset++]) + this.ptOriginShift.x;
            double y = this.parseDoubleStr(tokens[offset++]) + this.ptOriginShift.y;
            double z = this.parseDoubleStr(tokens[offset]) + this.ptOriginShift.z;
            this.setAtomCoordXYZ(atom, x, y, z);
            atom.elementSymbol = CrystalReader.getElementSymbol(atomicNumber);
        }
        this.lstCoords = null;
        if (irreducible != null) {
            this.asc.setAtomProperties("irreducible", irreducible, -1, false);
        }
        if (this.primitiveVolume > 0.0) {
            this.asc.setAtomSetModelProperty("volumePrimitive", DF.formatDecimal(this.primitiveVolume, 3));
            this.asc.setModelInfoForSet("primitiveVolume", this.primitiveVolume, this.asc.iSet);
        }
        if (this.primitiveDensity > 0.0) {
            this.asc.setAtomSetModelProperty("densityPrimitive", DF.formatDecimal(this.primitiveDensity, 3));
            this.asc.setModelInfoForSet("primitiveDensity", this.primitiveDensity, this.asc.iSet);
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        this.setUnitCellOrientation();
        if (this.primitiveToCrystal != null) {
            this.asc.setModelInfoForSet("primitiveToCrystal", this.primitiveToCrystal, this.asc.iSet);
            M4d m4p2c = new M4d();
            m4p2c.setRotationScale(this.primitiveToCrystal);
            m4p2c.m33 = 1.0;
            this.asc.setModelInfoForSet("mat4PrimitiveToCrystal", m4p2c, this.asc.iSet);
            M4d m4c2p = M4d.newM4(m4p2c);
            m4c2p.invert();
            this.asc.setModelInfoForSet("mat4CrystalToPrimitive", m4c2p, this.asc.iSet);
            if (this.symops.size() > 0) {
                this.asc.setModelInfoForSet("fileSymmetryOperations", this.symops.clone(), this.asc.iSet);
            }
        }
        this.iHaveSymmetryOperators = false;
        this.applySymTrajASCR();
    }

    private void newAtomSet() throws Exception {
        if (this.ac > 0 && this.asc.ac > 0) {
            this.applySymmetryAndSetTrajectory();
            this.asc.newAtomSet();
        }
        if (this.spaceGroupName != null) {
            this.setSpaceGroupName(this.spaceGroupName);
        }
        this.ac = 0;
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.energy, this.energy);
        this.asc.setCurrentModelInfo("Energy", this.energy);
        this.asc.setInfo("Energy", this.energy);
        this.asc.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private boolean readPartialCharges() throws Exception {
        if (this.haveCharges || this.asc.ac == 0) {
            return true;
        }
        this.haveCharges = true;
        this.readLines(3);
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        int iPrim = 0;
        while (this.rd() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int iConv = this.getAtomIndexFromPrimitiveIndex(iPrim);
            if (iConv >= 0) {
                atoms[i0 + iConv].partialCharge = this.parseDoubleRange(this.line, 9, 11) - this.parseDoubleRange(this.line, 12, 18);
            }
            ++iPrim;
        }
        return true;
    }

    private boolean readTotalAtomicCharges() throws Exception {
        SB data = new SB();
        while (this.rd() != null && this.line.indexOf("T") < 0) {
            data.append(this.line);
        }
        String[] tokens = PT.getTokens(data.toString());
        double[] charges = new double[tokens.length];
        if (this.nuclearCharges == null || this.nuclearCharges.length != charges.length) {
            this.nuclearCharges = charges;
        }
        if (this.asc.ac == 0) {
            return true;
        }
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < charges.length; ++i) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv < 0) continue;
            charges[i] = this.parseDoubleStr(tokens[i]);
            atoms[i0 + iConv].partialCharge = this.nuclearCharges[i] - charges[i];
        }
        return true;
    }

    private void readFreqFragments() throws Exception {
        int numAtomsFrag = this.parseIntRange(this.line, 39, 44);
        if (numAtomsFrag < 0) {
            return;
        }
        this.atomFrag = new int[numAtomsFrag];
        String Sfrag = "";
        while (this.rd() != null && this.line.indexOf("(") >= 0) {
            Sfrag = Sfrag + this.line;
        }
        Sfrag = PT.rep(Sfrag, "(", " ");
        Sfrag = PT.rep(Sfrag, ")", " ");
        String[] tokens = PT.getTokens(Sfrag);
        int i = 0;
        int pos = 0;
        while (i < numAtomsFrag) {
            this.atomFrag[i] = this.getAtomIndexFromPrimitiveIndex(this.parseIntStr(tokens[pos]) - 1);
            ++i;
            pos += 3;
        }
        Arrays.sort(this.atomFrag);
    }

    private void readFrequencies() throws Exception {
        int freqAtomCount;
        this.getLastConventional = false;
        this.addModel();
        this.energy = null;
        this.discardLinesUntilContains("MODES");
        boolean haveIntensities = this.line.indexOf("INTENS") >= 0;
        this.rd();
        Lst<String[]> vData = new Lst<String[]>();
        int n = freqAtomCount = this.atomFrag == null ? this.ac : 0;
        while (this.rd() != null && this.line.length() > 0) {
            int i0 = this.parseIntRange(this.line, 1, 5);
            int i1 = this.parseIntRange(this.line, 6, 10);
            String irrep = (this.isLongMode ? this.line.substring(48, 51) : this.line.substring(49, 52)).trim();
            String intens = !haveIntensities ? "not available" : (this.isLongMode ? this.line.substring(53, 61) : this.line.substring(59, 69).replace(')', ' ')).trim();
            String irActivity = this.isLongMode ? "A" : this.line.substring(55, 58).trim();
            String ramanActivity = this.isLongMode ? "I" : this.line.substring(71, 73).trim();
            String[] data = new String[]{irrep, intens, irActivity, ramanActivity};
            for (int i = i0; i <= i1; ++i) {
                vData.addLast(data);
            }
        }
        String test = this.isLongMode ? "LO MODES FOR IRREP" : (this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES");
        this.rd();
        Lst<String> ramanData = null;
        if (this.line.indexOf("<RAMAN>") >= 0) {
            ramanData = this.readRaman(null);
        }
        if (!this.line.contains(test)) {
            this.discardLinesUntilContains(test);
        }
        this.rd();
        int modelAtomCount = -1;
        while (this.rd() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            String[] tokens = PT.getTokens(this.line.substring(15));
            double[] frequencies = new double[tokens.length];
            int frequencyCount = frequencies.length;
            for (int i = 0; i < frequencyCount; ++i) {
                frequencies[i] = this.parseDoubleStr(tokens[i]);
                if (!this.debugging) continue;
                Logger.debug(this.vibrationNumber + i + " frequency=" + frequencies[i]);
            }
            boolean[] ignore = new boolean[frequencyCount];
            int iAtom0 = 0;
            int nData = vData.size();
            boolean isFirst = true;
            for (int i = 0; i < frequencyCount; ++i) {
                tokens = (String[])vData.get(this.vibrationNumber % nData);
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber) || tokens == null;
                if (ignore[i]) continue;
                this.applySymmetryAndSetTrajectory();
                if (isFirst) {
                    modelAtomCount = this.asc.getLastAtomSetAtomCount();
                }
                this.cloneLastAtomSet(this.ac, null);
                if (isFirst) {
                    iAtom0 = this.asc.getLastAtomSetAtomIndex();
                    isFirst = false;
                }
                this.setFreqValue(frequencies[i], tokens);
            }
            this.rd();
            this.fillFrequencyData(iAtom0, freqAtomCount, modelAtomCount, ignore, false, 14, 10, this.atomFrag, 0, null);
            this.rd();
        }
        if (ramanData != null) {
            this.readRaman(ramanData);
        }
    }

    private void setFreqValue(double freq, String[] data) {
        String activity = "IR: " + data[2] + ", Ram.: " + data[3];
        this.asc.setAtomSetFrequency(this.vibrationNumber, null, activity, "" + freq, null);
        this.asc.setAtomSetModelProperty("IRintensity", data[1] + " km/Mole");
        this.asc.setAtomSetModelProperty("vibrationalSymmetry", data[0]);
        this.asc.setAtomSetModelProperty("IRactivity", data[2]);
        this.asc.setAtomSetModelProperty("Ramanactivity", data[3]);
        this.asc.setAtomSetName((this.isLongMode ? "LO " : "") + data[0] + " " + DF.formatDecimal(freq, 2) + " cm-1 (" + DF.formatDecimal(Double.parseDouble(data[1]), 0) + " km/Mole), " + activity);
    }

    private Lst<String> readRaman(Lst<String> ramanData) throws Exception {
        int mode2;
        int mode1;
        int i;
        if (ramanData == null) {
            ramanData = new Lst();
            this.rd();
            while (this.rd() != null && !this.line.contains("<RAMAN>")) {
                ramanData.addLast(this.line);
            }
            return ramanData;
        }
        int n = ramanData.size();
        for (i = 0; i < n; ++i) {
            this.line = (String)ramanData.get(i);
            if (this.line.contains("---")) break;
        }
        ++i;
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.length() == 0) break;
            mode1 = this.parseIntRange(this.line, 1, 5);
            mode2 = this.parseIntRange(this.line, 6, 10);
            double i_tot = this.parseDoubleRange(this.line, 30, 40);
            double i_par = this.parseDoubleRange(this.line, 40, 50);
            double i_perp = this.parseDoubleRange(this.line, 50, 60);
            int i0 = 0;
            for (int mode = mode1; mode <= mode2; ++mode) {
                int imodel = this.getModelForMode(i0, mode);
                if (imodel < 0) continue;
                i0 = imodel + 1;
                Hashtable<String, double[]> info = (Hashtable<String, double[]>)this.asc.getAtomSetAuxiliaryInfoValue(imodel, "ramanInfo");
                if (info == null) {
                    info = new Hashtable<String, double[]>();
                    this.asc.setModelInfoForSet("ramanInfo", info, imodel);
                }
                info.put("isotropicIntensities", new double[]{i_tot, i_par, i_perp});
            }
            ++i;
        }
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.contains("---")) break;
            ++i;
        }
        ++i;
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.length() == 0) break;
            mode1 = this.parseIntRange(this.line, 1, 5);
            mode2 = this.parseIntRange(this.line, 6, 10);
            double i_xx = this.parseDoubleRange(this.line, 30, 38);
            double i_xy = this.parseDoubleRange(this.line, 38, 46);
            double i_xz = this.parseDoubleRange(this.line, 46, 54);
            double i_yy = this.parseDoubleRange(this.line, 54, 62);
            double i_yz = this.parseDoubleRange(this.line, 62, 70);
            double i_zz = this.parseDoubleRange(this.line, 70, 78);
            int i0 = 0;
            for (int mode = mode1; mode <= mode2; ++mode) {
                int imodel = this.getModelForMode(i0, mode);
                if (imodel < 0) continue;
                i0 = imodel + 1;
                double[][] a = new double[][]{{i_xx, i_xy, i_xz}, {i_xy, i_yy, i_yz}, {i_xz, i_yz, i_zz}};
                this.asc.atoms[this.asc.getAtomSetAtomIndex(imodel)].addTensor(new Tensor().setFromAsymmetricTensor(a, "raman", "mode" + mode), "raman", false);
            }
            ++i;
        }
        this.appendLoadNote("Ellipsoids set \"raman\": Raman tensors");
        return null;
    }

    private int getModelForMode(int i0, int mode) {
        int n = this.asc.atomSetCount;
        for (int i = i0; i < n; ++i) {
            int m;
            Integer imode = (Integer)this.asc.getAtomSetAuxiliaryInfoValue(i, "vibrationalMode");
            int n2 = m = imode == null ? 0 : imode;
            if (m != mode) continue;
            return i;
        }
        return -1;
    }

    private boolean readGradient() throws Exception {
        String key = null;
        while (this.line != null) {
            String[] tokens = this.getTokens();
            if (this.line.indexOf("MAX GRAD") >= 0) {
                key = "maxGradient";
            } else if (this.line.indexOf("RMS GRAD") >= 0) {
                key = "rmsGradient";
            } else if (this.line.indexOf("MAX DISP") >= 0) {
                key = "maxDisplacement";
            } else {
                if (this.line.indexOf("RMS DISP") < 0) break;
                key = "rmsDisplacement";
            }
            if (this.asc.ac > 0) {
                this.asc.setAtomSetModelProperty(key, tokens[2]);
            }
            this.rd();
        }
        return true;
    }

    private boolean readData(String name, int nfields) throws Exception {
        this.processCoordLines();
        double[] f = new double[this.ac];
        for (int i = 0; i < this.ac; ++i) {
            f[i] = 0.0;
        }
        String data = "";
        while (this.rd() != null && (this.line.length() < 4 || PT.isDigit(this.line.charAt(3)))) {
            data = data + this.line;
        }
        data = PT.rep(data, "-", " -");
        String[] tokens = PT.getTokens(data);
        int i = 0;
        int pt = nfields - 1;
        while (i < this.ac) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv >= 0) {
                f[iConv] = this.parseDoubleStr(tokens[pt]);
            }
            ++i;
            pt += nfields;
        }
        this.asc.setAtomProperties(name, f, -1, false);
        return true;
    }

    private boolean getQuadrupoleTensors() throws Exception {
        this.readLines(6);
        Atom[] atoms = this.asc.atoms;
        T3d[] vectors = new V3d[3];
        if (this.directLatticeVectors == null) {
            vectors = new V3d[]{V3d.new3(1.0, 0.0, 0.0), V3d.new3(0.0, 1.0, 0.0), V3d.new3(0.0, 0.0, 1.0)};
        } else {
            for (int i = 0; i < 3; ++i) {
                vectors[i] = V3d.newV(this.directLatticeVectors[i]);
                vectors[i].normalize();
            }
        }
        while (this.rd() != null && this.line.startsWith(" *** ATOM")) {
            String[] tokens = this.getTokens();
            int index = this.parseIntStr(tokens[3]) - 1;
            tokens = PT.getTokens(this.readLines(3));
            atoms[index].addTensor(new Tensor().setFromEigenVectors(vectors, new double[]{this.parseDoubleStr(tokens[1]), this.parseDoubleStr(tokens[3]), this.parseDoubleStr(tokens[5])}, "quadrupole", atoms[index].atomName, null), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"quadrupole\": Quadrupole tensors");
        return true;
    }

    private boolean readBornChargeTensors() throws Exception {
        this.processCoordLines();
        this.rd();
        Atom[] atoms = this.asc.atoms;
        while (this.rd().startsWith(" ATOM")) {
            int index = this.parseIntAt(this.line, 5) - 1;
            Atom atom = atoms[index];
            this.readLines(2);
            atom.addTensor(new Tensor().setFromAsymmetricTensor(this.fill3x3(null, -3), "charge", atom.elementSymbol + (index + 1)), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"charge\": Born charge tensors");
        return false;
    }
}

