/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.api.GenericBinaryDocument;
import javajs.util.BC;
import org.jmol.adapter.readers.xtal.CmdfReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class CmdxReader
extends CmdfReader {
    private int nSites;
    private int nAIC;
    private int nc;
    private byte[] buf = new byte[100];

    @Override
    protected void processBinaryDocument() throws Exception {
        this.binaryDoc.setStream(null, false);
        this.dumpFile(this.binaryDoc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpFile(GenericBinaryDocument binaryDoc) {
        int nPre = 0;
        try {
            block12: while (true) {
                long pt = binaryDoc.getPosition();
                String key = binaryDoc.readString(4);
                int len = this.checkLen(pt, key);
                switch (key) {
                    case "WINS": {
                        continue block12;
                    }
                    case "PREV": {
                        this.writePreview(++nPre, len);
                        continue block12;
                    }
                    case "STRS": {
                        nPre = this.readStructures(nPre, pt + (long)len);
                        return;
                    }
                }
                binaryDoc.readBytes(len);
            }
        }
        catch (Exception e) {
            System.out.println(binaryDoc.getPosition());
            return;
        }
    }

    private void writePreview(int i, int len) throws Exception {
        String fname = (String)this.htParams.get("fullPathName") + ".preview" + i + ".jpg";
        int p = fname.indexOf("file:/");
        if (p >= 0) {
            fname = fname.substring(p + 6);
        }
        String s = this.vwr.writeBinaryFile(fname, this.binaryDoc.readBytes(len));
        System.out.println(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readStructures(int nPre, long endPos) throws Exception {
        long pos = this.binaryDoc.getPosition();
        long i1 = pos + (long)this.binaryDoc.readInt();
        System.out.println(i1);
        try {
            block24: while (this.binaryDoc.getPosition() < i1) {
                long pt = this.binaryDoc.getPosition();
                String key = this.binaryDoc.readString(4);
                int len = this.checkLen(pt, key);
                switch (key) {
                    case "PREV": {
                        this.writePreview(++nPre, len);
                        continue block24;
                    }
                    case "TYPE": 
                    case "NAME": 
                    case "NOTE": {
                        System.out.println(this.binaryDoc.readString(len));
                        continue block24;
                    }
                    case "NSIT": {
                        this.nSites = this.binaryDoc.readInt();
                        System.out.println(this.nSites + " sites");
                        continue block24;
                    }
                    case "NAIC": {
                        this.nAIC = this.binaryDoc.readInt();
                        System.out.println(this.nAIC + " naic");
                        continue block24;
                    }
                    case "CNUM": {
                        this.nc = this.binaryDoc.readInt();
                        System.out.println(this.nc + " compounds");
                        continue block24;
                    }
                    case "SITS": {
                        this.readSites(len);
                        continue block24;
                    }
                    case "ATMS": {
                        this.readAtoms(len);
                        continue block24;
                    }
                    case "BNDS": {
                        this.readBonds(len);
                        continue block24;
                    }
                }
                this.binaryDoc.readBytes(len);
            }
            return nPre;
        }
        catch (Exception e) {
            System.out.println(this.binaryDoc.getPosition());
        }
        return nPre;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readSites(int len) throws Exception {
        long pos = this.binaryDoc.getPosition();
        int n = this.binaryDoc.readInt();
        int i = 0;
        while (i < n) {
            pos = this.binaryDoc.getPosition();
            long i1 = pos + (long)this.binaryDoc.readInt();
            try {
                block21: while (this.binaryDoc.getPosition() < i1) {
                    long pt = this.binaryDoc.getPosition();
                    String key = this.binaryDoc.readString(4);
                    len = this.checkLen(pt, key);
                    switch (key) {
                        case "FRAC": {
                            double x = this.binaryDoc.readDouble();
                            double y = this.binaryDoc.readDouble();
                            double z = this.binaryDoc.readDouble();
                            System.out.println(x + " " + y + " " + z);
                            continue block21;
                        }
                        case "LABL": {
                            System.out.println(this.binaryDoc.readString(len));
                            continue block21;
                        }
                    }
                    this.binaryDoc.readBytes(len);
                }
            }
            catch (Exception e) {
                System.out.println(this.binaryDoc.getPosition());
            }
            ++i;
        }
        return;
    }

    private int checkLen(long pt, String key) throws Exception {
        int len = this.binaryDoc.readInt();
        if ((double)len > 1000000.0) {
            throw new RuntimeException("CMDX len " + len);
        }
        System.out.println(pt + "\t" + key + "\t" + len);
        return len;
    }

    private void readBonds(int len) throws Exception {
        long pos = this.binaryDoc.getPosition();
        int nBonds = this.binaryDoc.readInt();
        int i2 = this.binaryDoc.readInt();
        System.out.println(nBonds + " " + i2);
        long i1 = pos + (long)len;
        int nbonds = 0;
        try {
            block14: while (this.binaryDoc.getPosition() < i1) {
                String key;
                long pt = this.binaryDoc.getPosition();
                switch (key = this.binaryDoc.readString(4)) {
                    case "\u001c\u0000\u0000\u0000": {
                        System.out.println("NBONDS " + ++nbonds);
                        continue block14;
                    }
                }
                len = this.checkLen(pt, key);
                switch (key) {
                    default: 
                }
                this.binaryDoc.readBytes(len);
            }
        }
        catch (Exception e) {
            System.out.println(this.binaryDoc.getPosition());
        }
    }

    private static String fixSpaceGroup(String sg) {
        int pt = sg.indexOf(0);
        if (pt == 0) {
            System.out.println("SYMM: empty;NO space group??");
        }
        return (pt < 0 ? sg : sg.substring(0, pt)).trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAtoms(int len) throws Exception {
        long pos = this.binaryDoc.getPosition();
        long i1 = this.binaryDoc.readInt();
        System.out.println(i1);
        i1 = pos + (long)len;
        int nAtoms = 0;
        try {
            block19: while (this.binaryDoc.getPosition() < i1) {
                String key;
                long pt = this.binaryDoc.getPosition();
                switch (key = this.binaryDoc.readString(4)) {
                    case "E\u0000\u0000\u0000": 
                    case "5\u0000\u0000\u0000": {
                        System.out.println("NATOMS " + ++nAtoms);
                        continue block19;
                    }
                }
                len = this.checkLen(pt, key);
                switch (key) {
                    case "FRAC": {
                        double x = this.binaryDoc.readDouble();
                        double y = this.binaryDoc.readDouble();
                        double z = this.binaryDoc.readDouble();
                        System.out.println(x + " " + y + " " + z);
                        continue block19;
                    }
                    case "SITE": {
                        int site = this.binaryDoc.readInt();
                        System.out.println("site=" + site);
                        continue block19;
                    }
                }
                this.binaryDoc.readBytes(len);
            }
            return;
        }
        catch (Exception e) {
            System.out.println(this.binaryDoc.getPosition());
        }
    }

    private void readSite() throws Exception {
        int nOccupants = this.binaryDoc.readByte();
        int pt0 = (int)this.binaryDoc.getPosition();
        Atom[] atoms = new Atom[nOccupants];
        for (int i = 0; i < nOccupants; ++i) {
            Atom a = atoms[i] = new Atom();
            char ch2 = (char)this.binaryDoc.readByte();
            char ch1 = (char)this.binaryDoc.readByte();
            a.elementSymbol = CmdxReader.getSymbol("" + ch1 + ch2);
            if (JmolAdapter.getElementNumber(a.elementSymbol) == 0) {
                System.out.println("ELEMENT error " + a.elementSymbol + " " + this.fileName);
            }
            a.foccupancy = CmdxReader.fixDouble(this.binaryDoc.readFloat());
            this.asc.addAtom(a);
        }
        int elementIndex = this.binaryDoc.readInt();
        String sym0 = atoms[0].elementSymbol;
        String name = this.readString();
        int valence = this.binaryDoc.readInt();
        for (int i = 0; i < nOccupants; ++i) {
            atoms[i].atomName = i == 0 || sym0.length() > name.length() ? name : atoms[i].elementSymbol + name.substring(sym0.length());
        }
        int unk3s = this.binaryDoc.readShort() & 0xFFFF;
        float x = this.binaryDoc.readFloat();
        float y = this.binaryDoc.readFloat();
        float z = this.binaryDoc.readFloat();
        for (int i = 0; i < nOccupants; ++i) {
            this.setAtomCoordXYZ(atoms[i], CmdxReader.fixDouble(x), CmdxReader.fixDouble(y), CmdxReader.fixDouble(z));
        }
        float index2 = (float)this.binaryDoc.readInt() / 32.0f;
        int unk4b = this.binaryDoc.readByte() & 0xFF;
        short siteNumber = this.binaryDoc.readShort();
        int unk5b = this.binaryDoc.readByte() & 0xFF;
        int wyn = this.binaryDoc.readInt();
        byte wyabc = this.binaryDoc.readByte();
        String wyckoff = "" + wyn + (char)(96 + wyabc);
        System.out.println("SITE " + siteNumber + " occ=" + nOccupants + " " + atoms[0].elementSymbol + " " + atoms[0].atomName + " " + wyckoff + " " + atoms[0] + (nOccupants > 1 ? atoms[1].atomName : "") + " valence=" + valence + " " + index2 + " " + Integer.toHexString(unk3s) + " " + Integer.toHexString(unk4b) + " " + Integer.toHexString(unk5b));
    }

    private String readString() throws Exception {
        byte n = this.binaryDoc.readByte();
        this.binaryDoc.readByteArray(this.buf, 0, n);
        return new String(this.buf, 0, (int)n);
    }

    private void peek(int n) {
        long p0 = this.binaryDoc.getPosition();
        int p = (int)p0;
        byte[] bytes = new byte[4];
        try {
            for (int i = 0; i < n; ++i) {
                this.binaryDoc.seek(p++);
                this.binaryDoc.readByteArray(bytes, 0, 4);
                int ival = BC.bytesToInt(bytes, 0, false);
                float fval = BC.bytesToFloat(bytes, 0, false);
                System.out.println(p + " " + Integer.toHexString(bytes[0] < 0 ? 256 + bytes[0] : bytes[0]) + " " + (bytes[0] >= 48 && bytes[0] <= 122 ? Character.valueOf((char)bytes[0]) : ".") + " " + Integer.toHexString(ival) + " " + fval);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.binaryDoc.seek(p0);
    }

    private static double fixDouble(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private int seek(String label, int where) throws Exception {
        byte[] bytes = label.getBytes();
        if (where > 0) {
            this.binaryDoc.seek(where);
        }
        int p = where >= 0 ? where : (int)this.binaryDoc.getPosition();
        System.out.println("looking for " + label + " @" + p);
        int off = 0;
        int n = bytes.length;
        int p0 = p;
        while (off < n) {
            byte b = this.binaryDoc.readByte();
            ++p;
            if (b == bytes[off]) {
                ++off;
                continue;
            }
            if (off <= 0) continue;
            p = ++p0;
            this.binaryDoc.seek(p0);
            off = 0;
        }
        System.out.println(label + " found at " + (p - n));
        return p;
    }

    private static String getSymbol(String sym) {
        if (sym == null) {
            return "Xx";
        }
        int len = sym.length();
        if (len < 2) {
            return sym;
        }
        char ch1 = sym.charAt(1);
        if (ch1 >= 'a' && ch1 <= 'z') {
            return sym.substring(0, 2);
        }
        return "" + sym.charAt(0);
    }
}

