/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.util.Logger;

public class XmlQEReader
extends XmlReader {
    private double a;
    private double b;
    private double c;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        parent.doProcessLines = true;
        this.processXml2(parent, saxReader);
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if (this.debugging) {
            Logger.debug("xmlqe: start " + localName);
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("number_of_atoms".equals(localName) || "cell_dimensions".equals(localName) || "at".equals(localName)) {
            this.setKeepChars(true);
            return;
        }
        if (localName.startsWith("atom.")) {
            this.parent.setAtomCoordScaled(null, (String[])PT.getTokens((String)((String)this.atts.get((Object)"tau"))), (int)0, (double)0.5291772).elementSymbol = ((String)this.atts.get("species")).trim();
        }
        if ("structure".equals(localName)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.asc.doFixPeriodic = true;
            this.asc.newAtomSet();
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
    }

    @Override
    void processEndElement(String localName) {
        if (this.debugging) {
            Logger.debug("xmlqe: end " + localName);
        }
        if (this.parent.doProcessLines) {
            if ("cell_dimensions".equals(localName)) {
                this.parent.setFractionalCoordinates(true);
                double[] data = XmlQEReader.getTokensDouble(this.chars.toString(), null, 6);
                this.a = data[0];
                this.b = data[1] == 0.0 ? this.a : data[1];
                this.c = data[2] == 0.0 ? this.a : data[2];
            } else if ("at".equals(localName)) {
                double[] m = XmlQEReader.getTokensDouble(this.chars.toString(), null, 9);
                for (int i = 0; i < 9; i += 3) {
                    int n = i;
                    m[n] = m[n] * this.a;
                    int n2 = i + 1;
                    m[n2] = m[n2] * this.b;
                    int n3 = i + 2;
                    m[n3] = m[n3] * this.c;
                }
                this.parent.addExplicitLatticeVector(0, m, 0);
                this.parent.addExplicitLatticeVector(1, m, 3);
                this.parent.addExplicitLatticeVector(2, m, 6);
            } else if ("geometry_info".equals(localName)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.setKeepChars(false);
    }
}

