/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Edge;
import org.jmol.util.Logger;

public class XmlCdxReader
extends XmlReader {
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double minZ = Double.MAX_VALUE;
    private double maxZ = -1.7976931348623157E308;
    private double maxY = -1.7976931348623157E308;
    private double maxX = -1.7976931348623157E308;
    private boolean no3D;
    private Stack<String> fragments = new Stack();
    private String thisFragmentID;
    private CDNode thisNode;
    private Stack<CDNode> nodes = new Stack();
    private Lst<CDNode> nostereo = new Lst();
    Map<String, Object> objectsByID = new HashMap<String, Object>();
    private String textBuffer;
    public boolean isCDX;
    private Stack<BracketedGroup> bracketedGroups;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.is2D = true;
        if (parent == null) {
            this.processXml2(this, saxReader);
            parent = this;
        } else {
            this.no3D = parent.checkFilterKey("NO3D");
            this.noHydrogens = parent.noHydrogens;
            this.processXml2(parent, saxReader);
            this.filter = parent.filter;
        }
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        String id = (String)this.atts.get("id");
        if ("fragment".equals(localName)) {
            this.objectsByID.put(id, this.setFragment(id));
            return;
        }
        if ("n".equals(localName)) {
            this.objectsByID.put(id, this.setNode(id));
            return;
        }
        if ("b".equals(localName)) {
            this.objectsByID.put(id, this.setBond(id));
            return;
        }
        if ("t".equals(localName)) {
            this.textBuffer = "";
            return;
        }
        if ("s".equals(localName)) {
            this.setKeepChars(true);
            return;
        }
        if ("crossingbond".equals(localName)) {
            BracketedGroup bg;
            BracketedGroup bracketedGroup = bg = this.bracketedGroups == null || this.bracketedGroups.isEmpty() ? null : (BracketedGroup)this.bracketedGroups.get(this.bracketedGroups.size() - 1);
            if (bg != null && bg.repeatCount > 0) {
                bg.innerAtomID = this.parseIntStr((String)this.atts.get("inneratomid"));
                bg.bondID = this.parseIntStr((String)this.atts.get("bondid"));
            }
            return;
        }
        if ("bracketedgroup".equals(localName)) {
            String usage = (String)this.atts.get("bracketusage");
            if (this.bracketedGroups == null) {
                this.bracketedGroups = new Stack();
            }
            int[] ids = null;
            int repeatCount = 0;
            if ("MultipleGroup".equals(usage)) {
                String[] sids = PT.getTokens((String)this.atts.get("bracketedobjectids"));
                ids = new int[sids.length];
                int i = ids.length;
                while (--i >= 0) {
                    ids[i] = this.parseIntStr(sids[i]);
                }
                repeatCount = this.parseIntStr((String)this.atts.get("repeatcount"));
            }
            this.bracketedGroups.add(new BracketedGroup(ids, repeatCount));
        }
    }

    private CDNode setFragment(String id) {
        String s;
        CDNode fragmentNode;
        this.thisFragmentID = id;
        this.fragments.push(this.thisFragmentID);
        CDNode cDNode = fragmentNode = this.thisNode == null || !this.thisNode.isFragment ? null : this.thisNode;
        if (fragmentNode != null) {
            fragmentNode.setInnerFragmentID(id);
        }
        if ((s = (String)this.atts.get("connectionorder")) != null) {
            System.out.println(id + " ConnectionOrder is " + s);
            this.thisNode.setConnectionOrder(PT.split(s.trim(), " "));
        }
        return fragmentNode;
    }

    @Override
    void processEndElement(String localName) {
        if ("fragment".equals(localName)) {
            this.thisFragmentID = this.fragments.pop();
            return;
        }
        if ("n".equals(localName)) {
            this.thisNode = this.nodes.size() == 0 ? null : this.nodes.pop();
            return;
        }
        if ("BracketedGroup".equals(localName)) {
            this.bracketedGroups.pop().process();
        }
        if ("s".equals(localName)) {
            this.textBuffer = this.textBuffer + this.chars.toString();
        }
        if ("t".equals(localName)) {
            if (this.thisNode == null) {
                System.out.println("XmlChemDrawReader unassigned text: " + this.textBuffer);
            } else {
                this.thisNode.text = this.textBuffer;
                if (this.atom.elementNumber == 0) {
                    System.err.println("XmlChemDrawReader: Problem with \"" + this.textBuffer + "\"");
                }
                if (this.thisNode.warning != null) {
                    this.parent.appendLoadNote("Warning: " + this.textBuffer + " " + this.thisNode.warning);
                }
            }
            this.textBuffer = "";
        }
        this.setKeepChars(false);
    }

    private CDNode setNode(String id) {
        String nodeType = (String)this.atts.get("nodetype");
        if (this.asc.bsAtoms == null) {
            this.asc.bsAtoms = new BS();
        }
        if (this.thisNode != null) {
            this.nodes.push(this.thisNode);
        }
        if ("_".equals(nodeType)) {
            this.thisNode = null;
            this.atom = null;
            return null;
        }
        this.thisNode = new CDNode(id, nodeType, this.thisFragmentID, this.thisNode);
        this.atom = this.thisNode;
        this.asc.addAtomWithMappedSerialNumber(this.atom);
        this.asc.bsAtoms.set(this.atom.index);
        String w = (String)this.atts.get("warning");
        if (w != null) {
            this.thisNode.warning = PT.rep(w, "&apos;", "'");
            this.thisNode.isValid = w.indexOf("ChemDraw can't interpret") < 0;
        }
        String element = (String)this.atts.get("element");
        String s = (String)this.atts.get("genericnickname");
        if (s != null) {
            element = s;
        }
        this.atom.elementNumber = (short)(!this.checkWarningOK(w) ? 0 : (element == null ? 6 : this.parseIntStr(element)));
        element = JmolAdapter.getElementSymbol(this.atom.elementNumber);
        s = (String)this.atts.get("isotope");
        if (s != null) {
            element = s + element;
        }
        this.setElementAndIsotope(this.atom, element);
        s = (String)this.atts.get("charge");
        if (s != null) {
            this.atom.formalCharge = this.parseIntStr(s);
        }
        boolean hasXYZ = this.atts.containsKey("xyz");
        boolean hasXY = this.atts.containsKey("p");
        if (!(!hasXYZ || this.no3D && hasXY)) {
            this.is2D = false;
            this.setAtom("xyz");
        } else if (this.atts.containsKey("p")) {
            this.setAtom("p");
        }
        s = (String)this.atts.get("attachments");
        if (s != null) {
            System.out.println(id + " Attachments is " + s);
            this.thisNode.setMultipleAttachments(PT.split(s.trim(), " "));
        }
        if ((s = (String)this.atts.get("bondordering")) != null) {
            System.out.println(id + " BondOrdering is " + s);
            this.thisNode.setBondOrdering(PT.split(s.trim(), " "));
        }
        if (Logger.debugging) {
            Logger.info("XmlChemDraw id=" + id + " " + element + " " + this.atom);
        }
        return this.thisNode;
    }

    private boolean checkWarningOK(String warning) {
        return warning == null || warning.indexOf("valence") >= 0 || warning.indexOf("very close") >= 0 || warning.indexOf("two identical colinear bonds") >= 0;
    }

    private CDBond setBond(String id) {
        String atom1 = (String)this.atts.get("b");
        String atom2 = (String)this.atts.get("e");
        String a = (String)this.atts.get("beginattach");
        int beginAttach = a == null ? 0 : this.parseIntStr(a);
        a = (String)this.atts.get("endattach");
        int endAttach = a == null ? 0 : this.parseIntStr(a);
        String s = (String)this.atts.get("order");
        String disp = (String)this.atts.get("display");
        String disp2 = (String)this.atts.get("display2");
        int order = 131071;
        boolean invertEnds = false;
        if (disp == null) {
            if (s == null) {
                order = 1;
            } else if (s.equals("1.5")) {
                order = 515;
            } else {
                if (s.indexOf(".") > 0 && !"Dash".equals(disp2)) {
                    s = s.substring(0, s.indexOf("."));
                }
                order = Edge.getBondOrderFromString(s);
            }
        } else if (disp.equals("WedgeBegin")) {
            order = 1025;
        } else if (disp.equals("Hash") || disp.equals("WedgedHashBegin")) {
            order = 1041;
        } else if (disp.equals("WedgeEnd")) {
            invertEnds = true;
            order = 1025;
        } else if (disp.equals("WedgedHashEnd")) {
            invertEnds = true;
            order = 1041;
        } else if (disp.equals("Bold")) {
            order = 1;
        } else if (disp.equals("Wavy")) {
            order = 1057;
        }
        if (order == 131071) {
            System.err.println("XmlChemDrawReader ignoring bond type " + s);
            return null;
        }
        CDBond b = invertEnds ? new CDBond(id, atom2, atom1, order) : new CDBond(id, atom1, atom2, order);
        CDNode node1 = (CDNode)this.asc.atoms[b.atomIndex1];
        CDNode node2 = (CDNode)this.asc.atoms[b.atomIndex2];
        if (order == 1057) {
            if (!this.nostereo.contains(node1)) {
                this.nostereo.addLast(node1);
            }
            if (!this.nostereo.contains(node2)) {
                this.nostereo.addLast(node2);
            }
        }
        if (node1.hasMultipleAttachments) {
            node1.attachedAtom = node2;
            return b;
        }
        if (node2.hasMultipleAttachments) {
            node2.attachedAtom = node1;
            return b;
        }
        if (node1.isFragment && beginAttach == 0) {
            beginAttach = 1;
        }
        if (node2.isFragment && endAttach == 0) {
            endAttach = 1;
        }
        if (beginAttach > 0) {
            (invertEnds ? node2 : node1).addAttachedAtom(b, beginAttach);
        }
        if (endAttach > 0) {
            (invertEnds ? node1 : node2).addAttachedAtom(b, endAttach);
        }
        if (node1.isExternalPt) {
            node1.setInternalAtom(node2);
        }
        if (node2.isExternalPt) {
            node2.setInternalAtom(node1);
        }
        this.asc.addBondNoCheck(b);
        return b;
    }

    private void setAtom(String key) {
        double z;
        String xyz = (String)this.atts.get(key);
        String[] tokens = PT.getTokens(xyz);
        double x = this.parseDoubleStr(tokens[0]);
        double y = -this.parseDoubleStr(tokens[1]);
        double d = z = key == "xyz" ? this.parseDoubleStr(tokens[2]) : 0.0;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        this.atom.set(x, y, z);
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.fixConnections();
        this.fixInvalidAtoms();
        this.centerAndScale();
        this.parent.appendLoadNote((this.isCDX ? "CDX: " : "CDXML: ") + (this.is2D ? "2D" : "3D"));
        this.asc.setInfo("minimize3D", !this.is2D && !this.noHydrogens);
        this.asc.setInfo("is2D", this.is2D);
        if (this.is2D) {
            this.optimize2D = !this.noHydrogens && !this.noMinimize;
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
            this.set2D();
        }
    }

    private void fixConnections() {
        int i = this.asc.ac;
        while (--i >= 0) {
            CDNode a = (CDNode)this.asc.atoms[i];
            if (!a.isFragment && !a.hasMultipleAttachments) continue;
            a.fixAttachments();
        }
        int n = this.asc.bondCount;
        for (i = 0; i < n; ++i) {
            Bond b = this.asc.bonds[i];
            if (b == null) continue;
            CDNode a1 = (CDNode)this.asc.atoms[b.atomIndex1];
            CDNode a2 = (CDNode)this.asc.atoms[b.atomIndex2];
            a1.isConnected = true;
            a2.isConnected = true;
            if (this.nostereo.contains(a1) == this.nostereo.contains(a2)) continue;
            b.order = 1;
        }
    }

    private void centerAndScale() {
        double f;
        if (this.minX > this.maxX) {
            return;
        }
        double sum = 0.0;
        int n = 0;
        double lenH = 1.0;
        int i = this.asc.bondCount;
        while (--i >= 0) {
            Atom a1 = this.asc.atoms[this.asc.bonds[i].atomIndex1];
            Atom a2 = this.asc.atoms[this.asc.bonds[i].atomIndex2];
            double d = a1.distance(a2);
            if (a1.elementNumber > 1 && a2.elementNumber > 1) {
                sum += d;
                ++n;
                continue;
            }
            lenH = d;
        }
        double d = sum > 0.0 ? 1.45 * (double)n / sum : (f = lenH > 0.0 ? 1.0 / lenH : 1.0);
        if (f > 0.5) {
            f = 1.0;
        }
        double cx = (this.maxX + this.minX) / 2.0;
        double cy = (this.maxY + this.minY) / 2.0;
        double cz = (this.maxZ + this.minZ) / 2.0;
        int i2 = this.asc.ac;
        while (--i2 >= 0) {
            Atom a = this.asc.atoms[i2];
            a.x = (a.x - cx) * f;
            a.y = (a.y - cy) * f;
            a.z = (a.z - cz) * f;
        }
    }

    private void fixInvalidAtoms() {
        int i = this.asc.ac;
        while (--i >= 0) {
            CDNode a = (CDNode)this.asc.atoms[i];
            a.atomSerial = Integer.MIN_VALUE;
            if (!a.isFragment && !a.isExternalPt && (a.isConnected || a.isValid && a.elementNumber != 6 && a.elementNumber != 0)) continue;
            this.asc.bsAtoms.clear(a.index);
        }
    }

    static class BracketedGroup {
        int[] ids;
        int bondID;
        int innerAtomID;
        int repeatCount;

        BracketedGroup(int[] ids, int repeatCount) {
            this.ids = ids;
            this.repeatCount = repeatCount;
        }

        public void process() {
            System.out.println("bracketed groups not implmented");
        }
    }

    class CDBond
    extends Bond {
        String id;
        String id1;
        String id2;

        CDBond(String id, String id1, String id2, int order) {
            super(((CDNode)XmlCdxReader.this.objectsByID.get((Object)id1)).index, ((CDNode)XmlCdxReader.this.objectsByID.get((Object)id2)).index, order);
            this.id = id;
            this.id1 = id1;
            this.id2 = id2;
        }

        CDNode getOtherNode(CDNode a) {
            return (CDNode)XmlCdxReader.this.asc.atoms[this.atomIndex1 == a.index ? this.atomIndex2 : this.atomIndex1];
        }

        @Override
        public String toString() {
            return "[CDBond " + this.id + " id1=" + this.id1 + " id2=" + this.id2 + super.toString() + "]";
        }
    }

    class CDNode
    extends Atom {
        String warning;
        String id;
        int intID;
        boolean isValid = true;
        boolean isConnected;
        boolean isExternalPt;
        String nodeType;
        boolean isFragment;
        String outerFragmentID;
        String innerFragmentID;
        public String text;
        CDNode parentNode;
        Lst<Object[]> orderedConnectionBonds;
        CDNode internalAtom;
        Lst<CDNode> orderedExternalPoints;
        private String[] attachments;
        private String[] bondOrdering;
        private String[] connectionOrder;
        public boolean hasMultipleAttachments;
        CDNode attachedAtom;
        private boolean isGeneric;

        CDNode(String id, String nodeType, String fragmentID, CDNode parent) {
            this.id = id;
            this.outerFragmentID = fragmentID;
            this.atomSerial = this.intID = Integer.parseInt(id);
            this.nodeType = nodeType;
            this.parentNode = parent;
            this.isFragment = "Fragment".equals(nodeType) || "Nickname".equals(nodeType);
            this.isExternalPt = "ExternalConnectionPoint".equals(nodeType);
            this.isGeneric = "GenericNickname".equals(nodeType);
        }

        public void setInnerFragmentID(String id) {
            this.innerFragmentID = id;
        }

        void setBondOrdering(String[] bondOrdering) {
            this.bondOrdering = bondOrdering;
        }

        void setConnectionOrder(String[] connectionOrder) {
            this.connectionOrder = connectionOrder;
        }

        void setMultipleAttachments(String[] attachments) {
            this.attachments = attachments;
            this.hasMultipleAttachments = true;
        }

        void addExternalPoint(CDNode externalPoint) {
            if (this.orderedExternalPoints == null) {
                this.orderedExternalPoints = new Lst();
            }
            int i = this.orderedExternalPoints.size();
            while (--i >= 0 && ((CDNode)this.orderedExternalPoints.get((int)i)).intID >= externalPoint.internalAtom.intID) {
            }
            this.orderedExternalPoints.add(++i, externalPoint);
        }

        public void setInternalAtom(CDNode a) {
            this.internalAtom = a;
            if (this.parentNode != null) {
                this.parentNode.addExternalPoint(this);
            }
        }

        void addAttachedAtom(CDBond bond, int pt) {
            if (this.orderedConnectionBonds == null) {
                this.orderedConnectionBonds = new Lst();
            }
            int i = this.orderedConnectionBonds.size();
            while (--i >= 0 && (Integer)((Object[])this.orderedConnectionBonds.get(i))[0] > pt) {
            }
            this.orderedConnectionBonds.add(++i, new Object[]{pt, bond});
        }

        void fixAttachments() {
            int i;
            if (this.hasMultipleAttachments && this.attachedAtom != null) {
                int order = Edge.getBondOrderFromString("partial");
                int a1 = this.attachedAtom.index;
                int i2 = this.attachments.length;
                while (--i2 >= 0) {
                    CDNode a = (CDNode)XmlCdxReader.this.objectsByID.get(this.attachments[i2]);
                    if (a == null) continue;
                    XmlCdxReader.this.asc.addBondNoCheck(new Bond(a1, a.index, order));
                }
            }
            if (this.orderedExternalPoints == null || this.text == null) {
                return;
            }
            int n = this.orderedExternalPoints.size();
            if (n != this.orderedConnectionBonds.size()) {
                System.err.println("XmlCdxReader cannot fix attachments for fragment " + this.text);
                return;
            }
            System.out.println("XmlCdxReader attaching fragment " + this.outerFragmentID + " " + this.text);
            if (this.bondOrdering == null) {
                this.bondOrdering = new String[n];
                for (i = 0; i < n; ++i) {
                    this.bondOrdering[i] = ((CDBond)((Object[])this.orderedConnectionBonds.get((int)i))[1]).id;
                }
            }
            if (this.connectionOrder == null) {
                this.connectionOrder = new String[n];
                for (i = 0; i < n; ++i) {
                    this.connectionOrder[i] = ((CDNode)this.orderedExternalPoints.get((int)i)).id;
                }
            }
            for (i = 0; i < n; ++i) {
                CDBond b = (CDBond)XmlCdxReader.this.objectsByID.get(this.bondOrdering[i]);
                CDNode pt = (CDNode)XmlCdxReader.this.objectsByID.get(this.connectionOrder[i]);
                CDNode a = pt.internalAtom;
                this.updateExternalBond(b, a);
            }
        }

        private void updateExternalBond(CDBond bond2f, CDNode intAtom) {
            if (bond2f.atomIndex2 == this.index) {
                bond2f.atomIndex2 = intAtom.index;
            } else if (bond2f.atomIndex1 == this.index) {
                bond2f.atomIndex1 = intAtom.index;
            } else {
                System.err.println("XmlCdxReader attachment failed! " + intAtom + " " + bond2f);
            }
        }

        @Override
        public String toString() {
            return "[CDNode " + this.id + " " + this.elementSymbol + " " + this.elementNumber + " index=" + this.index + " ext=" + this.isExternalPt + " frag=" + this.isFragment + " " + this.elementSymbol + " " + this.x + " " + this.y + "]";
        }
    }
}

