/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.V3d;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class InputReader
extends AtomSetCollectionReader {
    protected int ac;
    protected Lst<Atom> vAtoms = new Lst();
    private Map<String, Integer> atomMap = new Hashtable<String, Integer>();
    private String[] tokens;
    private boolean isJmolZformat;
    private Lst<String[]> lineBuffer = new Lst();
    private Map<String, Double> symbolicMap = new Hashtable<String, Double>();
    private boolean isMopac;
    private boolean isHeader = true;
    private boolean firstLine = true;
    private final P3d pt0 = new P3d();
    private final V3d v1 = new V3d();
    private final V3d v2 = new V3d();
    private final P4d plane1 = new P4d();
    private final P4d plane2 = new P4d();

    @Override
    protected boolean checkLine() throws Exception {
        if (this.firstLine) {
            this.firstLine = false;
            String[] tokens = this.getTokens();
            if (tokens.length == 3 && this.parseIntStr(tokens[0]) > 0 && this.parseIntStr(tokens[1]) > 0 && this.parseIntStr(tokens[2]) > 0) {
                this.readConFile();
                this.continuing = false;
                return false;
            }
        }
        this.cleanLine();
        if (this.line.length() <= 2) {
            this.isHeader = false;
        }
        if (this.line.startsWith("#") || this.line.startsWith("*") || this.isMopac && this.isHeader) {
            if (this.line.startsWith("#ZMATRIX")) {
                this.isJmolZformat = this.line.toUpperCase().indexOf("GAUSSIAN") < 0 && !(this.isMopac = this.line.toUpperCase().indexOf("MOPAC") >= 0);
            }
            this.checkCurrentLineForScript();
            return true;
        }
        if (this.line.indexOf("#") >= 0) {
            this.line = this.line.substring(0, this.line.indexOf("#"));
        }
        if (this.line.indexOf(":") >= 0) {
            return true;
        }
        if (this.line.contains("$molecule")) {
            this.rd();
            return this.readBlock("$end");
        }
        if (this.line.startsWith("$")) {
            return true;
        }
        if (this.line.contains("%mem")) {
            this.discardLinesUntilBlank();
            this.discardLinesUntilBlank();
            this.rd();
            return this.readBlock(null);
        }
        if (this.line.contains("ATOMS cartesian")) {
            return this.readBlock("END");
        }
        if (this.line.contains("geometry units angstroms")) {
            return this.readBlock("end");
        }
        if (this.line.contains("&zmat")) {
            return this.readBlock("&");
        }
        if (this.line.contains("%coords")) {
            this.discardLinesUntilContains("coords");
            return this.readBlock("end");
        }
        if (this.line.contains("GEOM=PQS")) {
            return this.readBlock("BASIS");
        }
        if (this.line.contains("geometry={")) {
            this.readLines(2);
            return this.readBlock("}");
        }
        this.tokens = this.getTokens();
        if (this.tokens.length > 10) {
            return this.readVFI();
        }
        switch (this.tokens.length) {
            case 1: {
                if (this.tokens[0].indexOf("=") < 0) {
                    this.lineBuffer.clear();
                    break;
                }
                this.tokens = PT.split(this.tokens[0], "=");
            }
            case 2: {
                if (this.parseIntStr(this.line) > 0 && this.parseInt() >= 0) {
                    this.readCFI();
                    this.continuing = false;
                    return false;
                }
                this.getSymbolic();
                return true;
            }
            case 10: {
                if (this.tokens[0].equals("0")) {
                    this.continuing = false;
                    return false;
                }
                if (this.tokens[1].indexOf(".") < 0) {
                    return true;
                }
                if (this.lineBuffer.size() <= 0 || ((String[])this.lineBuffer.get(this.lineBuffer.size() - 1)).length >= 8) break;
                this.lineBuffer.clear();
            }
        }
        this.lineBuffer.addLast(this.tokens);
        return true;
    }

    private void readConFile() throws Exception {
        this.rd();
        Hashtable<String, Atom> map = new Hashtable<String, Atom>();
        Lst<String[]> lstTokens = new Lst<String[]>();
        int n = 0;
        while (this.rd() != null && this.line.length() > 40) {
            ++n;
            String[] tokens = this.getTokens();
            lstTokens.addLast(tokens);
            map.put(tokens[1], this.addAtomXYZSymName(tokens, 2, tokens[0], null));
        }
        for (int i = 0; i < n; ++i) {
            String[] tokens = (String[])lstTokens.get(i);
            Atom a = (Atom)map.get(tokens[1]);
            for (int j = 6; j < tokens.length; ++j) {
                this.asc.addBond(new Bond(a.index, ((Atom)map.get((Object)tokens[j])).index, 1));
            }
        }
    }

    private void readCFI() throws Exception {
        this.tokens = this.getTokens();
        int nAtoms = (int)this.getValue(0);
        int nBonds = (int)this.getValue(1);
        Hashtable<String, Atom> map = new Hashtable<String, Atom>();
        for (int i = 0; i < nAtoms; ++i) {
            this.tokens = PT.getTokens(this.rd());
            if (this.tokens[1].equals("0") || this.tokens[1].equals("2")) continue;
            Atom a = this.addAtomXYZSymName(this.tokens, 2, null, null);
            a.elementNumber = (short)this.getValue(1);
            map.put(this.tokens[0], a);
        }
        double[] bonds = this.fillDoubleArray(null, 0, new double[nBonds * 2]);
        double[] orders = this.fillDoubleArray(null, 0, new double[nBonds]);
        int pt = 0;
        for (int i = 0; i < nBonds; ++i) {
            this.asc.addBond(new Bond(((Atom)map.get((Object)new StringBuilder().append((String)"").append((int)((int)bonds[pt++])).toString())).index, ((Atom)map.get((Object)new StringBuilder().append((String)"").append((int)((int)bonds[pt++])).toString())).index, (int)orders[i]));
        }
    }

    private boolean readVFI() throws Exception {
        Hashtable<String, Atom> map = new Hashtable<String, Atom>();
        Lst<String[]> bonds = new Lst<String[]>();
        while (this.tokens != null && this.tokens.length > 0) {
            String[] stringArray;
            int i = this.tokens.length;
            while (--i >= 11) {
                bonds.addLast(new String[]{this.tokens[3], this.tokens[i]});
            }
            String id = this.tokens[3];
            if (this.tokens[2].equals("0")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.tokens[4];
            } else if (this.tokens[1].equals("0")) {
                String[] stringArray3 = new String[3];
                stringArray3[0] = this.tokens[4];
                stringArray3[1] = this.tokens[2];
                stringArray = stringArray3;
                stringArray3[2] = this.tokens[5];
            } else if (this.tokens[0].equals("0")) {
                String[] stringArray4 = new String[5];
                stringArray4[0] = this.tokens[4];
                stringArray4[1] = this.tokens[2];
                stringArray4[2] = this.tokens[5];
                stringArray4[3] = this.tokens[1];
                stringArray = stringArray4;
                stringArray4[4] = this.tokens[7];
            } else {
                String[] stringArray5 = new String[7];
                stringArray5[0] = this.tokens[4];
                stringArray5[1] = this.tokens[2];
                stringArray5[2] = this.tokens[5];
                stringArray5[3] = this.tokens[1];
                stringArray5[4] = this.tokens[7];
                stringArray5[5] = this.tokens[0];
                stringArray = stringArray5;
                stringArray5[6] = this.tokens[9];
            }
            this.tokens = stringArray;
            Atom atom = this.getAtom();
            map.put(id, atom);
            this.tokens = PT.getTokens(this.rd());
        }
        int i = bonds.size();
        while (--i >= 0) {
            String[] b = (String[])bonds.get(i);
            this.asc.addBond(new Bond(((Atom)map.get((Object)b[0])).index, ((Atom)map.get((Object)b[1])).index, 1));
        }
        this.continuing = false;
        return false;
    }

    private boolean readBlock(String strEnd) throws Exception {
        this.lineBuffer.clear();
        while (this.rd() != null && this.cleanLine() != null && (strEnd == null ? this.line.length() > 0 : this.line.indexOf(strEnd) < 0)) {
            this.lineBuffer.addLast(this.getTokens());
        }
        this.continuing = false;
        return false;
    }

    private String cleanLine() {
        int pt2;
        int pt1;
        this.line = this.line.replace(',', ' ');
        while ((pt1 = this.line.indexOf(40)) >= 0 && (pt2 = this.line.indexOf(40, pt1)) >= 0) {
            this.line = this.line.substring(0, pt1) + " " + this.line.substring(pt2 + 1);
        }
        this.line = this.line.trim();
        return this.line;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        int firstLine;
        for (int i = firstLine = 0; i < this.lineBuffer.size(); ++i) {
            this.tokens = (String[])this.lineBuffer.get(i);
            if (this.tokens.length <= 0) continue;
            this.getAtom();
        }
        this.finalizeReaderASCR();
    }

    private void getSymbolic() {
        if (this.symbolicMap.containsKey(this.tokens[0])) {
            return;
        }
        double f = this.parseDoubleStr(this.tokens[1]);
        this.symbolicMap.put(this.tokens[0], f);
        Logger.info("symbolic " + this.tokens[0] + " = " + f);
    }

    private Atom getAtom() throws Exception {
        Atom atom = new Atom();
        String element = this.tokens[0];
        int i = element.length();
        while (--i >= 0 && PT.isDigit(element.charAt(i))) {
        }
        if (++i == 0) {
            element = JmolAdapter.getElementSymbol(this.parseIntStr(element));
        }
        if (i == 0 || i == element.length()) {
            atom.atomName = element + (this.ac + 1);
        } else {
            atom.atomName = element;
            element = element.substring(0, i);
        }
        if (this.isMopac && i != this.tokens[0].length()) {
            element = this.tokens[0].substring(i) + element;
        }
        this.parseAtomTokens(atom, element);
        return atom;
    }

    private void parseAtomTokens(Atom atom, String element) throws Exception {
        this.setElementAndIsotope(atom, element);
        if (this.tokens.length > 5 && this.tokens[1].indexOf(".") >= 0) {
            String[] stringArray;
            String[] t = this.tokens;
            int l = t.length;
            if (t[l - 3].equals("0")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = t[0];
            } else if (t[l - 2].equals("0")) {
                String[] stringArray3 = new String[3];
                stringArray3[0] = t[0];
                stringArray3[1] = t[l - 3];
                stringArray = stringArray3;
                stringArray3[2] = t[1];
            } else if (t[l - 1].equals("0")) {
                String[] stringArray4 = new String[5];
                stringArray4[0] = t[0];
                stringArray4[1] = t[l - 3];
                stringArray4[2] = t[1];
                stringArray4[3] = t[l - 2];
                stringArray = stringArray4;
                stringArray4[4] = t[3];
            } else {
                String[] stringArray5 = new String[7];
                stringArray5[0] = t[0];
                stringArray5[1] = t[l - 3];
                stringArray5[2] = t[1];
                stringArray5[3] = t[l - 2];
                stringArray5[4] = t[3];
                stringArray5[5] = t[l - 1];
                stringArray = stringArray5;
                stringArray5[6] = t[5];
            }
            this.tokens = stringArray;
        }
        int ia = this.getAtomIndex(1);
        int bondOrder = 0;
        switch (this.tokens.length) {
            case 6: 
            case 8: {
                bondOrder = (int)this.getValue(this.tokens.length - 1);
                atom = this.getAtomGeneral(atom, ia, bondOrder);
                break;
            }
            case 5: {
                if (this.tokens[1].equals("0")) {
                    atom.set(this.getValue(2), this.getValue(3), this.getValue(4));
                    break;
                }
            }
            case 7: {
                atom = this.getAtomGeneral(atom, ia, 0);
                break;
            }
            case 4: {
                if (this.getAtomIndex(1) < 0) {
                    atom.set(this.getValue(1), this.getValue(2), this.getValue(3));
                    break;
                }
                bondOrder = (int)this.getValue(3);
            }
            case 3: {
                if (this.ac != 1 || (ia = this.getAtomIndex(1)) != 0) {
                    atom = null;
                    break;
                }
                atom.set(this.getValue(2), 0.0, 0.0);
                break;
            }
            case 1: {
                if (this.ac != 0) {
                    atom = null;
                    break;
                }
                atom.set(0.0, 0.0, 0.0);
                break;
            }
            default: {
                atom = null;
            }
        }
        if (atom == null) {
            throw new Exception("bad Z-Matrix line");
        }
        this.vAtoms.addLast(atom);
        this.atomMap.put(atom.atomName, this.ac++);
        if (element.startsWith("X") && JmolAdapter.getElementNumber(element) < 1) {
            Logger.info("#dummy atom ignored: atom " + this.ac + " - " + atom.atomName);
        } else {
            this.asc.addAtom(atom);
            this.setAtomCoord(atom);
            Logger.info(atom.atomName + " " + atom.x + " " + atom.y + " " + atom.z);
            if (bondOrder < 0 || this.isJmolZformat && bondOrder > 0) {
                this.asc.addBond(new Bond(atom.index, ((Atom)this.vAtoms.get((int)ia)).index, Math.abs(bondOrder)));
            }
        }
    }

    private Atom getAtomGeneral(Atom atom, int ia, int bondOrder) throws Exception {
        double theta2;
        int ic;
        int ib;
        if (this.tokens.length < 7 && this.ac != 2 || (ib = this.getAtomIndex(3)) < 0 || (ic = this.tokens.length < 7 ? -2 : this.getAtomIndex(5)) == -1) {
            return null;
        }
        double d = this.getValue(2);
        double theta1 = this.getValue(4);
        double d2 = theta2 = this.tokens.length < 7 ? Double.MAX_VALUE : this.getValue(6);
        if (this.tokens.length == 8 && !this.isJmolZformat && !this.isMopac && bondOrder == 1) {
            d = -Math.abs(d);
        }
        atom = this.setAtom(atom, ia, ib, ic, d, theta1, theta2);
        return atom;
    }

    private double getSymbolic(String key) {
        boolean isNeg = key.startsWith("-");
        Double F = this.symbolicMap.get(isNeg ? key.substring(1) : key);
        if (F == null) {
            return Double.NaN;
        }
        double f = F;
        return isNeg ? -f : f;
    }

    private double getValue(int i) throws Exception {
        double f = this.getSymbolic(this.tokens[i]);
        if (Double.isNaN(f) && Double.isNaN(f = this.parseDoubleStr(this.tokens[i]))) {
            throw new Exception("Bad Z-matrix value: " + this.tokens[i]);
        }
        return f;
    }

    private int getAtomIndex(int i) {
        String name;
        if (i >= this.tokens.length || (name = this.tokens[i]).indexOf(".") >= 0 || !PT.isLetterOrDigit(name.charAt(0))) {
            return -1;
        }
        int ia = this.parseIntStr(name);
        if (ia <= 0 || name.length() != ("" + ia).length()) {
            Integer I = this.atomMap.get(name);
            if (I == null) {
                i = this.vAtoms.size();
                while (--i >= 0) {
                    Atom atom = (Atom)this.vAtoms.get(i);
                    if (!atom.atomName.startsWith(name) || atom.atomName.length() <= name.length() || !PT.isDigit(atom.atomName.charAt(name.length()))) continue;
                    I = this.atomMap.get(atom.atomName);
                    break;
                }
            }
            ia = I == null ? -1 : I;
        } else {
            --ia;
        }
        return ia;
    }

    protected Atom setAtom(Atom atom, int ia, int ib, int ic, double d, double theta1, double theta2) {
        if (Double.isNaN(theta1) || Double.isNaN(theta2)) {
            return null;
        }
        Atom a = (Atom)this.vAtoms.get(ia);
        Atom b = (Atom)this.vAtoms.get(ib);
        this.v1.set(b.x - a.x, b.y - a.y, b.z - a.z);
        this.v1.normalize();
        if (theta2 == Double.MAX_VALUE) {
            this.v2.set(0.0, 0.0, 1.0);
            Qd.newVA(this.v2, theta1).transform2(this.v1, this.v2);
        } else if (d >= 0.0) {
            Atom c = (Atom)this.vAtoms.get(ic);
            this.v2.set(c.x - a.x, c.y - a.y, c.z - a.z);
            this.v2.cross(this.v1, this.v2);
            Qd.newVA(this.v2, theta1).transform2(this.v1, this.v2);
            Qd.newVA(this.v1, -theta2).transform2(this.v2, this.v2);
        } else {
            this.setAtom(atom, ia, ib, ic, -d, theta1, 0.0);
            this.pt0.set(a.x, a.y, a.z);
            MeasureD.getPlaneThroughPoint(this.pt0, this.v1, this.plane1);
            this.setAtom(atom, ia, ic, ib, -d, theta2, 0.0);
            this.pt0.set(a.x, a.y, a.z);
            MeasureD.getPlaneThroughPoint(this.pt0, this.v1, this.plane2);
            Lst<Object> list = MeasureD.getIntersectionPP(this.plane1, this.plane2);
            if (list.size() == 0) {
                return null;
            }
            this.pt0.setT((P3d)list.get(0));
            d = Math.sqrt(d * d - this.pt0.x * a.x - this.pt0.y * a.y - this.pt0.z * a.z) * Math.signum(theta1) * Math.signum(theta2);
            this.v2.setT((V3d)list.get(1));
        }
        atom.set(d * this.v2.x + this.pt0.x, d * this.v2.y + this.pt0.y, d * this.v2.z + this.pt0.z);
        return atom;
    }
}

