/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacSlaterReader {
    private static String DS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String DC_LIST = "xx    yy    zz    xy    xz    yz";
    private static String FS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String FC_LIST = "xxx   yyy   zzz   yyx   xxy   xxz   zzx   zzy   yyz   xyz";

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.equals("[HEADER]")) {
            this.readHeader();
            return true;
        }
        if (this.line.equals("[ATOMS]")) {
            this.readAtoms();
            return false;
        }
        if (this.line.equals("[BONDS]")) {
            this.readBonds();
            return false;
        }
        if (!this.doReadMolecularOrbitals) {
            return true;
        }
        if (this.line.equals("[AO_ORDER]")) {
            this.readAtomicOrbitalOrder();
            return false;
        }
        if (this.line.equals("[GTO]")) {
            this.readGaussianBasis();
            return false;
        }
        if (this.line.equals("[STO]")) {
            this.readSlaterBasis();
            return false;
        }
        if (this.line.indexOf("[MO") == 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readMolecularOrbital();
            return false;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
        if (this.nOrbitals > 0) {
            this.setMOs("eV");
        }
        if (this.debugging) {
            Logger.debug(this.orbitals.size() + " molecular orbitals read");
        }
    }

    void readHeader() throws Exception {
        this.moData.put("isNormalized", Boolean.TRUE);
        while (this.rd() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] tokens = this.getTokens();
            tokens[0] = tokens[0].substring(0, 1).toLowerCase() + tokens[0].substring(1, tokens[0].length());
            String str = "";
            for (int i = 1; i < tokens.length; ++i) {
                str = str + (i == 1 ? "" : " ") + tokens[i].toLowerCase();
            }
            this.moData.put(tokens[0], str);
        }
    }

    void readAtoms() throws Exception {
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            String sym = tokens[0];
            int atNo = this.parseIntStr(sym);
            this.setAtomCoordScaled(null, (String[])tokens, (int)1, (double)0.5291772).elementSymbol = atNo == Integer.MIN_VALUE ? sym : WebMOReader.getElementSymbol(atNo);
        }
    }

    void readBonds() throws Exception {
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            int atomIndex1 = this.parseIntStr(tokens[0]);
            int atomIndex2 = this.parseIntStr(tokens[1]);
            int order = this.parseIntStr(tokens[2]);
            this.asc.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            String data = this.line.substring(9).trim().toLowerCase();
            boolean isOK = false;
            switch (tokens.length - 1) {
                case 3: 
                case 4: {
                    isOK = true;
                    break;
                }
                case 5: {
                    isOK = tokens[0].equals("DOrbitals") && this.getDFMap("DS", data, 3, DS_LIST, 99);
                    break;
                }
                case 6: {
                    isOK = tokens[0].equals("DOrbitals") && this.getDFMap("DC", data, 4, DC_LIST, 2);
                    break;
                }
                case 7: {
                    isOK = tokens[0].equals("FOrbitals") && this.getDFMap("FS", data, 5, FS_LIST, 99);
                    break;
                }
                case 10: {
                    boolean bl = isOK = tokens[0].equals("FOrbitals") && this.getDFMap("FC", data, 6, FC_LIST, 3);
                }
            }
            if (isOK) continue;
            Logger.error("atomic orbital order is unrecognized -- skipping reading of MOs due to line: " + this.line);
            this.orbitals = null;
        }
    }

    private boolean getLine() throws Exception {
        return this.rd() != null && (this.line.length() == 0 || this.line.charAt(0) != '[');
    }

    void readGaussianBasis() throws Exception {
        Lst<int[]> sdata = new Lst<int[]>();
        Lst<double[]> gdata = new Lst<double[]>();
        int atomNo = 1;
        int gaussianPtr = 0;
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            if (tokens.length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] slater = new int[4];
            atomNo = this.parseIntStr(tokens[0]);
            tokens = PT.getTokens(this.rd());
            int nGaussians = this.parseIntStr(tokens[1]);
            slater[0] = atomNo;
            slater[1] = BasisFunctionReader.getQuantumShellTagID(tokens[0]);
            slater[2] = gaussianPtr + 1;
            slater[3] = nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                String[] strData = PT.getTokens(this.rd());
                int nData = strData.length;
                double[] data = new double[nData];
                for (int d = 0; d < nData; ++d) {
                    data[d] = this.parseDoubleStr(strData[d]);
                }
                gdata.addLast(data);
                ++gaussianPtr;
            }
            sdata.addLast(slater);
        }
        double[][] garray = AU.newDouble2(gaussianPtr);
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = (double[])gdata.get(i);
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        if (this.debugging) {
            Logger.debug(sdata.size() + " slater shells read");
            Logger.debug(garray.length + " gaussian primitives read");
        }
        this.asc.setCurrentModelInfo("moData", this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length < 7) continue;
            this.addSlater(this.parseIntStr(tokens[0]), this.parseIntStr(tokens[1]), this.parseIntStr(tokens[2]), this.parseIntStr(tokens[3]), this.parseIntStr(tokens[4]), this.parseDoubleStr(tokens[5]), this.parseDoubleStr(tokens[6]));
        }
        this.scaleSlaters = false;
        this.setSlaters(false);
    }

    void readMolecularOrbital() throws Exception {
        if (this.orbitals == null) {
            Logger.error("MOLECULAR ORBITALS SKIPPED");
            while (this.getLine()) {
            }
            return;
        }
        Hashtable<String, Object> mo = new Hashtable<String, Object>();
        Lst<String> data = new Lst<String>();
        double energy = this.parseDoubleStr(this.rd());
        double occupancy = this.parseDoubleStr(this.rd());
        while (this.getLine()) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            data.addLast(tokens[1]);
        }
        double[] coefs = new double[data.size()];
        int i = data.size();
        while (--i >= 0) {
            coefs[i] = this.parseDoubleStr((String)data.get(i));
        }
        mo.put("energy", energy);
        mo.put("occupancy", occupancy);
        mo.put("coefficients", coefs);
        this.orbitals.addLast(mo);
        ++this.nOrbitals;
        if (occupancy > 0.0) {
            this.moData.put("HOMO", this.nOrbitals);
        }
    }
}

