/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.QS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class OrcaReader
extends MOReader {
    private String chargeTag;
    private int atomCount;
    private boolean xyzBohr;
    private int moModelSet;

    @Override
    protected void initializeReader() throws Exception {
        this.chargeTag = this.checkAndRemoveFilterKey("CHARGE=LOW") ? "LOEW" : "MULL";
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("! Bohrs")) {
            this.xyzBohr = true;
            return true;
        }
        if (this.line.startsWith("* xyz") || this.line.startsWith("*xyz")) {
            this.processInputFile();
            this.continuing = false;
            return false;
        }
        if (this.line.indexOf("CARTESIAN COORDINATES (ANG") >= 0) {
            this.processAtoms();
            return true;
        }
        if (this.line.indexOf("ATOMIC CHARGES") >= 0 && this.line.indexOf(this.chargeTag) >= 0) {
            this.processAtomicCharges();
            return true;
        }
        if (this.line.startsWith("Total Energy")) {
            this.processEnergyLine();
            return true;
        }
        if (this.line.indexOf("BASIS SET IN INPUT FORMAT") == 0) {
            this.processBasis();
        }
        if (this.line.trim().equals("MOLECULAR ORBITALS")) {
            this.processMolecularOrbitals();
        }
        return true;
    }

    private void processEnergyLine() {
        String[] tokens = this.getTokens();
        this.asc.setAtomSetEnergy(tokens[3], Double.parseDouble(tokens[3]));
    }

    private void processInputFile() throws Exception {
        while (this.rd() != null) {
            while (this.line.trim().length() == 0 || this.line.startsWith("#")) {
                this.rd();
            }
            if (this.line.indexOf("*") >= 0) break;
            String[] tokens = this.getTokens();
            Atom a = this.addAtomXYZSymName(tokens, 1, tokens[0], null);
            if (!this.xyzBohr) continue;
            a.scale(0.5291772);
        }
    }

    void processAtoms() throws Exception {
        String[] tokens;
        ++this.modelNumber;
        if (!this.doGetModel(this.modelNumber, null)) {
            return;
        }
        this.asc.newAtomSet();
        this.baseAtomIndex = this.asc.ac;
        this.rd();
        while (this.rd() != null && (tokens = this.getTokens()).length == 4) {
            this.addAtomXYZSymName(tokens, 1, tokens[0], null);
        }
        if (this.baseAtomIndex == 0) {
            this.atomCount = this.asc.ac;
        }
    }

    void processAtomicCharges() throws Exception {
        this.rd();
        for (int i = 0; i < this.atomCount; ++i) {
            this.rd();
            this.asc.atoms[i + this.baseAtomIndex].partialCharge = Double.parseDouble(this.line.substring(this.line.indexOf(":") + 1));
        }
    }

    private void processBasis() throws Exception {
        int j;
        Lst lines;
        if (this.shells != null) {
            return;
        }
        this.shells = new Lst();
        Lst<String[]> gdata = new Lst<String[]>();
        boolean doSphericalF = true;
        boolean doSphericalD = true;
        this.calculationType = "5D7F";
        Hashtable<String, Lst> basisLines = new Hashtable<String, Lst>();
        this.rd();
        while (this.discardLinesUntilContains2("#", "-----").indexOf("#") >= 0) {
            String element = this.line.substring(this.line.indexOf(":") + 1).trim();
            lines = new Lst();
            basisLines.put(element, lines);
            this.rd();
            while (this.rd().indexOf("end;") < 0) {
                if (this.line.length() > 10) {
                    this.line = this.line.substring(4);
                }
                lines.addLast(this.getTokens());
            }
        }
        for (int ac = 0; ac < this.atomCount; ++ac) {
            lines = (Lst)basisLines.get(this.asc.atoms[ac].elementSymbol);
            j = 0;
            while (j < lines.size()) {
                String[] tokens = (String[])lines.get(j++);
                ++this.shellCount;
                int[] slater = new int[4];
                slater[0] = ac + 1;
                String oType = tokens[0];
                slater[1] = doSphericalF && oType.indexOf("F") >= 0 || doSphericalD && oType.indexOf("D") >= 0 ? BasisFunctionReader.getQuantumShellTagIDSpherical(oType) : BasisFunctionReader.getQuantumShellTagID(oType);
                int nGaussians = this.parseIntStr(tokens[1]);
                slater[2] = this.gaussianCount + 1;
                slater[3] = nGaussians;
                if (this.debugging) {
                    Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(slater));
                }
                this.shells.addLast(slater);
                this.gaussianCount += nGaussians;
                for (int i = 0; i < nGaussians; ++i) {
                    tokens = (String[])lines.get(j++);
                    if (this.debugging) {
                        Logger.debug("Gaussians " + (i + 1) + " " + Escape.eAS(tokens, true));
                    }
                    gdata.addLast(tokens);
                }
            }
        }
        this.gaussians = AU.newDouble2(this.gaussianCount);
        for (int i = 0; i < this.gaussianCount; ++i) {
            String[] tokens = (String[])gdata.get(i);
            this.gaussians[i] = new double[tokens.length];
            for (j = 0; j < tokens.length; ++j) {
                this.gaussians[i][j] = this.parseDoubleStr(tokens[j]);
            }
        }
        Logger.info(this.shellCount + " slater shells read");
        Logger.info(this.gaussianCount + " gaussian primitives read");
    }

    private void processMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Map<K, V>[] mos = AU.createArrayOfHashtable(6);
        Lst<type>[] data = AU.createArrayOfArrayList(6);
        int nThisLine = 0;
        this.rd();
        Lst<String> labels = new Lst<String>();
        while (this.rd() != null && this.line.indexOf("----") < 0) {
            String[] tokens;
            if (this.line.length() == 0) continue;
            if (this.line.startsWith("          ")) {
                int i;
                this.addMODataOR(nThisLine, labels, data, mos);
                labels.clear();
                this.rd();
                tokens = this.getTokens();
                nThisLine = tokens.length;
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Lst();
                    mos[i].put("energy", Double.valueOf(tokens[i]));
                }
                this.rd();
                tokens = this.getTokens();
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("occupancy", Double.valueOf(tokens[i]));
                }
                this.rd();
                continue;
            }
            try {
                tokens = this.getTokens();
                String type = tokens[tokens.length - nThisLine - 1].substring(1).toUpperCase();
                labels.addLast(type);
                if (PT.isDigit(type.charAt(0))) {
                    type = type.substring(1);
                }
                if (!QS.isQuantumBasisSupported(type.charAt(0)) && "XYZ".indexOf(type.charAt(0)) >= 0) {
                    type = (type.length() == 2 ? "D" : "F") + type;
                }
                if (!QS.isQuantumBasisSupported(type.charAt(0))) continue;
                tokens = OrcaReader.getStrings(this.line.substring(this.line.length() - 10 * nThisLine), nThisLine, 10);
                for (int i = 0; i < nThisLine; ++i) {
                    data[i].addLast(tokens[i]);
                }
            }
            catch (Exception e) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMODataOR(nThisLine, labels, data, mos);
        this.setMOData(this.moModelSet != this.asc.atomSetCount);
        this.moModelSet = this.asc.atomSetCount;
    }

    private void addMODataOR(int nThisLine, Lst<String> labels, Lst<String>[] data, Map<String, Object>[] mos) {
        if (labels.size() == 0) {
            return;
        }
        for (int i = 0; i < labels.size(); ++i) {
            if (!((String)labels.get(i)).equals("PZ")) continue;
            for (int j = 0; j < nThisLine; ++j) {
                Lst<String> d = data[j];
                String s = d.removeItemAt(i);
                d.add(i + 2, s);
            }
        }
        this.addMOData(nThisLine, data, mos);
    }
}

