/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.SlaterData;

abstract class MopacSlaterReader
extends SlaterReader {
    protected static final double MIN_COEF = 1.0E-4;
    protected int[] atomicNumbers;
    protected double[][] mopacBasis;
    protected boolean allowMopacDCoef;
    private static final int[] principalQuantumNumber = new int[]{0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] npqd = new int[]{0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7};
    private static final int[] sphericalDValues = new int[]{0, -2, 0, 1, 0, 1, -2, 0, 0, 0, 1, 1, 1, 1, 0};
    private static Map<String, double[][]> mopacParams;
    public static final String MOPAC_TYPES = "AM1  MNDO PM3  PM6  PM7  RM1";
    static final double[] _AM1_C;
    private static final double[] _MNDO_C;
    private static final double[] _PM3_C;
    private static final double[] _PM6_C;
    private static final double[] _PM7_C;
    private static final double[] _RM1_C;

    MopacSlaterReader() {
    }

    @Override
    protected double scaleSlater(int ex, int ey, int ez, int er, double zeta) {
        int el = Math.abs(ex + ey + ez);
        switch (el) {
            case 0: {
                return MopacSlaterReader.getSlaterConstSSpherical(er + 1, Math.abs(zeta));
            }
            case 1: {
                return MopacSlaterReader.getSlaterConstPSpherical(er + 2, Math.abs(zeta));
            }
        }
        if (ex >= 0 && ey >= 0) {
            return super.scaleSlater(ex, ey, ez, er, zeta);
        }
        if (el == 3) {
            return 0.0;
        }
        return MopacSlaterReader.getSlaterConstDSpherical(el + er + 1, Math.abs(zeta), ex, ey);
    }

    private static final double getSlaterConstDSpherical(int n, double zeta, int ex, int ey) {
        return MopacSlaterReader.fact(15.0 / (double)(ex < 0 ? 12 : (ey < 0 ? 4 : 1)), zeta, n);
    }

    private static final double getSlaterConstSSpherical(int n, double zeta) {
        return Math.pow(2.0 * zeta, (double)n + 0.5) * Math.sqrt(0.07957747154594767 / fact_2n[n]);
    }

    private static final double getSlaterConstPSpherical(int n, double zeta) {
        double f = fact_2n[n] / 3.0;
        return Math.pow(2.0 * zeta, (double)n + 0.5) * Math.sqrt(0.07957747154594767 / f);
    }

    @Override
    public void setMOData(boolean clearOrbitals) {
        if (!this.allowNoOrbitals && this.orbitals.size() == 0) {
            return;
        }
        if (this.mopacBasis == null || !this.forceMOPAC && this.gaussians != null && this.shells != null) {
            if (this.forceMOPAC) {
                System.out.println("MopacSlaterReader ignoring MOPAC zeta parameters -- using Gaussian contractions");
            }
            super.setMOData(clearOrbitals);
            return;
        }
        this.setSlaters(false);
        this.moData.put("calculationType", this.calculationType);
        this.moData.put("energyUnits", this.energyUnits);
        this.moData.put("mos", this.orbitals);
        this.lastMoData = this.moData;
        this.finalizeMOData(this.lastMoData);
        if (clearOrbitals) {
            this.clearOrbitals();
        }
    }

    private static final int getNPQ(int atomicNumber) {
        return atomicNumber < principalQuantumNumber.length ? principalQuantumNumber[atomicNumber] : 0;
    }

    private static final int getNPQs(int atomicNumber) {
        int n = MopacSlaterReader.getNPQ(atomicNumber);
        switch (atomicNumber) {
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return n + 1;
            }
        }
        return n;
    }

    private static final int getNPQp(int atomicNumber) {
        int n = MopacSlaterReader.getNPQ(atomicNumber);
        switch (atomicNumber) {
            case 2: {
                return n + 1;
            }
        }
        return n;
    }

    private static final int getNPQd(int atomicNumber) {
        return atomicNumber < npqd.length ? npqd[atomicNumber] : 0;
    }

    @Override
    protected void addSlaterBasis() {
        if (this.mopacBasis == null || this.slaters != null && this.slaters.size() > 0) {
            return;
        }
        int ac = this.asc.ac;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atoms = this.asc.atoms;
        for (int i = i0; i < ac; ++i) {
            short an = atoms[i].elementNumber;
            this.createMopacSlaters(i, an, this.mopacBasis[an], this.allowMopacDCoef);
        }
    }

    public void createMopacSlaters(int iAtom, int atomicNumber, double[] values, boolean allowD) {
        double zeta = values[0];
        if (zeta != 0.0) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "S", zeta, 1.0);
        }
        if ((zeta = values[1]) != 0.0) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Px", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Py", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Pz", zeta, 1.0);
        }
        if ((zeta = values[2]) != 0.0 && allowD) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dx2-y2", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dxz", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dz2", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dyz", zeta, 1.0);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dxy", zeta, 1.0);
        }
    }

    protected void createSphericalSlaterByType(int iAtom, int atomicNumber, String type, double zeta, double coef) {
        int pt = "S Px Py Pz  Dx2-y2Dxz Dz2 Dyz Dxy".indexOf(type);
        switch (pt) {
            case 0: {
                SlaterData sd = this.addSlater(iAtom + 1, 0, 0, 0, MopacSlaterReader.getNPQs(atomicNumber) - 1, zeta, coef);
                sd.elemNo = atomicNumber;
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(iAtom + 1, pt == 2 ? 1 : 0, pt == 5 ? 1 : 0, pt == 8 ? 1 : 0, MopacSlaterReader.getNPQp(atomicNumber) - 2, zeta, coef);
                return;
            }
        }
        pt = (pt >> 2) * 3 - 9;
        this.addSlater(iAtom + 1, sphericalDValues[pt++], sphericalDValues[pt++], sphericalDValues[pt++], MopacSlaterReader.getNPQd(atomicNumber) - 3, zeta, coef);
    }

    public static double[][] getMopacAtomZetaSPD(String type) {
        double[][] params;
        if (mopacParams == null) {
            mopacParams = new Hashtable<String, double[][]>();
        }
        if ((params = mopacParams.get(type)) == null) {
            params = new double[120][3];
            mopacParams.put(type, params);
            double[] data = null;
            switch (MOPAC_TYPES.indexOf(type)) {
                case 0: {
                    data = _AM1_C;
                    break;
                }
                case 5: {
                    data = _MNDO_C;
                    break;
                }
                case 10: {
                    data = _PM3_C;
                    break;
                }
                case 15: {
                    data = _PM6_C;
                    break;
                }
                case 20: {
                    data = _PM7_C;
                    break;
                }
                case 25: {
                    MopacSlaterReader.addData(params, _AM1_C);
                    data = _RM1_C;
                    break;
                }
                default: {
                    System.err.println("MopacSlaterReader could not find MOPAC params for " + type);
                    return null;
                }
            }
            MopacSlaterReader.addData(params, data);
        }
        System.out.println("MopacSlaterReader using MOPAC params for " + type);
        return params;
    }

    private static void addData(double[][] params, double[] data) {
        int p = 0;
        int a = 0;
        for (int i = 0; i < data.length; ++i) {
            double d = data[i];
            if (d < 0.0) {
                a = (int)(-d);
                p = 0;
                continue;
            }
            params[a][p++] = d;
        }
    }

    static {
        _AM1_C = new double[]{-1.0, 1.188078, -2.0, 2.1956103, 6.9012486, -3.0, 0.7973487, 0.9045583, -4.0, 0.7425237, 0.8080499, -6.0, 1.808665, 1.685116, -7.0, 2.31541, 2.15794, -8.0, 3.108032, 2.524039, -9.0, 3.770082, 2.49467, -10.0, 5.998377, 4.1699304, -11.0, 0.789009, 1.1399864, -12.0, 1.0128928, 1.1798191, -13.0, 1.516593, 1.306347, -14.0, 1.830697, 1.284953, -15.0, 1.98128, 1.87515, -16.0, 2.366515, 1.667263, -17.0, 3.631376, 2.076799, -18.0, 0.9714216, 5.9236231, -19.0, 1.2660244, 0.9555939, -20.0, 1.1767754, 1.273852, -30.0, 1.954299, 1.372365, -31.0, 4.000216, 1.3540466, -32.0, 1.219631, 1.982794, -33.0, 2.2576897, 1.724971, -34.0, 2.684157, 2.0506164, -35.0, 3.064133, 2.038333, -36.0, 3.5931632, 2.0944633, -37.0, 4.0000187, 1.0140619, -38.0, 1.5236848, 1.5723524, -42.0, 1.945, 1.477, 2.468, -49.0, 1.8281576, 1.48475, -50.0, 1.6182807, 1.5084984, -51.0, 2.254823, 2.218592, -52.0, 2.1321165, 1.971268, -53.0, 2.102858, 2.161153, -54.0, 4.9675243, 3.1432142, -55.0, 5.7873708, 1.0311693, -56.0, 1.9136517, 1.3948894, -80.0, 2.036413, 1.955766, -81.0, 3.8077333, 1.5511578, -82.0, 2.4432161, 1.5506706, -83.0, 4.0007862, 0.9547714, -102.0, 4.0, 0.3, 0.3, -104.0};
        _MNDO_C = new double[]{-1.0, 1.331967, -2.0, 1.7710761, 6.9018258, -3.0, 0.4296141, 0.7554884, -4.0, 1.00421, 1.00421, -5.0, 1.506801, 1.506801, -6.0, 1.787537, 1.787537, -7.0, 2.255614, 2.255614, -8.0, 2.699905, 2.699905, -9.0, 2.848487, 2.848487, -10.0, 5.9998745, 4.17526, -11.0, 0.8213124, 1.030327, -12.0, 0.9394811, 1.3103428, -13.0, 1.444161, 1.444161, -14.0, 1.315986, 1.709943, -15.0, 2.10872, 1.78581, -16.0, 2.312962, 2.009146, -17.0, 3.784645, 2.036263, -18.0, 0.9821697, 5.999715, -19.0, 0.7276039, 0.9871174, -20.0, 1.0034161, 1.3102564, -21.0, 1.3951231, 5.0160943, 0.9264186, -22.0, 0.8961552, 0.9676159, 1.8698884, -23.0, 1.2873544, 1.1744379, 2.015022, -24.0, 2.1495003, 1.3131074, 2.3289346, -26.0, 1.4536275, 0.8933716, 1.8691105, -27.0, 0.59975, 0.607314, 1.856797, -28.0, 0.7735888, 6.0000132, 2.7857108, -29.0, 3.3957872, 1.786178, 3.3573266, -30.0, 2.047359, 1.460946, -31.0, 0.6986316, 1.8386933, -32.0, 1.29318, 2.020564, -33.0, 2.5614338, 1.6117315, -34.0, 0.7242956, 1.9267288, -35.0, 3.8543019, 2.1992091, -36.0, 3.5608622, 1.9832062, -37.0, 4.0001632, 0.9187408, -38.0, 1.3729266, 1.1118128, -40.0, 1.5386288, 1.1472515, 1.8744783, -42.0, 2.0001083, 1.4112837, 2.1944707, -46.0, 1.6942397, 6.0000131, 2.2314824, -47.0, 2.6156672, 1.5209942, 3.1178537, -48.0, 1.4192491, 1.0480637, -49.0, 1.762574, 1.8648962, -50.0, 2.08038, 1.937106, -51.0, 3.6458835, 1.9733156, -52.0, 2.7461609, 1.6160376, -53.0, 2.272961, 2.169498, -54.0, 4.9900791, 2.6929255, -55.0, 6.000417, 0.8986916, -56.0, 1.9765973, 1.3157348, -78.0, 1.8655763, 1.9475781, 2.8552253, -80.0, 2.218184, 2.065038, -81.0, 4.0000447, 1.8076332, -82.0, 2.498286, 2.082071, -83.0, 2.6772255, 0.6936864, -85.0, -87.0, -90.0, 1.435306, 1.435306, -100.0, -101.0, -102.0, 4.0, 0.3, 0.3, -103.0, -104.0, -105.0};
        _PM3_C = new double[]{-1.0, 0.967807, -2.0, 1.7710761, 6.9018258, -3.0, 0.65, 0.75, -4.0, 0.877439, 1.508755, -5.0, 1.5312597, 1.1434597, -6.0, 1.565085, 1.842345, -7.0, 2.028094, 2.313728, -8.0, 3.796544, 2.389402, -9.0, 4.708555, 2.491178, -10.0, 5.9998745, 4.17526, -11.0, 2.6618938, 0.8837425, -12.0, 0.698552, 1.483453, -13.0, 1.702888, 1.073629, -14.0, 1.635075, 1.313088, -15.0, 2.017563, 1.504732, -16.0, 1.891185, 1.658972, -17.0, 2.24621, 2.15101, -18.0, 0.9821697, 5.999715, -19.0, 0.8101687, 0.9578342, -20.0, 1.2087415, 0.940937, -30.0, 1.819989, 1.506922, -31.0, 1.84704, 0.839411, -32.0, 2.2373526, 1.5924319, -33.0, 2.636177, 1.703889, -34.0, 2.828051, 1.732536, -35.0, 5.348457, 2.12759, -36.0, 3.5608622, 1.9832062, -37.0, 4.0000415, 1.013459, -38.0, 1.2794532, 1.39125, -48.0, 1.679351, 2.066412, -49.0, 2.016116, 1.44535, -50.0, 2.373328, 1.638233, -51.0, 2.343039, 1.899992, -52.0, 4.165492, 1.647555, -53.0, 7.001013, 2.454354, -54.0, 4.9900791, 2.6929255, -55.0, 3.5960298, 0.9255168, -56.0, 1.9258219, 1.4519912, -80.0, 1.476885, 2.479951, -81.0, 6.867921, 1.969445, -82.0, 3.141289, 1.892418, -83.0, 4.916451, 1.934935, -87.0, -102.0, 4.0, 0.3, -104.0};
        _PM6_C = new double[]{-1.0, 1.268641, -2.0, 3.313204, 3.657133, -3.0, 0.981041, 2.953445, -4.0, 1.212539, 1.276487, -5.0, 1.634174, 1.479195, -6.0, 2.047558, 1.702841, -7.0, 2.380406, 1.999246, -8.0, 5.421751, 2.27096, -9.0, 6.043849, 2.906722, -10.0, 6.000148, 3.834528, -11.0, 0.686327, 0.950068, -12.0, 1.31083, 1.388897, -13.0, 2.364264, 1.749102, 1.269384, -14.0, 1.752741, 1.198413, 2.128593, -15.0, 2.158033, 1.805343, 1.230358, -16.0, 2.192844, 1.841078, 3.109401, -17.0, 2.63705, 2.118146, 1.324033, -18.0, 6.000272, 5.94917, -19.0, 6.000478, 1.127503, -20.0, 1.528258, 2.060094, -21.0, 1.402469, 1.345196, 1.859012, -22.0, 5.324777, 1.164068, 1.41828, -23.0, 1.97433, 1.063106, 1.394806, -24.0, 3.28346, 1.029394, 1.623119, -25.0, 2.13168, 1.52588, 2.6078, -26.0, 1.47915, 6.002246, 1.080747, -27.0, 1.166613, 3.0, 1.860218, -28.0, 1.591828, 2.304739, 2.514761, -29.0, 1.669096, 3.0, 2.73499, -30.0, 1.512875, 1.789482, -31.0, 2.339067, 1.729592, -32.0, 2.546073, 1.70913, -33.0, 2.926171, 1.765191, 1.392142, -34.0, 2.512366, 2.007576, -35.0, 4.670684, 2.035626, 1.521031, -36.0, 1.312248, 4.491371, -37.0, 5.510145, 1.33517, -38.0, 2.197303, 1.730137, -39.0, 0.593368, 1.490422, 1.650893, -40.0, 1.69259, 1.694916, 1.567392, -41.0, 2.355562, 1.386907, 1.977324, -42.0, 1.060429, 1.350412, 1.827152, -43.0, 1.956245, 6.006299, 1.76736, -44.0, 1.459195, 5.537201, 2.093164, -45.0, 1.324919, 4.306111, 2.901406, -46.0, 1.658503, 1.156718, 2.219861, -47.0, 1.994004, 0.681817, 6.007328, -48.0, 1.384108, 1.957413, -49.0, 2.023087, 2.106618, -50.0, 2.383941, 2.057908, -51.0, 2.391178, 1.773006, 2.46559, -52.0, 2.769862, 1.731319, -53.0, 4.498653, 1.917072, 1.875175, -54.0, 2.759787, 1.977446, -55.0, 5.956008, 1.619485, -56.0, 1.395379, 1.430139, -57.0, 2.67378, 1.248192, 1.688562, -71.0, 5.471741, 1.712296, 2.225892, -72.0, 3.085344, 1.575819, 1.84084, -73.0, 4.578087, 4.841244, 1.838249, -74.0, 2.66456, 1.62401, 1.7944, -75.0, 2.411839, 1.815351, 2.522766, -76.0, 3.031, 1.59396, 1.77557, -77.0, 1.500907, 4.106373, 2.676047, -78.0, 2.301264, 1.662404, 3.168852, -79.0, 1.814169, 1.618657, 5.053167, -80.0, 2.104896, 1.516293, -81.0, 3.335883, 1.766141, -82.0, 2.368901, 1.685246, -83.0, 3.702377, 1.872327, -85.0, -87.0, -90.0, 1.435306, 1.435306, -97.0, -98.0, 2.0, -100.0, -101.0, -102.0, 4.0, -103.0, -104.0, -105.0};
        _PM7_C = new double[]{-1.0, 1.260237, -2.0, 3.313204, 3.657133, -3.0, 0.804974, 6.02753, -4.0, 1.036199, 1.764629, -5.0, 1.560481, 1.449712, -6.0, 1.942244, 1.708723, -7.0, 2.354344, 2.028288, -8.0, 5.972309, 2.349017, -9.0, 6.07003, 2.930631, -10.0, 6.000148, 3.834528, -11.0, 1.666701, 1.397571, -12.0, 1.170297, 1.840439, -13.0, 1.232599, 1.219336, 1.617502, -14.0, 1.433994, 1.671776, 1.221915, -15.0, 2.257933, 1.555172, 1.235995, -16.0, 2.046153, 1.807678, 3.510309, -17.0, 2.223076, 2.264466, 0.949994, -18.0, 6.000272, 5.94917, -19.0, 5.422018, 1.471023, -20.0, 1.477988, 2.220194, -21.0, 1.794897, 2.174934, 5.99286, -22.0, 1.448579, 1.940695, 1.093648, -23.0, 6.051795, 2.249871, 1.087345, -24.0, 2.838413, 1.37956, 1.188729, -25.0, 1.66644, 2.078735, 2.89707, -26.0, 1.157576, 2.737621, 1.860792, -27.0, 1.789441, 1.531664, 1.951497, -28.0, 1.70834, 2.000099, 5.698724, -29.0, 1.735325, 3.219976, 6.013523, -30.0, 1.56014, 1.915631, -31.0, 1.913326, 1.811217, -32.0, 2.762845, 1.531131, -33.0, 3.21385, 1.628384, 3.314358, -34.0, 2.75113, 1.901764, -35.0, 3.72548, 2.242318, 1.591034, -36.0, 1.312248, 4.491371, -37.0, 1.314831, 6.015581, -38.0, 2.092264, 3.314082, -39.0, 1.605083, 2.131069, 6.021645, -40.0, 1.373517, 1.141705, 1.618769, -41.0, 2.761686, 5.999062, 1.611677, -42.0, 1.595399, 1.426575, 1.787748, -43.0, 2.104672, 2.669984, 3.030496, -44.0, 1.605646, 4.58082, 1.244578, -45.0, 1.591465, 4.546046, 2.685918, -46.0, 5.790768, 2.169788, 1.327661, -47.0, 1.793032, 2.528721, 3.524808, -48.0, 3.670047, 1.857036, -49.0, 1.902085, 1.940127, -50.0, 1.959238, 1.976146, -51.0, 1.9986, 1.887062, 1.475516, -52.0, 3.024819, 2.598283, -53.0, 3.316202, 2.449124, 1.716121, -54.0, 3.208788, 2.727979, -55.0, 1.776064, 6.02531, -56.0, 1.75049, 1.968788, -57.0, 3.398968, 1.811983, 1.894574, -71.0, 2.327039, 6.000335, 1.208414, -72.0, 2.854938, 3.079458, 2.067146, -73.0, 4.116264, 3.380936, 1.755408, -74.0, 3.881177, 2.044717, 1.928901, -75.0, 2.452162, 1.583194, 2.414839, -76.0, 3.094808, 2.845232, 1.986395, -77.0, 1.924564, 3.510744, 2.437796, -78.0, 2.922551, 0.725689, 2.158085, -79.0, 1.904923, 2.408005, 4.377691, -80.0, 2.575831, 1.955505, -81.0, 1.903342, 2.838647, 5.015677, -82.0, 4.706006, 2.591455, -83.0, 5.465413, 2.037481, 2.8554, -85.0, -87.0, -90.0, 1.435306, 1.435306, -97.0, -98.0, 2.0, -100.0, -101.0, -102.0, 4.0, -103.0, -104.0, -105.0};
        _RM1_C = new double[]{-1.0, 1.0826737, -6.0, 1.850188, 1.7683009, -7.0, 2.3744716, 1.9781257, -8.0, 3.1793691, 2.5536191, -9.0, 4.4033791, 2.6484156, -15.0, 2.1224012, 1.7432795, -16.0, 2.1334431, 1.8746065, -17.0, 3.8649107, 1.8959314, -35.0, 5.7315721, 2.0314758, -53.0, 2.5300375, 2.3173868, -57.0, 1.272677, 1.423276, 1.410369, -58.0, 1.281028, 1.425366, 1.412866, -59.0, 1.538039, 1.581647, 1.374904, -60.0, 1.45829, 1.570516, 1.513561, -61.0, 1.065536, 1.846925, 1.424049, -62.0, 1.293914, 1.738656, 1.521378, -63.0, 1.350342, 1.733714, 1.494122, -64.0, 1.272776, 1.908122, 1.515905, -65.0, 1.210052, 1.921514, 1.528123, -66.0, 1.295275, 1.912107, 1.413397, -67.0, 1.33055, 1.779559, 1.536524, -68.0, 1.347757, 1.806481, 1.466189, -69.0, 1.369147, 1.674365, 1.714394, -70.0, 1.239808, 1.849144, 1.485378, -71.0, 1.425302, 1.790353, 1.642603, -102.0, 4.0, 0.3};
    }
}

