/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.adapter.smarter.XtalSymmetry;
import org.jmol.api.JmolAdapter;
import org.jmol.c.STR;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class PdbReader
extends AtomSetCollectionReader {
    private static final int MODE_PDB = 0;
    private static final int MODE_HEX = 1;
    private static final int MODE_HYBRID36 = 2;
    private int serMode = 0;
    private int seqMode = 0;
    private int serial;
    private int lineLength;
    private SB pdbHeader;
    private boolean applySymmetry;
    private boolean getTlsGroups;
    private boolean isMultiModel;
    private boolean haveMappedSerials;
    private boolean isConnectStateBug;
    private boolean isLegacyModelType;
    protected boolean gromacsWideFormat;
    private final Map<String, Map<String, Boolean>> htFormul = new Hashtable<String, Map<String, Boolean>>();
    private Map<String, String> htHetero;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, Boolean> htElementsInCurrentGroup;
    private Map<String, Map<String, String>> htMolIds;
    private Lst<Map<String, String>> vCompnds;
    private Lst<Map<String, Object>> vBiomolecules;
    private Lst<Map<String, Object>> vTlsModels;
    private SB sbTlsErrors;
    protected int[] biomtChainAtomCounts;
    private SB sbIgnored;
    private SB sbSelected;
    private SB sbConect;
    private SB sb;
    private int ac;
    private int maxSerial;
    private int nUNK;
    private int nRes;
    private Map<String, String> currentCompnd;
    private String currentGroup3;
    private String currentKey;
    private int currentResno = Integer.MIN_VALUE;
    private int configurationPtr = Integer.MIN_VALUE;
    private boolean resetKey = true;
    private String compnd = null;
    private int conformationIndex;
    protected int fileAtomIndex;
    private char lastAltLoc = '\u0000';
    private int lastGroup = Integer.MIN_VALUE;
    private char lastInsertion = '\u0000';
    private int lastSourceSerial = Integer.MIN_VALUE;
    private int lastTargetSerial = Integer.MIN_VALUE;
    private int tlsGroupID;
    private int atomTypePt0;
    private int atomTypeLen;
    private boolean isCourseGrained;
    private boolean isbiomol;
    private double cryst1;
    private String fileSgName;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  SOURCE  TITLE   SEQADV  ";
    Map<String, String> htGroup1;
    private int maxLength = 80;
    protected String pdbID;
    private boolean haveDoubleBonds;
    private final double[] dataT = new double[8];
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double _8PI2_ = 78.95683520871486;
    private Map<Atom, double[]> tlsU;
    private Lst<int[]> vConnect;
    private int connectNextAtomIndex = 0;
    private int connectNextAtomSet = 0;
    private int[] connectLast;

    @Override
    protected void initializeReader() throws Exception {
        String conf;
        String s;
        this.allowPDBFilter = true;
        this.pdbHeader = this.getHeader ? new SB() : null;
        boolean bl = this.applySymmetry = !this.checkFilterKey("NOSYMMETRY");
        if (this.isDSSP1) {
            this.asc.setInfo("isDSSP1", Boolean.TRUE);
        }
        this.getTlsGroups = this.checkFilterKey("TLS");
        if (this.checkFilterKey("ASSEMBLY")) {
            this.filter = PT.rep(this.filter, "ASSEMBLY", "BIOMOLECULE");
        }
        this.isbiomol = this.checkFilterKey("BIOMOLECULE");
        if (this.isbiomol) {
            this.filter = this.filter.replace(':', ' ');
        }
        boolean byChain = this.isbiomol && this.checkFilterKey("BYCHAIN");
        boolean bySymop = this.isbiomol && this.checkFilterKey("BYSYMOP");
        boolean bl2 = this.isCourseGrained = byChain || bySymop;
        if (!this.isCourseGrained) {
            this.setIsPDB();
        }
        this.isConcatenated |= this.filePath.endsWith(".dssr");
        if (this.htParams.containsKey("vTlsModels")) {
            this.vTlsModels = (Lst)this.htParams.remove("vTlsModels");
        }
        if ((s = this.getFilter("TYPE ")) != null) {
            String[] tokens = PT.getTokens(s.replace(',', ' '));
            this.atomTypePt0 = Integer.parseInt(tokens[0]) - 1;
            int pt = tokens[1].indexOf("=");
            if (pt >= 0) {
                this.setFilterAtomTypeStr(tokens[1].substring(pt + 1).toUpperCase());
            } else {
                pt = tokens[1].length();
            }
            this.atomTypeLen = Integer.parseInt(tokens[1].substring(0, pt));
        }
        if ((conf = this.getFilter("CONF ")) != null) {
            this.configurationPtr = this.parseIntStr(conf);
            this.sbIgnored = new SB();
            this.sbSelected = new SB();
        }
        this.isLegacyModelType = this.stateScriptVersionInt < 120000;
        this.isConnectStateBug = this.stateScriptVersionInt >= 120151 && this.stateScriptVersionInt <= 120220 || this.stateScriptVersionInt >= 120300 && this.stateScriptVersionInt <= 120320;
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean forceNewModel;
        this.lineLength = this.line.length();
        int ptOption = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
        boolean isAtom = ptOption == 0 || ptOption == 1;
        boolean isModel = ptOption == 2;
        this.serial = isAtom ? this.getSerial(6, 11) : 0;
        boolean bl = forceNewModel = (this.isTrajectory || this.isSequential) && !this.isMultiModel && isAtom && this.serial == 1;
        if (this.getHeader) {
            if (isAtom || isModel) {
                this.getHeader = false;
            } else {
                this.readHeader(false);
            }
        }
        if (isModel || forceNewModel) {
            this.isMultiModel = isModel;
            this.getHeader = false;
            int modelNo = forceNewModel ? this.modelNumber + 1 : this.getModelNumber();
            String modelName = this.getModelName();
            int n = this.modelNumber = this.useFileModelNumbers ? modelNo : this.modelNumber + 1;
            if (!this.doGetModel(this.modelNumber, null)) {
                this.handleTlsMissingModels();
                boolean isOK = this.checkLastModel();
                if (!isOK && this.isConcatenated) {
                    this.continuing = true;
                    isOK = true;
                }
                return isOK;
            }
            if (!this.isCourseGrained) {
                this.connectAll(this.maxSerial, this.isConnectStateBug);
            }
            if (this.ac > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.model(modelNo, modelName);
            if (this.isLegacyModelType || !isAtom) {
                return true;
            }
        }
        if (this.isMultiModel && !this.doProcessLines) {
            return true;
        }
        if (isAtom) {
            this.getHeader = false;
            this.atom();
            return true;
        }
        switch (ptOption) {
            case 3: {
                this.conect();
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                if (!this.ignoreStructure) {
                    this.structure();
                }
                return true;
            }
            case 7: {
                this.het();
                return true;
            }
            case 8: {
                this.hetnam();
                return true;
            }
            case 9: {
                this.anisou();
                return true;
            }
            case 10: {
                this.site();
                return true;
            }
            case 11: {
                this.cryst1();
                return true;
            }
            case 12: 
            case 13: 
            case 14: {
                this.scale(ptOption - 11);
                return true;
            }
            case 15: {
                this.expdta();
                return true;
            }
            case 16: {
                this.formul();
                return true;
            }
            case 17: {
                if (this.line.startsWith("REMARK 285")) {
                    return this.remark285();
                }
                if (this.line.startsWith("REMARK 350")) {
                    return this.remark350();
                }
                if (this.line.startsWith("REMARK 290")) {
                    return this.remark290();
                }
                if (this.line.contains("This file does not adhere to the PDB standard")) {
                    this.gromacsWideFormat = true;
                }
                if (this.getTlsGroups && this.line.indexOf("TLS DETAILS") > 0) {
                    return this.remarkTls();
                }
                this.checkRemark();
                return true;
            }
            case 18: {
                this.header();
                return true;
            }
            case 19: 
            case 20: {
                this.compnd(ptOption == 20);
                return true;
            }
            case 21: {
                this.title();
                return true;
            }
            case 22: {
                this.seqAdv();
                return true;
            }
        }
        return true;
    }

    protected void checkRemark() {
        this.checkCurrentLineForScript();
    }

    private void seqAdv() {
        String g1 = this.line.substring(39, 42).trim().toLowerCase();
        if (g1.length() != 1) {
            return;
        }
        if (this.htGroup1 == null) {
            this.htGroup1 = new Hashtable<String, String>();
            this.asc.setInfo("htGroup1", this.htGroup1);
        }
        String g3 = this.line.substring(12, 15).trim();
        this.htGroup1.put(g3, g1);
    }

    private String readHeader(boolean getLine) throws Exception {
        if (getLine) {
            this.rd();
            if (!this.getHeader) {
                return this.line;
            }
        }
        this.pdbHeader.append(this.line).appendC('\n');
        return this.line;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderPDB();
    }

    protected void finalizeReaderPDB() throws Exception {
        this.checkNotPDB();
        if (this.pdbID != null && this.pdbID.length() > 0) {
            if (!this.isMultiModel) {
                this.asc.setAtomSetName(this.pdbID);
            }
            this.asc.setCurrentModelInfo("pdbID", this.pdbID);
        }
        this.checkUnitCellParams();
        if (!this.isCourseGrained) {
            this.connectAll(this.maxSerial, this.isConnectStateBug);
        }
        if (this.vBiomolecules != null && this.vBiomolecules.size() > 0 && this.asc.ac > 0) {
            this.asc.setCurrentModelInfo("biomolecules", this.vBiomolecules);
            this.setBiomoleculeAtomCounts();
            if (this.thisBiomolecule != null && this.applySymmetry) {
                this.asc.getXSymmetry().applySymmetryBio(this.thisBiomolecule, this.applySymmetryToBonds, this.filter);
                this.vTlsModels = null;
                this.asc.xtalSymmetry = null;
            }
        }
        if (this.vTlsModels != null) {
            int i;
            XtalSymmetry.FileSymmetry symmetry = this.asc.newFileSymmetry();
            int n = this.asc.atomSetCount;
            if (n == this.vTlsModels.size()) {
                i = n;
                while (--i >= 0) {
                    this.setTlsGroups(i, i, symmetry);
                }
            } else {
                Logger.info(n + " models but " + this.vTlsModels.size() + " TLS descriptions");
                if (this.vTlsModels.size() == 1) {
                    Logger.info(" -- assuming all models have the same TLS description -- check REMARK 3 for details.");
                    i = n;
                    while (--i >= 0) {
                        this.setTlsGroups(0, i, symmetry);
                    }
                }
            }
            this.checkForResidualBFactors(symmetry);
        }
        if (this.sbTlsErrors != null) {
            this.asc.setInfo("tlsErrors", this.sbTlsErrors.toString());
            this.appendLoadNote(this.sbTlsErrors.toString());
        }
        this.doCheckUnitCell &= this.iHaveUnitCell && this.doApplySymmetry;
        if (this.doCheckUnitCell && this.isbiomol) {
            this.ignoreFileSpaceGroupName = true;
            this.sgName = this.fileSgName;
            this.fractionalizeCoordinates(true);
            this.asc.setModelInfoForSet("biosymmetry", null, this.asc.iSet);
            this.checkNearAtoms = false;
        }
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            this.addJmolScript("unitcell;axes on;axes unitcell;");
        }
        this.finalizeReaderASCR();
        if (this.vCompnds != null) {
            this.asc.setInfo("compoundSource", this.vCompnds);
            int i = this.asc.iSet + 1;
            while (--i >= 0) {
                this.asc.setModelInfoForSet("compoundSource", this.vCompnds, i);
            }
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.pdbHeader != null) {
            this.asc.setInfo("fileHeader", this.pdbHeader.toString());
        }
        if (this.configurationPtr > 0) {
            Logger.info(this.sbSelected.toString());
            Logger.info(this.sbIgnored.toString());
        }
    }

    private void checkUnitCellParams() {
        if (this.isbiomol && (this.unitCellParams == null || Double.isNaN(this.unitCellParams[0]))) {
            this.setUnitCell(1.0, 1.0, 1.0, 90.0, 90.0, 90.0);
            this.addSpaceGroupName("P1");
        }
        if (this.iHaveUnitCell) {
            this.asc.setCurrentModelInfo("unitCellParams", this.unitCellParams);
            if (this.sgName != null) {
                this.asc.setCurrentModelInfo("spaceGroup", this.sgName);
            }
        }
    }

    private void checkForResidualBFactors(XtalSymmetry.FileSymmetry symmetry) {
        Atom[] atoms = this.asc.atoms;
        boolean isResidual = false;
        int i = this.asc.ac;
        while (--i >= 0) {
            double resid;
            double[] anisou = this.tlsU.get(atoms[i]);
            if (anisou == null || !((resid = anisou[7] - (anisou[0] + anisou[1] + anisou[2]) / 3.0) < 0.0) && !Double.isNaN(resid)) continue;
            isResidual = true;
            break;
        }
        Logger.info("TLS analysis suggests Bfactors are " + (isResidual ? "" : "NOT") + " residuals");
        for (Map.Entry<Atom, double[]> entry : this.tlsU.entrySet()) {
            double[] anisou = entry.getValue();
            double resid = anisou[7];
            if (resid == 0.0) continue;
            if (!isResidual) {
                resid -= (anisou[0] + anisou[1] + anisou[2]) / 3.0;
            }
            anisou[0] = anisou[0] + resid;
            anisou[1] = anisou[1] + resid;
            anisou[2] = anisou[2] + resid;
            entry.getKey().addTensor(symmetry.getTensor(this.vwr, anisou).setType(null), "TLS-R", false);
            Logger.info("TLS-U:  " + Escape.eAD(anisou));
            anisou = entry.getKey().anisoBorU;
            if (anisou == null) continue;
            Logger.info("ANISOU: " + Escape.eAD(anisou));
        }
        this.tlsU = null;
    }

    private void header() {
        if (this.lineLength < 8) {
            return;
        }
        this.appendLoadNote(this.line.substring(7).trim());
        if (this.lineLength == 80) {
            this.maxLength = 72;
        }
        String string = this.pdbID = this.lineLength >= 66 ? this.line.substring(62, 66).trim() : "";
        if (this.pdbID.length() == 4) {
            this.asc.setCollectionName(this.pdbID);
            this.asc.setInfo("havePDBHeaderName", Boolean.TRUE);
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.asc.setInfo("CLASSIFICATION", this.line.substring(7).trim());
    }

    private void title() {
        if (this.lineLength > 10) {
            this.appendLoadNote(this.line.substring(10, Math.min(this.maxLength, this.line.length())).trim());
        }
    }

    private void compnd(boolean isSource) {
        String value;
        if (!isSource) {
            this.compnd = this.compnd == null ? "" : this.compnd + " ";
            String s = this.line;
            if (this.lineLength > 62) {
                s = s.substring(0, 62);
            }
            this.compnd = this.compnd + s.substring(10).trim();
            this.asc.setInfo("COMPND", this.compnd);
        }
        if (this.vCompnds == null) {
            if (isSource) {
                return;
            }
            this.vCompnds = new Lst();
            this.htMolIds = new Hashtable<String, Map<String, String>>();
            this.currentCompnd = new Hashtable<String, String>();
            this.currentCompnd.put("select", "(*)");
            this.currentKey = "MOLECULE";
            this.htMolIds.put("", this.currentCompnd);
        }
        if (isSource && this.resetKey) {
            this.resetKey = false;
            this.currentKey = "SOURCE";
            this.currentCompnd = this.htMolIds.get("");
        }
        this.line = this.line.substring(10, Math.min(this.lineLength, 72)).trim();
        int pt = this.line.indexOf(":");
        if (pt < 0 || pt > 0 && this.line.charAt(pt - 1) == '\\') {
            pt = this.line.length();
        }
        String key = this.line.substring(0, pt).trim();
        String string = value = pt < this.line.length() ? this.line.substring(pt + 1).trim() : null;
        if (key.equals("MOL_ID")) {
            if (value == null) {
                return;
            }
            if (isSource) {
                this.currentCompnd = this.htMolIds.remove(value);
                return;
            }
            this.currentCompnd = new Hashtable<String, String>();
            this.vCompnds.addLast(this.currentCompnd);
            this.htMolIds.put(value, this.currentCompnd);
        }
        if (this.currentCompnd == null) {
            return;
        }
        if (value == null) {
            value = this.currentCompnd.get(this.currentKey);
            if (value == null) {
                value = "";
            }
            value = value + key;
            if (this.vCompnds.size() == 0) {
                this.vCompnds.addLast(this.currentCompnd);
            }
        } else {
            this.currentKey = key;
        }
        if (value.endsWith(";")) {
            value = value.substring(0, value.length() - 1);
        }
        this.currentCompnd.put(this.currentKey, value);
        if (this.currentKey.equals("CHAIN")) {
            this.currentCompnd.put("select", "(:" + PT.rep(PT.rep(value, ", ", ",:"), " ", "") + ")");
        }
    }

    private void setBiomoleculeAtomCounts() {
        int i = this.vBiomolecules.size();
        while (--i >= 0) {
            Map biomolecule = (Map)this.vBiomolecules.get(i);
            Lst biomts = (Lst)biomolecule.get("biomts");
            Lst biomtchains = (Lst)biomolecule.get("chains");
            int nTransforms = biomts.size();
            int nAtoms = 0;
            int k = nTransforms;
            while (--k >= 0) {
                String chains = (String)biomtchains.get(k);
                int j = chains.length() - 1;
                while (--j >= 0) {
                    if (chains.charAt(j) != ':') continue;
                    nAtoms += this.biomtChainAtomCounts['\u0000' + chains.charAt(j + 1)];
                }
            }
            biomolecule.put("atomCount", nAtoms);
        }
    }

    private boolean remark350() throws Exception {
        Lst<M4d> biomts = null;
        Lst<String> biomtchains = null;
        this.vBiomolecules = new Lst();
        this.biomtChainAtomCounts = new int[255];
        String title = "";
        String chainlist = "";
        String id = "";
        boolean needLine = true;
        Hashtable<String, Object> info = null;
        int nBiomt = 0;
        M4d mIdent = M4d.newM4(null);
        while (true) {
            if (needLine) {
                this.readHeader(true);
            } else {
                needLine = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (nBiomt > 0) {
                        Logger.info("biomolecule " + id + ": number of transforms: " + nBiomt);
                    }
                    info = new Hashtable<String, Object>();
                    id = this.line.substring(this.line.indexOf(":") + 1).trim();
                    title = this.line.trim();
                    info.put("name", "biomolecule " + id);
                    info.put("molecule", id.length() == 3 ? id : Integer.valueOf(this.parseIntStr(id)));
                    info.put("title", title);
                    biomtchains = new Lst<String>();
                    info.put("chains", biomtchains);
                    biomts = new Lst<M4d>();
                    info.put("biomts", biomts);
                    this.vBiomolecules.addLast((Map<String, Object>)info);
                    nBiomt = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (info == null) {
                        needLine = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    String list = this.line.substring(41).trim();
                    this.appendLoadNote("found biomolecule " + id + ": " + list);
                    chainlist = ":" + list.replace(',', ';').replace(' ', ':');
                    needLine = false;
                    while (this.readHeader(true) != null && this.line.indexOf("BIOMT") < 0 && this.line.indexOf("350") == 7) {
                        chainlist = chainlist + ":" + this.line.substring(11).trim().replace(',', ';').replace(' ', ':');
                    }
                    chainlist = chainlist + ";";
                    if (!this.checkFilterKey("BIOMOLECULE " + id + ";") && !this.checkFilterKey("BIOMOLECULE=" + id + ";")) continue;
                    this.setFilter(this.filterCased + chainlist);
                    Logger.info("filter set to \"" + this.filter + "\"");
                    this.thisBiomolecule = info;
                    this.haveMappedSerials = this.applySymmetry;
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++nBiomt;
                double[] mat = new double[16];
                int i = 0;
                while (i < 12) {
                    String[] tokens = this.getTokens();
                    mat[i++] = this.parseDoubleStr(tokens[4]);
                    mat[i++] = this.parseDoubleStr(tokens[5]);
                    mat[i++] = this.parseDoubleStr(tokens[6]);
                    mat[i++] = this.parseDoubleStr(tokens[7]);
                    if (i != 4 && i != 8) continue;
                    this.readHeader(true);
                }
                mat[15] = 1.0;
                M4d m4 = new M4d();
                m4.setA(mat);
                if (m4.equals(mIdent)) {
                    biomts.add(0, m4);
                    biomtchains.add(0, chainlist);
                    continue;
                }
                biomts.addLast(m4);
                biomtchains.addLast(chainlist);
            }
            catch (Exception e) {
                this.thisBiomolecule = null;
                this.vBiomolecules = null;
                return false;
            }
        }
        if (nBiomt > 0) {
            Logger.info("biomolecule " + id + ": number of transforms: " + nBiomt);
        }
        return false;
    }

    private boolean remark285() {
        return true;
    }

    private boolean remark290() throws Exception {
        while (this.readHeader(true) != null && this.line.startsWith("REMARK 290")) {
            String[] tokens;
            if (this.line.indexOf("NNNMMM   OPERATOR") < 0) continue;
            while (this.readHeader(true) != null && (tokens = this.getTokens()).length >= 4) {
                if (!this.doApplySymmetry && !this.isbiomol) continue;
                this.setSymmetryOperator(tokens[3]);
            }
        }
        return false;
    }

    private int getSerial(int i, int j) {
        char c = this.line.charAt(i);
        boolean isBase10 = c == ' ' || this.line.charAt(j - 1) == ' ';
        switch (this.serMode) {
            default: {
                if (isBase10) {
                    return this.parseIntRange(this.line, i, j);
                }
                try {
                    this.serial = Integer.parseInt(this.line.substring(i, j));
                    return this.serial;
                }
                catch (Exception e) {
                    this.serMode = PT.isDigit(c) ? 1 : 2;
                    return this.getSerial(i, j);
                }
            }
            case 2: {
                return isBase10 || PT.isDigit(c) ? this.parseIntRange(this.line, i, j) : PT.parseIntRadix(this.line.substring(i, j), 36) + (PT.isUpperCase(c) ? -16696160 : 26973856);
            }
            case 1: 
        }
        if (!isBase10) {
            this.serial = PT.parseIntRadix(this.line.substring(i, j), 16);
            return this.serial;
        }
        this.serMode = 0;
        return this.getSerial(i, j);
    }

    private int getSeqNo(int i, int j) {
        char c = this.line.charAt(i);
        boolean isBase10 = c == ' ' || this.line.charAt(j - 1) == ' ';
        switch (this.seqMode) {
            default: {
                if (isBase10) {
                    return this.parseIntRange(this.line, i, j);
                }
                try {
                    return Integer.parseInt(this.line.substring(i, j));
                }
                catch (Exception e) {
                    this.seqMode = PT.isDigit(c) ? 1 : 2;
                    return this.getSeqNo(i, j);
                }
            }
            case 2: {
                return isBase10 || PT.isDigit(c) ? this.parseIntRange(this.line, i, j) : PT.parseIntRadix(this.line.substring(i, j), 36) + (PT.isUpperCase(c) ? -456560 : 756496);
            }
            case 1: 
        }
        if (!isBase10) {
            return PT.parseIntRadix(this.line.substring(i, j), 16);
        }
        this.seqMode = 0;
        return this.getSeqNo(i, j);
    }

    protected Atom processAtom(Atom atom, String name, char altID, String group3, int chainID, int seqNo, char insCode, boolean isHetero, String sym) {
        atom.atomName = name;
        if (altID != ' ') {
            atom.altLoc = altID;
        }
        atom.group3 = group3 == null ? "UNK" : group3;
        atom.chainID = chainID;
        if (this.biomtChainAtomCounts != null) {
            int n = chainID % 256;
            this.biomtChainAtomCounts[n] = this.biomtChainAtomCounts[n] + 1;
        }
        atom.sequenceNumber = seqNo;
        atom.insertionCode = JmolAdapter.canonizeInsertionCode(insCode);
        atom.isHetero = isHetero;
        atom.elementSymbol = sym;
        return atom;
    }

    protected void processAtom2(Atom atom, int serial, double x, double y, double z, int charge) {
        atom.atomSerial = serial;
        if (serial > this.maxSerial) {
            this.maxSerial = serial;
        }
        if (atom.group3 == null) {
            if (this.currentGroup3 != null) {
                this.currentGroup3 = null;
                this.currentResno = Integer.MIN_VALUE;
                this.htElementsInCurrentGroup = null;
            }
        } else if (!atom.group3.equals(this.currentGroup3) || atom.sequenceNumber != this.currentResno) {
            this.currentGroup3 = atom.group3;
            this.currentResno = atom.sequenceNumber;
            this.htElementsInCurrentGroup = this.htFormul.get(atom.group3);
            ++this.nRes;
            if (atom.group3.equals("UNK")) {
                ++this.nUNK;
            }
        }
        this.setAtomCoordXYZ(atom, x, y, z);
        atom.formalCharge = charge;
        this.setAdditionalAtomParameters(atom);
        if (this.haveMappedSerials) {
            this.asc.addAtomWithMappedSerialNumber(atom);
        } else {
            this.asc.addAtom(atom);
        }
        if (this.ac++ == 0 && !this.isCourseGrained) {
            this.setModelPDB(true);
        }
        if (atom.isHetero && this.htHetero != null) {
            this.asc.setCurrentModelInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    private void atom() {
        double z;
        double y;
        double x;
        String s;
        boolean isHetero = this.line.startsWith("HETATM");
        Atom atom = this.processAtom(new Atom(), this.line.substring(12, 16).trim(), this.line.charAt(16), this.parseTokenRange(this.line, 17, 20), this.vwr.getChainID(this.line.substring(21, 22), true), this.getSeqNo(22, 26), this.line.charAt(26), isHetero, this.deduceElementSymbol(isHetero));
        if (this.atomTypeLen > 0 && (s = this.line.substring(this.atomTypePt0, this.atomTypePt0 + this.atomTypeLen).trim()).length() > 0) {
            atom.atomName = atom.atomName + "\u0000" + s;
        }
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return;
        }
        int charge = 0;
        if (this.gromacsWideFormat) {
            x = this.parseDoubleRange(this.line, 30, 40);
            y = this.parseDoubleRange(this.line, 40, 50);
            z = this.parseDoubleRange(this.line, 50, 60);
        } else {
            if (this.lineLength >= 80) {
                char chMagnitude = this.line.charAt(78);
                char chSign = this.line.charAt(79);
                if (chSign >= '0' && chSign <= '7') {
                    char chT = chSign;
                    chSign = chMagnitude;
                    chMagnitude = chT;
                }
                if ((chSign == '+' || chSign == '-' || chSign == ' ') && chMagnitude >= '0' && chMagnitude <= '7') {
                    charge = chMagnitude - 48;
                    if (chSign == '-') {
                        charge = -charge;
                    }
                }
            }
            x = this.parseDoubleRange(this.line, 30, 38);
            y = this.parseDoubleRange(this.line, 38, 46);
            z = this.parseDoubleRange(this.line, 46, 54);
        }
        this.processAtom2(atom, this.serial, x, y, z, charge);
    }

    protected boolean filterPDBAtom(Atom atom, int iAtom) {
        if (!this.filterAtom(atom, iAtom)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (atom.sequenceNumber != this.lastGroup || atom.insertionCode != this.lastInsertion) {
                this.conformationIndex = this.configurationPtr - 1;
                this.lastGroup = atom.sequenceNumber;
                this.lastInsertion = atom.insertionCode;
                this.lastAltLoc = '\u0000';
            }
            if (atom.altLoc != '\u0000') {
                String msg = " atom [" + atom.group3 + "]" + atom.sequenceNumber + (atom.insertionCode == '\u0000' ? "" : "^" + atom.insertionCode) + (atom.chainID == 0 ? "" : ":" + this.vwr.getChainIDStr(atom.chainID)) + "." + atom.atomName + "%" + atom.altLoc + "\n";
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex < 0 && atom.altLoc != this.lastAltLoc) {
                    this.sbIgnored.append("ignoring").append(msg);
                    return false;
                }
                this.sbSelected.append("loading").append(msg);
            }
        }
        return true;
    }

    protected void setAdditionalAtomParameters(Atom atom) {
        double floatOccupancy;
        if (this.gromacsWideFormat) {
            floatOccupancy = this.parseDoubleRange(this.line, 60, 68);
            atom.bfactor = PdbReader.fixRadius(this.parseDoubleRange(this.line, 68, 76));
        } else {
            floatOccupancy = this.parseDoubleRange(this.line, 54, 60);
            atom.bfactor = this.parseDoubleRange(this.line, 60, 66);
        }
        atom.foccupancy = Double.isNaN(floatOccupancy) ? 1.0 : floatOccupancy;
    }

    protected String deduceElementSymbol(boolean isHetero) {
        if (this.lineLength >= 78) {
            char ch76 = this.line.charAt(76);
            char ch77 = this.line.charAt(77);
            if (ch76 == ' ' && Atom.isValidSym1(ch77)) {
                return "" + ch77;
            }
            if (Atom.isValidSymNoCase(ch76, ch77)) {
                return "" + ch76 + ch77;
            }
        }
        char ch12 = this.line.charAt(12);
        char ch13 = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidSymNoCase(ch12, ch13)) {
            return isHetero || ch12 != 'H' ? "" + ch12 + ch13 : "H";
        }
        if (ch12 == 'H') {
            return "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch13) != null) && Atom.isValidSym1(ch13)) {
            return "" + ch13;
        }
        if (ch12 != ' ' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch12) != null) && Atom.isValidSym1(ch12)) {
            return "" + ch12;
        }
        char ch14 = this.line.charAt(14);
        if (ch12 == ' ' && ch13 != 'X' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(13, 15)) != null) && Atom.isValidSymNoCase(ch13, ch14)) {
            return "" + ch13 + ch14;
        }
        return "Xx";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void conect() {
        if (this.sbConect == null) {
            this.sbConect = new SB();
            this.sb = new SB();
        } else {
            this.sb.setLength(0);
        }
        int sourceSerial = this.getSerial(6, 11);
        if (sourceSerial < 0) {
            return;
        }
        int order = 1;
        int pt1 = this.line.trim().length();
        if (pt1 > 56) {
            pt1 = this.line.substring(0, 56).trim().length();
        }
        int pt = 11;
        while (true) {
            block16: {
                String st;
                int i1;
                int targetSerial;
                block17: {
                    boolean isSwapped;
                    boolean isDoubleBond;
                    if (pt >= pt1) {
                        this.sbConect.appendSB(this.sb);
                        return;
                    }
                    switch (pt) {
                        case 31: {
                            order = 2048;
                            break;
                        }
                        case 41: {
                            break block16;
                        }
                    }
                    targetSerial = this.getSerial(pt, pt + 5);
                    if (targetSerial < 0) break block16;
                    boolean bl = isDoubleBond = sourceSerial == this.lastSourceSerial && targetSerial == this.lastTargetSerial;
                    if (isDoubleBond) {
                        this.haveDoubleBonds = true;
                    }
                    this.lastSourceSerial = sourceSerial;
                    this.lastTargetSerial = targetSerial;
                    boolean bl2 = isSwapped = targetSerial < sourceSerial;
                    if (isSwapped) {
                        i1 = targetSerial;
                        targetSerial = sourceSerial;
                    } else {
                        i1 = sourceSerial;
                    }
                    st = ";" + i1 + " " + targetSerial + ";";
                    if (this.sbConect.indexOf(st) >= 0 && !isDoubleBond) break block16;
                    if (!this.haveDoubleBonds) break block17;
                    String st1 = "--" + st;
                    if (this.sbConect.indexOf(st1) >= 0) break block16;
                    this.sb.append(st1);
                }
                this.sbConect.append(st);
                this.addConnection(new int[]{i1, targetSerial, order});
            }
            pt += 5;
        }
    }

    private void structure() {
        int endIndex;
        int endChainIDIndex;
        int startIndex;
        int startChainIDIndex;
        STR structureType = STR.NONE;
        STR substructureType = STR.NONE;
        int strandCount = 0;
        if (this.line.startsWith("HELIX ")) {
            structureType = STR.HELIX;
            startChainIDIndex = 19;
            startIndex = 21;
            endChainIDIndex = 31;
            endIndex = 33;
            if (this.line.length() >= 40) {
                substructureType = Structure.getHelixType(this.parseIntRange(this.line, 38, 40));
            }
        } else if (this.line.startsWith("SHEET ")) {
            structureType = STR.SHEET;
            startChainIDIndex = 21;
            startIndex = 22;
            endChainIDIndex = 32;
            endIndex = 33;
            strandCount = this.parseIntRange(this.line, 14, 16);
        } else if (this.line.startsWith("TURN  ")) {
            structureType = STR.TURN;
            startChainIDIndex = 19;
            startIndex = 20;
            endChainIDIndex = 30;
            endIndex = 31;
        } else {
            return;
        }
        if (this.lineLength < endIndex + 4) {
            return;
        }
        String structureID = this.line.substring(11, 15).trim();
        String strandID = this.line.substring(7, 10).trim();
        int startChainID = this.vwr.getChainID(this.line.substring(startChainIDIndex, startChainIDIndex + 1), true);
        int startSequenceNumber = this.parseIntRange(this.line, startIndex, startIndex + 4);
        char startInsertionCode = this.line.charAt(startIndex + 4);
        int endChainID = this.vwr.getChainID(this.line.substring(endChainIDIndex, endChainIDIndex + 1), true);
        int endSequenceNumber = this.parseIntRange(this.line, endIndex, endIndex + 4);
        char endInsertionCode = ' ';
        if (this.lineLength > endIndex + 4) {
            endInsertionCode = this.line.charAt(endIndex + 4);
        }
        if (substructureType == STR.NONE) {
            substructureType = structureType;
        }
        Structure structure = new Structure(-1, structureType, substructureType, structureID, strandID, strandCount, null);
        structure.set(startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode, 0, 0);
        this.asc.addStructure(structure);
    }

    private int getModelNumber() {
        int iModel;
        int startModelColumn = 6;
        int endModelColumn = 14;
        if (endModelColumn > this.lineLength) {
            endModelColumn = this.lineLength;
        }
        return (iModel = this.parseIntRange(this.line, startModelColumn, endModelColumn)) == Integer.MIN_VALUE ? 0 : iModel;
    }

    private String getModelName() {
        if (this.lineLength < 16) {
            return null;
        }
        if (this.line.startsWith("ATOM")) {
            return "";
        }
        String name = this.line.substring(15, this.lineLength).trim();
        return name.length() == 0 ? null : name;
    }

    protected void model(int modelNumber, String name) {
        this.checkNotPDB();
        if (name == null) {
            name = this.pdbID;
        }
        this.haveMappedSerials = this.thisBiomolecule != null && this.applySymmetry;
        this.sbConect = null;
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("pdbID", this.pdbID);
        if (this.asc.iSet == 0 || this.isTrajectory) {
            this.asc.setAtomSetName(this.pdbID);
        }
        this.asc.setCurrentModelInfo("name", name);
        this.checkUnitCellParams();
        if (!this.isCourseGrained) {
            this.setModelPDB(true);
        }
        this.asc.setCurrentAtomSetNumber(modelNumber);
        if (this.isCourseGrained) {
            this.asc.setCurrentModelInfo("courseGrained", Boolean.TRUE);
        }
    }

    private void checkNotPDB() {
        boolean isPDB = !this.isCourseGrained && (this.nRes == 0 || this.nUNK != this.nRes);
        this.checkNearAtoms = !isPDB;
        this.setModelPDB(isPDB);
        this.nRes = 0;
        this.nUNK = 0;
        this.currentGroup3 = null;
    }

    private void cryst1() throws Exception {
        this.cryst1 = this.getFloat(6, 9);
        double a = this.cryst1;
        if (a == 1.0) {
            a = Double.NaN;
        }
        this.setUnitCell(a, this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        this.addSpaceGroupName(PT.parseTrimmedRange(this.line, 55, 66));
    }

    private void addSpaceGroupName(String name) {
        if (this.isbiomol) {
            this.doConvertToFractional = false;
        }
        if (this.sgName == null || this.sgName.equals("unspecified!")) {
            this.setSpaceGroupName(name);
        }
        this.fileSgName = this.sgName;
    }

    private double getFloat(int ich, int cch) throws Exception {
        return this.parseDoubleRange(this.line, ich, ich + cch);
    }

    private void scale(int n) throws Exception {
        if (this.unitCellParams == null) {
            return;
        }
        int pt = n * 4 + 2;
        this.unitCellParams[0] = this.cryst1;
        this.setUnitCellItem(pt++, this.getFloat(10, 10));
        this.setUnitCellItem(pt++, this.getFloat(20, 10));
        this.setUnitCellItem(pt++, this.getFloat(30, 10));
        this.setUnitCellItem(pt++, this.getFloat(45, 10));
        if (this.isbiomol) {
            this.doConvertToFractional = false;
        }
    }

    private void expdta() {
        if (this.line.toUpperCase().indexOf("NMR") >= 0) {
            this.asc.setInfo("isNMRdata", "true");
        }
    }

    private void formul() {
        String elementWithCount;
        Map<String, Boolean> htElementsInGroup;
        String groupName = this.parseTokenRange(this.line, 12, 15);
        String formula = PT.parseTrimmedRange(this.line, 19, 70);
        int ichLeftParen = formula.indexOf(40);
        if (ichLeftParen >= 0) {
            int ichRightParen = formula.indexOf(41);
            if (ichRightParen < 0 || ichLeftParen >= ichRightParen || ichLeftParen + 1 == ichRightParen) {
                return;
            }
            formula = PT.parseTrimmedRange(formula, ichLeftParen + 1, ichRightParen);
        }
        if ((htElementsInGroup = this.htFormul.get(groupName)) == null) {
            htElementsInGroup = new Hashtable<String, Boolean>();
            this.htFormul.put(groupName, htElementsInGroup);
        }
        this.next[0] = 0;
        while ((elementWithCount = this.parseTokenNext(formula)) != null) {
            char chSecond;
            if (elementWithCount.length() < 2) continue;
            char chFirst = elementWithCount.charAt(0);
            if (Atom.isValidSymNoCase(chFirst, chSecond = elementWithCount.charAt(1))) {
                htElementsInGroup.put("" + chFirst + chSecond, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidSym1(chFirst)) continue;
            htElementsInGroup.put("" + chFirst, Boolean.TRUE);
        }
    }

    private void het() {
        String groupName;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (this.htHetero.containsKey(groupName = this.parseTokenRange(this.line, 7, 10))) {
            return;
        }
        String hetName = PT.parseTrimmedRange(this.line, 30, 70);
        this.htHetero.put(groupName, hetName);
    }

    private void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        String groupName = this.parseTokenRange(this.line, 11, 14);
        String hetName = PT.parseTrimmedRange(this.line, 15, 70);
        if (groupName == null) {
            Logger.error("ERROR: HETNAM record does not contain a group name: " + this.line);
            return;
        }
        String htName = this.htHetero.get(groupName);
        if (htName != null) {
            hetName = htName + hetName;
        }
        this.htHetero.put(groupName, hetName);
        this.appendLoadNote(groupName + " = " + hetName);
    }

    private void anisou() {
        Atom atom;
        double[] data = new double[8];
        data[6] = 1.0;
        String serial = this.line.substring(6, 11).trim();
        if (!this.haveMappedSerials && this.asc.ac > 0) {
            for (int i = this.asc.getAtomSetAtomIndex(this.asc.iSet); i < this.asc.ac; ++i) {
                int atomSerial = this.asc.atoms[i].atomSerial;
                if (atomSerial == Integer.MIN_VALUE) continue;
                this.asc.atomSymbolicMap.put("" + atomSerial, this.asc.atoms[i]);
            }
            this.haveMappedSerials = true;
        }
        if ((atom = this.asc.getAtomFromName(serial)) == null) {
            return;
        }
        int i = 28;
        int pt = 0;
        while (i < 70) {
            data[pt] = this.parseDoubleRange(this.line, i, i + 7);
            i += 7;
            ++pt;
        }
        i = 0;
        while (i < 6) {
            if (Double.isNaN(data[i])) {
                Logger.error("Bad ANISOU record: " + this.line);
                return;
            }
            int n = i++;
            data[n] = data[n] / 10000.0;
        }
        this.asc.setAnisoBorU(atom, data, 12);
    }

    private void site() {
        int pt;
        String resName;
        if (this.htSites == null) {
            this.htSites = new Hashtable<String, Map<String, Object>>();
        }
        int nResidues = this.parseIntRange(this.line, 15, 17);
        String siteID = PT.parseTrimmedRange(this.line, 11, 14);
        Map<String, Object> htSite = this.htSites.get(siteID);
        if (htSite == null) {
            htSite = new Hashtable<String, Object>();
            htSite.put("nResidues", nResidues);
            htSite.put("groups", "");
            this.htSites.put(siteID, htSite);
        }
        String groups = (String)htSite.get("groups");
        for (int i = 0; i < 4 && (resName = PT.parseTrimmedRange(this.line, pt = 18 + i * 11, pt + 3)).length() != 0; ++i) {
            String chainID = PT.parseTrimmedRange(this.line, pt + 4, pt + 5);
            String seq = PT.parseTrimmedRange(this.line, pt + 5, pt + 9);
            String iCode = PT.parseTrimmedRange(this.line, pt + 9, pt + 10);
            groups = groups + (groups.length() == 0 ? "" : ",") + "[" + resName + "]" + seq;
            if (iCode.length() > 0) {
                groups = groups + "^" + iCode;
            }
            if (chainID.length() > 0) {
                groups = groups + ":" + chainID;
            }
            htSite.put("groups", groups);
        }
    }

    private boolean remarkTls() throws Exception {
        int nGroups = 0;
        int iGroup = 0;
        String components = null;
        Lst<Hashtable<String, Object>> tlsGroups = null;
        Hashtable<String, Object> tlsGroup = null;
        Lst ranges = null;
        Hashtable<String, Object> range = null;
        String remark = this.line.substring(0, 11);
        while (this.readHeader(true) != null && this.line.startsWith(remark)) {
            try {
                int i;
                String[] tokens = PT.getTokens(this.line.substring(10).replace(':', ' '));
                if (tokens.length < 2) continue;
                Logger.info(this.line);
                if (tokens[1].equalsIgnoreCase("GROUP")) {
                    tlsGroup = new Hashtable<String, Object>();
                    ranges = new Lst();
                    tlsGroup.put("ranges", ranges);
                    tlsGroups.addLast(tlsGroup);
                    this.tlsGroupID = this.parseIntStr(tokens[tokens.length - 1]);
                    tlsGroup.put("id", this.tlsGroupID);
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("NUMBER")) {
                    if (tokens[2].equalsIgnoreCase("COMPONENTS")) continue;
                    nGroups = this.parseIntStr(tokens[tokens.length - 1]);
                    if (nGroups < 1) break;
                    if (this.vTlsModels == null) {
                        this.vTlsModels = new Lst();
                    }
                    tlsGroups = new Lst<Hashtable<String, Object>>();
                    this.appendLoadNote(this.line.substring(11).trim());
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("COMPONENTS")) {
                    components = this.line;
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("RESIDUE")) {
                    int res2;
                    int res1;
                    char chain2;
                    char chain1;
                    range = new Hashtable<String, Object>();
                    if (tokens.length == 6) {
                        chain1 = tokens[2].charAt(0);
                        chain2 = tokens[4].charAt(0);
                        res1 = this.parseIntStr(tokens[3]);
                        res2 = this.parseIntStr(tokens[5]);
                    } else {
                        int toC = components.indexOf(" C ");
                        int fromC = components.indexOf(" C ", toC + 4);
                        chain1 = this.line.charAt(fromC);
                        chain2 = this.line.charAt(toC);
                        res1 = this.parseIntRange(this.line, fromC + 1, toC);
                        res2 = this.parseIntStr(this.line.substring(toC + 1));
                    }
                    if (chain1 == chain2) {
                        range.put("chains", "" + chain1 + chain2);
                        if (res1 <= res2) {
                            range.put("residues", new int[]{res1, res2});
                            ranges.addLast(range);
                            continue;
                        }
                        this.tlsAddError(" TLS group residues are not in order (range ignored)");
                        continue;
                    }
                    this.tlsAddError(" TLS group chains are different (range ignored)");
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("SELECTION")) {
                    char chain = '\u0000';
                    for (int i2 = 1; i2 < tokens.length; ++i2) {
                        if (tokens[i2].toUpperCase().indexOf("CHAIN") >= 0) {
                            chain = tokens[++i2].charAt(0);
                            continue;
                        }
                        int resno = this.parseIntStr(tokens[i2]);
                        if (resno == Integer.MIN_VALUE) continue;
                        range = new Hashtable();
                        range.put("residues", new int[]{resno, this.parseIntStr(tokens[++i2])});
                        if (chain != '\u0000') {
                            range.put("chains", "" + chain + chain);
                        }
                        ranges.addLast(range);
                    }
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("ORIGIN")) {
                    P3d origin = new P3d();
                    tlsGroup.put("origin", origin);
                    if (tokens.length == 8) {
                        origin.set(this.parseDoubleStr(tokens[5]), this.parseDoubleStr(tokens[6]), this.parseDoubleStr(tokens[7]));
                    } else {
                        int n = this.line.length();
                        origin.set(this.parseDoubleRange(this.line, n - 27, n - 18), this.parseDoubleRange(this.line, n - 18, n - 9), this.parseDoubleRange(this.line, n - 9, n));
                    }
                    if (!Double.isNaN(origin.x) && !Double.isNaN(origin.y) && !Double.isNaN(origin.z)) continue;
                    origin.set(Double.NaN, Double.NaN, Double.NaN);
                    this.tlsAddError("invalid origin: " + this.line);
                    continue;
                }
                if (!tokens[1].equalsIgnoreCase("TENSOR")) continue;
                char tensorType = tokens[0].charAt(0);
                String s = (this.readHeader(true).substring(10) + this.readHeader(true).substring(10) + this.readHeader(true).substring(10)).replace(tensorType, ' ').replace(':', ' ');
                tokens = PT.getTokens(s);
                double[][] data = new double[3][3];
                tlsGroup.put("t" + tensorType, data);
                for (i = 0; i < tokens.length; ++i) {
                    int ti = tokens[i].charAt(0) - 49;
                    int tj = tokens[i].charAt(1) - 49;
                    data[ti][tj] = this.parseDoubleStr(tokens[++i]);
                    if (ti >= tj) continue;
                    data[tj][ti] = data[ti][tj];
                }
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (!Double.isNaN(data[i][j])) continue;
                        this.tlsAddError("invalid tensor: " + Escape.escapeDoubleAA(data, false));
                    }
                }
                if (tensorType != 'S' || ++iGroup != nGroups) continue;
                Logger.info(nGroups + " TLS groups read");
                this.readHeader(true);
                break;
            }
            catch (Exception e) {
                Logger.error(this.line + "\nError in TLS parser: ");
                System.out.println(e.getMessage());
                tlsGroups = null;
                break;
            }
        }
        if (tlsGroups != null) {
            Hashtable<String, Serializable> tlsModel = new Hashtable<String, Serializable>();
            tlsModel.put("groupCount", Integer.valueOf(nGroups));
            tlsModel.put("groups", tlsGroups);
            this.vTlsModels.addLast((Map<String, Object>)tlsModel);
        }
        return nGroups < 1;
    }

    private void handleTlsMissingModels() {
        this.vTlsModels = null;
    }

    private void setTlsGroups(int iGroup, int iModel, XtalSymmetry.FileSymmetry symmetry) {
        Logger.info("TLS model " + (iModel + 1) + " set " + (iGroup + 1));
        Map tlsGroupInfo = (Map)this.vTlsModels.get(iGroup);
        Lst groups = (Lst)tlsGroupInfo.get("groups");
        int index0 = this.asc.getAtomSetAtomIndex(iModel);
        double[] data = new double[this.asc.getAtomSetAtomCount(iModel)];
        int indexMax = index0 + data.length;
        Atom[] atoms = this.asc.atoms;
        int nGroups = groups.size();
        for (int i = 0; i < nGroups; ++i) {
            Map group = (Map)groups.get(i);
            Lst ranges = (Lst)group.get("ranges");
            this.tlsGroupID = (Integer)group.get("id");
            int j = ranges.size();
            while (--j >= 0) {
                int index2;
                String chains = (String)((Map)ranges.get(j)).get("chains");
                int[] residues = (int[])((Map)ranges.get(j)).get("residues");
                int chain0 = '\u0000' + chains.charAt(0);
                int chain1 = '\u0000' + chains.charAt(1);
                int res0 = residues[0];
                int res1 = residues[1];
                int index1 = this.findAtomForRange(index0, indexMax, chain0, res0, false);
                int n = index2 = index1 >= 0 ? this.findAtomForRange(index1, indexMax, chain1, res1, false) : -1;
                if (index2 < 0) {
                    Logger.info("TLS processing terminated");
                    return;
                }
                Logger.info("TLS ID=" + this.tlsGroupID + " model atom index range " + index1 + "-" + index2);
                boolean isSameChain = chain0 == chain1;
                for (int iAtom = index0; iAtom < indexMax; ++iAtom) {
                    Atom atom = atoms[iAtom];
                    if (!(isSameChain ? atom.sequenceNumber >= res0 && atom.sequenceNumber <= res1 : atom.chainID > chain0 && atom.chainID < chain1 || atom.chainID == chain0 && atom.sequenceNumber >= res0 || atom.chainID == chain1 && atom.sequenceNumber <= res1)) continue;
                    data[iAtom - index0] = this.tlsGroupID;
                    this.setTlsTensor(atom, group, symmetry);
                }
            }
        }
        this.asc.setAtomProperties("tlsGroup", data, iModel, true);
        this.asc.setModelInfoForSet("TLS", tlsGroupInfo, iModel);
        this.asc.setTensors();
    }

    private int findAtomForRange(int atom1, int atom2, int chain, int resno, boolean isLast) {
        int iAtom = this.findAtom(atom1, atom2, chain, resno, true);
        return isLast && iAtom >= 0 ? this.findAtom(iAtom, atom2, chain, resno, false) : iAtom;
    }

    private int findAtom(int atom1, int atom2, int chain, int resno, boolean isTrue) {
        Atom[] atoms = this.asc.atoms;
        for (int i = atom1; i < atom2; ++i) {
            Atom atom = atoms[i];
            if ((atom.chainID == chain && atom.sequenceNumber == resno) != isTrue) continue;
            return i;
        }
        if (isTrue) {
            Logger.warn("PdbReader findAtom chain=" + chain + " resno=" + resno + " not found");
            this.tlsAddError("atom not found: chain=" + chain + " resno=" + resno);
        }
        return isTrue ? -1 : atom2;
    }

    private void setTlsTensor(Atom atom, Map<String, Object> group, XtalSymmetry.FileSymmetry symmetry) {
        P3d origin = (P3d)group.get("origin");
        if (Double.isNaN(origin.x)) {
            return;
        }
        double[][] T2 = (double[][])group.get("tT");
        double[][] L = (double[][])group.get("tL");
        double[][] S = (double[][])group.get("tS");
        if (T2 == null || L == null || S == null) {
            return;
        }
        double x = (atom.x - origin.x) * (Math.PI / 180);
        double y = (atom.y - origin.y) * (Math.PI / 180);
        double z = (atom.z - origin.z) * (Math.PI / 180);
        double xx = x * x;
        double yy = y * y;
        double zz = z * z;
        double xy = x * y;
        double xz = x * z;
        double yz = y * z;
        this.dataT[0] = T2[0][0];
        this.dataT[1] = T2[1][1];
        this.dataT[2] = T2[2][2];
        this.dataT[3] = T2[0][1];
        this.dataT[4] = T2[0][2];
        this.dataT[5] = T2[1][2];
        this.dataT[6] = 12.0;
        double[] anisou = new double[8];
        double bresidual = Double.isNaN(atom.bfactor) ? 0.0 : atom.bfactor / 78.95683520871486;
        anisou[0] = this.dataT[0] + L[1][1] * zz + L[2][2] * yy - 2.0 * L[1][2] * yz + 2.0 * S[1][0] * z - 2.0 * S[2][0] * y;
        anisou[1] = this.dataT[1] + L[0][0] * zz + L[2][2] * xx - 2.0 * L[2][0] * xz - 2.0 * S[0][1] * z + 2.0 * S[2][1] * x;
        anisou[2] = this.dataT[2] + L[0][0] * yy + L[1][1] * xx - 2.0 * L[0][1] * xy - 2.0 * S[1][2] * x + 2.0 * S[0][2] * y;
        anisou[3] = this.dataT[3] - L[2][2] * xy + L[1][2] * xz + L[2][0] * yz - L[0][1] * zz - S[0][0] * z + S[1][1] * z + S[2][0] * x - S[2][1] * y;
        anisou[4] = this.dataT[4] - L[1][1] * xz + L[1][2] * xy - L[2][0] * yy + L[0][1] * yz + S[0][0] * y - S[2][2] * y + S[1][2] * z - S[1][0] * x;
        anisou[5] = this.dataT[5] - L[0][0] * yz - L[1][2] * xx + L[2][0] * xy + L[0][1] * xz - S[1][1] * x + S[2][2] * x + S[0][1] * y - S[0][2] * z;
        anisou[6] = 12.0;
        anisou[7] = bresidual;
        if (this.tlsU == null) {
            this.tlsU = new Hashtable<Atom, double[]>();
        }
        this.tlsU.put(atom, anisou);
        atom.addTensor(symmetry.getTensor(this.vwr, this.dataT).setType(null), "TLS-U", false);
    }

    private void tlsAddError(String error) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new SB();
        }
        this.sbTlsErrors.append(this.fileName).appendC('\t').append("TLS group ").appendI(this.tlsGroupID).appendC('\t').append(error).appendC('\n');
    }

    protected static double fixRadius(double r) {
        return r < 0.9 ? 1.0 : r;
    }

    private void addConnection(int[] is) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new Lst();
        }
        if (this.connectLast != null && is[0] == this.connectLast[0] && is[1] == this.connectLast[1] && is[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = is;
        this.vConnect.addLast(is);
    }

    private void connectAllBad(int maxSerial) {
        int firstAtom = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.asc.atomSetCount; ++i) {
            int count = this.asc.getAtomSetAtomCount(i);
            this.asc.setModelInfoForSet("PDB_CONECT_firstAtom_count_max", new int[]{firstAtom, count, maxSerial}, i);
            if (this.vConnect != null) {
                this.asc.setModelInfoForSet("PDB_CONECT_bonds", this.vConnect, i);
                this.asc.setGlobalBoolean(3);
            }
            firstAtom += count;
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.asc.iSet + 1;
        this.connectNextAtomIndex = firstAtom;
    }

    private void connectAll(int maxSerial, boolean isConnectStateBug) {
        AtomSetCollection a = this.asc;
        int index = a.iSet;
        if (index < 0) {
            return;
        }
        if (isConnectStateBug) {
            this.connectAllBad(maxSerial);
            return;
        }
        a.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{a.getAtomSetAtomIndex(index), a.getAtomSetAtomCount(index), maxSerial});
        if (this.vConnect == null) {
            return;
        }
        int firstAtom = this.connectNextAtomIndex;
        int i = a.atomSetCount;
        while (--i >= this.connectNextAtomSet) {
            a.setModelInfoForSet("PDB_CONECT_bonds", this.vConnect, i);
            a.setGlobalBoolean(3);
            firstAtom += a.getAtomSetAtomCount(i);
        }
        this.vConnect = null;
        this.connectNextAtomSet = index + 1;
        this.connectNextAtomIndex = firstAtom;
    }
}

