/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Map;
import javajs.util.P3d;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MdCrdReader
extends AtomSetCollectionReader {
    private int ptFloat = 0;
    private int lenLine = 0;

    @Override
    protected void setup(String fullPath, Map<String, Object> htParams, Object readerOrDocument) {
        this.requiresBSFilter = true;
        this.setupASCR(fullPath, htParams, readerOrDocument);
    }

    @Override
    protected void initializeReader() {
        this.initializeTrajectoryFile();
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.readCoordinates();
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
        this.continuing = false;
        return false;
    }

    private void readCoordinates() throws Exception {
        this.line = null;
        int ac = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean isPeriodic = this.htParams.containsKey("isPeriodic");
        int floatCount = this.templateAtomCount * 3 + (isPeriodic ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3d[] trajectoryStep = new P3d[ac];
                if (!this.getTrajectoryStep(trajectoryStep, isPeriodic)) {
                    return;
                }
                this.trajectorySteps.addLast(trajectoryStep);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(floatCount)) break;
        }
    }

    private double getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.rd() == null) {
                return Double.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseDoubleRange(this.line, this.ptFloat - 8, this.ptFloat);
    }

    private P3d getPoint() throws Exception {
        double x = this.getFloat();
        double y = this.getFloat();
        double z = this.getFloat();
        return Double.isNaN(z) ? null : P3d.new3(x, y, z);
    }

    private boolean getTrajectoryStep(P3d[] trajectoryStep, boolean isPeriodic) throws Exception {
        int ac = trajectoryStep.length;
        int n = -1;
        for (int i = 0; i < this.templateAtomCount; ++i) {
            P3d p = this.getPoint();
            if (p == null) {
                return false;
            }
            if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
            if (++n == ac) {
                return false;
            }
            trajectoryStep[n] = p;
        }
        if (isPeriodic) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        for (int i = 0; i < n && this.rd() != null; i += this.getTokens().length) {
        }
        return this.line != null;
    }
}

