/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.iupac.fairdata.api.IFDObjectI;
import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDAttribute;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDProperty;
import org.iupac.fairdata.core.IFDReference;

public abstract class IFDObject<T>
extends ArrayList<T>
implements IFDObjectI<T>,
IFDSerializableI {
    protected static int indexCount;
    protected int index;
    protected boolean isValid = true;
    protected boolean hasProperty = false;
    protected IFDCollection<?> parentCollection;
    protected String label;
    protected String id;
    private String timestamp;
    protected String description;
    protected String doi;
    protected String url;
    protected String note;
    private String sortKey;
    protected Map<String, IFDProperty> htProps = new PropertyMap();
    protected List<IFDAttribute> attributes = new ArrayList<IFDAttribute>();
    private int maxCount;
    private int minCount;
    protected String type;
    private boolean doSerializeType = true;
    private String myPropertyPrefix;
    protected IFDReference reference;
    private static Map<String, String> htExtendedTypes;

    public String getObjectFlag() {
        return this.getIFDPropertyPrefix().substring(IFDConst.propertyPrefixLength - 1);
    }

    public void setParentCollection(IFDCollection<? extends IFDObject<?>> c) {
        this.parentCollection = c;
    }

    public IFDCollection<? extends IFDObject<?>> getParentCollection() {
        return this.parentCollection;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String key) {
        this.sortKey = key;
    }

    public IFDObject(String label, String type) {
        this.set(label, type, Integer.MAX_VALUE);
    }

    public IFDObject(String label, String type, int maxCount, T ... initialSet) throws IFDException {
        this.set(label, type, maxCount);
        if (initialSet == null) {
            this.minCount = 0;
        } else {
            this.minCount = initialSet.length;
            for (int i = 0; i < this.minCount; ++i) {
                if (initialSet[i] == null) {
                    throw new IFDException("IFDObject initial set cannot be null");
                }
                super.add(initialSet[i]);
            }
        }
    }

    private void set(String label, String type, int maxCount) {
        this.label = label;
        if (type == null) {
            type = this.getClass().getName();
        }
        this.type = type;
        this.maxCount = maxCount;
        this.index = indexCount++;
    }

    protected void setMinCount(int n) {
        this.minCount = n;
    }

    protected void setProperties(String propertyPrefix, String notKey) {
        this.myPropertyPrefix = propertyPrefix;
        IFDConst.setProperties(this.htProps, propertyPrefix, notKey);
    }

    public Map<String, IFDProperty> getProperties() {
        return this.htProps;
    }

    public final List<IFDAttribute> getAttributes() {
        return this.attributes;
    }

    public IFDProperty setPropertyValue(String key, Object value) {
        if (IFDConst.isRepresentation(key) || this.checkSpecialProperties(key, value)) {
            return null;
        }
        IFDProperty p = IFDConst.getIFDProperty(this.htProps, key);
        if (p != null) {
            this.hasProperty = true;
            p = p.getClone(value);
            this.htProps.put(key, p);
            return p;
        }
        key = this.fixAttributeKey(key);
        if (value == null) {
            IFDAttribute.remove(this.attributes, key);
        } else {
            IFDAttribute.add(this.attributes, key, value);
        }
        return null;
    }

    public void setPropertyValue(String key, Object value, String source) {
        IFDProperty p = this.setPropertyValue(key, value);
        if (p != null) {
            p.setSource(p.getValue() == null ? null : source);
        }
    }

    public String getPropertySource(String key) {
        IFDProperty p = this.htProps.get(key);
        return p == null ? null : p.getSource();
    }

    private String fixAttributeKey(String key) {
        key = key.trim().replaceAll("\\W", "_");
        return key;
    }

    protected abstract String getIFDPropertyPrefix();

    protected String getPropertyPrefixForSerialization() {
        return this.getIFDPropertyPrefix();
    }

    private boolean checkSpecialProperties(String key, Object value) {
        String myPropertyPrefix = this.getIFDPropertyPrefix();
        if (key.equals(IFDConst.IFD_PROPERTY_LABEL) || key.equals(myPropertyPrefix + IFDConst.IFD_LABEL_FLAG)) {
            this.setLabel(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_ID) || key.equals(myPropertyPrefix + IFDConst.IFD_ID_FLAG)) {
            this.setID(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_DESCRIPTION) || key.equals(myPropertyPrefix + IFDConst.IFD_DESCRIPTION_FLAG)) {
            this.setDescription(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_NOTE) || key.equals(myPropertyPrefix + IFDConst.IFD_NOTE_FLAG)) {
            this.addNote(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_TIMESTAMP) || key.equals(myPropertyPrefix + IFDConst.IFD_TIMESTAMP_FLAG)) {
            this.setTimestamp(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_DOI) || key.equals(myPropertyPrefix + IFDConst.IFD_DOI_FLAG)) {
            this.setDOI(value.toString());
            return true;
        }
        if (key.equals(IFDConst.IFD_PROPERTY_URL) || key.equals(myPropertyPrefix + IFDConst.IFD_URL_FLAG)) {
            this.setURL(value.toString());
            return true;
        }
        return false;
    }

    public Object getPropertyValue(String key) {
        IFDProperty p = this.htProps.get(key);
        return p == null ? null : p.getValue();
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = "[" + (this.index + 1) + "]";
        }
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    protected void addNote(String note) {
        this.note = this.note == null ? note : this.note + ";\n" + note;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public String getDOI() {
        return this.doi;
    }

    @Override
    public void setDOI(String doi) {
        this.doi = doi;
    }

    public void setDOIorURLFromMapByID(Map<String, Map<String, Object>> htURLReferences) {
        Map<String, Object> ref = htURLReferences.get(this.getID());
        if (ref == null) {
            return;
        }
        Object r = ref.get("url");
        if (r != null) {
            this.url = r.toString();
        }
        if ((r = ref.get("doi")) != null) {
            this.doi = r.toString();
        }
    }

    @Override
    public T getObject(int index) {
        return (T)this.get(index);
    }

    @Override
    public int getObjectCount() {
        return this.size();
    }

    @Override
    public T remove(int index) {
        this.checkRange(index);
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        int i = super.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.checkRange(i);
        return super.remove(o);
    }

    @Override
    public T set(int index, T c) {
        this.checkRange(index);
        return super.set(index, c);
    }

    protected void setSafely(int index, T c) {
        super.set(index, c);
    }

    private void checkRange(int index) {
        if (index < this.minCount) {
            throw new IndexOutOfBoundsException("operation not allowed for index < " + this.minCount);
        }
        if (index > this.maxCount) {
            throw new IndexOutOfBoundsException("operation not allowed for index > " + this.maxCount);
        }
    }

    public boolean haveProperties() {
        return this.hasProperty;
    }

    public void setSerializeType(boolean doSerializeType) {
        this.doSerializeType = doSerializeType;
    }

    @Override
    public String getSerializedType() {
        return this.type;
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
        this.serializeTop(serializer);
        this.serializeProps(serializer);
        this.serializeList(serializer);
    }

    public void setReference(IFDReference ref) {
        this.reference = ref;
    }

    protected void serializeTop(IFDSerializerI serializer) {
        if (this.doSerializeType) {
            IFDObject.serializeClass(serializer, this.getClass(), null);
        }
        serializer.addAttr("id", this.getID());
        serializer.addAttr("label", this.getLabel());
        serializer.addAttr("note", this.getNote());
        serializer.addAttr("description", this.getDescription());
        serializer.addAttr("timestamp", this.getTimestamp());
        serializer.addAttr("doi", this.doi);
        serializer.addAttr("url", this.url);
        if (this.reference != null) {
            this.reference.serialize(serializer);
        }
        if (this.hasProperty) {
            serializer.addAttr("propertyPrefix", this.getPropertyPrefixForSerialization());
        }
    }

    protected void serializeProps(IFDSerializerI serializer) {
        TreeMap<String, Object> map;
        if (this.haveProperties()) {
            map = new TreeMap<String, Object>();
            String propPrefix = this.getPropertyPrefixForSerialization() + '.';
            int prefixLength = propPrefix.length();
            for (Map.Entry<String, IFDProperty> e : this.htProps.entrySet()) {
                Object val = e.getValue().getValue();
                if (val == null) continue;
                String key = e.getKey();
                if (key.startsWith(propPrefix)) {
                    key = key.substring(prefixLength);
                }
                map.put(key, val);
            }
            serializer.addObject("properties", map);
        }
        if (this.attributes.size() > 0) {
            map = new TreeMap();
            for (IFDAttribute p : this.attributes) {
                Object val = p.getValue();
                if (val == null || val == "") continue;
                map.put(p.getName(), val);
            }
            serializer.addObject("attributes", map);
        }
    }

    abstract void serializeList(IFDSerializerI var1);

    public static Map<String, Object> getTypeAndExtends(Class<?> c, Map<String, Object> m) {
        if (m == null) {
            m = new TreeMap<String, Object>();
        }
        String ctype = c.getName();
        m.put("ifdType", ctype);
        String strtype = IFDObject.serializeExtended(c);
        if (strtype.length() > 0 && !strtype.equals(ctype)) {
            m.put("ifdTypeExtends", strtype);
        }
        return m;
    }

    static void serializeClass(IFDSerializerI serializer, Class<?> c, String stype) {
        if (stype == null) {
            stype = "ifdType";
        }
        Map<String, Object> m = IFDObject.getTypeAndExtends(c, null);
        serializer.addAttr(stype, (String)m.get("ifdType"));
        String ext = (String)m.get("ifdTypeExtends");
        if (ext != null) {
            serializer.addAttr(stype + "Extends", ext);
        }
    }

    private static String serializeExtended(Class<?> t) {
        String label = t.getName();
        String et = htExtendedTypes.get(label);
        String n = label;
        if (et == null) {
            et = "";
            String sep = "";
            while ((t = t.getSuperclass()) != Object.class && (n = t.getName()).indexOf("IFDObject") < 0) {
                et = et + sep + n;
                sep = ";";
                if (!n.startsWith("org.iupac.fairdata.core")) continue;
            }
            htExtendedTypes.put(label, et);
        }
        return et;
    }

    public void setValid(boolean tf) {
        this.isValid = tf;
        if (!tf) {
            System.out.println("IFDO invalidating " + this.getClass().getName() + " " + (this.id != null ? this.id : (this.label != null ? this.label : this.description)));
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public IFDObject<T> clone() {
        IFDObject o = (IFDObject)super.clone();
        o.index = indexCount++;
        o.attributes = new ArrayList<IFDAttribute>();
        o.htProps = new PropertyMap();
        o.setProperties(this.myPropertyPrefix, null);
        for (Map.Entry<String, IFDProperty> p : this.htProps.entrySet()) {
            Object val = p.getValue().getValue();
            if (val == null) continue;
            o.setPropertyValue(p.getKey(), val);
        }
        this.clear();
        return o;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.index + " id=" + this.getID() + (this.label == null ? "" : " label=" + this.getLabel()) + " size=" + this.size() + " isValid=" + this.isValid + "]";
    }

    public void dumpProperties(String label) {
        Map<String, IFDProperty> props = this.getProperties();
        System.out.println("IFDObject property dump for " + this);
        for (Map.Entry<String, IFDProperty> p : props.entrySet()) {
            if (p.getValue().getValue() == null) continue;
            System.out.println(label + ":" + p.getKey() + "=" + p.getValue());
        }
    }

    static {
        htExtendedTypes = new Hashtable<String, String>();
    }

    public class PropertyMap
    extends TreeMap<String, IFDProperty> {
        @Override
        public IFDProperty get(Object key) {
            return (IFDProperty)super.get(key);
        }

        @Override
        public IFDProperty put(String key, IFDProperty value) {
            return super.put(key, value);
        }

        @Override
        public IFDProperty remove(Object key) {
            return null;
        }

        @Override
        public void clear() {
            for (String key : this.keySet()) {
                this.put(key, this.get(key).getClone(null));
            }
        }
    }
}

