/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDObject;

public class IFDAssociation
extends IFDCollection<IFDCollection<? extends IFDObject<?>>>
implements Comparable<IFDAssociation> {
    protected boolean byID;
    int intID = -1;
    private List<String> typeList;

    public void setByID(boolean b) {
        this.byID = b;
        this.checkIntID();
    }

    private void checkIntID() {
        if (this.byID && this.id != null && this.intID < 0) {
            this.intID = 0;
            int n = this.id.length();
            for (int i = 0; i < n; ++i) {
                char c = this.id.charAt(i);
                if (c < '0' || c > '9') {
                    this.intID = 0;
                    break;
                }
                this.intID = this.intID * 10 + (c - 48);
            }
        }
    }

    @SafeVarargs
    protected IFDAssociation(String type, IFDCollection<IFDObject<?>> ... collections) throws IFDException {
        super(null, type, (IFDObject[])collections);
        for (int i = 0; i < collections.length; ++i) {
            if (collections[i] != null) continue;
            throw new IFDException("IFDAssociation collections must be non-null.");
        }
    }

    @Override
    public void setID(String id) {
        super.setID(id);
        if (this.byID) {
            this.intID = -1;
            this.checkIntID();
        }
    }

    public boolean associates1ToN(IFDObject<?> obj1) {
        IFDCollection c1;
        return this.size() >= 2 && (c1 = (IFDCollection)this.get(0)).size() == 1 && c1.get(0) == obj1;
    }

    public boolean associates(IFDObject<?> obj1, IFDObject<?> obj2) {
        return !(obj1 == null && obj2 == null || this.size() < 2 || obj2 != null && ((IFDCollection)this.get(1)).indexOf(obj2) < 0 || obj1 != null && ((IFDCollection)this.get(0)).indexOf(obj1) < 0);
    }

    public boolean associatesToFirstObj2(IFDObject<?> obj2) {
        return this.getFirstObj2() == obj2;
    }

    public IFDObject<?> getFirstObj1() {
        return ((IFDCollection)this.get(0)).size() > 0 ? (IFDObject)((IFDCollection)this.get(0)).get(0) : null;
    }

    public IFDObject<?> getFirstObj2() {
        return ((IFDCollection)this.get(1)).size() > 0 ? (IFDObject)((IFDCollection)this.get(1)).get(0) : null;
    }

    public IFDObject<?> getFirstObj(int collectionIndex) throws IFDException {
        if (collectionIndex < 0 || collectionIndex >= this.size()) {
            throw new IFDException("IFDAssociation collectionIndex must be in the range 0 to " + (this.size() - 1));
        }
        return (IFDObject)((IFDCollection)this.get(collectionIndex)).get(0);
    }

    public void setTypeList(List<String> list) {
        this.typeList = list;
    }

    private Map<String, List<String>> getMyIDList() {
        LinkedHashMap<String, List<String>> list = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < this.size(); ++i) {
            IFDCollection c = (IFDCollection)this.getObject(i);
            list.put(this.typeList.get(i), c.getIDList());
        }
        return list;
    }

    private List<List<Integer>> getMyIndexList() {
        ArrayList<List<Integer>> list = new ArrayList<List<Integer>>();
        for (int i = 0; i < this.size(); ++i) {
            IFDCollection c = (IFDCollection)this.getObject(i);
            list.add(c.getIndexList());
        }
        return list;
    }

    @Override
    public int compareTo(IFDAssociation o) {
        if (!this.byID || this.id == null || o.id == null) {
            return Integer.compare(this.index, o.index);
        }
        if (this.intID > 0 && o.intID > 0) {
            return Integer.compare(this.intID, o.intID);
        }
        return this.id.compareTo(o.getID());
    }

    @Override
    public void serializeList(IFDSerializerI serializer) {
        if (this.size() == 0) {
            return;
        }
        if (this.byID) {
            serializer.addObject("itemsByID", this.getMyIDList());
        } else {
            serializer.addObject("items", this.getMyIndexList());
        }
    }

    @Override
    public String toString() {
        return super.toString().replace(']', ' ') + this.getMyIndexList() + " ]";
    }
}

