/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.contrib.fairspec.dataobject;

import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.dataobject.IFDDataObject;

public class FAIRSpecDataObject
extends IFDDataObject {
    private static String basePropertyPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_DATAOBJECT_FLAG, "fairspec.");
    protected String exptMethod;
    private String serializerPropertyPrefix;
    private String objectType;

    public void setExptMethod(String method) {
        this.exptMethod = method.toUpperCase();
    }

    @Override
    protected String getIFDPropertyPrefix() {
        return this.serializerPropertyPrefix == null ? basePropertyPrefix : this.serializerPropertyPrefix;
    }

    @Override
    protected String getPropertyPrefixForSerialization() {
        return this.serializerPropertyPrefix;
    }

    public FAIRSpecDataObject(String name) {
        this.setProperties(basePropertyPrefix + "." + name, null);
    }

    public static FAIRSpecDataObject createFAIRSpecObject(String key) {
        if (key == null) {
            key = "unknown";
        }
        String type = key.substring(key.lastIndexOf(".") + 1);
        String ucType = type.toUpperCase();
        String className = FAIRSpecDataObject.class.getName();
        className = className.substring(0, className.lastIndexOf(".") + 1) + type + ".FAIRSpec" + ucType + "Data";
        try {
            FAIRSpecDataObject o = (FAIRSpecDataObject)Class.forName(className).newInstance();
            o.objectType = IFDConst.getProp("DATAOBJECT_FAIRSPEC_" + ucType + "_FLAG");
            o.setExptMethod(ucType);
            String prefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, o.objectType);
            o.serializerPropertyPrefix = prefix = prefix.substring(0, prefix.length() - 1 - ucType.length());
            o.setProperties(prefix + "." + type, null);
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected IFDRepresentation newRepresentation(IFDReference ifdReference, Object object, long len, String type, String subtype) {
        throw new NullPointerException("FAIRSpecDataObject cannot be instantialized directly");
    }

    @Override
    protected void serializeProps(IFDSerializerI serializer) {
        super.serializeProps(serializer);
        if (this.exptMethod != null) {
            serializer.addAttr("exptMethod", this.exptMethod);
        }
    }
}

