/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class TextTransfer
implements ClipboardOwner,
ActionListener {
    private PasteAction pasteAction;

    public void test() {
        TextTransfer textTransfer = new TextTransfer();
        System.out.println("Clipboard contains:" + textTransfer.getClipboardContents());
        textTransfer.setClipboardContents("blah, blah, blah");
        System.out.println("Clipboard contains:" + textTransfer.getClipboardContents());
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(this);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void getAsyncClipboardContents(PasteAction pasteAction) {
        this.pasteAction = pasteAction;
        String content = this.getClipboardContents();
        if (content != null) {
            pasteAction.paste(content);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pasteAction.paste(e.getActionCommand());
    }

    public static interface PasteAction {
        public void paste(String var1);
    }
}

