/*
 * Decompiled with CFR 0.152.
 */
package jme.core;

import jme.core.AtomBondCommon;

public class Bond
implements AtomBondCommon {
    public static final int SINGLE = 1;
    public static final int DOUBLE = 2;
    public static final int TRIPLE = 3;
    public static final int AROMATIC = 5;
    public static final int QUERY = 9;
    public static final int COORDINATION = 0;
    public static final int STEREO_NONE = 0;
    public static final int STEREO_UP = 1;
    public static final int STEREO_DOWN = 2;
    public static final int STEREO_XUP = 3;
    public static final int STEREO_XDOWN = 4;
    public static final int STEREO_LAST_KNOWN = 4;
    public static final int STEREO_EITHER = 5;
    public static final int STEREO_XEITHER = 6;
    public static final int STEREO_EZ = 10;
    public static final int QB_ANY = 11;
    public static final int QB_AROMATIC = 12;
    public static final int QB_RING = 13;
    public static final int QB_NONRING = 14;
    public int va;
    public int vb;
    public int bondType = 1;
    public int stereo;
    public String btag;
    public double centerX;
    public double centerY;
    public double guideX = Double.NaN;
    public double guideY;
    public int partIndex;
    public int[] backgroundColors;
    int mark = -99199;
    public boolean smallRing;

    public void setBondType(int type) {
        this.bondType = type;
    }

    public int getBondType() {
        return this.bondType;
    }

    public Bond() {
        this.resetBackgroundColors();
    }

    @Override
    public Bond deepCopy() {
        return this.copyTo(new Bond());
    }

    public Bond copyTo(Bond b) {
        b.backgroundColors = AtomBondCommon.copyArray(this.backgroundColors);
        b.mark = this.mark;
        b.va = this.va;
        b.vb = this.vb;
        b.bondType = this.bondType;
        b.smallRing = this.smallRing;
        b.stereo = this.stereo;
        b.btag = this.btag;
        b.centerX = this.centerX;
        b.centerY = this.centerY;
        b.guideX = this.guideX;
        b.guideY = this.guideY;
        b.partIndex = this.partIndex;
        return b;
    }

    public static String convertBondType(int bondType) {
        String result = null;
        switch (bondType) {
            case 1: {
                result = "single";
                break;
            }
            case 2: {
                result = "double";
                break;
            }
            case 3: {
                result = "triple";
                break;
            }
            case 5: {
                result = "aromatic";
                break;
            }
            case 0: {
                result = "coordination";
                break;
            }
            case 9: {
                result = "query";
            }
        }
        return result;
    }

    public static String convertBondStereo(int stereo) {
        String result = null;
        switch (stereo) {
            case 2: 
            case 4: {
                result = "down";
                break;
            }
            case 1: 
            case 3: {
                result = "up";
                break;
            }
            case 5: 
            case 6: {
                result = "either";
                break;
            }
            case 10: {
                result = "either";
            }
        }
        return result;
    }

    public boolean is(Bond b) {
        return this.va == b.va && this.vb == b.vb || this.va == b.vb && this.vb == b.va;
    }

    public boolean isAB(int atom1, int atom2) {
        return this.va == atom1 && this.vb == atom2 || this.va == atom2 && this.vb == atom1;
    }

    public boolean isSingle() {
        return this.bondType == 1;
    }

    public boolean isDouble() {
        return this.bondType == 2;
    }

    public boolean isTriple() {
        return this.bondType == 3;
    }

    public void toggleNormalCrossedDoubleBond() {
        if (this.isDouble()) {
            this.stereo = this.smallRing ? 0 : 10 - this.stereo;
        }
    }

    public boolean isCoordination() {
        return this.bondType == 0;
    }

    public Bond setCoordination(Boolean yesOrNo) {
        this.bondType = yesOrNo != false ? 0 : 1;
        return this;
    }

    public boolean isQuery() {
        return this.bondType == 9;
    }

    public Bond toggleCoordination() {
        return this.setCoordination(!this.isCoordination());
    }

    @Override
    public boolean resetObjectMark() {
        boolean hasChanged = this.backgroundColors[0] != -99199;
        this.resetBackgroundColors();
        return hasChanged;
    }

    @Override
    public void addBackgroundColor(int c) {
        for (int i = 0; i < this.backgroundColors.length; ++i) {
            if (this.backgroundColors[i] != c) continue;
            return;
        }
        this.backgroundColors = AtomBondCommon.growArray(this.backgroundColors, this.backgroundColors.length + 1);
        this.backgroundColors[this.backgroundColors.length - 1] = c;
    }

    @Override
    public void resetBackgroundColors() {
        this.backgroundColors = new int[]{-99199};
    }

    @Override
    public int[] getBackgroundColors() {
        return this.backgroundColors;
    }

    @Override
    public boolean resetMark() {
        if (this.mark == -99199) {
            return false;
        }
        this.mark = -99199;
        return true;
    }

    @Override
    public int getMark() {
        return Math.max(this.mark, 0);
    }

    @Override
    public void setMark(int mark) {
        this.mark = mark;
    }

    @Override
    public boolean isMarked() {
        return this.mark > 0;
    }

    public void checkSmallRing() {
        if (this.smallRing) {
            if (this.bondType == 3) {
                this.bondType = 1;
            } else if (this.bondType == 2 && this.stereo == 10) {
                this.stereo = 0;
            }
        }
    }

    public String toString() {
        return "[Bond " + this.va + " " + this.vb + " " + this.bondType + "]";
    }
}

