/*
 * Decompiled with CFR 0.152.
 */
package jme.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme.core.AtomBondCommon;
import jme.core.JMECore;
import jme.util.Isotopes;

public class Atom
implements AtomBondCommon {
    public static final int AN_H = 1;
    public static final int AN_B = 2;
    public static final int AN_C = 3;
    public static final int AN_N = 4;
    public static final int AN_O = 5;
    public static final int AN_SI = 6;
    public static final int AN_P = 7;
    public static final int AN_S = 8;
    public static final int AN_F = 9;
    public static final int AN_CL = 10;
    public static final int AN_BR = 11;
    public static final int AN_I = 12;
    public static final int AN_SE = 13;
    public static final int AN_K = 14;
    public static final int AN_METAL1_START = 14;
    public static final int AN_Na = 15;
    public static final int AN_Li = 16;
    public static final int AN_Rb = 17;
    public static final int AN_Cs = 18;
    public static final int AN_Fr = 19;
    public static final int AN_Ag = 20;
    public static final int AN_METAL1_END = 20;
    public static final int AN_Mg = 21;
    public static final int AN_METAL2_START = 21;
    public static final int AN_Ca = 22;
    public static final int AN_Ba = 23;
    public static final int AN_Sr = 24;
    public static final int AN_Zn = 25;
    public static final int AN_Ni = 26;
    public static final int AN_Cu = 27;
    public static final int AN_Cd = 28;
    public static final int AN_METAL2_END = 28;
    public static final int AN_METAL3_START = 29;
    public static final int AN_Al = 29;
    public static final int AN_Ga = 30;
    public static final int AN_Au = 31;
    public static final int AN_METAL3_END = 31;
    public static final int AN_X = 32;
    public static final int AN_R = 33;
    public static final int AN_R_LAST = 42;
    public static final String[] zlabel = new String[43];
    int map = -99199;
    int mark = -99199;
    public int[] backgroundColors;
    public int iso;
    public double x;
    public double y;
    public double z;
    public int q = 0;
    public int partIndex;
    public boolean deleteFlag;
    public String label;
    public int[] v = new int[7];
    public int nv;
    public int an = 3;
    public int nh = 0;
    public int sbo;
    public String atag;
    static final Pattern atomicSymbolPattern;
    static final Pattern atomicSymbolPatternIsotopAndCharge;

    public static int chargedMetalType(int an) {
        if (an >= 14 && an <= 20) {
            return 1;
        }
        if (an >= 21 && an <= 28) {
            return 2;
        }
        if (an >= 29 && an <= 31) {
            return 3;
        }
        return 0;
    }

    public static void atomicData() {
        Atom.zlabel[32] = "X";
        Atom.zlabel[1] = "H";
        Atom.zlabel[2] = "B";
        Atom.zlabel[3] = "C";
        Atom.zlabel[4] = "N";
        Atom.zlabel[5] = "O";
        Atom.zlabel[9] = "F";
        Atom.zlabel[10] = "Cl";
        Atom.zlabel[11] = "Br";
        Atom.zlabel[12] = "I";
        Atom.zlabel[8] = "S";
        Atom.zlabel[7] = "P";
        Atom.zlabel[6] = "Si";
        Atom.zlabel[13] = "Se";
        Atom.zlabel[32] = "X";
        Atom.zlabel[14] = "K";
        Atom.zlabel[16] = "Li";
        Atom.zlabel[15] = "Na";
        Atom.zlabel[17] = "Rb";
        Atom.zlabel[18] = "Cs";
        Atom.zlabel[19] = "Fr";
        Atom.zlabel[20] = "Ag";
        Atom.zlabel[21] = "Mg";
        Atom.zlabel[22] = "Ca";
        Atom.zlabel[24] = "Sr";
        Atom.zlabel[23] = "Ba";
        Atom.zlabel[25] = "Zn";
        Atom.zlabel[26] = "Ni";
        Atom.zlabel[27] = "Cu";
        Atom.zlabel[28] = "Cd";
        Atom.zlabel[29] = "Al";
        Atom.zlabel[30] = "Ga";
        Atom.zlabel[31] = "Au";
        for (int i = 33; i <= 42; ++i) {
            Atom.zlabel[i] = "R" + (i > 33 ? Integer.valueOf(i - 33) : "");
        }
    }

    public Atom() {
        this.resetBackgroundColors();
    }

    @Override
    public Atom deepCopy() {
        return this.copyTo(new Atom());
    }

    public Atom copyTo(Atom a) {
        a.backgroundColors = AtomBondCommon.copyArray(this.backgroundColors);
        a.mark = this.mark;
        a.map = this.map;
        a.iso = this.iso;
        a.x = this.x;
        a.y = this.y;
        a.z = this.z;
        a.q = this.q;
        a.label = this.label;
        a.v = AtomBondCommon.copyArray(this.v);
        a.nv = this.nv;
        a.an = this.an;
        a.atag = this.atag;
        a.nh = this.nh;
        a.sbo = this.sbo;
        a.partIndex = this.partIndex;
        a.deleteFlag = this.deleteFlag;
        return a;
    }

    public void addNeighbor(int neighbor) {
        if (this.nv < 6) {
            ++this.nv;
            this.v[this.nv] = neighbor;
        }
    }

    public boolean hasBeenMapped() {
        return this.map != -99199;
    }

    @Override
    public boolean resetObjectMark() {
        return this.resetMap();
    }

    public boolean resetMap() {
        boolean hasChanged = this.hasBeenMapped();
        this.map = -99199;
        return hasChanged;
    }

    public int getMap() {
        return this.hasBeenMapped() ? this.map : 0;
    }

    public int getMapOrMark(boolean isMap) {
        return isMap ? this.getMap() : this.getMark();
    }

    public void setMapOrMark(int m, boolean isMap) {
        if (isMap) {
            this.setMap(m);
        } else {
            this.setMark(m);
        }
    }

    public void setMap(int map) {
        this.map = map;
    }

    public boolean isMapped() {
        return this.getMap() != 0;
    }

    public boolean isMappedOrMarked() {
        return this.isMapped() || this.getMark() != 0;
    }

    public boolean isCumuleneSP() {
        return this.sbo >= 4 && this.nv == 2;
    }

    public void moveXY(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public void scaleXY(double scale) {
        this.x *= scale;
        this.y *= scale;
    }

    public void XY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int iso() {
        return this.iso;
    }

    public int q() {
        return this.q;
    }

    public void Q(int charge) {
        this.q = charge;
    }

    public void incrQ(int incr) {
        this.q += incr;
    }

    public double squareDistance(Atom other) {
        return Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0);
    }

    public boolean hasCloseContactWith(Atom other, double minDistance) {
        double dist = this.squareDistance(other);
        return dist < Math.pow(minDistance, 2.0);
    }

    String parseAtomSymbolIsotop(String symbol) {
        this.iso = 0;
        Matcher m = atomicSymbolPattern.matcher(symbol);
        if (m.find()) {
            int isomass = Integer.parseInt(m.group(1));
            String element = m.group(2);
            if (Isotopes.isKnown(element, isomass)) {
                this.iso = isomass;
                symbol = element + m.group(3);
            }
        }
        return symbol;
    }

    public String parseAtomicSymbolPatternIsotopMappAndCharge(String symbol, JMECore.Parameters parameters) {
        Matcher m = atomicSymbolPatternIsotopAndCharge.matcher(symbol);
        if (m.find()) {
            String iso = m.group(1);
            String element = m.group(2);
            String hCount = m.group(3);
            String hCountNumber = m.group(4);
            String chargeNumber = m.group(6);
            String chargeSign = m.group(5);
            String multiCharge = m.group(7);
            String query = m.group(8);
            String atomMap = m.group(10);
            int charge = 0;
            boolean isValid = true;
            if (Isotopes.getNaturalMass(element) != -1) {
                if (iso != null && iso.length() > 0) {
                    int isomass = Integer.parseInt(iso);
                    if (Isotopes.isKnown(element, isomass)) {
                        this.iso = isomass;
                    } else {
                        isValid = false;
                    }
                }
            } else {
                isValid = false;
            }
            if (isValid) {
                boolean hasMultiCharge;
                boolean hasChargeSign = chargeSign != null && chargeSign.length() > 0;
                boolean hasChargeNumber = chargeNumber != null && chargeNumber.length() > 0;
                boolean bl = hasMultiCharge = multiCharge != null && multiCharge.length() > 0;
                if (hasChargeSign || hasChargeNumber) {
                    charge = 1;
                    if (hasChargeNumber) {
                        charge = Integer.parseInt(chargeNumber);
                    }
                    charge *= chargeSign.equals("-") ? -1 : 1;
                } else if (hasMultiCharge) {
                    charge = multiCharge.length();
                    charge *= multiCharge.equals("-") ? -1 : 1;
                }
            }
            if (isValid) {
                symbol = element + (query != null ? query : "");
                this.q = charge;
            }
            if (atomMap != null && atomMap.length() > 0) {
                try {
                    int map = Integer.parseInt(atomMap);
                    if (map > 0) {
                        if (parameters.mark) {
                            this.setMark(map);
                        }
                        if (parameters.number) {
                            this.setMap(map);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hCount != null) {
                this.nh = 1;
                if (hCountNumber != null && hCountNumber.length() > 0) {
                    this.nh = Integer.parseInt(hCountNumber);
                }
            }
        }
        return symbol;
    }

    public String getLabel() {
        return this.an == 32 ? this.label : zlabel[this.an];
    }

    @Override
    public void addBackgroundColor(int c) {
        for (int i = 0; i < this.backgroundColors.length; ++i) {
            if (this.backgroundColors[i] != c) continue;
            return;
        }
        this.backgroundColors = AtomBondCommon.growArray(this.backgroundColors, this.backgroundColors.length + 1);
        this.backgroundColors[this.backgroundColors.length - 1] = c;
    }

    @Override
    public void resetBackgroundColors() {
        this.backgroundColors = new int[]{-99199};
    }

    @Override
    public boolean resetMark() {
        if (this.mark == -99199) {
            return false;
        }
        this.mark = -99199;
        return true;
    }

    @Override
    public int getMark() {
        return Math.max(this.mark, 0);
    }

    @Override
    public void setMark(int markOrMap) {
        this.mark = markOrMap;
    }

    @Override
    public boolean isMarked() {
        return this.mark > 0;
    }

    public String toString() {
        return "[Atom " + this.getLabel() + " " + this.x + " " + this.y + "]";
    }

    @Override
    public int[] getBackgroundColors() {
        return this.backgroundColors;
    }

    public static int checkAtomicSymbol(String s) {
        for (int an = 1; an < zlabel.length; ++an) {
            if (!s.equals(zlabel[an])) continue;
            return an;
        }
        return 32;
    }

    static {
        Atom.atomicData();
        atomicSymbolPattern = Pattern.compile("^(\\d+)([A-Z][a-z]?)(\\b.*)");
        atomicSymbolPatternIsotopAndCharge = Pattern.compile("^(\\d+)?\\s*([A-Z][a-z]?)\\s*(H(\\d*))?(?:(?:([+-])(\\d*))|((?:\\++)|(?:-+)))?([^:+-]+?([,;#!])?[^:+-]+?)?(?::(\\d+))?$");
    }
}

