/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.Serializable;
import javajs.api.JSONEncodable;

public abstract class T3d
implements JSONEncodable,
Serializable {
    public double x;
    public double y;
    public double z;

    public final void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void setA(double[] t) {
        this.x = t[0];
        this.y = t[1];
        this.z = t[2];
    }

    public final void setT(T3d t1) {
        this.x = t1.x;
        this.y = t1.y;
        this.z = t1.z;
    }

    public final void add2(T3d t1, T3d t2) {
        this.x = t1.x + t2.x;
        this.y = t1.y + t2.y;
        this.z = t1.z + t2.z;
    }

    public final void add(T3d t) {
        this.x += t.x;
        this.y += t.y;
        this.z += t.z;
    }

    public final double distanceSquared(T3d p1) {
        double dx = this.x - p1.x;
        double dy = this.y - p1.y;
        double dz = this.z - p1.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distance(T3d p1) {
        return Math.sqrt(this.distanceSquared(p1));
    }

    public final void sub2(T3d t1, T3d t2) {
        this.x = t1.x - t2.x;
        this.y = t1.y - t2.y;
        this.z = t1.z - t2.z;
    }

    public final void sub(T3d t1) {
        this.x -= t1.x;
        this.y -= t1.y;
        this.z -= t1.z;
    }

    public final void scale(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public final void scaleT(T3d p) {
        this.x *= p.x;
        this.y *= p.y;
        this.z *= p.z;
    }

    public final void add3(double a, double b, double c) {
        this.x += a;
        this.y += b;
        this.z += c;
    }

    public final void scaleAdd(double s, T3d t1, T3d t2) {
        this.x = s * t1.x + t2.x;
        this.y = s * t1.y + t2.y;
        this.z = s * t1.z + t2.z;
    }

    public final void scaleAdd2(double s, T3d t1, T3d t2) {
        this.x = s * t1.x + t2.x;
        this.y = s * t1.y + t2.y;
        this.z = s * t1.z + t2.z;
    }

    public void ave(T3d a, T3d b) {
        this.x = (a.x + b.x) / 2.0;
        this.y = (a.y + b.y) / 2.0;
        this.z = (a.z + b.z) / 2.0;
    }

    public final double dot(T3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final void normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public final void cross(T3d v1, T3d v2) {
        this.set(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public int hashCode() {
        long xbits = T3d.doubleToLongBits0(this.x);
        long ybits = T3d.doubleToLongBits0(this.y);
        long zbits = T3d.doubleToLongBits0(this.z);
        return (int)(xbits ^ xbits >> 32 ^ ybits ^ ybits >> 32 ^ zbits ^ zbits >> 32);
    }

    static long doubleToLongBits0(double d) {
        return d == 0.0 ? 0L : Double.doubleToLongBits(d);
    }

    public boolean equals(Object t1) {
        if (!(t1 instanceof T3d)) {
            return false;
        }
        T3d t2 = (T3d)t1;
        return this.x == t2.x && this.y == t2.y && this.z == t2.z;
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public static int doubleToIntBits(double x) {
        return x == 0.0 ? 0 : Float.floatToIntBits((float)x);
    }

    @Override
    public String toJSON() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public T3d setP(T3d t) {
        this.set(t.x, t.y, t.z);
        return this;
    }

    public T3d putP(T3d t) {
        t.set(this.x, this.y, this.z);
        return t;
    }
}

