/*
 * Decompiled with CFR 0.152.
 */
package javajs.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import javajs.export.PDFObject;
import javajs.util.Lst;
import javajs.util.SB;

public class PDFCreator {
    private OutputStream os;
    private Lst<PDFObject> indirectObjects;
    private PDFObject root;
    private PDFObject graphics;
    private int pt;
    private int xrefPt;
    private int count;
    private int height;
    private int width;
    private Map<String, PDFObject> fonts;
    private Map<Object, PDFObject> images;

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public void newDocument(int paperWidth, int paperHeight, boolean isLandscape) {
        this.width = isLandscape ? paperHeight : paperWidth;
        this.height = isLandscape ? paperWidth : paperHeight;
        System.out.println("Creating PDF with width=" + this.width + " and height=" + this.height);
        this.fonts = new Hashtable<String, PDFObject>();
        this.indirectObjects = new Lst();
        this.root = this.newObject("Catalog");
        PDFObject pages = this.newObject("Pages");
        PDFObject page = this.newObject("Page");
        PDFObject pageContents = this.newObject(null);
        this.graphics = this.newObject("XObject");
        this.root.addDef("Pages", pages.getRef());
        pages.addDef("Count", "1");
        pages.addDef("Kids", "[ " + page.getRef() + " ]");
        page.addDef("Parent", pages.getRef());
        page.addDef("MediaBox", "[ 0 0 " + paperWidth + " " + paperHeight + " ]");
        if (isLandscape) {
            page.addDef("Rotate", "90");
        }
        pageContents.addDef("Length", "?");
        pageContents.append((isLandscape ? "q 0 1 1 0 0 0 " : "q 1 0 0 -1 0 " + paperHeight) + " cm /" + this.graphics.getID() + " Do Q");
        page.addDef("Contents", pageContents.getRef());
        this.addProcSet(page);
        this.addProcSet(this.graphics);
        this.graphics.addDef("Subtype", "/Form");
        this.graphics.addDef("FormType", "1");
        this.graphics.addDef("BBox", "[0 0 " + this.width + " " + this.height + "]");
        this.graphics.addDef("Matrix", "[1 0 0 1 0 0]");
        this.graphics.addDef("Length", "?");
        page.addResource("XObject", this.graphics.getID(), this.graphics.getRef());
        this.g("q 1 w 1 J 1 j 10 M []0 d q ");
        this.clip(0, 0, this.width, this.height);
    }

    private void addProcSet(PDFObject o) {
        o.addResource(null, "ProcSet", "[/PDF /Text /ImageB /ImageC /ImageI]");
    }

    private void clip(int x1, int y1, int x2, int y2) {
        this.moveto(x1, y1);
        this.lineto(x2, y1);
        this.lineto(x2, y2);
        this.lineto(x1, y2);
        this.g("h W n");
    }

    public void moveto(int x, int y) {
        this.g(x + " " + y + " m");
    }

    public void lineto(int x, int y) {
        this.g(x + " " + y + " l");
    }

    private PDFObject newObject(String type) {
        PDFObject o = new PDFObject(++this.count);
        if (type != null) {
            o.addDef("Type", "/" + type);
        }
        this.indirectObjects.addLast(o);
        return o;
    }

    public void addInfo(Map<String, String> data) {
        Hashtable<String, String> info = new Hashtable<String, String>();
        for (Map.Entry<String, String> e : data.entrySet()) {
            String value = "(" + e.getValue().replace(')', '_').replace('(', '_') + ")";
            info.put(e.getKey(), value);
        }
        this.root.addDef("Info", info);
    }

    private PDFObject addFontResource(String fname) {
        PDFObject f = this.newObject("Font");
        this.fonts.put(fname, f);
        f.addDef("BaseFont", fname);
        f.addDef("Encoding", "/WinAnsiEncoding");
        f.addDef("Subtype", "/Type1");
        this.graphics.addResource("Font", f.getID(), f.getRef());
        return f;
    }

    public void addImageResource(Object newImage, int width, int height, int[] buffer, boolean isRGB) {
        PDFObject imageObj = this.newObject("XObject");
        if (this.images == null) {
            this.images = new Hashtable<Object, PDFObject>();
        }
        this.images.put(newImage, imageObj);
        imageObj.addDef("Subtype", "/Image");
        imageObj.addDef("Length", "?");
        imageObj.addDef("ColorSpace", isRGB ? "/DeviceRGB" : "/DeviceGray");
        imageObj.addDef("BitsPerComponent", "8");
        imageObj.addDef("Width", "" + width);
        imageObj.addDef("Height", "" + height);
        this.graphics.addResource("XObject", imageObj.getID(), imageObj.getRef());
        int n = buffer.length;
        byte[] stream = new byte[n * (isRGB ? 3 : 1)];
        if (isRGB) {
            int pt = 0;
            for (int i = 0; i < n; ++i) {
                stream[pt++] = (byte)(buffer[i] >> 16 & 0xFF);
                stream[pt++] = (byte)(buffer[i] >> 8 & 0xFF);
                stream[pt++] = (byte)(buffer[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                stream[i] = (byte)buffer[i];
            }
        }
        imageObj.setStream(stream);
        this.graphics.addResource("XObject", imageObj.getID(), imageObj.getRef());
    }

    public void g(String cmd) {
        this.graphics.append(cmd).appendC('\n');
    }

    private void output(String s) throws IOException {
        byte[] b = s.getBytes();
        this.os.write(b, 0, b.length);
        this.pt += b.length;
    }

    public void closeDocument() throws IOException {
        this.g("Q Q");
        this.outputHeader();
        this.writeObjects();
        this.writeXRefTable();
        this.writeTrailer();
        this.os.flush();
        this.os.close();
    }

    private void outputHeader() throws IOException {
        this.output("%PDF-1.3\n%");
        byte[] b = new byte[]{-1, -1, -1, -1};
        this.os.write(b, 0, b.length);
        this.pt += 4;
        this.output("\n");
    }

    private void writeTrailer() throws IOException {
        PDFObject trailer = new PDFObject(-2);
        this.output("trailer");
        trailer.addDef("Size", "" + this.indirectObjects.size());
        trailer.addDef("Root", this.root.getRef());
        trailer.output(this.os);
        this.output("startxref\n");
        this.output("" + this.xrefPt + "\n");
        this.output("%%EOF\n");
    }

    private void writeObjects() throws IOException {
        PDFObject o;
        int i;
        int nObj = this.indirectObjects.size();
        for (i = 0; i < nObj; ++i) {
            o = (PDFObject)this.indirectObjects.get(i);
            if (!o.isFont()) continue;
            o.pt = this.pt;
            this.pt += o.output(this.os);
        }
        for (i = 0; i < nObj; ++i) {
            o = (PDFObject)this.indirectObjects.get(i);
            if (o.isFont()) continue;
            o.pt = this.pt;
            this.pt += o.output(this.os);
        }
    }

    private void writeXRefTable() throws IOException {
        this.xrefPt = this.pt;
        int nObj = this.indirectObjects.size();
        SB sb = new SB();
        sb.append("xref\n0 " + (nObj + 1) + "\n0000000000 65535 f\r\n");
        for (int i = 0; i < nObj; ++i) {
            PDFObject o = (PDFObject)this.indirectObjects.get(i);
            String s = "0000000000" + o.pt;
            sb.append(s.substring(s.length() - 10));
            sb.append(" 00000 n\r\n");
        }
        this.output(sb.toString());
    }

    public boolean canDoLineTo() {
        return true;
    }

    public void fill() {
        this.g("f");
    }

    public void stroke() {
        this.g("S");
    }

    public void doCircle(int x, int y, int r, boolean doFill) {
        double d = (double)(r * 4) * (Math.sqrt(2.0) - 1.0) / 3.0;
        double dx = x;
        double dy = y;
        this.g(dx + (double)r + " " + dy + " m");
        this.g(dx + (double)r + " " + (dy + d) + " " + (dx + d) + " " + (dy + (double)r) + " " + dx + " " + (dy + (double)r) + "  c");
        this.g(dx - d + " " + (dy + (double)r) + " " + (dx - (double)r) + " " + (dy + d) + " " + (dx - (double)r) + " " + dy + " c");
        this.g(dx - (double)r + " " + (dy - d) + " " + (dx - d) + " " + (dy - (double)r) + " " + dx + " " + (dy - (double)r) + " c");
        this.g(dx + d + " " + (dy - (double)r) + " " + (dx + (double)r) + " " + (dy - d) + " " + (dx + (double)r) + " " + dy + " c");
        this.g(doFill ? "f" : "s");
    }

    public void doPolygon(int[] axPoints, int[] ayPoints, int nPoints, boolean doFill) {
        this.moveto(axPoints[0], ayPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            this.lineto(axPoints[i], ayPoints[i]);
        }
        this.g(doFill ? "f" : "s");
    }

    public void doRect(int x, int y, int width, int height, boolean doFill) {
        this.g(x + " " + y + " " + width + " " + height + " re " + (doFill ? "f" : "s"));
    }

    public void drawImage(Object image, int destX0, int destY0, int destX1, int destY1, int srcX0, int srcY0, int srcX1, int srcY1) {
        PDFObject imageObj = this.images.get(image);
        if (imageObj == null) {
            return;
        }
        this.g("q");
        this.clip(destX0, destY0, destX1, destY1);
        double iw = Double.parseDouble((String)imageObj.getDef("Width"));
        double ih = Double.parseDouble((String)imageObj.getDef("Height"));
        double dw = destX1 - destX0 + 1;
        double dh = destY1 - destY0 + 1;
        double sw = srcX1 - srcX0 + 1;
        double sh = srcY1 - srcY0 + 1;
        double scaleX = dw / sw;
        double scaleY = dh / sh;
        double transX = (double)destX0 - (double)srcX0 * scaleX;
        double transY = (double)destY0 + (ih - (double)srcY0) * scaleY;
        this.g(scaleX * iw + " 0 0 " + -scaleY * ih + " " + transX + " " + transY + " cm");
        this.g("/" + imageObj.getID() + " Do");
        this.g("Q");
    }

    public void drawStringRotated(String s, int x, int y, int angle) {
        this.g("q " + this.getRotation(angle) + " " + x + " " + y + " cm BT(" + s + ")Tj ET Q");
    }

    public String getRotation(int angle) {
        float cos = 0.0f;
        float sin = 0.0f;
        switch (angle) {
            case 0: {
                cos = 1.0f;
                break;
            }
            case 90: {
                sin = 1.0f;
                break;
            }
            case -90: {
                sin = -1.0f;
                break;
            }
            case 180: {
                cos = -1.0f;
                break;
            }
            default: {
                float a = (float)((double)angle * (Math.PI / 180));
                cos = (float)Math.cos(a);
                sin = (float)Math.sin(a);
                if ((double)Math.abs(cos) < 1.0E-4) {
                    cos = 0.0f;
                }
                if (!((double)Math.abs(sin) < 1.0E-4)) break;
                sin = 0.0f;
            }
        }
        return cos + " " + sin + " " + sin + " " + -cos;
    }

    public void setColor(float[] rgb, boolean isFill) {
        this.g(rgb[0] + " " + rgb[1] + " " + rgb[2] + (isFill ? " rg" : " RG"));
    }

    public void setFont(String fname, float size) {
        PDFObject f = this.fonts.get(fname);
        if (f == null) {
            f = this.addFontResource(fname);
        }
        this.g("/" + f.getID() + " " + size + " Tf");
    }

    public void setLineWidth(float width) {
        this.g(width + " w");
    }

    public void translateScale(float x, float y, float scale) {
        this.g(scale + " 0 0 " + scale + " " + x + " " + y + " cm");
    }
}

