/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.io;

import com.junrar.io.SeekableReadOnlyByteChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SeekableReadOnlyFile
implements SeekableReadOnlyByteChannel {
    private final RandomAccessFile file;

    public SeekableReadOnlyFile(File file) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, "r");
    }

    @Override
    public int readFully(byte[] buffer, int count) throws IOException {
        assert (count >= 0) : count;
        this.file.readFully(buffer, 0, count);
        return count;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public long getPosition() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public void setPosition(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public int read(byte[] buffer, int off, int count) throws IOException {
        return this.file.read(buffer, off, count);
    }
}

