/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.util;

import java.io.BufferedReader;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlReader {
    protected Map<String, String> atts = new TreeMap<String, String>();
    protected String myError;
    protected StringBuffer log;
    protected boolean keepChars = true;
    protected StringBuffer chars = new StringBuffer(2000);

    public XmlReader(StringBuffer log) {
        this.log = log == null ? new StringBuffer() : log;
    }

    public StringBuffer getLog() {
        return this.log;
    }

    public String parseXML(BufferedReader reader) throws Exception {
        XMLReader saxReader = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        saxReader = saxParser.getXMLReader();
        saxReader.setFeature("http://xml.org/sax/features/validation", false);
        saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        new XmlHandler().parseXML(this, saxReader, reader);
        return this.myError;
    }

    protected abstract void processStartElement(String var1, String var2);

    protected void setKeepChars(boolean TF) {
        this.keepChars = TF;
        this.chars.setLength(0);
    }

    protected abstract void processEndElement(String var1);

    protected void endDocument() {
    }

    void error(String msg) {
        this.myError = msg;
        this.log.append("\nSAX Error:" + msg);
    }

    void fatalError(String msg) {
        this.myError = msg;
        this.log.append("\nSAX FatalError:" + msg);
    }

    void warn(String msg) {
        this.log.append("\nSAX warning:" + msg);
    }

    private static class XmlHandler
    extends DefaultHandler {
        private XmlReader xmlReader;

        private XmlHandler() {
        }

        void parseXML(XmlReader xmlReader, Object saxReaderObj, BufferedReader reader) throws Exception {
            this.xmlReader = xmlReader;
            XMLReader saxReader = (XMLReader)saxReaderObj;
            saxReader.setFeature("http://xml.org/sax/features/validation", false);
            saxReader.setFeature("http://xml.org/sax/features/namespaces", true);
            saxReader.setEntityResolver(this);
            saxReader.setContentHandler(this);
            saxReader.setErrorHandler(this);
            InputSource is = new InputSource(reader);
            is.setSystemId("foo");
            saxReader.parse(is);
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
            this.xmlReader.endDocument();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String nodeName, Attributes attributes) {
            this.xmlReader.atts.clear();
            int i = attributes.getLength();
            while (--i >= 0) {
                this.xmlReader.atts.put(attributes.getLocalName(i).toLowerCase(), attributes.getValue(i));
            }
            this.xmlReader.processStartElement(localName.toLowerCase(), nodeName.toLowerCase());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.xmlReader.processEndElement(localName.toLowerCase());
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.xmlReader.keepChars) {
                this.xmlReader.chars.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException exception) {
            this.xmlReader.error("SAX ERROR:" + exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.xmlReader.fatalError("SAX FATAL:" + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) {
            this.xmlReader.warn("SAX WARNING:" + exception.getMessage());
        }
    }
}

