/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.test;

import com.integratedgraphics.ifd.vendor.DefaultVendorPlugin;
import com.integratedgraphics.ifd.vendor.jeol.NmrMLJeolAcquStreamReader;
import com.integratedgraphics.ifd.vendor.varian.NmrMLVarianAcquStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.nmrml.parser.Acqu;

public class NmrMLConverterTest {
    public static final void main(String[] args) {
        try {
            FileInputStream fis = NmrMLConverterTest.newStream("test/varian/sucrose_1h/procpar");
            NmrMLVarianAcquStreamReader varian = new NmrMLVarianAcquStreamReader(fis);
            Acqu acq = varian.read();
            fis.close();
            NmrMLConverterTest.setParams(varian.getDimension(), acq);
            fis = NmrMLConverterTest.newStream("test/varian/agilent_2d/procpar");
            varian = new NmrMLVarianAcquStreamReader(fis);
            acq = varian.read();
            fis.close();
            NmrMLConverterTest.setParams(varian.getDimension(), acq);
            String filename = "test/jeol/1d_1d-13C.jdf";
            byte[] bytes = FAIRSpecUtilities.getLimitedStreamBytes(new FileInputStream(filename), -1L, null, true, true);
            NmrMLJeolAcquStreamReader jeol = new NmrMLJeolAcquStreamReader(bytes);
            acq = jeol.read();
            fis.close();
            NmrMLConverterTest.setParams(jeol.getDimension(), acq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static FileInputStream newStream(String f) throws FileNotFoundException {
        String inputFolder = new File(f).getAbsolutePath();
        return new FileInputStream(inputFolder);
    }

    protected static void setParams(int dim, Acqu acq) {
        NmrMLConverterTest.report("DIM", dim);
        double freq = acq.getTransmiterFreq();
        NmrMLConverterTest.report("F1", freq);
        String nuc = acq.getObservedNucleus();
        nuc = DefaultVendorPlugin.fixNucleus(nuc);
        NmrMLConverterTest.report("N1", nuc);
        int nominalFreq = DefaultVendorPlugin.getNominalFrequency(freq, nuc);
        NmrMLConverterTest.report("SF", nominalFreq);
        String solvent = acq.getSolvent();
        NmrMLConverterTest.report("SOLVENT", solvent);
        String pp = acq.getPulseProgram();
        NmrMLConverterTest.report("PP", pp);
        String probe = acq.getProbehead();
        NmrMLConverterTest.report("PROBE", probe);
    }

    private static void report(String key, Object val) {
        System.out.println(key + " = " + val);
    }
}

