/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.test;

import com.integratedgraphics.extractor.IFDExtractor;
import com.integratedgraphics.html.PageCreator;
import com.integratedgraphics.test.ExtractorTest;
import java.io.File;
import java.io.IOException;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;

public class ExtractorTestACS
extends ExtractorTest {
    private static String[] acsTestSet = new String[]{"./extract/acs.joc.0c00770/IFD-extract.json#22567817", "./extract/acs.orglett.0c00571/IFD-extract.json#21975525", "./extract/acs.orglett.0c00624/IFD-extract.json#21947274", "./extract/acs.orglett.0c00755/IFD-extract.json#22150197", "./extract/acs.orglett.0c00788/IFD-extract.json#22125318", "./extract/acs.orglett.0c00874/IFD-extract.json#22233351", "./extract/acs.orglett.0c00967/IFD-extract.json#22111341", "./extract/acs.orglett.0c01022/IFD-extract.json#22195341", "./extract/acs.orglett.0c01043/IFD-extract.json#22232721", "./extract/acs.orglett.0c01153/IFD-extract.json#22284726,22284720", "./extract/acs.orglett.0c01197/IFD-extract.json#22491647", "./extract/acs.orglett.0c01277/IFD-extract.json#22613762", "./extract/acs.orglett.0c01297/IFD-extract.json#22612484", "./extract/acs.orgLett.9b02307/IFD-extract.json#acs.orglett.9b02307.NMR.rar"};

    private static void runACSExtractionTest(String[] args, String findACSID, int first, int last, boolean createFindingAidJSONList) {
        String localSourceArchive = args[1];
        String targetDir = args[2];
        new File(targetDir).mkdirs();
        FAIRSpecUtilities.setLogging(targetDir + "/extractor.log");
        String json = null;
        int i0 = Math.max(0, Math.min(findACSID != null ? 0 : first, last));
        int i1 = Math.min(acsTestSet.length - 1, Math.max(0, Math.max(first, findACSID != null ? acsTestSet.length : last)));
        int failed = 0;
        int n = 0;
        int nWarnings = 0;
        int nErrors = 0;
        String warnings = "";
        IFDExtractor extractor = null;
        String sflags = null;
        String targetDir0 = targetDir;
        for (int i = i0; i <= i1; ++i) {
            String ifdExtractFile;
            String extractInfo = acsTestSet[i];
            if (findACSID != null && !extractInfo.contains(findACSID)) continue;
            extractor = new IFDExtractor();
            extractor.logToSys("Extractor.runExtractionTest output to " + new File(targetDir).getAbsolutePath());
            extractor.logToSys("Extractor.runExtraction " + i + " " + extractInfo);
            int pt = extractInfo.indexOf("#");
            if (pt == 0) {
                ifdExtractFile = null;
                System.out.println("Ignoring " + extractInfo);
                continue;
            }
            ifdExtractFile = pt > 0 ? extractInfo.substring(0, pt) : extractInfo;
            String targetSubDirectory = new File(ifdExtractFile).getParentFile().getName();
            if (targetSubDirectory.length() > 0) {
                targetDir = targetDir0 + "/" + targetSubDirectory;
            }
            ++n;
            json = json == null ? "{\"findingaids\":[\n" : json + ",\n";
            json = json + "\"" + targetDir + "/IFD.findingaid.json\"";
            long t0 = System.currentTimeMillis();
            extractor.testID = i;
            extractor.processFlags(args, null);
            new File(targetDir).mkdirs();
            try {
                File ifdExtractScriptFile = new File(ifdExtractFile).getAbsoluteFile();
                File targetPath = new File(targetDir).getAbsoluteFile();
                String sourcePath = localSourceArchive == null || "-".equals(localSourceArchive) ? "-" : new File(localSourceArchive).getAbsolutePath();
                extractor.run(ifdExtractScriptFile, targetPath, sourcePath);
                extractor.logToSys("Extractor.runExtraction ok " + extractInfo);
            }
            catch (Exception e) {
                ++failed;
                extractor.logErr("Exception " + e + " " + i, "runExtraction");
                e.printStackTrace();
                if (extractor.stopOnAnyFailure) break;
            }
            if (extractor.assetsOnly) continue;
            nWarnings += extractor.warnings;
            nErrors += extractor.errors;
            extractor.logToSys("!Extractor.runExtraction job " + extractInfo + " time/sec=" + (double)(System.currentTimeMillis() - t0) / 1000.0);
            ifdExtractFile = null;
            if (extractor.warnings <= 0) continue;
            warnings = warnings + "======== " + i + ": " + extractor.warnings + " warnings for " + targetDir + "\n" + extractor.strWarnings;
            try {
                FAIRSpecUtilities.writeBytesToFile(warnings.getBytes(), new File(targetDir0 + "/_IFD_warnings.txt"));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (extractor != null) {
            if (createFindingAidJSONList) {
                createFindingAidJSONList = !extractor.debugReadOnly && (first != last || first < 0);
            }
            sflags = "\n first = " + first + " last = " + last + "\n" + extractor.dumpFlags() + "\n createFindingAidJSONList = " + createFindingAidJSONList + "\n IFD version " + IFDConst.IFD_VERSION + "\n";
            if (!createFindingAidJSONList) {
                json = null;
            } else if (json != null) {
                json = json + "\n]}\n";
            }
            File htmlPath = new File(targetDir0);
            try {
                if (json != null) {
                    PageCreator.buildSite(htmlPath, true, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            extractor.setTargetPath(htmlPath);
            extractor.finalizeExtraction(json, n, failed, nWarnings, nErrors, sflags);
        }
        FAIRSpecUtilities.setLogging(null);
    }

    protected static String[] setSourceTargetArgs(String[] args, String ifdExtractJSONFilename, String localSourceArchive, String targetDir, String flags) {
        if (args == null) {
            args = new String[]{};
        }
        String[] a = new String[Math.max(4, args.length)];
        a[0] = args.length < 1 || args[0] == null ? ifdExtractJSONFilename : args[0];
        a[1] = args.length < 2 || args[1] == null ? localSourceArchive : args[1];
        a[2] = args.length < 3 || args[2] == null ? targetDir : args[2];
        a[3] = args.length < 4 || args[3] == null ? flags : args[3];
        for (int i = 4; i < args.length; ++i) {
            a[i] = args[i];
        }
        return a;
    }

    public static void main(String[] args) {
        int first = 0;
        int last = 13;
        String findACSID = null;
        String flags = null;
        String localSourceArchive = "c:/temp/iupac/zip";
        String targetDir = "c:/temp/iupac/ifd2024";
        args = ExtractorTestACS.setSourceTargetArgs(args, null, localSourceArchive, targetDir, flags);
        boolean createFindingAidJSONList = true;
        ExtractorTestACS.runACSExtractionTest(args, findACSID, first, last, createFindingAidJSONList);
    }
}

