/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.varian;

import com.integratedgraphics.ifd.vendor.nmrml.NmrMLIFDVendorPlugin;
import com.integratedgraphics.ifd.vendor.varian.NmrMLVarianAcquStreamReader;
import java.io.ByteArrayInputStream;
import org.iupac.fairdata.extract.MetadataReceiverI;

public class VarianIFDVendorPlugin
extends NmrMLIFDVendorPlugin {
    public VarianIFDVendorPlugin() {
        this.paramRegex = "procpar$";
        this.rezipRegex = "procpar";
    }

    @Override
    public String accept(MetadataReceiverI extractor, String originPath, byte[] bytes) {
        super.accept(extractor, originPath, bytes);
        try {
            NmrMLVarianAcquStreamReader varian = new NmrMLVarianAcquStreamReader(new ByteArrayInputStream(bytes));
            this.setParams(varian, varian.read());
            return this.processRepresentation(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getVendorName() {
        return "Varian";
    }

    @Override
    public String processRepresentation(String originPath, byte[] bytes) {
        return IFD_REP_DATAOBJECT_FAIRSPEC_NMR_VENDOR_DATASET;
    }

    static {
        VarianIFDVendorPlugin.register(VarianIFDVendorPlugin.class);
    }
}

