/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.ExtractorUtils;
import com.integratedgraphics.extractor.IFDExtractor;
import com.integratedgraphics.extractor.IFDExtractorLayer0;
import com.integratedgraphics.ifd.api.VendorPluginI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.util.JSJSONParser;

abstract class IFDExtractorLayer1
extends IFDExtractorLayer0 {
    private String extractVersion;
    private String userStructureFilePattern;

    IFDExtractorLayer1() {
    }

    protected boolean processPhase1(File ifdExtractScriptFile, String localArchive) throws IOException, IFDException {
        this.phase1SetLocalSourceDir(localArchive);
        this.extractScriptFile = ifdExtractScriptFile;
        this.extractScriptFileDir = this.extractScriptFile.getParent();
        this.log("!Extracting " + ifdExtractScriptFile.getAbsolutePath());
        this.extractScript = FAIRSpecUtilities.getFileStringData(ifdExtractScriptFile);
        this.objectParsers = this.phase1ParseScript(this.extractScript);
        if (!this.processPubURI()) {
            return false;
        }
        this.phase1SetCachePattern(this.userStructureFilePattern);
        this.rezipCachePattern = this.phase1SetRezipCachePattern(null, null);
        return true;
    }

    private List<ExtractorUtils.ObjectParser> phase1GetObjectParsers(List<Object> jsonArray) throws IFDException, MalformedURLException, IOException {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<ExtractorUtils.ObjectParser> parsers = new ArrayList<ExtractorUtils.ObjectParser>();
        ArrayList<Object> ignored = new ArrayList<Object>();
        ArrayList<Object> rejected = new ArrayList<Object>();
        ArrayList<Object> accepted = new ArrayList<Object>();
        ExtractorUtils.ExtractorResource source = null;
        boolean isDefaultStructurePath = false;
        List replacements = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object o = jsonArray.get(i);
            if (o instanceof String) {
                if (!o.equals("EXIT")) continue;
                break;
            }
            Map directives = (Map)o;
            for (Map.Entry entry : directives.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("#")) continue;
                o = entry.getValue();
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_METADATA)) {
                    if (o instanceof Map) {
                        this.phase1ProcessMetadataElement(o);
                        continue;
                    }
                    if (o instanceof List) {
                        for (Object m : (List)o) {
                            this.phase1ProcessMetadataElement(m);
                        }
                        continue;
                    }
                    this.logWarn("extractor template METADATA element is not a map or array", "Extractor.getObjectParsers");
                    continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_REPLACEMENTS)) {
                    replacements = (List)o;
                    continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_ACCEPT)) {
                    if (o instanceof String) {
                        accepted.add(o);
                        continue;
                    }
                    accepted.addAll((List)o);
                    continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_REJECT)) {
                    if (o instanceof String) {
                        rejected.add(o);
                        continue;
                    }
                    rejected.addAll((List)o);
                    continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_IGNORE)) {
                    if (o instanceof String) {
                        ignored.add(o);
                        continue;
                    }
                    ignored.addAll((List)o);
                    continue;
                }
                String val = o.toString();
                if (val.indexOf("{") >= 0) {
                    String s = FAIRSpecUtilities.replaceStrings(val, keys, values);
                    if (!s.equals(val)) {
                        if (this.debugging) {
                            this.log(val + "\n" + s + "\n");
                        }
                        entry.setValue(s);
                    }
                    val = s;
                }
                this.log("!" + key + " = " + val);
                String keyDef = null;
                int pt = key.indexOf("=");
                if (pt > 0) {
                    keyDef = key.substring(0, pt);
                    key = key.substring(pt + 1);
                }
                if (key.equals(FAIRSPEC_EXTRACTOR_REFERENCES)) {
                    val = FAIRSpecUtilities.getFileStringData(new File(this.toAbsolutePath(val)));
                    this.log("!processing " + val);
                    HashMap<String, Map> htCompoundFileReferences = new HashMap<String, Map>();
                    List jsonMap = (List)new JSJSONParser().parse(val, false);
                    int j = jsonMap.size();
                    while (--j >= 0) {
                        Map jm = (Map)jsonMap.get(j);
                        String file = (String)jm.get("file");
                        String cmpd = (String)jm.get("cmpd");
                        htCompoundFileReferences.put(cmpd + (file == null ? "" : "|" + file), jm);
                    }
                    this.htURLReferences = htCompoundFileReferences;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_LOCAL_SOURCE_FILE)) {
                    String string = this.localSourceFile = val.length() == 0 ? null : val;
                    if (this.localSourceDir == null) continue;
                    this.localSourceFile = this.localSourceDir + "/" + this.localSourceFile;
                    continue;
                }
                if (key.equals(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_URI)) {
                    String local;
                    boolean isFoundLocal;
                    boolean isRemote = val.startsWith("http");
                    boolean isRelative = val.startsWith("./");
                    if (isRelative) {
                        this.localSourceFile = null;
                    }
                    boolean bl = isFoundLocal = (local = this.localizeURL(val)).startsWith("file:/") && new File(local.substring(6)).exists();
                    if (isFoundLocal) {
                        this.localSourceFile = this.localizeURL(val);
                    } else {
                        source = null;
                        isDefaultStructurePath = IFDExtractorLayer1.isDefaultStructurePath(val);
                        String msg = "local source directory does not exist (ignored): " + val;
                        if (isDefaultStructurePath) {
                            this.logNote(msg, "phase1CheckSource");
                        } else {
                            this.logWarn(msg, "phase1CheckSource");
                        }
                        if (isDefaultStructurePath) continue;
                    }
                    source = (ExtractorUtils.ExtractorResource)this.htResources.get(val);
                    if (source == null) {
                        source = new ExtractorUtils.ExtractorResource(this.htResources.size() + 1, this.localSourceFile == null || isRelative ? val : null);
                        this.htResources.put(val, source);
                    }
                    source.setLocalSourceFileName(this.localSourceFile == null ? null : this.localizeURL(null));
                    if (!isRemote) continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_OBJECT)) {
                    if (source == null) {
                        if (isDefaultStructurePath) continue;
                        throw new IFDException(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_URI + " was not set before " + val);
                    }
                    ExtractorUtils.ObjectParser parser = this.newObjectParser(source, val);
                    parser.setReplacements(replacements);
                    parsers.add(parser);
                    continue;
                }
                if (key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_RELATED_METADATA)) {
                    this.ifdMetadataFileName = val;
                }
                if (key.startsWith(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_OPTION_FLAG) || key.equals(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_OPTIONS)) {
                    this.setExtractorOption(key, val);
                    continue;
                }
                if (key.startsWith(IFDConst.IFD_PROPERTY_FLAG)) {
                    if (key.equals(IFDConst.IFD_PROPERTY_COLLECTIONSET_ID)) {
                        this.ifdid = val;
                        this.faHelper.getFindingAid().setID(this.ifdid);
                    }
                    if (key.equals(IFDConst.IFD_PROPERTY_COLLECTIONSET_BYID)) {
                        this.setExtractorOption(key, val);
                        continue;
                    }
                    this.faHelper.getFindingAid().setPropertyValue(key, val);
                    if (keyDef == null) continue;
                }
                keys.add(0, "{" + (keyDef == null ? key : keyDef) + "}");
                values.add(0, val);
            }
        }
        this.faHelper.getFindingAid().setID(this.ifdid);
        String s = "";
        if (rejected.size() > 0) {
            for (int i = 0; i < rejected.size(); ++i) {
                s = s + "(" + rejected.get(i) + ")|";
            }
        }
        this.lstRejected.setAcceptPattern(FAIRSpecUtilities.rep(s, ".", "\\.") + FAIRSpecExtractorHelper.junkFilePattern);
        if (accepted.size() > 0) {
            s = "";
            for (int i = 0; i < accepted.size(); ++i) {
                s = s + "|(" + accepted.get(i) + ")";
            }
            this.acceptRegex = FAIRSpecUtilities.rep(s.substring(1), ".", "\\.");
            this.lstAccepted.setAcceptPattern(this.acceptRegex);
        } else {
            this.acceptRegex = null;
        }
        if (ignored.size() > 0) {
            s = "";
            for (int i = 0; i < ignored.size(); ++i) {
                s = s + "|(" + ignored.get(i) + ")";
            }
            this.ignoreRegex = FAIRSpecUtilities.rep(s.substring(1), ".", "\\.");
        } else {
            this.ignoreRegex = null;
        }
        return parsers;
    }

    private List<ExtractorUtils.ObjectParser> phase1ParseScript(String script) throws IOException, IFDException {
        List defaultScripts;
        if (this.faHelper != null) {
            throw new IFDException("Only one finding aid per instance of Extractor is allowed (for now).");
        }
        this.helper = this.newExtractionHelper();
        this.faHelper = this.helper;
        Map jsonMap = (Map)new JSJSONParser().parse(script, false);
        if (this.debugging) {
            this.log(jsonMap.toString());
        }
        this.extractVersion = (String)jsonMap.get(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACT_VERSION);
        if (IFDExtractorLayer1.logging()) {
            this.log(this.extractVersion);
        }
        List scripts = (List)jsonMap.get("keys");
        if (this.config != null && (defaultScripts = (List)this.config.get("defaultScripts")) != null) {
            scripts.addAll(defaultScripts);
        }
        List<ExtractorUtils.ObjectParser> objectParsers = this.phase1GetObjectParsers(scripts);
        if (IFDExtractorLayer1.logging()) {
            this.log(objectParsers.size() + " extractor regex strings");
        }
        this.log("!license: " + this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_NAME) + " at " + this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_LICENSE_URI));
        return objectParsers;
    }

    private void phase1ProcessMetadataElement(Object m) throws IFDException {
        Map map = (Map)m;
        String key = (String)map.get("FOR");
        if (key == null) {
            throw new IFDException("extractor template METADATA element does not contain 'FOR' key in " + m);
        }
        if (this.htSpreadsheetMetadata == null) {
            this.htSpreadsheetMetadata = new HashMap();
        }
        this.htSpreadsheetMetadata.put(key, map);
        if (key.startsWith("IFD.")) {
            String fileName = (String)map.get(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_METADATA_FILE);
            if (fileName == null) {
                this.logWarn("METADATA extraction map did not contain the key " + FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_METADATA_FILE, "phase1ProcessMetadataElement");
            } else {
                String err = FAIRSpecUtilities.loadFileMetadata(key, map, fileName = this.toAbsolutePath(fileName));
                if (err != null) {
                    this.logWarn(err + " loading " + fileName, "loadFileMetadata");
                }
            }
        }
    }

    private void phase1SetCachePattern(String sp) {
        if (sp == null) {
            sp = "(?<img>\\.pdf$|\\.png$)|" + this.getStructurePropertyManager().getParamRegex();
        } else if (sp.length() == 0) {
            sp = "(?<img>\n)|(?<struc>\n)";
        }
        String s = "";
        for (int i = 0; i < VendorPluginI.activeVendors.size(); ++i) {
            String cp = VendorPluginI.activeVendors.get((int)i).vcache;
            if (cp == null) continue;
            this.bsPropertyVendors.set(i);
            s = s + "|" + cp;
        }
        if (s.length() > 0) {
            s = "(?<param>" + s.substring(1) + ")|" + sp;
            this.cachePatternHasVendors = true;
        } else {
            s = sp;
        }
        this.vendorCachePattern = Pattern.compile("(?<ext>" + s + ")");
        this.vendorCache = new LinkedHashMap();
    }

    private void phase1SetLocalSourceDir(String sourceDir) {
        if ("-".equals(sourceDir)) {
            sourceDir = null;
        }
        if (sourceDir != null && sourceDir.indexOf("://") < 0) {
            sourceDir = "file:///" + sourceDir.replace('\\', '/');
        }
        this.localSourceDir = sourceDir;
    }

    private Pattern phase1SetRezipCachePattern(String procs, String toExclude) {
        String s = "";
        for (int i = 0; i < VendorPluginI.activeVendors.size(); ++i) {
            String cp = VendorPluginI.activeVendors.get((int)i).vrezip;
            if (cp == null) continue;
            this.bsRezipVendors.set(i);
            s = s + "|" + cp;
        }
        s = s + (procs == null ? "" : "|" + procs);
        return s.length() == 0 ? null : Pattern.compile(s.substring(1));
    }

    private ExtractorUtils.ObjectParser newObjectParser(ExtractorUtils.ExtractorResource source, String sObj) throws IFDException {
        return new ExtractorUtils.ObjectParser((IFDExtractor)this, source, sObj);
    }

    protected String toAbsolutePath(String fname) {
        if (fname.startsWith("./")) {
            fname = this.extractScriptFileDir.replace('\\', '/') + fname.substring(1);
        }
        return fname;
    }

    protected String localizeURL(String sUrl) throws IFDException {
        if (sUrl == null) {
            sUrl = this.localSourceFile;
        } else {
            boolean isRelative;
            boolean bl = isRelative = sUrl != null && (sUrl.startsWith("./") || sUrl.indexOf("/./") >= 0);
            if (!isRelative && this.localSourceDir != null) {
                if (FAIRSpecUtilities.isZip(this.localSourceDir)) {
                    sUrl = this.localSourceDir;
                } else if (this.localSourceDir.endsWith("/*")) {
                    sUrl = this.localSourceDir.substring(0, this.localSourceDir.length() - 1);
                } else {
                    int pt = sUrl.lastIndexOf("/");
                    if (pt >= 0 && !FAIRSpecUtilities.isZip(sUrl = this.localSourceDir + sUrl.substring(pt)) && !sUrl.endsWith("/")) {
                        sUrl = sUrl + ".zip";
                    }
                }
            }
        }
        sUrl = this.toAbsolutePath(sUrl);
        if (sUrl.indexOf("//") < 0 && !sUrl.startsWith("file:/")) {
            sUrl = "file:/" + sUrl;
        }
        return sUrl;
    }

    private static boolean isDefaultStructurePath(String val) {
        return "./structures/".equals(val) || "./structures.zip".equals(val);
    }
}

