/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel.table;

import com.actelion.research.calc.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableModelString {
    private static final String SEP_FIELD = "\t";
    private static final String SEP_LINE = "\n";
    private static final String SEP_FIELD_LATEX = " &\t";
    private static final String SEP_LINE_LATEX = " \\\\\n";
    private List<String> liColName;
    private List<String> liRowName;
    private List<List<String>> liliData;
    private HashMap<String, Integer> hmRowName_Index;
    private HashMap<String, Integer> hmColName_Index;

    public TableModelString() {
        this.init();
    }

    public TableModelString(int n, int n2) {
        this.init();
        this.init(n, n2);
    }

    public TableModelString(List<String> list, List<String> list2) {
        int n;
        this.init();
        this.init(list.size(), list2.size());
        for (n = 0; n < list.size(); ++n) {
            this.setRowName(n, list.get(n));
        }
        for (n = 0; n < list2.size(); ++n) {
            this.setColName(n, list2.get(n));
        }
    }

    public boolean containsColumn(String string) {
        return this.hmColName_Index.get(string) != null;
    }

    private void init() {
        this.liColName = new ArrayList<String>();
        this.liRowName = new ArrayList<String>();
        this.liliData = new ArrayList<List<String>>();
        this.hmRowName_Index = new HashMap();
        this.hmColName_Index = new HashMap();
    }

    private void init(int n, int n2) {
        int n3;
        this.liliData.clear();
        this.liColName.clear();
        this.liRowName.clear();
        this.hmRowName_Index.clear();
        this.hmColName_Index.clear();
        for (n3 = 0; n3 < n; ++n3) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(null);
            }
            this.liliData.add(arrayList);
            this.liRowName.add("");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.liColName.add("");
        }
    }

    public String getColName(int n) {
        return this.liColName.get(n);
    }

    public void setColName(int n, String string) {
        this.liColName.set(n, string);
        this.hmColName_Index.put(string, n);
    }

    public String getRowName(int n) {
        return this.liRowName.get(n);
    }

    public void setRowName(int n, String string) {
        this.liRowName.set(n, string);
        this.hmRowName_Index.put(string, n);
    }

    public void set(int n, int n2, String string) {
        this.liliData.get(n).set(n2, string);
    }

    public void set(Matrix matrix, int n) {
        int n2 = this.liRowName.size();
        int n3 = this.liColName.size();
        String string = "";
        if (n > 0) {
            string = string + ".";
        }
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.set(i, j, decimalFormat.format(matrix.get(i, j)));
            }
        }
    }

    public void set(String string, String string2, String string3) {
        int n = this.hmRowName_Index.get(string);
        int n2 = this.hmColName_Index.get(string2);
        this.liliData.get(n).set(n2, string3);
    }

    public String get(int n, int n2) {
        return this.liliData.get(n).get(n2);
    }

    public int getRows() {
        return this.liliData.size();
    }

    public int getCols() {
        if (this.getRows() == 0) {
            return 0;
        }
        return this.liliData.get(0).size();
    }

    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[this.liColName.size()];
        int n3 = 0;
        for (n2 = 0; n2 < this.liRowName.size(); ++n2) {
            n3 = Math.max(n3, this.liRowName.get(n2).length());
        }
        for (n2 = 0; n2 < this.liColName.size(); ++n2) {
            nArray[n2] = Math.max(nArray[n2], this.liColName.get(n2).length());
            for (int i = 0; i < this.liRowName.size(); ++i) {
                String string = this.get(i, n2);
                if (string != null) {
                    nArray[n2] = Math.max(nArray[n2], string.length());
                    continue;
                }
                System.out.println("TableModelString toString() no value for field: row [" + i + "] " + this.liRowName.get(i) + ", and col [" + n2 + "] " + this.liColName.get(n2) + ".");
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(SEP_FIELD);
        for (n2 = 0; n2 < this.liColName.size(); ++n2) {
            String string = this.liColName.get(n2);
            int n4 = nArray[n2] - string.length();
            for (n = 0; n < n4; ++n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            if (n2 >= this.liColName.size() - 1) continue;
            stringBuilder.append(SEP_FIELD);
        }
        stringBuilder.append(SEP_LINE);
        for (n2 = 0; n2 < this.liRowName.size(); ++n2) {
            String string = this.liRowName.get(n2);
            int n5 = n3 - string.length();
            for (n = 0; n < n5; ++n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            stringBuilder.append(SEP_FIELD);
            for (n = 0; n < this.liColName.size(); ++n) {
                String string2 = this.get(n2, n);
                if (string2 == null) {
                    string2 = "";
                }
                n5 = nArray[n] - string2.length();
                for (int i = 0; i < n5; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string2);
                if (n >= this.liColName.size() - 1) continue;
                stringBuilder.append(SEP_FIELD);
            }
            if (n2 >= this.liRowName.size() - 1) continue;
            stringBuilder.append(SEP_LINE);
        }
        return stringBuilder.toString();
    }

    public String toStringLaTex() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\begin{table}[]");
        stringBuilder.append(SEP_LINE);
        String string = "l";
        for (int i = 0; i < this.liColName.size(); ++i) {
            string = string + "l";
        }
        stringBuilder.append("\\begin{tabular}{" + string + "}");
        stringBuilder.append(SEP_LINE);
        int[] nArray = new int[this.liColName.size()];
        int n3 = 0;
        for (n2 = 0; n2 < this.liRowName.size(); ++n2) {
            n3 = Math.max(n3, this.liRowName.get(n2).length());
        }
        for (n2 = 0; n2 < this.liColName.size(); ++n2) {
            nArray[n2] = Math.max(nArray[n2], this.liColName.get(n2).length());
            for (int i = 0; i < this.liRowName.size(); ++i) {
                String string2 = this.get(i, n2);
                nArray[n2] = Math.max(nArray[n2], string2.length());
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(SEP_FIELD_LATEX);
        for (n2 = 0; n2 < this.liColName.size(); ++n2) {
            String string3 = this.liColName.get(n2);
            int n4 = nArray[n2] - string3.length();
            for (n = 0; n < n4; ++n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string3);
            if (n2 >= this.liColName.size() - 1) continue;
            stringBuilder.append(SEP_FIELD_LATEX);
        }
        stringBuilder.append(SEP_LINE_LATEX);
        for (n2 = 0; n2 < this.liRowName.size(); ++n2) {
            String string4 = this.liRowName.get(n2);
            int n5 = n3 - string4.length();
            for (n = 0; n < n5; ++n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string4);
            stringBuilder.append(SEP_FIELD_LATEX);
            for (n = 0; n < this.liColName.size(); ++n) {
                String string5 = this.get(n2, n);
                n5 = nArray[n] - string5.length();
                for (int i = 0; i < n5; ++i) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string5);
                if (n >= this.liColName.size() - 1) continue;
                stringBuilder.append(SEP_FIELD_LATEX);
            }
            if (n2 >= this.liRowName.size() - 1) continue;
            stringBuilder.append(SEP_LINE_LATEX);
        }
        stringBuilder.append(SEP_LINE);
        stringBuilder.append("\\end{tabular}");
        stringBuilder.append(SEP_LINE);
        stringBuilder.append("\\end{table}");
        return stringBuilder.toString();
    }

    public void write(File file, String string) throws IOException {
        int n;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.write(SEP_FIELD);
        for (n = 0; n < this.liColName.size(); ++n) {
            bufferedWriter.write(this.liColName.get(n));
            if (n >= this.liColName.size() - 1) continue;
            bufferedWriter.write(SEP_FIELD);
        }
        bufferedWriter.write(SEP_LINE);
        for (n = 0; n < this.liRowName.size(); ++n) {
            bufferedWriter.write(this.liRowName.get(n));
            bufferedWriter.write(SEP_FIELD);
            List<String> list = this.liliData.get(n);
            for (int i = 0; i < list.size(); ++i) {
                bufferedWriter.write(list.get(i));
                if (n >= list.size() - 1) continue;
                bufferedWriter.write(SEP_FIELD);
            }
            if (n >= this.liRowName.size() - 1) continue;
            bufferedWriter.write(SEP_LINE);
        }
        bufferedWriter.close();
    }
}

