/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.datamodel.IntArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class IntVec
implements Comparable<IntVec> {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    public static final int LEN_INTEGER_BYTES = 4;
    public static final int MASK_FIRST_BYTE = 255;
    public static final int MASK_SEC_BYTE = 65280;
    public static final int MASK_THIRD_BYTE = 0xFF0000;
    public static final int MASK_FOURTH_BYTE = -16777216;
    public static final int MASK_INVERSE_FIRST_BYTE = -256;
    public static final int MASK_INVERSE_SEC_BYTE = -65281;
    public static final int MASK_INVERSE_THIRD_BYTE = -16711681;
    public static final int MASK_INVERSE_FOURTH_BYTE = 0xFFFFFF;
    private int[] data;
    private int hash;

    public IntVec() {
    }

    public IntVec(IntVec intVec) {
        this(intVec.data);
    }

    public IntVec(int n) {
        this.init();
        this.data = new int[n];
    }

    public IntVec(int[] nArray) {
        this.init();
        this.data = new int[nArray.length];
        System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        this.calculateHashCode();
    }

    public IntVec(int[] nArray, boolean bl) {
        this.init();
        int n = (nArray.length + 32 - 1) / 32;
        this.data = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 1) {
                this.setBit(i);
                continue;
            }
            if (nArray[i] <= 1 && nArray[i] >= 0) continue;
            throw new RuntimeException("abs(value) in array larger than one, no binary data");
        }
    }

    public IntVec(boolean[] blArray) {
        this.init();
        int n = (blArray.length + 32 - 1) / 32;
        this.data = new int[n];
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            this.setBit(i);
        }
    }

    public IntVec(List<Integer> list) {
        this.init();
        this.data = new int[list.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = list.get(i);
        }
    }

    public IntVec add(IntVec intVec) {
        IntVec intVec2 = new IntVec(this.data.length);
        if (this.data.length != intVec.data.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < intVec2.data.length; ++i) {
            intVec2.data[i] = this.data[i] + intVec.data[i];
        }
        return intVec2;
    }

    public void copy(IntVec intVec) {
        System.arraycopy(intVec.data, 0, this.data, 0, this.data.length);
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.hash = -1;
    }

    @Override
    public int compareTo(IntVec intVec) {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > intVec.data[i]) {
                n = 1;
                break;
            }
            if (this.data[i] >= intVec.data[i]) continue;
            n = -1;
            break;
        }
        return n;
    }

    public static IntVec devide(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] / intVec2.data[i];
        }
        return intVec3;
    }

    public boolean equal(IntVec intVec) {
        boolean bl = true;
        if (this.size() != intVec.size()) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == intVec.data[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        return this.equal((IntVec)object);
    }

    public static double getEuclidDist(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            d2 += (double)((intVec.data[i] - intVec2.data[i]) * (intVec.data[i] - intVec2.data[i]));
        }
        d = Math.sqrt(d2);
        return d;
    }

    public static double getEuclidDistBitWise(IntVec intVec, IntVec intVec2) {
        int n = 0;
        for (int i = 0; i < intVec.data.length; ++i) {
            n += Integer.bitCount(intVec.data[i] ^ intVec2.data[i]);
        }
        return Math.sqrt(n);
    }

    public static double getEuclidDistFast(IntVec intVec, IntVec intVec2) throws ArrayIndexOutOfBoundsException {
        if (intVec.data.length != intVec2.data.length) {
            String string = "Length double vector 1: " + intVec.data.length + "Length double vector 2: " + intVec2.data.length + "\n";
            throw new ArrayIndexOutOfBoundsException(string);
        }
        double d = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            d += (double)((intVec.data[i] - intVec2.data[i]) * (intVec.data[i] - intVec2.data[i]));
        }
        return d;
    }

    public static IntVec OR(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] | intVec2.data[i];
        }
        intVec3.calculateHashCode();
        return intVec3;
    }

    public static IntVec OR(List<IntVec> list) {
        IntVec intVec = new IntVec(list.get(0));
        int n = intVec.data.length;
        for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < n; ++j) {
                intVec.data[j] = intVec.data[j] | list.get((int)i).data[j];
            }
        }
        intVec.calculateHashCode();
        return intVec;
    }

    public static IntVec AND(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] & intVec2.data[i];
        }
        intVec3.calculateHashCode();
        return intVec3;
    }

    public static int[] getRND(int n) {
        int[] nArray = new int[n];
        return nArray;
    }

    public int[] get() {
        return this.data;
    }

    public int getByte(int n) {
        return IntVec.getByte(this.data, n);
    }

    public static int getByte(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n / 4;
        int n4 = n % 4;
        switch (n4) {
            case 3: {
                n2 = nArray[n3] & 0xFF;
                break;
            }
            case 2: {
                n2 = nArray[n3] & 0xFF00;
                n2 >>>= 8;
                break;
            }
            case 1: {
                n2 = nArray[n3] & 0xFF0000;
                n2 >>>= 16;
                break;
            }
            case 0: {
                n2 = nArray[n3] & 0xFF000000;
                n2 >>>= 24;
            }
        }
        return n2;
    }

    public byte[] getByteVec() {
        return IntVec.getByteVec(this.data);
    }

    public static byte[] getByteVec(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        byArray[0] = (byte)(n & 0xFF);
        n2 = n & 0xFF00;
        byArray[1] = (byte)(n2 >>> 8);
        n2 = n & 0xFF0000;
        byArray[2] = (byte)(n2 >>> 16);
        n2 = n & 0xFF000000;
        byArray[3] = (byte)(n2 >>> 24);
        return byArray;
    }

    public static byte[] getByteVec(int[] nArray) {
        int n = 4;
        byte[] byArray = new byte[nArray.length * n];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = 0;
            int n4 = i * n;
            byArray[n4 + 0] = (byte)(n2 & 0xFF);
            n3 = n2 & 0xFF00;
            byArray[n4 + 1] = (byte)(n3 >>> 8);
            n3 = n2 & 0xFF0000;
            byArray[n4 + 2] = (byte)(n3 >>> 16);
            n3 = n2 & 0xFF000000;
            byArray[n4 + 3] = (byte)(n3 >>> 24);
        }
        return byArray;
    }

    public static int getSizeForBits(int n) {
        int n2 = 0;
        n2 = (n + 32 - 1) / 32;
        return n2;
    }

    public static int getNumberAbove(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            ++n2;
        }
        return n2;
    }

    public static int getInt(byte[] byArray) {
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = 0xFF & byArray[3];
        int n5 = n;
        int n6 = n5 | (n2 <<= 8);
        int n7 = n6 | (n3 <<= 16);
        int n8 = n7 | (n4 <<= 24);
        return n8;
    }

    public int getBitsSet() {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            n += Integer.bitCount(this.data[i]);
        }
        return n;
    }

    public int[] getByteWise() {
        int n = this.size() * 4;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getByte(i);
        }
        return nArray;
    }

    public int[] getBitWise() {
        int n = this.size() * 32;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.isBitSet(i) ? 1 : 0;
        }
        return nArray;
    }

    public static int[] extractForGivenResolution(IntVec intVec, int n, int n2) {
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!intVec.isBitSet(n3++)) continue;
                n4 |= 1 << j;
            }
            nArray[i] = n4;
        }
        return nArray;
    }

    public boolean allFieldsEquals(int n) {
        boolean bl = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == n) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public int get(int n) {
        return this.data[n];
    }

    public double getNorm() {
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            d += (double)(this.data[i] * this.data[i]);
        }
        d = Math.sqrt(d);
        return d;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.calculateHashCode();
        }
        return this.hash;
    }

    public void calculateHashCode() {
        this.hash = this.data.length == 1 ? this.data[0] : BurtleHasher.hashlittle(this.data, 13L);
    }

    public static double getCosine(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            d += (double)(intVec.data[i] * intVec2.data[i]);
            d2 += (double)(intVec.data[i] * intVec.data[i]);
            d3 += (double)(intVec2.data[i] * intVec2.data[i]);
        }
        double d4 = Math.sqrt(d) / (Math.sqrt(d2) * Math.sqrt(d3));
        return d4;
    }

    public static double cubicDistance(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            double d2 = Math.abs(intVec.data[i] - intVec2.data[i]);
            d += d2 * d2 * d2;
        }
        return d;
    }

    public static int calculateHashCode(IntVec intVec) {
        int n = 0;
        int n2 = intVec.size() * 4;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)intVec.getByte(i);
        }
        n = BurtleHasher.hashlittle(byArray, 13L);
        return n;
    }

    private static int[] convert(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.replaceAll("'", "");
            try {
                int n2;
                nArray[n] = n2 = (int)Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("No number: " + string2 + ".");
                numberFormatException.printStackTrace();
            }
            ++n;
        }
        return nArray;
    }

    public static IntVec readBitStringDense(String string) {
        int n = string.length();
        if (n % 32 != 0) {
            throw new RuntimeException("Wrong size (" + n + ") of string for coversion.");
        }
        int n2 = n / 32;
        IntVec intVec = new IntVec(n2);
        for (int i = 0; i < n; ++i) {
            int n3 = n - i - 1;
            if (string.charAt(n3) == '1') {
                intVec.setBit(i);
                continue;
            }
            if (string.charAt(n3) == '0') continue;
            throw new RuntimeException("Illegal character.");
        }
        return intVec;
    }

    private void init() {
        this.hash = -1;
    }

    public static double manhattanBlockDistance(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            d2 += (double)Math.abs(intVec.data[i] - intVec2.data[i]);
        }
        d = Math.sqrt(d2);
        return d;
    }

    public IntVec mult(double d) {
        IntVec intVec = new IntVec(this.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec.data[i] = (int)((double)this.data[i] * d);
        }
        return intVec;
    }

    public static double mult(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            d += (double)(intVec.data[i] * intVec2.data[i]);
        }
        return d;
    }

    public static double mult(int[] nArray, int[] nArray2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)(nArray[i] * nArray2[i]);
        }
        return d;
    }

    public static double multByteWise(IntVec intVec, IntVec intVec2) {
        return IntVec.multByteWise(intVec.data, intVec2.data);
    }

    public static double multByteWise(int[] nArray, int[] nArray2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] & 0xFF;
            int n2 = nArray2[i] & 0xFF;
            int n3 = (nArray[i] & 0xFF00) >> 8;
            int n4 = (nArray2[i] & 0xFF00) >> 8;
            int n5 = (nArray[i] & 0xFF0000) >> 16;
            int n6 = (nArray2[i] & 0xFF0000) >> 16;
            int n7 = (nArray[i] & 0xFF000000) >> 24;
            int n8 = (nArray2[i] & 0xFF000000) >> 24;
            d += (double)(n * n2 + n3 * n4 + n5 * n6 + n7 * n8);
        }
        return d;
    }

    public static double getSimilarityBytewiseOverlap(int[] nArray, int[] nArray2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] & 0xFF;
            int n2 = nArray2[i] & 0xFF;
            int n3 = (nArray[i] & 0xFF00) >>> 8;
            int n4 = (nArray2[i] & 0xFF00) >>> 8;
            int n5 = (nArray[i] & 0xFF0000) >>> 16;
            int n6 = (nArray2[i] & 0xFF0000) >>> 16;
            int n7 = (nArray[i] & 0xFF000000) >>> 24;
            int n8 = (nArray2[i] & 0xFF000000) >>> 24;
            f2 += (float)Math.min(n, n2);
            f3 += (float)Math.max(n, n2);
            f2 += (float)Math.min(n3, n4);
            f3 += (float)Math.max(n3, n4);
            f2 += (float)Math.min(n5, n6);
            f3 += (float)Math.max(n5, n6);
            f2 += (float)Math.min(n7, n8);
            f3 += (float)Math.max(n7, n8);
        }
        f = f2 / f3;
        return f;
    }

    public static IntVec subtractByteWise(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.size());
        for (int i = 0; i < intVec.sizeBytes(); ++i) {
            int n = intVec.getByte(i) - intVec2.getByte(i);
            intVec3.setByte(i, n);
        }
        return intVec3;
    }

    public static IntVec maskByteWise(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec2);
        for (int i = 0; i < intVec.sizeBytes(); ++i) {
            if (intVec.getByte(i) <= 0) continue;
            intVec3.setByte(i, 0);
        }
        return intVec3;
    }

    public static IntVec multEl(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] * intVec2.data[i];
        }
        return intVec3;
    }

    public void norm2One() {
        double d = this.getNorm();
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = (int)((double)this.data[n2] / d);
        }
        this.hash = -1;
    }

    public static IntVec minus(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] - intVec2.data[i];
        }
        return intVec3;
    }

    public void read(String string) {
        this.data = IntVec.convert(string);
        this.hash = -1;
    }

    public static IntVec[] read(File file) {
        Object object;
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>();
        try {
            object = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while (((BufferedReader)object).ready()) {
                String string = ((BufferedReader)object).readLine();
                int[] nArray = IntVec.convert(string);
                IntVec intVec = new IntVec(nArray);
                arrayList.add(intVec);
            }
            ((BufferedReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new IntVec[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (IntVec)arrayList.get(i);
        }
        return object;
    }

    public void reduce(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            nArray[i] = this.data[n];
        }
        this.data = nArray;
    }

    public void resize(int n) {
        if (this.data.length == n) {
            return;
        }
        int n2 = 0;
        long l = Integer.MAX_VALUE;
        if ((long)n >= l) {
            n2 = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            n2 = n;
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.data, 0, nArray, 0, Math.min(this.data.length, n2));
        this.data = nArray;
    }

    public static IntVec plus(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = new IntVec(intVec.data.length);
        for (int i = 0; i < intVec.data.length; ++i) {
            intVec3.data[i] = intVec.data[i] + intVec2.data[i];
        }
        return intVec3;
    }

    public void set(int n) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = n;
        }
        this.hash = -1;
    }

    public void set(IntVec intVec) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = intVec.data[i];
        }
        this.hash = -1;
    }

    public void set(int n, int n2) {
        this.data[n] = n2;
        this.hash = -1;
    }

    public void setBit(int n) {
        int n2 = this.data.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        this.data[n2] = this.data[n2] | (n4 <<= n3);
        this.hash = -1;
    }

    public void unsetBit(int n) {
        int n2 = this.data.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        this.data[n2] = this.data[n2] & ~(n4 <<= n3);
        this.hash = -1;
    }

    public boolean isValidBitIndex(int n) {
        boolean bl = false;
        int n2 = n / 32;
        if (n2 < this.data.length) {
            bl = true;
        }
        return bl;
    }

    public void setByte(int n, int n2) {
        IntVec.setByte(this.data, n, n2);
        this.hash = -1;
    }

    public static void setBytes(int[] nArray, int n) {
        int n2 = nArray.length * 4;
        for (int i = 0; i < n2; ++i) {
            IntVec.setByte(nArray, i, n);
        }
    }

    public static void setByte(int[] nArray, int n, int n2) {
        int n3 = n / 4;
        int n4 = n % 4;
        int n5 = 0;
        switch (n4) {
            case 3: {
                n5 = -256;
                break;
            }
            case 2: {
                n5 = -65281;
                n2 <<= 8;
                break;
            }
            case 1: {
                n5 = -16711681;
                n2 <<= 16;
                break;
            }
            case 0: {
                n5 = 0xFFFFFF;
                n2 <<= 24;
            }
        }
        nArray[n3] = nArray[n3] & n5 | n2;
    }

    public List<Integer> getIndicesBitsSet() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.sizeBits(); ++i) {
            if (!this.isBitSet(i)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    public boolean isBitSet(int n) {
        return this.isBitSetNotStatic(this.data, n);
    }

    private boolean isBitSetNotStatic(int[] nArray, int n) {
        int n2 = nArray.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        return (nArray[n2] & (n4 <<= n3)) != 0;
    }

    public void switchBit(int n) {
        int n2 = this.data.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        this.data[n2] = (this.data[n2] & (n4 <<= n3)) != 0 ? this.data[n2] & ~n4 : this.data[n2] | n4;
        this.hash = -1;
    }

    public void setBits(int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.setBit(i);
        }
    }

    public void setBytes(int n, int n2, int n3) {
        for (int i = n; i < n + n2; ++i) {
            this.setByte(i, n3);
        }
        this.hash = -1;
    }

    public void setRNDvalue(double d, double d2) {
        double d3 = d - d2 / 2.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d4 = d2 * Math.random();
            this.data[i] = (int)(d3 + d4);
        }
        this.hash = -1;
    }

    public int size() {
        return this.data.length;
    }

    public int sizeBits() {
        return this.data.length * 32;
    }

    public int sizeBytes() {
        return this.data.length * 4;
    }

    public void setRNDvalue(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            double d2 = (double)this.data[i] - d / 2.0;
            double d3 = d * Math.random();
            this.data[i] = (int)(d2 + d3);
        }
        this.hash = -1;
    }

    public IntVec sub(IntVec intVec) {
        IntVec intVec2 = new IntVec(this.data.length);
        for (int i = 0; i < intVec2.data.length; ++i) {
            intVec2.data[i] = this.data[i] - intVec.data[i];
        }
        return intVec2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DecimalFormat decimalFormat = new DecimalFormat("0");
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(decimalFormat.format(this.data[i]));
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String toStringHex() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(Integer.toHexString(this.data[i]));
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String toStringBinary() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = IntVec.toStringBinary(this.get(i)) + " ";
            stringBuilder.append(string);
        }
        return stringBuilder.toString().trim();
    }

    public String toStringBinaryDense() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = IntVec.toStringBinary(this.get(i), false);
            stringBuilder.append(string);
        }
        return stringBuilder.toString().trim();
    }

    public String toStringBytes() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.sizeBytes();
        for (int i = 0; i < n; ++i) {
            String string = this.getByte(i) + " ";
            stringBuilder.append(string);
        }
        return stringBuilder.toString().trim();
    }

    public double[] toDoubleBitWise() {
        double[] dArray = new double[this.size() * 32];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.data[i];
            int n3 = 1;
            for (int j = 0; j < 32; ++j) {
                dArray[n] = (n2 & n3) != 0 ? 1.0 : 0.0;
                n3 <<= 1;
                ++n;
            }
        }
        return dArray;
    }

    public int[] toIntByteWise() {
        int[] nArray = new int[this.size() * 4];
        for (int i = 0; i < this.sizeBytes(); ++i) {
            nArray[i] = this.getByte(i);
        }
        return nArray;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "0";
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = decimalFormat.format(this.data[i]);
            stringBuffer.append(string2 + " ");
        }
        return stringBuffer.toString();
    }

    public String write2String() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.data.length);
        stringBuilder.append(" ");
        stringBuilder.append(this.hash);
        stringBuilder.append(" ");
        stringBuilder.append(this.toString());
        return stringBuilder.toString();
    }

    public int[] toArray() {
        return this.data;
    }

    public static double getTanimotoDistBitWise(IntVec intVec, IntVec intVec2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < intVec.data.length; ++i) {
            n += Integer.bitCount(intVec.data[i] | intVec2.data[i]);
            n2 += Integer.bitCount(intVec.data[i] & intVec2.data[i]);
        }
        if (n2 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n;
        return d;
    }

    public static final double getTanimotoDistBitWise(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += Integer.bitCount(nArray[i] | nArray2[i]);
            n2 += Integer.bitCount(nArray[i] & nArray2[i]);
        }
        if (n2 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n;
        return d;
    }

    public static double getTanimotoDistInvBitWise(IntVec intVec, IntVec intVec2) {
        return 1.0 - IntVec.getTanimotoDistBitWise(intVec, intVec2);
    }

    public static double getTanimotoDistInvBitWise(int[] nArray, int[] nArray2) {
        return 1.0 - IntVec.getTanimotoDistBitWise(nArray, nArray2);
    }

    public static double getTanimotoDist(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = IntVec.mult(intVec, intVec2);
        double d3 = IntVec.mult(intVec, intVec);
        double d4 = IntVec.mult(intVec2, intVec2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDist(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = IntVec.mult(nArray, nArray2);
        double d3 = IntVec.mult(nArray, nArray);
        double d4 = IntVec.mult(nArray2, nArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static final double getTanimotoDistInv(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = IntVec.mult(intVec, intVec2);
        double d3 = IntVec.mult(intVec, intVec);
        double d4 = IntVec.mult(intVec2, intVec2);
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getScoreQueryInBaseByteWise(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            int n = intVec.data[i] & 0xFF;
            int n2 = intVec2.data[i] & 0xFF;
            d2 += (double)n;
            int n3 = n - n2;
            if (n3 > 0) {
                d += (double)n3;
            }
            int n4 = (intVec.data[i] & 0xFF00) >> 8;
            int n5 = (intVec2.data[i] & 0xFF00) >> 8;
            d2 += (double)n4;
            n3 = n4 - n5;
            if (n3 > 0) {
                d += (double)n3;
            }
            int n6 = (intVec.data[i] & 0xFF0000) >> 16;
            int n7 = (intVec2.data[i] & 0xFF0000) >> 16;
            d2 += (double)n6;
            n3 = n6 - n7;
            if (n3 > 0) {
                d += (double)n3;
            }
            int n8 = (intVec.data[i] & 0xFF000000) >> 24;
            int n9 = (intVec2.data[i] & 0xFF000000) >> 24;
            d2 += (double)n8;
            n3 = n8 - n9;
            if (n3 <= 0) continue;
            d += (double)n3;
        }
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    public static double getScoreQueryInBase(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < intVec.size(); ++i) {
            int n = intVec.get(i) - intVec2.get(i);
            d2 += (double)intVec.get(i);
            if (n <= 0) continue;
            d += (double)n;
        }
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    public static double getScoreQueryInBaseBitWise(IntVec intVec, IntVec intVec2) {
        return IntVec.getScoreQueryInBaseBitWise(intVec.data, intVec2.data);
    }

    public static double getScoreQueryInBaseBitWise(int[] nArray, int[] nArray2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = 0;
            int n2 = 0;
            n = nArray[i] | nArray2[i];
            n2 = n ^ nArray2[i];
            d += (double)Integer.bitCount(n2) / (double)Integer.bitCount(nArray[i]);
        }
        return d /= (double)nArray.length;
    }

    public static double getScoreFracBitsInCommonBitWise(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            int n = intVec.data[i] & intVec2.data[i];
            int n2 = intVec.data[i] | intVec2.data[i];
            if (n2 != 0) {
                d += (double)Integer.bitCount(n) / (double)Integer.bitCount(n2);
            }
            d2 += 1.0;
        }
        return 1.0 - (d /= d2);
    }

    public static double getTanimotoDistInvByteWise(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        double d2 = IntVec.multByteWise(intVec, intVec2);
        double d3 = IntVec.multByteWise(intVec, intVec);
        double d4 = IntVec.multByteWise(intVec2, intVec2);
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDistInvByteWise(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = IntVec.multByteWise(nArray, nArray2);
        double d3 = IntVec.multByteWise(nArray, nArray);
        double d4 = IntVec.multByteWise(nArray2, nArray2);
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getScoreFracBitsCommonQuery(IntVec intVec, IntVec intVec2) {
        double d = 0.0;
        for (int i = 0; i < intVec.data.length; ++i) {
            int n = intVec.data[i] & intVec2.data[i];
            if (intVec.data[i] == 0) continue;
            d += (double)Integer.bitCount(n) / (double)Integer.bitCount(intVec.data[i]);
        }
        return 1.0 - (d /= (double)intVec.data.length);
    }

    public static int getOverlap(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = IntVec.AND(intVec, intVec2);
        return intVec3.getBitsSet();
    }

    public static void incrementByte(int[] nArray, int n) {
        int n2 = n / 4;
        int n3 = n % 4;
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        switch (n3) {
            case 3: {
                n6 = -256;
                n4 = nArray[n2] & 0xFF;
                break;
            }
            case 2: {
                n6 = -65281;
                n4 = nArray[n2] & 0xFF00;
                n5 <<= 8;
                break;
            }
            case 1: {
                n6 = -16711681;
                n4 = nArray[n2] & 0xFF0000;
                n5 <<= 16;
                break;
            }
            case 0: {
                n6 = 0xFFFFFF;
                n4 = nArray[n2] & 0xFF000000;
                n5 <<= 24;
            }
        }
        nArray[n2] = nArray[n2] & n6 | n4 + n5;
    }

    public static void writeBitStringDense(File file, List<IntVec> list) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < list.size(); ++i) {
            bufferedWriter.append(list.get(i).toStringBinaryDense());
            if (i >= list.size() - 1) continue;
            bufferedWriter.append("\n");
        }
        bufferedWriter.close();
    }

    public static List<IntVec> readBitStringDense(File file) throws IOException {
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            try {
                IntVec intVec = IntVec.readBitStringDense(string);
                arrayList.add(intVec);
            }
            catch (Exception exception) {
                System.err.println("Error in line " + n + ".");
                exception.printStackTrace();
            }
            ++n;
        }
        bufferedReader.close();
        return arrayList;
    }

    public static IntVec read(InputStream inputStream) throws IOException {
        int n = IntArray.parseInteger(inputStream);
        int n2 = IntArray.parseInteger(inputStream);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = IntArray.parseInteger(inputStream);
        }
        IntVec intVec = new IntVec();
        intVec.data = nArray;
        intVec.hash = n2;
        return intVec;
    }

    public static boolean isBitSet(int[] nArray, int n) {
        int n2 = nArray.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        return (nArray[n2] & (n4 <<= n3)) != 0;
    }

    public static boolean isBitSet(int n, int n2) {
        int n3 = n2 % 32;
        int n4 = 1;
        return (n & (n4 <<= n3)) != 0;
    }

    public static void setBit(int[] nArray, int n) {
        int n2 = nArray.length - n / 32 - 1;
        int n3 = n % 32;
        int n4 = 1;
        nArray[n2] = nArray[n2] | (n4 <<= n3);
    }

    public static String toStringBinary(int n) {
        return IntVec.toStringBinary(n, true);
    }

    public static String toStringBinary(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 32;
        for (int i = 0; i < n2; ++i) {
            if ((n & 1) == 1) {
                stringBuilder.insert(0, "1");
            } else {
                stringBuilder.insert(0, "0");
            }
            if (bl) {
                stringBuilder.insert(0, " ");
            }
            n >>= 1;
        }
        return stringBuilder.toString().trim();
    }
}

