/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.calc.INumericalDataColumn;
import com.actelion.research.util.datamodel.IntArray;
import java.util.Arrays;

public class DoubleArray
implements INumericalDataColumn {
    private static final int START_CAPACITY = 32;
    private static final int MAX_DELTA_CAPACITY = (int)Math.pow(2.0, 20.0);
    private double[] data;
    private int size;
    private int delta_capacity;

    public DoubleArray() {
        this.init(32);
    }

    public DoubleArray(int n) {
        this.init(n);
    }

    public DoubleArray(double[] dArray) {
        this.init(dArray.length);
        System.arraycopy(dArray, 0, this.data, 0, dArray.length);
        this.size = dArray.length;
    }

    public DoubleArray(int[] nArray) {
        this.init(nArray.length);
        System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        this.size = nArray.length;
    }

    public DoubleArray(IntArray intArray) {
        this.init(intArray.length());
        for (int i = 0; i < intArray.length(); ++i) {
            this.add(intArray.get(i));
        }
    }

    private void init(int n) {
        if (n < 1) {
            throw new RuntimeException("Capacity (" + n + ") to low!");
        }
        this.data = new double[n];
        this.delta_capacity = Math.max(1, n / 2);
        this.size = 0;
    }

    public void clear() {
        this.size = 0;
    }

    public double get(int n) {
        return this.data[n];
    }

    public double[] get() {
        if (this.size != this.data.length) {
            this.resize(this.size);
        }
        return this.data;
    }

    public int add(double d) {
        this.data[this.size] = d;
        int n = this.size++;
        if (this.size == this.data.length) {
            this.resize(this.data.length + this.delta_capacity);
            if (this.delta_capacity < MAX_DELTA_CAPACITY) {
                this.delta_capacity *= 2;
            }
        }
        return n;
    }

    public int add(double[] dArray) {
        int n = this.size - 1;
        for (int i = 0; i < dArray.length; ++i) {
            n = this.add(dArray[i]);
        }
        return n;
    }

    public int add(float[] fArray) {
        int n = this.size - 1;
        for (int i = 0; i < fArray.length; ++i) {
            n = this.add(fArray[i]);
        }
        return n;
    }

    public int add(DoubleArray doubleArray) {
        int n = this.size - 1;
        for (int i = 0; i < doubleArray.size; ++i) {
            n = this.add(doubleArray.get(i));
        }
        return n;
    }

    public double avr() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d += this.data[i];
        }
        return d / (double)this.size;
    }

    public double median() {
        double[] dArray = this.get();
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Arrays.sort(dArray2);
        double d = 0.0;
        if (dArray2.length % 2 > 0) {
            d = dArray2[dArray2.length / 2];
        } else {
            int n = dArray2.length / 2;
            d = (dArray2[n - 1] + dArray2[n]) / 2.0;
        }
        return d;
    }

    public double sum() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            d += this.data[i];
        }
        return d;
    }

    public double max() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.data[i] > d)) continue;
            d = this.data[i];
        }
        return d;
    }

    public double min() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.data[i] < d)) continue;
            d = this.data[i];
        }
        return d;
    }

    private void resize(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.data, 0, dArray, 0, Math.min(this.data.length, n));
        this.data = dArray;
    }

    public int size() {
        return this.size;
    }

    @Override
    public int getValueCount() {
        return this.size;
    }

    @Override
    public double getValueAt(int n) {
        return this.data[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DoubleArray{");
        stringBuilder.append("data=");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.data[i]);
            if (i >= this.size - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(", size=").append(this.size);
        stringBuilder.append(", delta_capacity=").append(this.delta_capacity);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

